/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.ImageSource;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Image Block</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageBlockImpl#getSource <em>Source</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageBlockImpl#getCacheControl <em>Cache Control</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ImageBlockImpl extends ContentBlockImpl implements ImageBlock {
	/**
	 * The cached value of the '{@link #getSource() <em>Source</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected ImageSource source;

	/**
	 * The cached value of the '{@link #getCacheControl() <em>Cache Control</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheControl()
	 * @generated
	 * @ordered
	 */
	protected CacheControl cacheControl;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageBlockImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.IMAGE_BLOCK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ImageSource getSource() {
		return source;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSource(ImageSource newSource, NotificationChain msgs) {
		ImageSource oldSource = source;
		source = newSource;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE, oldSource, newSource);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSource(ImageSource newSource) {
		if (newSource != source) {
			NotificationChain msgs = null;
			if (source != null)
				msgs = ((InternalEObject)source).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE, null, msgs);
			if (newSource != null)
				msgs = ((InternalEObject)newSource).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE, null, msgs);
			msgs = basicSetSource(newSource, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE, newSource, newSource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CacheControl getCacheControl() {
		return cacheControl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCacheControl(CacheControl newCacheControl, NotificationChain msgs) {
		CacheControl oldCacheControl = cacheControl;
		cacheControl = newCacheControl;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL, oldCacheControl, newCacheControl);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCacheControl(CacheControl newCacheControl) {
		if (newCacheControl != cacheControl) {
			NotificationChain msgs = null;
			if (cacheControl != null)
				msgs = ((InternalEObject)cacheControl).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL, null, msgs);
			if (newCacheControl != null)
				msgs = ((InternalEObject)newCacheControl).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL, null, msgs);
			msgs = basicSetCacheControl(newCacheControl, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL, newCacheControl, newCacheControl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE:
				return basicSetSource(null, msgs);
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL:
				return basicSetCacheControl(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE:
				return getSource();
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL:
				return getCacheControl();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE:
				setSource((ImageSource)newValue);
				return;
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE:
				setSource((ImageSource)null);
				return;
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__SOURCE:
				return source != null;
			case ClaudeChatCompletionPackage.IMAGE_BLOCK__CACHE_CONTROL:
				return cacheControl != null;
		}
		return super.eIsSet(featureID);
	}

} //ImageBlockImpl
