/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>MCP Server</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl#getUrl <em>Url</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl#getAuthorizationToken <em>Authorization Token</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl#getToolConfiguration <em>Tool Configuration</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MCPServerImpl extends MinimalEObjectImpl.Container implements MCPServer {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = "url";

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected String url = URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getAuthorizationToken() <em>Authorization Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuthorizationToken()
	 * @generated
	 * @ordered
	 */
	protected static final String AUTHORIZATION_TOKEN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAuthorizationToken() <em>Authorization Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAuthorizationToken()
	 * @generated
	 * @ordered
	 */
	protected String authorizationToken = AUTHORIZATION_TOKEN_EDEFAULT;

	/**
	 * The cached value of the '{@link #getToolConfiguration() <em>Tool Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolConfiguration()
	 * @generated
	 * @ordered
	 */
	protected MCPToolConfiguration toolConfiguration;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MCPServerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.MCP_SERVER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_SERVER__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_SERVER__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUrl() {
		return url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUrl(String newUrl) {
		String oldUrl = url;
		url = newUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_SERVER__URL, oldUrl, url));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAuthorizationToken() {
		return authorizationToken;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAuthorizationToken(String newAuthorizationToken) {
		String oldAuthorizationToken = authorizationToken;
		authorizationToken = newAuthorizationToken;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_SERVER__AUTHORIZATION_TOKEN, oldAuthorizationToken, authorizationToken));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MCPToolConfiguration getToolConfiguration() {
		return toolConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetToolConfiguration(MCPToolConfiguration newToolConfiguration, NotificationChain msgs) {
		MCPToolConfiguration oldToolConfiguration = toolConfiguration;
		toolConfiguration = newToolConfiguration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION, oldToolConfiguration, newToolConfiguration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setToolConfiguration(MCPToolConfiguration newToolConfiguration) {
		if (newToolConfiguration != toolConfiguration) {
			NotificationChain msgs = null;
			if (toolConfiguration != null)
				msgs = ((InternalEObject)toolConfiguration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION, null, msgs);
			if (newToolConfiguration != null)
				msgs = ((InternalEObject)newToolConfiguration).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION, null, msgs);
			msgs = basicSetToolConfiguration(newToolConfiguration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION, newToolConfiguration, newToolConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION:
				return basicSetToolConfiguration(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_SERVER__NAME:
				return getName();
			case ClaudeChatCompletionPackage.MCP_SERVER__TYPE:
				return getType();
			case ClaudeChatCompletionPackage.MCP_SERVER__URL:
				return getUrl();
			case ClaudeChatCompletionPackage.MCP_SERVER__AUTHORIZATION_TOKEN:
				return getAuthorizationToken();
			case ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION:
				return getToolConfiguration();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_SERVER__NAME:
				setName((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__TYPE:
				setType((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__URL:
				setUrl((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__AUTHORIZATION_TOKEN:
				setAuthorizationToken((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION:
				setToolConfiguration((MCPToolConfiguration)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_SERVER__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__URL:
				setUrl(URL_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__AUTHORIZATION_TOKEN:
				setAuthorizationToken(AUTHORIZATION_TOKEN_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION:
				setToolConfiguration((MCPToolConfiguration)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_SERVER__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ClaudeChatCompletionPackage.MCP_SERVER__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case ClaudeChatCompletionPackage.MCP_SERVER__URL:
				return URL_EDEFAULT == null ? url != null : !URL_EDEFAULT.equals(url);
			case ClaudeChatCompletionPackage.MCP_SERVER__AUTHORIZATION_TOKEN:
				return AUTHORIZATION_TOKEN_EDEFAULT == null ? authorizationToken != null : !AUTHORIZATION_TOKEN_EDEFAULT.equals(authorizationToken);
			case ClaudeChatCompletionPackage.MCP_SERVER__TOOL_CONFIGURATION:
				return toolConfiguration != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", type: ");
		result.append(type);
		result.append(", url: ");
		result.append(url);
		result.append(", authorizationToken: ");
		result.append(authorizationToken);
		result.append(')');
		return result.toString();
	}

} //MCPServerImpl
