/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>MCP Tool Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolConfigurationImpl#isEnabled <em>Enabled</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolConfigurationImpl#getAllowedTools <em>Allowed Tools</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MCPToolConfigurationImpl extends MinimalEObjectImpl.Container implements MCPToolConfiguration {
	/**
	 * The default value of the '{@link #isEnabled() <em>Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnabled()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENABLED_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isEnabled() <em>Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEnabled()
	 * @generated
	 * @ordered
	 */
	protected boolean enabled = ENABLED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAllowedTools() <em>Allowed Tools</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllowedTools()
	 * @generated
	 * @ordered
	 */
	protected EList<String> allowedTools;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MCPToolConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.MCP_TOOL_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isEnabled() {
		return enabled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEnabled(boolean newEnabled) {
		boolean oldEnabled = enabled;
		enabled = newEnabled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ENABLED, oldEnabled, enabled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getAllowedTools() {
		if (allowedTools == null) {
			allowedTools = new EDataTypeUniqueEList<String>(String.class, this, ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS);
		}
		return allowedTools;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ENABLED:
				return isEnabled();
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS:
				return getAllowedTools();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ENABLED:
				setEnabled((Boolean)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS:
				getAllowedTools().clear();
				getAllowedTools().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ENABLED:
				setEnabled(ENABLED_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS:
				getAllowedTools().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ENABLED:
				return enabled != ENABLED_EDEFAULT;
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS:
				return allowedTools != null && !allowedTools.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (enabled: ");
		result.append(enabled);
		result.append(", allowedTools: ");
		result.append(allowedTools);
		result.append(')');
		return result.toString();
	}

} //MCPToolConfigurationImpl
