/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>MCP Tool Result Block</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl#getToolUseId <em>Tool Use Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl#isIsError <em>Is Error</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl#getCacheControl <em>Cache Control</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MCPToolResultBlockImpl extends ContentBlockImpl implements MCPToolResultBlock {
	/**
	 * The default value of the '{@link #getToolUseId() <em>Tool Use Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolUseId()
	 * @generated
	 * @ordered
	 */
	protected static final String TOOL_USE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getToolUseId() <em>Tool Use Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolUseId()
	 * @generated
	 * @ordered
	 */
	protected String toolUseId = TOOL_USE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContent() <em>Content</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContent()
	 * @generated
	 * @ordered
	 */
	protected EList<ContentBlock> content;

	/**
	 * The default value of the '{@link #isIsError() <em>Is Error</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsError()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_ERROR_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsError() <em>Is Error</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsError()
	 * @generated
	 * @ordered
	 */
	protected boolean isError = IS_ERROR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCacheControl() <em>Cache Control</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheControl()
	 * @generated
	 * @ordered
	 */
	protected CacheControl cacheControl;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MCPToolResultBlockImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.MCP_TOOL_RESULT_BLOCK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getToolUseId() {
		return toolUseId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setToolUseId(String newToolUseId) {
		String oldToolUseId = toolUseId;
		toolUseId = newToolUseId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID, oldToolUseId, toolUseId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ContentBlock> getContent() {
		if (content == null) {
			content = new EObjectContainmentEList<ContentBlock>(ContentBlock.class, this, ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CONTENT);
		}
		return content;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIsError() {
		return isError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIsError(boolean newIsError) {
		boolean oldIsError = isError;
		isError = newIsError;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__IS_ERROR, oldIsError, isError));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CacheControl getCacheControl() {
		return cacheControl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCacheControl(CacheControl newCacheControl, NotificationChain msgs) {
		CacheControl oldCacheControl = cacheControl;
		cacheControl = newCacheControl;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL, oldCacheControl, newCacheControl);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCacheControl(CacheControl newCacheControl) {
		if (newCacheControl != cacheControl) {
			NotificationChain msgs = null;
			if (cacheControl != null)
				msgs = ((InternalEObject)cacheControl).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL, null, msgs);
			if (newCacheControl != null)
				msgs = ((InternalEObject)newCacheControl).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL, null, msgs);
			msgs = basicSetCacheControl(newCacheControl, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL, newCacheControl, newCacheControl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CONTENT:
				return ((InternalEList<?>)getContent()).basicRemove(otherEnd, msgs);
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL:
				return basicSetCacheControl(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID:
				return getToolUseId();
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CONTENT:
				return getContent();
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__IS_ERROR:
				return isIsError();
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL:
				return getCacheControl();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID:
				setToolUseId((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CONTENT:
				getContent().clear();
				getContent().addAll((Collection<? extends ContentBlock>)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__IS_ERROR:
				setIsError((Boolean)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID:
				setToolUseId(TOOL_USE_ID_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CONTENT:
				getContent().clear();
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__IS_ERROR:
				setIsError(IS_ERROR_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID:
				return TOOL_USE_ID_EDEFAULT == null ? toolUseId != null : !TOOL_USE_ID_EDEFAULT.equals(toolUseId);
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CONTENT:
				return content != null && !content.isEmpty();
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__IS_ERROR:
				return isError != IS_ERROR_EDEFAULT;
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL:
				return cacheControl != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (toolUseId: ");
		result.append(toolUseId);
		result.append(", isError: ");
		result.append(isError);
		result.append(')');
		return result.toString();
	}

} //MCPToolResultBlockImpl
