/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>MCP Tool Use Block</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl#getServerName <em>Server Name</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl#getInput <em>Input</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl#getCaller <em>Caller</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl#getCacheControl <em>Cache Control</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MCPToolUseBlockImpl extends ContentBlockImpl implements MCPToolUseBlock {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getServerName() <em>Server Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServerName()
	 * @generated
	 * @ordered
	 */
	protected static final String SERVER_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getServerName() <em>Server Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServerName()
	 * @generated
	 * @ordered
	 */
	protected String serverName = SERVER_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInput() <em>Input</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInput()
	 * @generated
	 * @ordered
	 */
	protected static final String INPUT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getInput() <em>Input</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInput()
	 * @generated
	 * @ordered
	 */
	protected String input = INPUT_EDEFAULT;

	/**
	 * The default value of the '{@link #getCaller() <em>Caller</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCaller()
	 * @generated
	 * @ordered
	 */
	protected static final String CALLER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCaller() <em>Caller</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCaller()
	 * @generated
	 * @ordered
	 */
	protected String caller = CALLER_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCacheControl() <em>Cache Control</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheControl()
	 * @generated
	 * @ordered
	 */
	protected CacheControl cacheControl;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MCPToolUseBlockImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.MCP_TOOL_USE_BLOCK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getServerName() {
		return serverName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setServerName(String newServerName) {
		String oldServerName = serverName;
		serverName = newServerName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__SERVER_NAME, oldServerName, serverName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getInput() {
		return input;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInput(String newInput) {
		String oldInput = input;
		input = newInput;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__INPUT, oldInput, input));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCaller() {
		return caller;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCaller(String newCaller) {
		String oldCaller = caller;
		caller = newCaller;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CALLER, oldCaller, caller));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CacheControl getCacheControl() {
		return cacheControl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCacheControl(CacheControl newCacheControl, NotificationChain msgs) {
		CacheControl oldCacheControl = cacheControl;
		cacheControl = newCacheControl;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL, oldCacheControl, newCacheControl);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCacheControl(CacheControl newCacheControl) {
		if (newCacheControl != cacheControl) {
			NotificationChain msgs = null;
			if (cacheControl != null)
				msgs = ((InternalEObject)cacheControl).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL, null, msgs);
			if (newCacheControl != null)
				msgs = ((InternalEObject)newCacheControl).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL, null, msgs);
			msgs = basicSetCacheControl(newCacheControl, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL, newCacheControl, newCacheControl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL:
				return basicSetCacheControl(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__ID:
				return getId();
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__NAME:
				return getName();
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__SERVER_NAME:
				return getServerName();
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__INPUT:
				return getInput();
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CALLER:
				return getCaller();
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL:
				return getCacheControl();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__ID:
				setId((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__NAME:
				setName((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__SERVER_NAME:
				setServerName((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__INPUT:
				setInput((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CALLER:
				setCaller((String)newValue);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__ID:
				setId(ID_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__SERVER_NAME:
				setServerName(SERVER_NAME_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__INPUT:
				setInput(INPUT_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CALLER:
				setCaller(CALLER_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__SERVER_NAME:
				return SERVER_NAME_EDEFAULT == null ? serverName != null : !SERVER_NAME_EDEFAULT.equals(serverName);
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__INPUT:
				return INPUT_EDEFAULT == null ? input != null : !INPUT_EDEFAULT.equals(input);
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CALLER:
				return CALLER_EDEFAULT == null ? caller != null : !CALLER_EDEFAULT.equals(caller);
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK__CACHE_CONTROL:
				return cacheControl != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", serverName: ");
		result.append(serverName);
		result.append(", input: ");
		result.append(input);
		result.append(", caller: ");
		result.append(caller);
		result.append(')');
		return result.toString();
	}

} //MCPToolUseBlockImpl
