/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Thinking Config</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ThinkingConfigImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ThinkingConfigImpl#getBudgetTokens <em>Budget Tokens</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ThinkingConfigImpl extends MinimalEObjectImpl.Container implements ThinkingConfig {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final ThinkingType TYPE_EDEFAULT = ThinkingType.ENABLED;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected ThinkingType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getBudgetTokens() <em>Budget Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBudgetTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int BUDGET_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getBudgetTokens() <em>Budget Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBudgetTokens()
	 * @generated
	 * @ordered
	 */
	protected int budgetTokens = BUDGET_TOKENS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThinkingConfigImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.THINKING_CONFIG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ThinkingType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(ThinkingType newType) {
		ThinkingType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.THINKING_CONFIG__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getBudgetTokens() {
		return budgetTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBudgetTokens(int newBudgetTokens) {
		int oldBudgetTokens = budgetTokens;
		budgetTokens = newBudgetTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.THINKING_CONFIG__BUDGET_TOKENS, oldBudgetTokens, budgetTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.THINKING_CONFIG__TYPE:
				return getType();
			case ClaudeChatCompletionPackage.THINKING_CONFIG__BUDGET_TOKENS:
				return getBudgetTokens();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.THINKING_CONFIG__TYPE:
				setType((ThinkingType)newValue);
				return;
			case ClaudeChatCompletionPackage.THINKING_CONFIG__BUDGET_TOKENS:
				setBudgetTokens((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.THINKING_CONFIG__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.THINKING_CONFIG__BUDGET_TOKENS:
				setBudgetTokens(BUDGET_TOKENS_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.THINKING_CONFIG__TYPE:
				return type != TYPE_EDEFAULT;
			case ClaudeChatCompletionPackage.THINKING_CONFIG__BUDGET_TOKENS:
				return budgetTokens != BUDGET_TOKENS_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", budgetTokens: ");
		result.append(budgetTokens);
		result.append(')');
		return result.toString();
	}

} //ThinkingConfigImpl
