/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tool Choice</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolChoiceImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolChoiceImpl#isDisableParallelToolUse <em>Disable Parallel Tool Use</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class ToolChoiceImpl extends MinimalEObjectImpl.Container implements ToolChoice {
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isDisableParallelToolUse() <em>Disable Parallel Tool Use</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisableParallelToolUse()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISABLE_PARALLEL_TOOL_USE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDisableParallelToolUse() <em>Disable Parallel Tool Use</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisableParallelToolUse()
	 * @generated
	 * @ordered
	 */
	protected boolean disableParallelToolUse = DISABLE_PARALLEL_TOOL_USE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolChoiceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.TOOL_CHOICE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getType() {
		// TODO: implement this method to return the 'Type' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDisableParallelToolUse() {
		return disableParallelToolUse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDisableParallelToolUse(boolean newDisableParallelToolUse) {
		boolean oldDisableParallelToolUse = disableParallelToolUse;
		disableParallelToolUse = newDisableParallelToolUse;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE, oldDisableParallelToolUse, disableParallelToolUse));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_CHOICE__TYPE:
				return getType();
			case ClaudeChatCompletionPackage.TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE:
				return isDisableParallelToolUse();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE:
				setDisableParallelToolUse((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE:
				setDisableParallelToolUse(DISABLE_PARALLEL_TOOL_USE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_CHOICE__TYPE:
				return TYPE_EDEFAULT == null ? getType() != null : !TYPE_EDEFAULT.equals(getType());
			case ClaudeChatCompletionPackage.TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE:
				return disableParallelToolUse != DISABLE_PARALLEL_TOOL_USE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (disableParallelToolUse: ");
		result.append(disableParallelToolUse);
		result.append(')');
		return result.toString();
	}

} //ToolChoiceImpl
