/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tool Result Block</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl#getToolUseId <em>Tool Use Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl#isIsError <em>Is Error</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ToolResultBlockImpl extends ContentBlockImpl implements ToolResultBlock {
	/**
	 * The default value of the '{@link #getToolUseId() <em>Tool Use Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolUseId()
	 * @generated
	 * @ordered
	 */
	protected static final String TOOL_USE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getToolUseId() <em>Tool Use Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolUseId()
	 * @generated
	 * @ordered
	 */
	protected String toolUseId = TOOL_USE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContent() <em>Content</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContent()
	 * @generated
	 * @ordered
	 */
	protected EList<ContentBlock> content;

	/**
	 * The default value of the '{@link #isIsError() <em>Is Error</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsError()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_ERROR_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsError() <em>Is Error</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsError()
	 * @generated
	 * @ordered
	 */
	protected boolean isError = IS_ERROR_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolResultBlockImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.TOOL_RESULT_BLOCK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getToolUseId() {
		return toolUseId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setToolUseId(String newToolUseId) {
		String oldToolUseId = toolUseId;
		toolUseId = newToolUseId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__TOOL_USE_ID, oldToolUseId, toolUseId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ContentBlock> getContent() {
		if (content == null) {
			content = new EObjectContainmentEList<ContentBlock>(ContentBlock.class, this, ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__CONTENT);
		}
		return content;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIsError() {
		return isError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIsError(boolean newIsError) {
		boolean oldIsError = isError;
		isError = newIsError;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__IS_ERROR, oldIsError, isError));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__CONTENT:
				return ((InternalEList<?>)getContent()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__TOOL_USE_ID:
				return getToolUseId();
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__CONTENT:
				return getContent();
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__IS_ERROR:
				return isIsError();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__TOOL_USE_ID:
				setToolUseId((String)newValue);
				return;
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__CONTENT:
				getContent().clear();
				getContent().addAll((Collection<? extends ContentBlock>)newValue);
				return;
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__IS_ERROR:
				setIsError((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__TOOL_USE_ID:
				setToolUseId(TOOL_USE_ID_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__CONTENT:
				getContent().clear();
				return;
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__IS_ERROR:
				setIsError(IS_ERROR_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__TOOL_USE_ID:
				return TOOL_USE_ID_EDEFAULT == null ? toolUseId != null : !TOOL_USE_ID_EDEFAULT.equals(toolUseId);
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__CONTENT:
				return content != null && !content.isEmpty();
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK__IS_ERROR:
				return isError != IS_ERROR_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (toolUseId: ");
		result.append(toolUseId);
		result.append(", isError: ");
		result.append(isError);
		result.append(')');
		return result.toString();
	}

} //ToolResultBlockImpl
