/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.Usage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Usage</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl#getInputTokens <em>Input Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl#getOutputTokens <em>Output Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl#getCacheCreationInputTokens <em>Cache Creation Input Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl#getCacheReadInputTokens <em>Cache Read Input Tokens</em>}</li>
 * </ul>
 *
 * @generated
 */
public class UsageImpl extends MinimalEObjectImpl.Container implements Usage {
	/**
	 * The default value of the '{@link #getInputTokens() <em>Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int INPUT_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInputTokens() <em>Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputTokens()
	 * @generated
	 * @ordered
	 */
	protected int inputTokens = INPUT_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getOutputTokens() <em>Output Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int OUTPUT_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOutputTokens() <em>Output Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputTokens()
	 * @generated
	 * @ordered
	 */
	protected int outputTokens = OUTPUT_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getCacheCreationInputTokens() <em>Cache Creation Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheCreationInputTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int CACHE_CREATION_INPUT_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCacheCreationInputTokens() <em>Cache Creation Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheCreationInputTokens()
	 * @generated
	 * @ordered
	 */
	protected int cacheCreationInputTokens = CACHE_CREATION_INPUT_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getCacheReadInputTokens() <em>Cache Read Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheReadInputTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int CACHE_READ_INPUT_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCacheReadInputTokens() <em>Cache Read Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheReadInputTokens()
	 * @generated
	 * @ordered
	 */
	protected int cacheReadInputTokens = CACHE_READ_INPUT_TOKENS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UsageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.USAGE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getInputTokens() {
		return inputTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInputTokens(int newInputTokens) {
		int oldInputTokens = inputTokens;
		inputTokens = newInputTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.USAGE__INPUT_TOKENS, oldInputTokens, inputTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getOutputTokens() {
		return outputTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOutputTokens(int newOutputTokens) {
		int oldOutputTokens = outputTokens;
		outputTokens = newOutputTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.USAGE__OUTPUT_TOKENS, oldOutputTokens, outputTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCacheCreationInputTokens() {
		return cacheCreationInputTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCacheCreationInputTokens(int newCacheCreationInputTokens) {
		int oldCacheCreationInputTokens = cacheCreationInputTokens;
		cacheCreationInputTokens = newCacheCreationInputTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.USAGE__CACHE_CREATION_INPUT_TOKENS, oldCacheCreationInputTokens, cacheCreationInputTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCacheReadInputTokens() {
		return cacheReadInputTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCacheReadInputTokens(int newCacheReadInputTokens) {
		int oldCacheReadInputTokens = cacheReadInputTokens;
		cacheReadInputTokens = newCacheReadInputTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.USAGE__CACHE_READ_INPUT_TOKENS, oldCacheReadInputTokens, cacheReadInputTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.USAGE__INPUT_TOKENS:
				return getInputTokens();
			case ClaudeChatCompletionPackage.USAGE__OUTPUT_TOKENS:
				return getOutputTokens();
			case ClaudeChatCompletionPackage.USAGE__CACHE_CREATION_INPUT_TOKENS:
				return getCacheCreationInputTokens();
			case ClaudeChatCompletionPackage.USAGE__CACHE_READ_INPUT_TOKENS:
				return getCacheReadInputTokens();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.USAGE__INPUT_TOKENS:
				setInputTokens((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.USAGE__OUTPUT_TOKENS:
				setOutputTokens((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.USAGE__CACHE_CREATION_INPUT_TOKENS:
				setCacheCreationInputTokens((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.USAGE__CACHE_READ_INPUT_TOKENS:
				setCacheReadInputTokens((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.USAGE__INPUT_TOKENS:
				setInputTokens(INPUT_TOKENS_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.USAGE__OUTPUT_TOKENS:
				setOutputTokens(OUTPUT_TOKENS_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.USAGE__CACHE_CREATION_INPUT_TOKENS:
				setCacheCreationInputTokens(CACHE_CREATION_INPUT_TOKENS_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.USAGE__CACHE_READ_INPUT_TOKENS:
				setCacheReadInputTokens(CACHE_READ_INPUT_TOKENS_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.USAGE__INPUT_TOKENS:
				return inputTokens != INPUT_TOKENS_EDEFAULT;
			case ClaudeChatCompletionPackage.USAGE__OUTPUT_TOKENS:
				return outputTokens != OUTPUT_TOKENS_EDEFAULT;
			case ClaudeChatCompletionPackage.USAGE__CACHE_CREATION_INPUT_TOKENS:
				return cacheCreationInputTokens != CACHE_CREATION_INPUT_TOKENS_EDEFAULT;
			case ClaudeChatCompletionPackage.USAGE__CACHE_READ_INPUT_TOKENS:
				return cacheReadInputTokens != CACHE_READ_INPUT_TOKENS_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (inputTokens: ");
		result.append(inputTokens);
		result.append(", outputTokens: ");
		result.append(outputTokens);
		result.append(", cacheCreationInputTokens: ");
		result.append(cacheCreationInputTokens);
		result.append(", cacheReadInputTokens: ");
		result.append(cacheReadInputTokens);
		result.append(')');
		return result.toString();
	}

} //UsageImpl
