/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.fennec.ai.chat.completion.model.claude.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage
 * @generated
 */
public class ClaudeChatCompletionAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ClaudeChatCompletionPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClaudeChatCompletionAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = ClaudeChatCompletionPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClaudeChatCompletionSwitch<Adapter> modelSwitch =
		new ClaudeChatCompletionSwitch<Adapter>() {
			@Override
			public Adapter caseClaudeRequest(ClaudeRequest object) {
				return createClaudeRequestAdapter();
			}
			@Override
			public Adapter caseUsage(Usage object) {
				return createUsageAdapter();
			}
			@Override
			public Adapter caseClaudeResponse(ClaudeResponse object) {
				return createClaudeResponseAdapter();
			}
			@Override
			public Adapter caseSystemPrompt(SystemPrompt object) {
				return createSystemPromptAdapter();
			}
			@Override
			public Adapter caseMessage(Message object) {
				return createMessageAdapter();
			}
			@Override
			public Adapter caseContentBlock(ContentBlock object) {
				return createContentBlockAdapter();
			}
			@Override
			public Adapter caseTextBlock(TextBlock object) {
				return createTextBlockAdapter();
			}
			@Override
			public Adapter caseImageBlock(ImageBlock object) {
				return createImageBlockAdapter();
			}
			@Override
			public Adapter caseImageSource(ImageSource object) {
				return createImageSourceAdapter();
			}
			@Override
			public Adapter caseBase64ImageSource(Base64ImageSource object) {
				return createBase64ImageSourceAdapter();
			}
			@Override
			public Adapter caseURLImageSource(URLImageSource object) {
				return createURLImageSourceAdapter();
			}
			@Override
			public Adapter caseDocumentBlock(DocumentBlock object) {
				return createDocumentBlockAdapter();
			}
			@Override
			public Adapter caseDocumentSource(DocumentSource object) {
				return createDocumentSourceAdapter();
			}
			@Override
			public Adapter caseBase64DocumentSource(Base64DocumentSource object) {
				return createBase64DocumentSourceAdapter();
			}
			@Override
			public Adapter casePlainTextDocumentSource(PlainTextDocumentSource object) {
				return createPlainTextDocumentSourceAdapter();
			}
			@Override
			public Adapter caseURLDocumentSource(URLDocumentSource object) {
				return createURLDocumentSourceAdapter();
			}
			@Override
			public Adapter caseToolUseBlock(ToolUseBlock object) {
				return createToolUseBlockAdapter();
			}
			@Override
			public Adapter caseMCPToolUseBlock(MCPToolUseBlock object) {
				return createMCPToolUseBlockAdapter();
			}
			@Override
			public Adapter caseToolResultBlock(ToolResultBlock object) {
				return createToolResultBlockAdapter();
			}
			@Override
			public Adapter caseMCPToolResultBlock(MCPToolResultBlock object) {
				return createMCPToolResultBlockAdapter();
			}
			@Override
			public Adapter caseTool(Tool object) {
				return createToolAdapter();
			}
			@Override
			public Adapter caseMCPServer(MCPServer object) {
				return createMCPServerAdapter();
			}
			@Override
			public Adapter caseMCPToolConfiguration(MCPToolConfiguration object) {
				return createMCPToolConfigurationAdapter();
			}
			@Override
			public Adapter caseContainer(Container object) {
				return createContainerAdapter();
			}
			@Override
			public Adapter caseSkill(Skill object) {
				return createSkillAdapter();
			}
			@Override
			public Adapter caseContextManagementConfig(ContextManagementConfig object) {
				return createContextManagementConfigAdapter();
			}
			@Override
			public Adapter caseContextEdit(ContextEdit object) {
				return createContextEditAdapter();
			}
			@Override
			public Adapter caseClearToolUsesEdit(ClearToolUsesEdit object) {
				return createClearToolUsesEditAdapter();
			}
			@Override
			public Adapter caseClearThinkingEdit(ClearThinkingEdit object) {
				return createClearThinkingEditAdapter();
			}
			@Override
			public Adapter caseClearTrigger(ClearTrigger object) {
				return createClearTriggerAdapter();
			}
			@Override
			public Adapter caseMetadata(Metadata object) {
				return createMetadataAdapter();
			}
			@Override
			public Adapter caseOutputConfig(OutputConfig object) {
				return createOutputConfigAdapter();
			}
			@Override
			public Adapter caseToolChoice(ToolChoice object) {
				return createToolChoiceAdapter();
			}
			@Override
			public Adapter caseAutoToolChoice(AutoToolChoice object) {
				return createAutoToolChoiceAdapter();
			}
			@Override
			public Adapter caseAnyToolChoice(AnyToolChoice object) {
				return createAnyToolChoiceAdapter();
			}
			@Override
			public Adapter caseToolToolChoice(ToolToolChoice object) {
				return createToolToolChoiceAdapter();
			}
			@Override
			public Adapter caseNoneToolChoice(NoneToolChoice object) {
				return createNoneToolChoiceAdapter();
			}
			@Override
			public Adapter caseThinkingConfig(ThinkingConfig object) {
				return createThinkingConfigAdapter();
			}
			@Override
			public Adapter caseOutputFormat(OutputFormat object) {
				return createOutputFormatAdapter();
			}
			@Override
			public Adapter caseCacheControl(CacheControl object) {
				return createCacheControlAdapter();
			}
			@Override
			public Adapter caseCitations(Citations object) {
				return createCitationsAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest <em>Claude Request</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest
	 * @generated
	 */
	public Adapter createClaudeRequestAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage <em>Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Usage
	 * @generated
	 */
	public Adapter createUsageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse <em>Claude Response</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse
	 * @generated
	 */
	public Adapter createClaudeResponseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt <em>System Prompt</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt
	 * @generated
	 */
	public Adapter createSystemPromptAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Message
	 * @generated
	 */
	public Adapter createMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock <em>Content Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock
	 * @generated
	 */
	public Adapter createContentBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock <em>Text Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock
	 * @generated
	 */
	public Adapter createTextBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock <em>Image Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock
	 * @generated
	 */
	public Adapter createImageBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ImageSource <em>Image Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ImageSource
	 * @generated
	 */
	public Adapter createImageSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource <em>Base64 Image Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource
	 * @generated
	 */
	public Adapter createBase64ImageSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource <em>URL Image Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource
	 * @generated
	 */
	public Adapter createURLImageSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock <em>Document Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock
	 * @generated
	 */
	public Adapter createDocumentBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentSource <em>Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentSource
	 * @generated
	 */
	public Adapter createDocumentSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource <em>Base64 Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource
	 * @generated
	 */
	public Adapter createBase64DocumentSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource <em>Plain Text Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource
	 * @generated
	 */
	public Adapter createPlainTextDocumentSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource <em>URL Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource
	 * @generated
	 */
	public Adapter createURLDocumentSourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock <em>Tool Use Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock
	 * @generated
	 */
	public Adapter createToolUseBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock <em>MCP Tool Use Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock
	 * @generated
	 */
	public Adapter createMCPToolUseBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock <em>Tool Result Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock
	 * @generated
	 */
	public Adapter createToolResultBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock <em>MCP Tool Result Block</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock
	 * @generated
	 */
	public Adapter createMCPToolResultBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool <em>Tool</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool
	 * @generated
	 */
	public Adapter createToolAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer <em>MCP Server</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer
	 * @generated
	 */
	public Adapter createMCPServerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration <em>MCP Tool Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration
	 * @generated
	 */
	public Adapter createMCPToolConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Container <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Container
	 * @generated
	 */
	public Adapter createContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill <em>Skill</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Skill
	 * @generated
	 */
	public Adapter createSkillAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig <em>Context Management Config</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig
	 * @generated
	 */
	public Adapter createContextManagementConfigAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit <em>Context Edit</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit
	 * @generated
	 */
	public Adapter createContextEditAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit <em>Clear Tool Uses Edit</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit
	 * @generated
	 */
	public Adapter createClearToolUsesEditAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit <em>Clear Thinking Edit</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit
	 * @generated
	 */
	public Adapter createClearThinkingEditAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger <em>Clear Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger
	 * @generated
	 */
	public Adapter createClearTriggerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Metadata <em>Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Metadata
	 * @generated
	 */
	public Adapter createMetadataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig <em>Output Config</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig
	 * @generated
	 */
	public Adapter createOutputConfigAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice <em>Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice
	 * @generated
	 */
	public Adapter createToolChoiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.AutoToolChoice <em>Auto Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.AutoToolChoice
	 * @generated
	 */
	public Adapter createAutoToolChoiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.AnyToolChoice <em>Any Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.AnyToolChoice
	 * @generated
	 */
	public Adapter createAnyToolChoiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice <em>Tool Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice
	 * @generated
	 */
	public Adapter createToolToolChoiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.NoneToolChoice <em>None Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.NoneToolChoice
	 * @generated
	 */
	public Adapter createNoneToolChoiceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig <em>Thinking Config</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig
	 * @generated
	 */
	public Adapter createThinkingConfigAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat <em>Output Format</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat
	 * @generated
	 */
	public Adapter createOutputFormatAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl
	 * @generated
	 */
	public Adapter createCacheControlAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Citations <em>Citations</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Citations
	 * @generated
	 */
	public Adapter createCitationsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //ClaudeChatCompletionAdapterFactory
