/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.fennec.ai.chat.completion.model.claude.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage
 * @generated
 */
public class ClaudeChatCompletionSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ClaudeChatCompletionPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClaudeChatCompletionSwitch() {
		if (modelPackage == null) {
			modelPackage = ClaudeChatCompletionPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST: {
				ClaudeRequest claudeRequest = (ClaudeRequest)theEObject;
				T result = caseClaudeRequest(claudeRequest);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.USAGE: {
				Usage usage = (Usage)theEObject;
				T result = caseUsage(usage);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE: {
				ClaudeResponse claudeResponse = (ClaudeResponse)theEObject;
				T result = caseClaudeResponse(claudeResponse);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.SYSTEM_PROMPT: {
				SystemPrompt systemPrompt = (SystemPrompt)theEObject;
				T result = caseSystemPrompt(systemPrompt);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.MESSAGE: {
				Message message = (Message)theEObject;
				T result = caseMessage(message);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CONTENT_BLOCK: {
				ContentBlock contentBlock = (ContentBlock)theEObject;
				T result = caseContentBlock(contentBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.TEXT_BLOCK: {
				TextBlock textBlock = (TextBlock)theEObject;
				T result = caseTextBlock(textBlock);
				if (result == null) result = caseContentBlock(textBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.IMAGE_BLOCK: {
				ImageBlock imageBlock = (ImageBlock)theEObject;
				T result = caseImageBlock(imageBlock);
				if (result == null) result = caseContentBlock(imageBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.IMAGE_SOURCE: {
				ImageSource imageSource = (ImageSource)theEObject;
				T result = caseImageSource(imageSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.BASE64_IMAGE_SOURCE: {
				Base64ImageSource base64ImageSource = (Base64ImageSource)theEObject;
				T result = caseBase64ImageSource(base64ImageSource);
				if (result == null) result = caseImageSource(base64ImageSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.URL_IMAGE_SOURCE: {
				URLImageSource urlImageSource = (URLImageSource)theEObject;
				T result = caseURLImageSource(urlImageSource);
				if (result == null) result = caseImageSource(urlImageSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK: {
				DocumentBlock documentBlock = (DocumentBlock)theEObject;
				T result = caseDocumentBlock(documentBlock);
				if (result == null) result = caseContentBlock(documentBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.DOCUMENT_SOURCE: {
				DocumentSource documentSource = (DocumentSource)theEObject;
				T result = caseDocumentSource(documentSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.BASE64_DOCUMENT_SOURCE: {
				Base64DocumentSource base64DocumentSource = (Base64DocumentSource)theEObject;
				T result = caseBase64DocumentSource(base64DocumentSource);
				if (result == null) result = caseDocumentSource(base64DocumentSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.PLAIN_TEXT_DOCUMENT_SOURCE: {
				PlainTextDocumentSource plainTextDocumentSource = (PlainTextDocumentSource)theEObject;
				T result = casePlainTextDocumentSource(plainTextDocumentSource);
				if (result == null) result = caseDocumentSource(plainTextDocumentSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.URL_DOCUMENT_SOURCE: {
				URLDocumentSource urlDocumentSource = (URLDocumentSource)theEObject;
				T result = caseURLDocumentSource(urlDocumentSource);
				if (result == null) result = caseDocumentSource(urlDocumentSource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.TOOL_USE_BLOCK: {
				ToolUseBlock toolUseBlock = (ToolUseBlock)theEObject;
				T result = caseToolUseBlock(toolUseBlock);
				if (result == null) result = caseContentBlock(toolUseBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK: {
				MCPToolUseBlock mcpToolUseBlock = (MCPToolUseBlock)theEObject;
				T result = caseMCPToolUseBlock(mcpToolUseBlock);
				if (result == null) result = caseContentBlock(mcpToolUseBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK: {
				ToolResultBlock toolResultBlock = (ToolResultBlock)theEObject;
				T result = caseToolResultBlock(toolResultBlock);
				if (result == null) result = caseContentBlock(toolResultBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK: {
				MCPToolResultBlock mcpToolResultBlock = (MCPToolResultBlock)theEObject;
				T result = caseMCPToolResultBlock(mcpToolResultBlock);
				if (result == null) result = caseContentBlock(mcpToolResultBlock);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.TOOL: {
				Tool tool = (Tool)theEObject;
				T result = caseTool(tool);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.MCP_SERVER: {
				MCPServer mcpServer = (MCPServer)theEObject;
				T result = caseMCPServer(mcpServer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION: {
				MCPToolConfiguration mcpToolConfiguration = (MCPToolConfiguration)theEObject;
				T result = caseMCPToolConfiguration(mcpToolConfiguration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CONTAINER: {
				Container container = (Container)theEObject;
				T result = caseContainer(container);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.SKILL: {
				Skill skill = (Skill)theEObject;
				T result = caseSkill(skill);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CONTEXT_MANAGEMENT_CONFIG: {
				ContextManagementConfig contextManagementConfig = (ContextManagementConfig)theEObject;
				T result = caseContextManagementConfig(contextManagementConfig);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CONTEXT_EDIT: {
				ContextEdit contextEdit = (ContextEdit)theEObject;
				T result = caseContextEdit(contextEdit);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT: {
				ClearToolUsesEdit clearToolUsesEdit = (ClearToolUsesEdit)theEObject;
				T result = caseClearToolUsesEdit(clearToolUsesEdit);
				if (result == null) result = caseContextEdit(clearToolUsesEdit);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT: {
				ClearThinkingEdit clearThinkingEdit = (ClearThinkingEdit)theEObject;
				T result = caseClearThinkingEdit(clearThinkingEdit);
				if (result == null) result = caseContextEdit(clearThinkingEdit);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER: {
				ClearTrigger clearTrigger = (ClearTrigger)theEObject;
				T result = caseClearTrigger(clearTrigger);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.METADATA: {
				Metadata metadata = (Metadata)theEObject;
				T result = caseMetadata(metadata);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.OUTPUT_CONFIG: {
				OutputConfig outputConfig = (OutputConfig)theEObject;
				T result = caseOutputConfig(outputConfig);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.TOOL_CHOICE: {
				ToolChoice toolChoice = (ToolChoice)theEObject;
				T result = caseToolChoice(toolChoice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.AUTO_TOOL_CHOICE: {
				AutoToolChoice autoToolChoice = (AutoToolChoice)theEObject;
				T result = caseAutoToolChoice(autoToolChoice);
				if (result == null) result = caseToolChoice(autoToolChoice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.ANY_TOOL_CHOICE: {
				AnyToolChoice anyToolChoice = (AnyToolChoice)theEObject;
				T result = caseAnyToolChoice(anyToolChoice);
				if (result == null) result = caseToolChoice(anyToolChoice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.TOOL_TOOL_CHOICE: {
				ToolToolChoice toolToolChoice = (ToolToolChoice)theEObject;
				T result = caseToolToolChoice(toolToolChoice);
				if (result == null) result = caseToolChoice(toolToolChoice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.NONE_TOOL_CHOICE: {
				NoneToolChoice noneToolChoice = (NoneToolChoice)theEObject;
				T result = caseNoneToolChoice(noneToolChoice);
				if (result == null) result = caseToolChoice(noneToolChoice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.THINKING_CONFIG: {
				ThinkingConfig thinkingConfig = (ThinkingConfig)theEObject;
				T result = caseThinkingConfig(thinkingConfig);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.OUTPUT_FORMAT: {
				OutputFormat outputFormat = (OutputFormat)theEObject;
				T result = caseOutputFormat(outputFormat);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CACHE_CONTROL: {
				CacheControl cacheControl = (CacheControl)theEObject;
				T result = caseCacheControl(cacheControl);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ClaudeChatCompletionPackage.CITATIONS: {
				Citations citations = (Citations)theEObject;
				T result = caseCitations(citations);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Claude Request</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Claude Request</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClaudeRequest(ClaudeRequest object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Usage</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Usage</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUsage(Usage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Claude Response</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Claude Response</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClaudeResponse(ClaudeResponse object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>System Prompt</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>System Prompt</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSystemPrompt(SystemPrompt object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Message</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Message</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMessage(Message object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Content Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Content Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContentBlock(ContentBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Text Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Text Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTextBlock(TextBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Image Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Image Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseImageBlock(ImageBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Image Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Image Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseImageSource(ImageSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Base64 Image Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Base64 Image Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBase64ImageSource(Base64ImageSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>URL Image Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>URL Image Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseURLImageSource(URLImageSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Document Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Document Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDocumentBlock(DocumentBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Document Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDocumentSource(DocumentSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Base64 Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Base64 Document Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBase64DocumentSource(Base64DocumentSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Plain Text Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Plain Text Document Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePlainTextDocumentSource(PlainTextDocumentSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>URL Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>URL Document Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseURLDocumentSource(URLDocumentSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tool Use Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tool Use Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToolUseBlock(ToolUseBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>MCP Tool Use Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>MCP Tool Use Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMCPToolUseBlock(MCPToolUseBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tool Result Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tool Result Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToolResultBlock(ToolResultBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>MCP Tool Result Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>MCP Tool Result Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMCPToolResultBlock(MCPToolResultBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tool</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tool</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTool(Tool object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>MCP Server</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>MCP Server</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMCPServer(MCPServer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>MCP Tool Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>MCP Tool Configuration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMCPToolConfiguration(MCPToolConfiguration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContainer(Container object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Skill</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Skill</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSkill(Skill object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context Management Config</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context Management Config</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContextManagementConfig(ContextManagementConfig object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context Edit</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context Edit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContextEdit(ContextEdit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clear Tool Uses Edit</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clear Tool Uses Edit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClearToolUsesEdit(ClearToolUsesEdit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clear Thinking Edit</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clear Thinking Edit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClearThinkingEdit(ClearThinkingEdit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clear Trigger</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clear Trigger</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClearTrigger(ClearTrigger object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Metadata</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Metadata</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMetadata(Metadata object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Output Config</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Output Config</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOutputConfig(OutputConfig object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tool Choice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToolChoice(ToolChoice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Auto Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Auto Tool Choice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAutoToolChoice(AutoToolChoice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Any Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Any Tool Choice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnyToolChoice(AnyToolChoice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Tool Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Tool Tool Choice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseToolToolChoice(ToolToolChoice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>None Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>None Tool Choice</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNoneToolChoice(NoneToolChoice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Thinking Config</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Thinking Config</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseThinkingConfig(ThinkingConfig object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Output Format</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Output Format</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOutputFormat(OutputFormat object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cache Control</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cache Control</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCacheControl(CacheControl object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Citations</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Citations</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCitations(Citations object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //ClaudeChatCompletionSwitch
