/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.mcp.structured.output.handler;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

/**
 * 
 * @author ilenia
 * @since Dec 3, 2025
 */
@ObjectClassDefinition(
		name = "Structured Output File Storage Configuration",
		description = "Configuration for the Structured Output File Storage Component which handles the output of a StrucuredOutput Tool by saving it to a file"
		)
public @interface StructuredOutputFileStorageConfig {
	
	@AttributeDefinition(
			name = "Storage Folder",
			description = "The path to the folder where the structured output has to be saved",
			required = true
			)
	String storage_folder();
	
	@AttributeDefinition(
			name = "File Extension",
			description = "The file extension of the file where the structured output result will be saved",
			defaultValue = ".json"
			)
	String file_extension() default ".json";
	
	@AttributeDefinition(
			name = "Root EClass URI",
			description = "The URI of the root EClass the structured output represent",
			required = true
			)
	String root_eclass_uri();

}
