/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.mcp.tool.provider;

import java.util.Collections;
import java.util.List;

import org.eclipse.fennec.ai.mcp.api.MCPToolProvider;
import org.osgi.service.component.annotations.Component;

import io.modelcontextprotocol.server.McpServerFeatures.AsyncToolSpecification;

/**
 * 
 * @author ilenia
 * @since Dec 3, 2025
 */
@Component(immediate = true, name = "EmptyMCPToolProvider")
public class EmptyMCPToolProvider implements MCPToolProvider{

	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.ai.mcp.api.MCPToolProvider#getMCPTools()
	 */
	@Override
	public List<AsyncToolSpecification> getMCPTools() {
		return Collections.emptyList();
	}

}
