/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.mcp.tool.provider;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

/**
 * 
 * @author ilenia
 * @since Dec 3, 2025
 */
@ObjectClassDefinition(
		name = "Structured Output Tool Configuration",
		description = "Configuration for the MCP Structured Output Tool"
		)
public @interface StructuredOutputToolConfig {
	
	@AttributeDefinition(
			name = "Tool Name",
			description = "The name of the MCP tool",
			required = true
			)
	String tool_name();
	
	@AttributeDefinition(
			name = "Tool Description",
			description = "The description of the MCP tool. This has to be the most precise as possible so the LLM model knows when to use it.",
			required = true
			)
	String tool_description();
	
	@AttributeDefinition(
			name = "Schema Folder Path",
			description = "The path to the folder containing the json schema to be used in the structured output",
			required = true
			)
	String schema_folder_path();
	
	@AttributeDefinition(
			name = "Schema Filename",
			description = "The filename containing the json schema to be used in the structured output",
			required = true
			)
	String schema_file_name();
	
	@AttributeDefinition(
			name = "Output Root Object Name",
			description = "The name of the root object in which the structred output will be saved by the LLM, if different from the original structure."
			)
	String output_root_object();
	
	
	@AttributeDefinition(
			name = "Structured Output Handler Target",
			description = "The target filter of the StructuredOutputHandler service to be used to handle the output from the LLM",
			required = true
			)
	String structuredOutputHandler_target();
}
