/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.pdf.extractor;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

/**
 * 
 * @author ilenia
 * @since Dec 3, 2025
 */
@ObjectClassDefinition(
		name = "PDF Service Configuration",
		description = "Configuration for the PDFService"
		)
public @interface PDFServiceConfig {
	
	@AttributeDefinition(
			name = "Data Folder",
			description = "The path to the data folder where to store and retrieve the pdf documents",
			required = true
			)
	String data_folder();

}
