/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.persistence.emformmapping.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.persistence.emformmapping.EmformmappingPackage;
import org.eclipse.fennec.persistence.emformmapping.EntityListener;
import org.eclipse.fennec.persistence.emformmapping.EntityListeners;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Entity Listeners</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.persistence.emformmapping.impl.EntityListenersImpl#getEntityListener <em>Entity Listener</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EntityListenersImpl extends MinimalEObjectImpl.Container implements EntityListeners {
	/**
	 * The cached value of the '{@link #getEntityListener() <em>Entity Listener</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntityListener()
	 * @generated
	 * @ordered
	 */
	protected EList<EntityListener> entityListener;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityListenersImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return EmformmappingPackage.eINSTANCE.getEntityListeners();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EntityListener> getEntityListener() {
		if (entityListener == null) {
			entityListener = new EObjectContainmentEList<EntityListener>(EntityListener.class, this, EmformmappingPackage.ENTITY_LISTENERS__ENTITY_LISTENER);
		}
		return entityListener;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case EmformmappingPackage.ENTITY_LISTENERS__ENTITY_LISTENER:
				return ((InternalEList<?>)getEntityListener()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case EmformmappingPackage.ENTITY_LISTENERS__ENTITY_LISTENER:
				return getEntityListener();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case EmformmappingPackage.ENTITY_LISTENERS__ENTITY_LISTENER:
				getEntityListener().clear();
				getEntityListener().addAll((Collection<? extends EntityListener>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case EmformmappingPackage.ENTITY_LISTENERS__ENTITY_LISTENER:
				getEntityListener().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case EmformmappingPackage.ENTITY_LISTENERS__ENTITY_LISTENER:
				return entityListener != null && !entityListener.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //EntityListenersImpl
