/**
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.jpa.demo;

import static java.util.Objects.nonNull;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.mappings.AttributeAccessor;

/**
 * 
 * @author mark
 * @since 09.12.2024
 */
public class EFeatureAccessor extends AttributeAccessor {

	/** serialVersionUID */
	private static final long serialVersionUID = 1L;
	private final EStructuralFeature feature;
	private static final Map<EStructuralFeature, AttributeAccessor> accessorMap = new ConcurrentHashMap<>();
	
	public static AttributeAccessor create(EStructuralFeature feature) {
		return accessorMap.computeIfAbsent(feature, EFeatureAccessor::new);
	}
	
	private EFeatureAccessor(EStructuralFeature feature) {
		this.feature = feature;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.persistence.mappings.AttributeAccessor#getAttributeValueFromObject(java.lang.Object)
	 */
	@Override
	public Object getAttributeValueFromObject(Object object) throws DescriptorException {
		if (object instanceof EObject && nonNull(feature)) {
			EObject eo = (EObject) object;
			return eo.eGet(feature);
		}
		return object;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.persistence.mappings.AttributeAccessor#setAttributeValueInObject(java.lang.Object, java.lang.Object)
	 */
	@Override
	public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
		if (object instanceof EObject && nonNull(feature)) {
			EObject eo = (EObject) object;
			eo.eSet(feature, value);
		}
	}

}
