/**
 * Copyright (c) 2012 - 2023 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v2.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.jpa.demo;

import org.gecko.emf.osgi.example.model.basic.BasicPackage;
import org.gecko.emf.osgi.example.model.basic.Contact;
import org.gecko.emf.osgi.example.model.basic.ContactContextType;
import org.gecko.emf.osgi.example.model.basic.ContactType;
import org.gecko.emf.osgi.example.model.basic.GenderType;
import org.gecko.emf.osgi.example.model.basic.Person;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

import jakarta.persistence.EntityManagerFactory;

/**
 * https://wiki.eclipse.org/EclipseLink/Examples/JPA/Dynamic
 * https://wiki.eclipse.org/EclipseLink/Examples/JPA/Dynamic/CustomizeAttributes
 * https://wiki.eclipse.org/EclipseLink/Examples/Foundation/DynamicPersistence
 * 
 * @author mark
 * @since 13.01.2023
 */
//@Component
public class TestBasicModelComponent {
	
	@Reference(target = "(" + EntityManagerFactoryBuilder.JPA_UNIT_NAME + "=Employee)")
    private EntityManagerFactory emf;
	@Reference
	private BasicPackage bp;
	
	@Activate
	public void activate(BundleContext ctx) {
		System.out.println("Got basic model");
        System.out.println("Gemini JPA Basic Component Sample started");
        BasicModelClient client = new BasicModelClient(emf);
        client.initEPackage(bp);
        Person p = bp.getBasicFactory().createPerson();
        p.setId("maho");
        p.setFirstName("Mark");
        p.setLastName("Hoffmann");
        p.setGender(GenderType.MALE);
        Contact c1 = bp.getBasicFactory().createContact();
        p.getContact().add(c1);
        c1.setContext(ContactContextType.HOME);
        c1.setType(ContactType.EMAIL);
        c1.setValue("bla@blub.com");
        Contact c2 = bp.getBasicFactory().createContact();
        p.getContact().add(c2);
        c2.setContext(ContactContextType.PRIVATE);
        c2.setType(ContactType.WEBADDRESS);
        c2.setValue("https://www.blub.com");
        client.runDynamic(p);
        client.readDynamic(p.eClass());
	}

}
