/*******************************************************************************
 * Copyright (c) 2010 Oracle.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution. 
 * The Eclipse Public License is available at
 *     http://www.eclipse.org/legal/epl-v10.html
 * and the Apache License v2.0 is available at 
 *     http://www.opensource.org/licenses/apache2.0.php.
 * You may elect to redistribute this code under either of these licenses.
 *
 * Contributors:
 *     mkeith - Gemini JPA sample 
 ******************************************************************************/
package org.eclipse.fennec.jpa.demo;

import java.util.Date;
import java.util.List;

import org.eclipse.fennec.jpa.demo.classloader.OSGiJPADynamicHelper;
import org.eclipse.fennec.jpa.demo.entities.Account;
import org.eclipse.fennec.jpa.demo.entities.Address;
import org.eclipse.fennec.jpa.demo.entities.Customer;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.queries.ReadAllQuery;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FindOption;
import jakarta.persistence.TypedQuery;

/**
 * Gemini JPA sample client class
 * 
 * @author mkeith
 */
public class AccountClient {
    
    public void run(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        
        Customer c1 = new Customer("Chan", "Jackie");
        Customer c2 = new Customer("Emil", "Tester");
        Address a1 = new Address("1034 KingFu Lane", "Los Angeles, CA");
//        Address a2 = new Address("Kahlaische Str. 4", "Jena, TH");
//        Address a3 = new Address("Testweg Str. 42", "Testtown, TT");
        c1.getAddress().add(a1);
        a1.getCustomers().add(c1);
        
        c2.getAddress().add(a1);
        a1.getCustomers().add(c2);
//        c1.getAddress().add(a2);
//        a2.getCustomers().add(c1);
//        c2.getAddress().add(a2);
//        a2.getCustomers().add(c2);
//        
//        c2.getAddress().add(a3);
//        a3.getCustomers().add(c2);
        
        em.persist(c1);
        em.persist(c2);
        em.persist(a1);
//        em.persist(a2);
//        em.persist(a3);
//        Account a = new Account(c1);
//        a.setBalance(100.0);
//        Account a42 = new Account(c);
//        a42.setBalance(42);
//        em.persist(a42);
//        c.setAccountMT(a42);
//        em.persist(a);

        em.getTransaction().commit();
        em.clear();
//        Account account = em.find(Account.class, a.getId());
//        TypedQuery<Account> q = em.createQuery("SELECT a FROM Account a", Account.class);
//        List<Account> results = q.getResultList();
//        System.out.println("\n*** Account Report ***");
//        for (Account acct : results) {
//            System.out.println("Account: " + acct);
//        }
        em = emf.createEntityManager();
        try {
        Customer customer = em.find(Customer.class, c1.getId());
        System.out.println("CUSTOMER: " + customer.toString());
        List<Address> addresses = customer.getAddress();
        addresses.forEach(a->{
        	System.out.println("ADDRESS CUSTOMER 1 :   " + a.toString());
        	System.out.println("ADDRESS CUSTOMER SIZE: " + a.getCustomers().size());
        });
        em = emf.createEntityManager();
        customer = em.find(Customer.class, c2.getId());
        System.out.println("CUSTOMER: " + customer.toString());
        addresses = customer.getAddress();
        addresses.forEach(a->System.out.println("ADDRESS CUSTOMER 2" + a.toString()));
        em = emf.createEntityManager();
        Address address = em.find(Address.class, a1.getId());
        System.out.println("ADDRESS " + address.toString());
        List<Customer> customers = address.getCustomers();
        customers.forEach(c->System.out.println("ADDRESS 2 CUSTOMER" + c.toString()));
        em.close();
        } catch(Exception e) {
        	e.printStackTrace();
        }
    }
    @SuppressWarnings("unchecked")
	public void runDynamic(EntityManagerFactory emf) {
    	EntityManager em = emf.createEntityManager();
    	JPADynamicHelper helper = new OSGiJPADynamicHelper(em);
    	DynamicClassLoader dcl = helper.getDynamicClassLoader();
    	Class<?> employeeClass= dcl.createDynamicClass("scott.Emp");
    	Class<?> deptClass= dcl.createDynamicClass("scott.Dept");
    	DynamicTypeBuilder employeeBuilder = new DynamicTypeBuilder(employeeClass,
    	    null /*no parent type*/, "EMP");
    	DynamicTypeBuilder deptBuilder = new DynamicTypeBuilder(deptClass,
    	    null /*no parent type*/, "DEPT");
    	employeeBuilder.setPrimaryKeyFields("EMPNO");
    	employeeBuilder.addDirectMapping("employeeNumber", int.class, "EMPNO");
    	employeeBuilder.addDirectMapping("name", String.class, "ENAME");
    	employeeBuilder.addDirectMapping("job", String.class, "JOB");
    	employeeBuilder.addDirectMapping("hiredOn", Date.class, "HIREDATE");
    	employeeBuilder.addDirectMapping("salaryPerWeek", int.class, "SAL");
    	employeeBuilder.addDirectMapping("commision", int.class, "COMM");
    	employeeBuilder.addOneToOneMapping("manager", employeeBuilder.getType(), "MGR");
    	deptBuilder.setPrimaryKeyFields("DEPTNO");
    	deptBuilder.addDirectMapping("deptNumber", int.class, "DEPTNO");
    	deptBuilder.addDirectMapping("name", String.class, "DNAME");
    	deptBuilder.addDirectMapping("location", String.class, "LOC");
    	employeeBuilder.addOneToOneMapping("department", deptBuilder.getType(), "DEPTNO");
    	
    	
    	helper.addTypes(true /*create tables*/, true /*create constraints*/,
    	    employeeBuilder.getType(), deptBuilder.getType());
    	 
    	DynamicEntity deptEntity = deptBuilder.getType().newDynamicEntity();
    	deptEntity.set("deptNumber", 12);
    	deptEntity.set("name", "digitalization");
    	deptEntity.set("location", "Jena DIMC Office");
    	
    	DynamicEntity employeeEntity = employeeBuilder.getType().newDynamicEntity();
    	employeeEntity.set("employeeNumber", 1);
    	employeeEntity.set("name", "Mark");
    	employeeEntity.set("job", "CTO");
//    	employeeEntity.set("hiredOn", new Date());
    	employeeEntity.set("salaryPerWeek", 1750);
    	employeeEntity.set("commision", 42);
    	employeeEntity.set("department", deptEntity);
    	
    	ReadAllQuery query = helper.newReadAllQuery("Emp");
    	List<DynamicEntity> employees = (List<DynamicEntity>)helper.getSession().executeQuery(query);
    	if (employees.isEmpty()) {
    		em.getTransaction().begin();
    		em.persist(deptEntity);
    		em.persist(employeeEntity);
    		em.getTransaction().commit();
    	}
    	
    	query = helper.newReadAllQuery("Emp");
    	query.addAscendingOrdering("name");
    	System.out.println("Employees-Size " + employees.size());
    	employees.forEach(e->{
    		System.out.println("Employee " + e.get("name"));
    		DynamicEntity dept = e.get("department");
    		System.out.println("Employee Department " + dept.get("name"));
    	
    	});
    	em.close();
    }
}