/*******************************************************************************
 * Copyright (c) 2010 Oracle.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution. 
 * The Eclipse Public License is available at
 *     http://www.eclipse.org/legal/epl-v10.html
 * and the Apache License v2.0 is available at 
 *     http://www.opensource.org/licenses/apache2.0.php.
 * You may elect to redistribute this code under either of these licenses.
 *
 * Contributors:
 *     mkeith - Gemini JPA Sample 
 ******************************************************************************/
package org.eclipse.fennec.jpa.demo.entities;

import java.util.ArrayList;
import java.util.List;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;

/**
 * Sample JPA model class
 * 
 * @author mkeith
 */
@Entity
public class Address {

    @Id @GeneratedValue
    int addressId;
    
    String street;
    String city;
    
    @ManyToMany(mappedBy="address")
    List<Customer> customers;
    
    /* Constructors */
    public Address() { 
    }
    public Address(String street, String city) {
        this();
        this.street = street;
        this.city = city;
        customers = new ArrayList<>();
    }
    
    /* Getters and setters */
    public int getId() { return addressId; }
    public void setId(int id) { this.addressId = id; }
    
    public String getStreet() { return street; }
    public void setStreet(String street) { this.street = street; }
    public String getCity() { return city; }
    public void setCity(String city) { this.city = city; }

    
    public List<Customer> getCustomers() { return customers; }
    public void setTxns(List<Customer> customers) { this.customers = customers; }
    
    public String toString() {
        return "Address(" + addressId + ", " + ", Street: " + street + ", City: " + city + ", Customers: " + (customers==null?0:customers.size()) + ")";
    }
}
