/*******************************************************************************
 * Copyright (c) 2010 Oracle.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution. 
 * The Eclipse Public License is available at
 *     http://www.eclipse.org/legal/epl-v10.html
 * and the Apache License v2.0 is available at 
 *     http://www.opensource.org/licenses/apache2.0.php.
 * You may elect to redistribute this code under either of these licenses.
 *
 * Contributors:
 *     mkeith - Gemini JPA Sample 
 ******************************************************************************/
package org.eclipse.fennec.jpa.demo.entities;

import java.util.ArrayList;
import java.util.List;

import jakarta.persistence.*;

/**
 * Gemini JPA Sample class
 * 
 * @author mkeith
 */
@Entity
public class Customer {
    @Id @GeneratedValue
    int customerId;
    
    @Column(name="LNAME")
    String lastName;
    
    @Column(name="FNAME")
    String firstName;

    @ManyToMany
//    @JoinTable(name = "CUST-ADR",
//    	    joinColumns = {
//    	            @JoinColumn(name = "customer_id", nullable = false, referencedColumnName = "customerId")
//    	    },
//    	    inverseJoinColumns = {
//    	            @JoinColumn(name = "account_id", nullable = false, referencedColumnName = "addressId")
//    	    }
//    	)
    List<Address> address;
    @ElementCollection
    List<Integer> number; 

    @OneToOne(cascade = CascadeType.ALL)
    Account account;
    
    @OneToMany
    List<Address> custAddr; 
    
//    @OneToOne
//    @JoinTable(
//    	    joinColumns = {
//    	            @JoinColumn(name = "customer_id", nullable = false, referencedColumnName = "customerId")
//    	    },
//    	    inverseJoinColumns = {
//    	            @JoinColumn(name = "account_id", nullable = false)
//    	    }
//    	)
    Account accountMT;

    /* Constructors */
    public Customer() { super(); }
    public Customer(String lastName, String firstName) {
        super();
        this.lastName = lastName;
        this.firstName = firstName;
        this.address = new ArrayList<>();
        this.custAddr = new ArrayList<>();
    }

    /* Getters and setters */
    public int getId() { return customerId; }
    
    public String getLastName() { return lastName; }
    public void setLastName(String lastName) { this.lastName = lastName; }

    public String getFirstName() { return firstName; }
    public void setFirstName(String firstName) { this.firstName = firstName; }

    public List<Address> getAddress() { return address; }
    public void setAddress(List<Address> address) { this.address = address; }
    
    public List<Address> getCustAddr() { return custAddr; }
    public void setCustAddr(List<Address> custAddr) { this.custAddr = custAddr; }
    
    public List<Integer> getNumber() { return number; }
    public void setNumber(List<Integer> number) { this.number = number; }

    public Account getAccount() { return account; }
    public void setAccount(Account account) { this.account = account; }
    
    public Account getAccountMT() { return accountMT; }
    public void setAccountMT(Account accountMT) { this.accountMT = accountMT; }
    
    public String toString() {
        return "Customer(" + firstName + " " + lastName + ", " + address + ")";
    }
}
