/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v2.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.persistence.old.context;

import java.util.List;
import java.util.Map;

import org.eclipse.fennec.persistence.old.api.ConverterService;
import org.eclipse.fennec.persistence.old.api.PrimaryKeyFactory;
import org.eclipse.fennec.persistence.old.api.QueryEngine;
import org.eclipse.fennec.persistence.old.mapping.EObjectMapper;
import org.eclipse.fennec.persistence.old.mapping.InputContentHandler;

/**
 * Just a wrapper to hold important information
 * @author Mark Hoffmann
 * @since 08.04.2022
 */
public interface PersistenceContext<TABLE, QT, RT, ENGINE, MAPPER extends EObjectMapper> {
	
	ConverterService getConverterSevice();
	
	List<InputContentHandler<RT, MAPPER>> getInputContentHandler();
	
	QueryEngine<QT, ENGINE> getQueryEngine();
	
	Map<String, PrimaryKeyFactory> getKeyFactories();

}
