/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v2.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.persistence.old.mapping;

import java.util.Map;

/**
 * Implementation of InputContentHandler that does not need a resource cache for the result
 * @param <RESULT> the result provider / iterator
 * @param <MAPPER> the optional result mapper
 * @author Mark Hoffmann
 * @since 26.03.2022
 */
public abstract class UncachedInputContentHandler<RESULT, MAPPER extends EObjectMapper> implements InputContentHandler<RESULT, MAPPER> {
	
	/* 
	 * (non-Javadoc)
	 * @see org.eclipse.fennec.persistence.old.old.api.InputContentHandler#enableResourceCache(java.util.Map)
	 */
	@Override
	public boolean enableResourceCache(Map<Object, Object> options) {
		return false;
	}
	
}
