/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.camel.camelspring;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Bean Constructors Definition</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.BeanConstructorsDefinition#getConstructor <em>Constructor</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.camel.camelspring.CamelSpringPackage#getBeanConstructorsDefinition()
 * @model extendedMetaData="name='beanConstructorsDefinition' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface BeanConstructorsDefinition extends EObject {
	/**
	 * Returns the value of the '<em><b>Constructor</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.camel.camelspring.BeanConstructorDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Constructor</em>' containment reference list.
	 * @see org.eclipse.fennec.camel.camelspring.CamelSpringPackage#getBeanConstructorsDefinition_Constructor()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='constructor' namespace='##targetNamespace'"
	 * @generated
	 */
	EList<BeanConstructorDefinition> getConstructor();

} // BeanConstructorsDefinition
