/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.camel.camelspring;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.camel.camelspring.CamelSpringFactory
 * @model kind="package"
 * @generated
 */
@ProviderType
@EPackage(uri = CamelSpringPackage.eNS_URI, genModel = "/model/camel-spring.genmodel", genModelSourceLocations = {"model/camel-spring.genmodel","org.eclipse.fennec.camel.model/model/camel-spring.genmodel"}, ecore="/model/camel-spring.ecore", ecoreSourceLocations="/model/camel-spring.ecore")
public interface CamelSpringPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "camelspring";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://camel.apache.org/schema/spring";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "camelspring";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	CamelSpringPackage eINSTANCE = org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.IdentifiedTypeImpl <em>Identified Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.IdentifiedTypeImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getIdentifiedType()
	 * @generated
	 */
	int IDENTIFIED_TYPE = 125;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_TYPE__ID = 0;

	/**
	 * The number of structural features of the '<em>Identified Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Identified Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelFactoryBeanImpl <em>Abstract Camel Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_FACTORY_BEAN = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FACTORY_BEAN__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Camel Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Camel Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelConsumerTemplateFactoryBeanImpl <em>Abstract Camel Consumer Template Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelConsumerTemplateFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelConsumerTemplateFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Maximum Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Camel Consumer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Camel Consumer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelContextFactoryBeanImpl <em>Abstract Camel Context Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelContextFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelContextFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Abstract Camel Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Camel Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelEndpointFactoryBeanImpl <em>Abstract Camel Endpoint Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelEndpointFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelEndpointFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__PROPERTY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__URI = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Camel Endpoint Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract Camel Endpoint Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelFluentProducerTemplateFactoryBeanImpl <em>Abstract Camel Fluent Producer Template Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelFluentProducerTemplateFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelFluentProducerTemplateFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Default Endpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__DEFAULT_ENDPOINT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Camel Fluent Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract Camel Fluent Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelProducerTemplateFactoryBeanImpl <em>Abstract Camel Producer Template Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelProducerTemplateFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelProducerTemplateFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Default Endpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__DEFAULT_ENDPOINT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Camel Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract Camel Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelRedeliveryPolicyFactoryBeanImpl <em>Abstract Camel Redelivery Policy Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelRedeliveryPolicyFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelRedeliveryPolicyFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Allow Redelivery While Stopping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ALLOW_REDELIVERY_WHILE_STOPPING = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Async Delayed Redelivery</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ASYNC_DELAYED_REDELIVERY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Back Off Multiplier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__BACK_OFF_MULTIPLIER = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Collision Avoidance Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__COLLISION_AVOIDANCE_FACTOR = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Delay Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__DELAY_PATTERN = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Disable Redelivery</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__DISABLE_REDELIVERY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Exchange Formatter Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__EXCHANGE_FORMATTER_REF = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Log Continued</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_CONTINUED = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Log Exhausted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Log Exhausted Message Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_BODY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Log Exhausted Message History</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_HISTORY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Log Handled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_HANDLED = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Log New Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_NEW_EXCEPTION = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Log Retry Attempted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_RETRY_ATTEMPTED = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Log Retry Stack Trace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_RETRY_STACK_TRACE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Log Stack Trace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_STACK_TRACE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Maximum Redeliveries</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__MAXIMUM_REDELIVERIES = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Maximum Redelivery Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__MAXIMUM_REDELIVERY_DELAY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Redelivery Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__REDELIVERY_DELAY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Retries Exhausted Log Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRIES_EXHAUSTED_LOG_LEVEL = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Retry Attempted Log Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRY_ATTEMPTED_LOG_INTERVAL = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Retry Attempted Log Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRY_ATTEMPTED_LOG_LEVEL = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Use Collision Avoidance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__USE_COLLISION_AVOIDANCE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Use Exponential Back Off</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__USE_EXPONENTIAL_BACK_OFF = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>Abstract Camel Redelivery Policy Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 24;

	/**
	 * The number of operations of the '<em>Abstract Camel Redelivery Policy Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractCamelThreadPoolFactoryBeanImpl <em>Abstract Camel Thread Pool Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractCamelThreadPoolFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractCamelThreadPoolFactoryBean()
	 * @generated
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Allow Core Thread Time Out</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__ALLOW_CORE_THREAD_TIME_OUT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Keep Alive Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__KEEP_ALIVE_TIME = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__MAX_POOL_SIZE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Max Queue Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__MAX_QUEUE_SIZE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__POOL_SIZE = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Rejected Policy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__REJECTED_POLICY = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Scheduled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__SCHEDULED = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Thread Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__THREAD_NAME = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Time Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__TIME_UNIT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Abstract Camel Thread Pool Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>Abstract Camel Thread Pool Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractJsseUtilFactoryBeanImpl <em>Abstract Jsse Util Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractJsseUtilFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractJsseUtilFactoryBean()
	 * @generated
	 */
	int ABSTRACT_JSSE_UTIL_FACTORY_BEAN = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_JSSE_UTIL_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_JSSE_UTIL_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The number of structural features of the '<em>Abstract Jsse Util Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Jsse Util Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_JSSE_UTIL_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractKeyManagersParametersFactoryBeanImpl <em>Abstract Key Managers Parameters Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractKeyManagersParametersFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractKeyManagersParametersFactoryBean()
	 * @generated
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__ALGORITHM = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Key Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__KEY_PASSWORD = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__PROVIDER = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Key Managers Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Abstract Key Managers Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractKeyStoreParametersFactoryBeanImpl <em>Abstract Key Store Parameters Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractKeyStoreParametersFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractKeyStoreParametersFactoryBean()
	 * @generated
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Key Store</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__KEY_STORE = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__PASSWORD = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__PROVIDER = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__RESOURCE = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__TYPE = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Abstract Key Store Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Abstract Key Store Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractSecureRandomParametersFactoryBeanImpl <em>Abstract Secure Random Parameters Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractSecureRandomParametersFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractSecureRandomParametersFactoryBean()
	 * @generated
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN__ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN__ALGORITHM = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN__PROVIDER = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Secure Random Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract Secure Random Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SECURE_RANDOM_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AbstractTrustManagersParametersFactoryBeanImpl <em>Abstract Trust Managers Parameters Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AbstractTrustManagersParametersFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAbstractTrustManagersParametersFactoryBean()
	 * @generated
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN__ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_JSSE_UTIL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN__ALGORITHM = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN__PROVIDER = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Trust Manager</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN__TRUST_MANAGER = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Trust Managers Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Abstract Trust Managers Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRUST_MANAGERS_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_JSSE_UTIL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OptionalIdentifiedDefinitionImpl <em>Optional Identified Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OptionalIdentifiedDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOptionalIdentifiedDefinition()
	 * @generated
	 */
	int OPTIONAL_IDENTIFIED_DEFINITION = 177;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_IDENTIFIED_DEFINITION__ID = 2;

	/**
	 * The number of structural features of the '<em>Optional Identified Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Optional Identified Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ProcessorDefinitionImpl <em>Processor Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ProcessorDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getProcessorDefinition()
	 * @generated
	 */
	int PROCESSOR_DEFINITION = 196;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DEFINITION__DISABLED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Processor Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Processor Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OutputImpl <em>Output</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OutputImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOutput()
	 * @generated
	 */
	int OUTPUT = 179;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The number of structural features of the '<em>Output</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Output</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AggregateDefinitionImpl <em>Aggregate Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AggregateDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAggregateDefinition()
	 * @generated
	 */
	int AGGREGATE_DEFINITION = 13;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Correlation Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CORRELATION_EXPRESSION = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Completion Predicate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_PREDICATE = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Completion Timeout Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_TIMEOUT_EXPRESSION = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Completion Size Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_SIZE_EXPRESSION = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Optimistic Lock Retry Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__OPTIMISTIC_LOCK_RETRY_POLICY = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Aggregate Controller</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__AGGREGATE_CONTROLLER = OUTPUT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Aggregation Repository</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__AGGREGATION_REPOSITORY = OUTPUT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__AGGREGATION_STRATEGY = OUTPUT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Allow Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__AGGREGATION_STRATEGY_METHOD_ALLOW_NULL = OUTPUT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__AGGREGATION_STRATEGY_METHOD_NAME = OUTPUT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Close Correlation Key On Completion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__CLOSE_CORRELATION_KEY_ON_COMPLETION = OUTPUT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Complete All On Stop</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETE_ALL_ON_STOP = OUTPUT_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Completion From Batch Consumer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_FROM_BATCH_CONSUMER = OUTPUT_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Completion Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_INTERVAL = OUTPUT_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Completion On New Correlation Group</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_ON_NEW_CORRELATION_GROUP = OUTPUT_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Completion Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_SIZE = OUTPUT_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>Completion Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_TIMEOUT = OUTPUT_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>Completion Timeout Checker Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__COMPLETION_TIMEOUT_CHECKER_INTERVAL = OUTPUT_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>Discard On Aggregation Failure</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DISCARD_ON_AGGREGATION_FAILURE = OUTPUT_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Discard On Completion Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__DISCARD_ON_COMPLETION_TIMEOUT = OUTPUT_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Eager Check Completion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__EAGER_CHECK_COMPLETION = OUTPUT_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__EXECUTOR_SERVICE = OUTPUT_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Force Completion On Stop</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__FORCE_COMPLETION_ON_STOP = OUTPUT_FEATURE_COUNT + 93;

	/**
	 * The feature id for the '<em><b>Ignore Invalid Correlation Keys</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__IGNORE_INVALID_CORRELATION_KEYS = OUTPUT_FEATURE_COUNT + 94;

	/**
	 * The feature id for the '<em><b>Optimistic Locking</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__OPTIMISTIC_LOCKING = OUTPUT_FEATURE_COUNT + 95;

	/**
	 * The feature id for the '<em><b>Parallel Processing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__PARALLEL_PROCESSING = OUTPUT_FEATURE_COUNT + 96;

	/**
	 * The feature id for the '<em><b>Timeout Checker Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION__TIMEOUT_CHECKER_EXECUTOR_SERVICE = OUTPUT_FEATURE_COUNT + 97;

	/**
	 * The number of structural features of the '<em>Aggregate Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 98;

	/**
	 * The number of operations of the '<em>Aggregate Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AGGREGATE_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AllowableValuesTypeImpl <em>Allowable Values Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AllowableValuesTypeImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAllowableValuesType()
	 * @generated
	 */
	int ALLOWABLE_VALUES_TYPE = 14;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOWABLE_VALUES_TYPE__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Allowable Values Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOWABLE_VALUES_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Allowable Values Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOWABLE_VALUES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AllowableValuesType1Impl <em>Allowable Values Type1</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AllowableValuesType1Impl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAllowableValuesType1()
	 * @generated
	 */
	int ALLOWABLE_VALUES_TYPE1 = 15;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOWABLE_VALUES_TYPE1__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Allowable Values Type1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOWABLE_VALUES_TYPE1_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Allowable Values Type1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOWABLE_VALUES_TYPE1_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.RestSecurityDefinitionImpl <em>Rest Security Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.RestSecurityDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getRestSecurityDefinition()
	 * @generated
	 */
	int REST_SECURITY_DEFINITION = 226;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REST_SECURITY_DEFINITION__DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REST_SECURITY_DEFINITION__KEY = 1;

	/**
	 * The number of structural features of the '<em>Rest Security Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REST_SECURITY_DEFINITION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Rest Security Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REST_SECURITY_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ApiKeyDefinitionImpl <em>Api Key Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ApiKeyDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getApiKeyDefinition()
	 * @generated
	 */
	int API_KEY_DEFINITION = 16;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION__DESCRIPTION = REST_SECURITY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION__KEY = REST_SECURITY_DEFINITION__KEY;

	/**
	 * The feature id for the '<em><b>In Cookie</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION__IN_COOKIE = REST_SECURITY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>In Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION__IN_HEADER = REST_SECURITY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>In Query</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION__IN_QUERY = REST_SECURITY_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION__NAME = REST_SECURITY_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Api Key Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION_FEATURE_COUNT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Api Key Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int API_KEY_DEFINITION_OPERATION_COUNT = REST_SECURITY_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeansDefinitionImpl <em>Beans Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeansDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeansDefinition()
	 * @generated
	 */
	int BEANS_DEFINITION = 32;

	/**
	 * The feature id for the '<em><b>Component Scan</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__COMPONENT_SCAN = 0;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__BEAN = 1;

	/**
	 * The feature id for the '<em><b>Any</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__ANY = 2;

	/**
	 * The feature id for the '<em><b>Data Formats</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__DATA_FORMATS = 3;

	/**
	 * The feature id for the '<em><b>Rest Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__REST_CONFIGURATION = 4;

	/**
	 * The feature id for the '<em><b>Rest</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__REST = 5;

	/**
	 * The feature id for the '<em><b>Route Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__ROUTE_CONFIGURATION = 6;

	/**
	 * The feature id for the '<em><b>Route Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__ROUTE_TEMPLATE = 7;

	/**
	 * The feature id for the '<em><b>Templated Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__TEMPLATED_ROUTE = 8;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION__ROUTE = 9;

	/**
	 * The number of structural features of the '<em>Beans Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Beans Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANS_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ApplicationDefinitionImpl <em>Application Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ApplicationDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getApplicationDefinition()
	 * @generated
	 */
	int APPLICATION_DEFINITION = 17;

	/**
	 * The feature id for the '<em><b>Component Scan</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__COMPONENT_SCAN = BEANS_DEFINITION__COMPONENT_SCAN;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__BEAN = BEANS_DEFINITION__BEAN;

	/**
	 * The feature id for the '<em><b>Any</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__ANY = BEANS_DEFINITION__ANY;

	/**
	 * The feature id for the '<em><b>Data Formats</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__DATA_FORMATS = BEANS_DEFINITION__DATA_FORMATS;

	/**
	 * The feature id for the '<em><b>Rest Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__REST_CONFIGURATION = BEANS_DEFINITION__REST_CONFIGURATION;

	/**
	 * The feature id for the '<em><b>Rest</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__REST = BEANS_DEFINITION__REST;

	/**
	 * The feature id for the '<em><b>Route Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__ROUTE_CONFIGURATION = BEANS_DEFINITION__ROUTE_CONFIGURATION;

	/**
	 * The feature id for the '<em><b>Route Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__ROUTE_TEMPLATE = BEANS_DEFINITION__ROUTE_TEMPLATE;

	/**
	 * The feature id for the '<em><b>Templated Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__TEMPLATED_ROUTE = BEANS_DEFINITION__TEMPLATED_ROUTE;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION__ROUTE = BEANS_DEFINITION__ROUTE;

	/**
	 * The number of structural features of the '<em>Application Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION_FEATURE_COUNT = BEANS_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Application Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APPLICATION_DEFINITION_OPERATION_COUNT = BEANS_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DataFormatImpl <em>Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDataFormat()
	 * @generated
	 */
	int DATA_FORMAT = 79;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.Asn1DataFormatImpl <em>Asn1 Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.Asn1DataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAsn1DataFormat()
	 * @generated
	 */
	int ASN1_DATA_FORMAT = 18;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASN1_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASN1_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Using Iterator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASN1_DATA_FORMAT__USING_ITERATOR = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Asn1 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASN1_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Asn1 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASN1_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.AvroDataFormatImpl <em>Avro Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.AvroDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getAvroDataFormat()
	 * @generated
	 */
	int AVRO_DATA_FORMAT = 19;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Jms Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__ALLOW_JMS_TYPE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Unmarshall Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__ALLOW_UNMARSHALL_TYPE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Auto Discover Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__AUTO_DISCOVER_OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Auto Discover Schema Resolver</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__AUTO_DISCOVER_SCHEMA_RESOLVER = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Collection Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__COLLECTION_TYPE = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__CONTENT_TYPE_HEADER = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Disable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__DISABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Enable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__ENABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Include</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__INCLUDE = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Instance Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__INSTANCE_CLASS_NAME = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Json View</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__JSON_VIEW = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Library</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__LIBRARY = DATA_FORMAT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Module Class Names</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__MODULE_CLASS_NAMES = DATA_FORMAT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Module Refs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__MODULE_REFS = DATA_FORMAT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Schema Resolver</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__SCHEMA_RESOLVER = DATA_FORMAT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__TIMEZONE = DATA_FORMAT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Use Default Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__USE_DEFAULT_OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Use List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT__USE_LIST = DATA_FORMAT_FEATURE_COUNT + 19;

	/**
	 * The number of structural features of the '<em>Avro Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 20;

	/**
	 * The number of operations of the '<em>Avro Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AVRO_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BarcodeDataFormatImpl <em>Barcode Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BarcodeDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBarcodeDataFormat()
	 * @generated
	 */
	int BARCODE_DATA_FORMAT = 20;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Barcode Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT__BARCODE_FORMAT = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT__HEIGHT = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Image Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT__IMAGE_TYPE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT__WIDTH = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Barcode Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Barcode Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BARCODE_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.Base64DataFormatImpl <em>Base64 Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.Base64DataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBase64DataFormat()
	 * @generated
	 */
	int BASE64_DATA_FORMAT = 21;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Line Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DATA_FORMAT__LINE_LENGTH = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Line Separator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DATA_FORMAT__LINE_SEPARATOR = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Url Safe</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DATA_FORMAT__URL_SAFE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Base64 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Base64 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BaseErrorHandlerDefinitionImpl <em>Base Error Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BaseErrorHandlerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBaseErrorHandlerDefinition()
	 * @generated
	 */
	int BASE_ERROR_HANDLER_DEFINITION = 22;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ERROR_HANDLER_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Base Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Base Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_ERROR_HANDLER_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BasicAuthDefinitionImpl <em>Basic Auth Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BasicAuthDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBasicAuthDefinition()
	 * @generated
	 */
	int BASIC_AUTH_DEFINITION = 23;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_AUTH_DEFINITION__DESCRIPTION = REST_SECURITY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_AUTH_DEFINITION__KEY = REST_SECURITY_DEFINITION__KEY;

	/**
	 * The number of structural features of the '<em>Basic Auth Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_AUTH_DEFINITION_FEATURE_COUNT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Basic Auth Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASIC_AUTH_DEFINITION_OPERATION_COUNT = REST_SECURITY_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ResequencerConfigImpl <em>Resequencer Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ResequencerConfigImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getResequencerConfig()
	 * @generated
	 */
	int RESEQUENCER_CONFIG = 214;

	/**
	 * The number of structural features of the '<em>Resequencer Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESEQUENCER_CONFIG_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Resequencer Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESEQUENCER_CONFIG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BatchResequencerConfigImpl <em>Batch Resequencer Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BatchResequencerConfigImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBatchResequencerConfig()
	 * @generated
	 */
	int BATCH_RESEQUENCER_CONFIG = 24;

	/**
	 * The feature id for the '<em><b>Allow Duplicates</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG__ALLOW_DUPLICATES = RESEQUENCER_CONFIG_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Batch Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG__BATCH_SIZE = RESEQUENCER_CONFIG_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Batch Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG__BATCH_TIMEOUT = RESEQUENCER_CONFIG_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Ignore Invalid Exchanges</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG__IGNORE_INVALID_EXCHANGES = RESEQUENCER_CONFIG_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Reverse</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG__REVERSE = RESEQUENCER_CONFIG_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Batch Resequencer Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG_FEATURE_COUNT = RESEQUENCER_CONFIG_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Batch Resequencer Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BATCH_RESEQUENCER_CONFIG_OPERATION_COUNT = RESEQUENCER_CONFIG_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanConstructorDefinitionImpl <em>Bean Constructor Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanConstructorDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanConstructorDefinition()
	 * @generated
	 */
	int BEAN_CONSTRUCTOR_DEFINITION = 25;

	/**
	 * The feature id for the '<em><b>Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTOR_DEFINITION__INDEX = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTOR_DEFINITION__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Bean Constructor Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTOR_DEFINITION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Bean Constructor Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTOR_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanConstructorsDefinitionImpl <em>Bean Constructors Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanConstructorsDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanConstructorsDefinition()
	 * @generated
	 */
	int BEAN_CONSTRUCTORS_DEFINITION = 26;

	/**
	 * The feature id for the '<em><b>Constructor</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTORS_DEFINITION__CONSTRUCTOR = 0;

	/**
	 * The number of structural features of the '<em>Bean Constructors Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTORS_DEFINITION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Bean Constructors Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_CONSTRUCTORS_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.NoOutputDefinitionImpl <em>No Output Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.NoOutputDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getNoOutputDefinition()
	 * @generated
	 */
	int NO_OUTPUT_DEFINITION = 167;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_OUTPUT_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_OUTPUT_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_OUTPUT_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_OUTPUT_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The number of structural features of the '<em>No Output Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_OUTPUT_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>No Output Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_OUTPUT_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanDefinitionImpl <em>Bean Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanDefinition()
	 * @generated
	 */
	int BEAN_DEFINITION = 27;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Bean Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__BEAN_TYPE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__METHOD = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__REF = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION__SCOPE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Bean Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Bean Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanFactoryDefinitionImpl <em>Bean Factory Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanFactoryDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanFactoryDefinition()
	 * @generated
	 */
	int BEAN_FACTORY_DEFINITION = 28;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__CONSTRUCTORS = 0;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__PROPERTIES = 1;

	/**
	 * The feature id for the '<em><b>Script</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__SCRIPT = 2;

	/**
	 * The feature id for the '<em><b>Builder Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__BUILDER_CLASS = 3;

	/**
	 * The feature id for the '<em><b>Builder Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__BUILDER_METHOD = 4;

	/**
	 * The feature id for the '<em><b>Destroy Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__DESTROY_METHOD = 5;

	/**
	 * The feature id for the '<em><b>Factory Bean</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__FACTORY_BEAN = 6;

	/**
	 * The feature id for the '<em><b>Factory Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__FACTORY_METHOD = 7;

	/**
	 * The feature id for the '<em><b>Init Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__INIT_METHOD = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__NAME = 9;

	/**
	 * The feature id for the '<em><b>Script Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__SCRIPT_LANGUAGE = 10;

	/**
	 * The feature id for the '<em><b>Script Property Placeholders</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__SCRIPT_PROPERTY_PLACEHOLDERS = 11;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION__TYPE = 12;

	/**
	 * The number of structural features of the '<em>Bean Factory Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION_FEATURE_COUNT = 13;

	/**
	 * The number of operations of the '<em>Bean Factory Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_FACTORY_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanioDataFormatImpl <em>Beanio Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanioDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanioDataFormat()
	 * @generated
	 */
	int BEANIO_DATA_FORMAT = 29;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Bean Reader Error Handler Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__BEAN_READER_ERROR_HANDLER_TYPE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Encoding</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__ENCODING = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ignore Invalid Records</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__IGNORE_INVALID_RECORDS = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Ignore Unexpected Records</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__IGNORE_UNEXPECTED_RECORDS = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Ignore Unidentified Records</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__IGNORE_UNIDENTIFIED_RECORDS = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__MAPPING = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Stream Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__STREAM_NAME = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Unmarshal Single Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT__UNMARSHAL_SINGLE_OBJECT = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Beanio Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Beanio Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEANIO_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanPropertiesDefinitionImpl <em>Bean Properties Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanPropertiesDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanPropertiesDefinition()
	 * @generated
	 */
	int BEAN_PROPERTIES_DEFINITION = 30;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTIES_DEFINITION__PROPERTY = 0;

	/**
	 * The number of structural features of the '<em>Bean Properties Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTIES_DEFINITION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Bean Properties Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTIES_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BeanPropertyDefinitionImpl <em>Bean Property Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BeanPropertyDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBeanPropertyDefinition()
	 * @generated
	 */
	int BEAN_PROPERTY_DEFINITION = 31;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTY_DEFINITION__PROPERTIES = 0;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTY_DEFINITION__KEY = 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTY_DEFINITION__VALUE = 2;

	/**
	 * The number of structural features of the '<em>Bean Property Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTY_DEFINITION_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Bean Property Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEAN_PROPERTY_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BearerTokenDefinitionImpl <em>Bearer Token Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BearerTokenDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBearerTokenDefinition()
	 * @generated
	 */
	int BEARER_TOKEN_DEFINITION = 33;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEARER_TOKEN_DEFINITION__DESCRIPTION = REST_SECURITY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEARER_TOKEN_DEFINITION__KEY = REST_SECURITY_DEFINITION__KEY;

	/**
	 * The feature id for the '<em><b>Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEARER_TOKEN_DEFINITION__FORMAT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Bearer Token Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEARER_TOKEN_DEFINITION_FEATURE_COUNT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Bearer Token Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEARER_TOKEN_DEFINITION_OPERATION_COUNT = REST_SECURITY_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BindyDataFormatImpl <em>Bindy Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BindyDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBindyDataFormat()
	 * @generated
	 */
	int BINDY_DATA_FORMAT = 34;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Empty Stream</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT__ALLOW_EMPTY_STREAM = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Class Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT__CLASS_TYPE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Locale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT__LOCALE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT__TYPE = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Unwrap Single Instance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT__UNWRAP_SINGLE_INSTANCE = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Bindy Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Bindy Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINDY_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ServiceCallConfigurationImpl <em>Service Call Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ServiceCallConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getServiceCallConfiguration()
	 * @generated
	 */
	int SERVICE_CALL_CONFIGURATION = 251;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_CONFIGURATION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_CONFIGURATION__PROPERTIES = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Service Call Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_CONFIGURATION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Service Call Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_CONFIGURATION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ServiceCallServiceFilterConfigurationImpl <em>Service Call Service Filter Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ServiceCallServiceFilterConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getServiceCallServiceFilterConfiguration()
	 * @generated
	 */
	int SERVICE_CALL_SERVICE_FILTER_CONFIGURATION = 258;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID = SERVICE_CALL_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES = SERVICE_CALL_CONFIGURATION__PROPERTIES;

	/**
	 * The number of structural features of the '<em>Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.BlacklistServiceCallServiceFilterConfigurationImpl <em>Blacklist Service Call Service Filter Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.BlacklistServiceCallServiceFilterConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getBlacklistServiceCallServiceFilterConfiguration()
	 * @generated
	 */
	int BLACKLIST_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION = 35;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLACKLIST_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLACKLIST_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Servers</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLACKLIST_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__SERVERS = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Blacklist Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLACKLIST_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Blacklist Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLACKLIST_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ServiceCallServiceDiscoveryConfigurationImpl <em>Service Call Service Discovery Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ServiceCallServiceDiscoveryConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getServiceCallServiceDiscoveryConfiguration()
	 * @generated
	 */
	int SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION = 257;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID = SERVICE_CALL_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES = SERVICE_CALL_CONFIGURATION__PROPERTIES;

	/**
	 * The number of structural features of the '<em>Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CachingServiceCallServiceDiscoveryConfigurationImpl <em>Caching Service Call Service Discovery Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CachingServiceCallServiceDiscoveryConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCachingServiceCallServiceDiscoveryConfiguration()
	 * @generated
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION = 36;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Consul Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CONSUL_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dns Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__DNS_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Kubernetes Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__KUBERNETES_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Combined Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__COMBINED_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Static Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__STATIC_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__TIMEOUT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Units</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__UNITS = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Caching Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Caching Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHING_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelBeanPostProcessorImpl <em>Camel Bean Post Processor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelBeanPostProcessorImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelBeanPostProcessor()
	 * @generated
	 */
	int CAMEL_BEAN_POST_PROCESSOR = 37;

	/**
	 * The number of structural features of the '<em>Camel Bean Post Processor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_BEAN_POST_PROCESSOR_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Camel Bean Post Processor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_BEAN_POST_PROCESSOR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelConsumerTemplateFactoryBeanImpl <em>Camel Consumer Template Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelConsumerTemplateFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelConsumerTemplateFactoryBean()
	 * @generated
	 */
	int CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN = 38;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__ID = ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Maximum Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE = ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE;

	/**
	 * The number of structural features of the '<em>Camel Consumer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Camel Consumer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_CONSUMER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelContextFactoryBeanImpl <em>Camel Context Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelContextFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelContextFactoryBean()
	 * @generated
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN = 39;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ID = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Global Options</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__GLOBAL_OPTIONS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Property Placeholder</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__PROPERTY_PLACEHOLDER = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Package</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__PACKAGE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Package Scan</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__PACKAGE_SCAN = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Context Scan</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__CONTEXT_SCAN = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Stream Caching</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__STREAM_CACHING = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Jmx Agent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__JMX_AGENT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Route Controller</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_CONTROLLER = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__GROUP = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TEMPLATE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Fluent Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__FLUENT_TEMPLATE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Consumer Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__CONSUMER_TEMPLATE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Error Handler</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ERROR_HANDLER = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Default Service Call Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DEFAULT_SERVICE_CALL_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Service Call Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__SERVICE_CALL_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Default Resilience4j Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DEFAULT_RESILIENCE4J_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Resilience4j Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__RESILIENCE4J_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Default Fault Tolerance Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DEFAULT_FAULT_TOLERANCE_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Fault Tolerance Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__FAULT_TOLERANCE_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Route Configuration Context Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_CONFIGURATION_CONTEXT_REF = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Route Template Context Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_TEMPLATE_CONTEXT_REF = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Route Builder</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_BUILDER = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Route Context Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_CONTEXT_REF = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Rest Context Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__REST_CONTEXT_REF = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Thread Pool Profile</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__THREAD_POOL_PROFILE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Thread Pool</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__THREAD_POOL = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ENDPOINT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Data Formats</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DATA_FORMATS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Transformers</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TRANSFORMERS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Validators</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__VALIDATORS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Profile</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__REDELIVERY_POLICY_PROFILE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ON_EXCEPTION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ON_COMPLETION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__INTERCEPT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__INTERCEPT_FROM = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__INTERCEPT_SEND_TO_ENDPOINT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Rest Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__REST_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Rest</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__REST = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Route Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_CONFIGURATION = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Route Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE_TEMPLATE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Templated Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TEMPLATED_ROUTE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ROUTE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Allow Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ALLOW_USE_ORIGINAL_MESSAGE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Auto Startup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__AUTO_STARTUP = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Autowired Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__AUTOWIRED_ENABLED = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Backlog Trace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__BACKLOG_TRACE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Bean Post Processor Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__BEAN_POST_PROCESSOR_ENABLED = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Case Insensitive Headers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__CASE_INSENSITIVE_HEADERS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Debug</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DEBUG = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Delayer</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DELAYER = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Depends On</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DEPENDS_ON = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Dump Routes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__DUMP_ROUTES = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Error Handler Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__ERROR_HANDLER_REF = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Inflight Repository Browse Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__INFLIGHT_REPOSITORY_BROWSE_ENABLED = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Load Health Checks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__LOAD_HEALTH_CHECKS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Load Type Converters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__LOAD_TYPE_CONVERTERS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Log Exhausted Message Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_BODY = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Log Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__LOG_MASK = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Management Name Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__MANAGEMENT_NAME_PATTERN = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Mdc Logging Keys Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__MDC_LOGGING_KEYS_PATTERN = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Message History</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__MESSAGE_HISTORY = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Runtime Endpoint Registry Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__RUNTIME_ENDPOINT_REGISTRY_ENABLED = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Shutdown Eager</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__SHUTDOWN_EAGER = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Shutdown Route</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__SHUTDOWN_ROUTE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Shutdown Running Task</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__SHUTDOWN_RUNNING_TASK = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Source Location Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__SOURCE_LOCATION_ENABLED = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Startup Summary Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__STARTUP_SUMMARY_LEVEL = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Stream Cache</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__STREAM_CACHE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Thread Name Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__THREAD_NAME_PATTERN = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Trace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TRACE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Trace Logging Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TRACE_LOGGING_FORMAT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Trace Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TRACE_PATTERN = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Type Converter Exists</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TYPE_CONVERTER_EXISTS = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Type Converter Exists Logging Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TYPE_CONVERTER_EXISTS_LOGGING_LEVEL = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Type Converter Statistics Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__TYPE_CONVERTER_STATISTICS_ENABLED = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Use Breadcrumb</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__USE_BREADCRUMB = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Use Data Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__USE_DATA_TYPE = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Use MDC Logging</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN__USE_MDC_LOGGING = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 77;

	/**
	 * The number of structural features of the '<em>Camel Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_FEATURE_COUNT + 78;

	/**
	 * The number of operations of the '<em>Camel Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_CONTEXT_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_CONTEXT_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelEndpointFactoryBeanImpl <em>Camel Endpoint Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelEndpointFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelEndpointFactoryBean()
	 * @generated
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN = 40;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN__ID = ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN__PROPERTY = ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__PROPERTY;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN__URI = ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN__URI;

	/**
	 * The number of structural features of the '<em>Camel Endpoint Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Camel Endpoint Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ENDPOINT_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_ENDPOINT_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelFluentProducerTemplateFactoryBeanImpl <em>Camel Fluent Producer Template Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelFluentProducerTemplateFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelFluentProducerTemplateFactoryBean()
	 * @generated
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN = 41;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__ID = ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Default Endpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__DEFAULT_ENDPOINT = ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__DEFAULT_ENDPOINT;

	/**
	 * The feature id for the '<em><b>Maximum Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE = ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE;

	/**
	 * The number of structural features of the '<em>Camel Fluent Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Camel Fluent Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_FLUENT_PRODUCER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelJMXAgentDefinitionImpl <em>Camel JMX Agent Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelJMXAgentDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelJMXAgentDefinition()
	 * @generated
	 */
	int CAMEL_JMX_AGENT_DEFINITION = 42;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__DISABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Endpoint Runtime Statistics Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__ENDPOINT_RUNTIME_STATISTICS_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Include Host Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__INCLUDE_HOST_NAME = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Load Statistics Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__LOAD_STATISTICS_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Mask</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__MASK = IDENTIFIED_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Mbean Object Domain Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__MBEAN_OBJECT_DOMAIN_NAME = IDENTIFIED_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Mbean Server Default Domain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__MBEAN_SERVER_DEFAULT_DOMAIN = IDENTIFIED_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mbeans Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__MBEANS_LEVEL = IDENTIFIED_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Only Register Processor With Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__ONLY_REGISTER_PROCESSOR_WITH_CUSTOM_ID = IDENTIFIED_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Register Always</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__REGISTER_ALWAYS = IDENTIFIED_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Register New Routes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__REGISTER_NEW_ROUTES = IDENTIFIED_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Statistics Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__STATISTICS_LEVEL = IDENTIFIED_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Update Route Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__UPDATE_ROUTE_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Use Host IP Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__USE_HOST_IP_ADDRESS = IDENTIFIED_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Use Platform MBean Server</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION__USE_PLATFORM_MBEAN_SERVER = IDENTIFIED_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of structural features of the '<em>Camel JMX Agent Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 15;

	/**
	 * The number of operations of the '<em>Camel JMX Agent Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_JMX_AGENT_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelProducerTemplateFactoryBeanImpl <em>Camel Producer Template Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelProducerTemplateFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelProducerTemplateFactoryBean()
	 * @generated
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN = 43;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__ID = ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Default Endpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__DEFAULT_ENDPOINT = ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__DEFAULT_ENDPOINT;

	/**
	 * The feature id for the '<em><b>Maximum Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE = ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN__MAXIMUM_CACHE_SIZE;

	/**
	 * The number of structural features of the '<em>Camel Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Camel Producer Template Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_PRODUCER_TEMPLATE_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelPropertyPlaceholderDefinitionImpl <em>Camel Property Placeholder Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelPropertyPlaceholderDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelPropertyPlaceholderDefinition()
	 * @generated
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION = 44;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Properties Function</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__PROPERTIES_FUNCTION = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Properties Location</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__PROPERTIES_LOCATION = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Default Fallback Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__DEFAULT_FALLBACK_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Encoding</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__ENCODING = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Ignore Missing Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__IGNORE_MISSING_LOCATION = IDENTIFIED_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__LOCATION = IDENTIFIED_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Nested Placeholder</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__NESTED_PLACEHOLDER = IDENTIFIED_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Properties Parser Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION__PROPERTIES_PARSER_REF = IDENTIFIED_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Camel Property Placeholder Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Camel Property Placeholder Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelPropertyPlaceholderFunctionDefinitionImpl <em>Camel Property Placeholder Function Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelPropertyPlaceholderFunctionDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelPropertyPlaceholderFunctionDefinition()
	 * @generated
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_FUNCTION_DEFINITION = 45;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_FUNCTION_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_FUNCTION_DEFINITION__REF = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Camel Property Placeholder Function Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_FUNCTION_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Camel Property Placeholder Function Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_FUNCTION_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelPropertyPlaceholderLocationDefinitionImpl <em>Camel Property Placeholder Location Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelPropertyPlaceholderLocationDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelPropertyPlaceholderLocationDefinition()
	 * @generated
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION = 46;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION__OPTIONAL = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION__PATH = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Resolver</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION__RESOLVER = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Camel Property Placeholder Location Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Camel Property Placeholder Location Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_PROPERTY_PLACEHOLDER_LOCATION_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelRedeliveryPolicyFactoryBeanImpl <em>Camel Redelivery Policy Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelRedeliveryPolicyFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelRedeliveryPolicyFactoryBean()
	 * @generated
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN = 47;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ID = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Allow Redelivery While Stopping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ALLOW_REDELIVERY_WHILE_STOPPING = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ALLOW_REDELIVERY_WHILE_STOPPING;

	/**
	 * The feature id for the '<em><b>Async Delayed Redelivery</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ASYNC_DELAYED_REDELIVERY = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__ASYNC_DELAYED_REDELIVERY;

	/**
	 * The feature id for the '<em><b>Back Off Multiplier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__BACK_OFF_MULTIPLIER = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__BACK_OFF_MULTIPLIER;

	/**
	 * The feature id for the '<em><b>Collision Avoidance Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__COLLISION_AVOIDANCE_FACTOR = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__COLLISION_AVOIDANCE_FACTOR;

	/**
	 * The feature id for the '<em><b>Delay Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__DELAY_PATTERN = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__DELAY_PATTERN;

	/**
	 * The feature id for the '<em><b>Disable Redelivery</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__DISABLE_REDELIVERY = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__DISABLE_REDELIVERY;

	/**
	 * The feature id for the '<em><b>Exchange Formatter Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__EXCHANGE_FORMATTER_REF = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__EXCHANGE_FORMATTER_REF;

	/**
	 * The feature id for the '<em><b>Log Continued</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_CONTINUED = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_CONTINUED;

	/**
	 * The feature id for the '<em><b>Log Exhausted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED;

	/**
	 * The feature id for the '<em><b>Log Exhausted Message Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_BODY = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_BODY;

	/**
	 * The feature id for the '<em><b>Log Exhausted Message History</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_HISTORY = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_EXHAUSTED_MESSAGE_HISTORY;

	/**
	 * The feature id for the '<em><b>Log Handled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_HANDLED = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_HANDLED;

	/**
	 * The feature id for the '<em><b>Log New Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_NEW_EXCEPTION = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_NEW_EXCEPTION;

	/**
	 * The feature id for the '<em><b>Log Retry Attempted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_RETRY_ATTEMPTED = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_RETRY_ATTEMPTED;

	/**
	 * The feature id for the '<em><b>Log Retry Stack Trace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_RETRY_STACK_TRACE = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_RETRY_STACK_TRACE;

	/**
	 * The feature id for the '<em><b>Log Stack Trace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_STACK_TRACE = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__LOG_STACK_TRACE;

	/**
	 * The feature id for the '<em><b>Maximum Redeliveries</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__MAXIMUM_REDELIVERIES = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__MAXIMUM_REDELIVERIES;

	/**
	 * The feature id for the '<em><b>Maximum Redelivery Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__MAXIMUM_REDELIVERY_DELAY = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__MAXIMUM_REDELIVERY_DELAY;

	/**
	 * The feature id for the '<em><b>Redelivery Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__REDELIVERY_DELAY = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__REDELIVERY_DELAY;

	/**
	 * The feature id for the '<em><b>Retries Exhausted Log Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRIES_EXHAUSTED_LOG_LEVEL = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRIES_EXHAUSTED_LOG_LEVEL;

	/**
	 * The feature id for the '<em><b>Retry Attempted Log Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRY_ATTEMPTED_LOG_INTERVAL = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRY_ATTEMPTED_LOG_INTERVAL;

	/**
	 * The feature id for the '<em><b>Retry Attempted Log Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRY_ATTEMPTED_LOG_LEVEL = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__RETRY_ATTEMPTED_LOG_LEVEL;

	/**
	 * The feature id for the '<em><b>Use Collision Avoidance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__USE_COLLISION_AVOIDANCE = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__USE_COLLISION_AVOIDANCE;

	/**
	 * The feature id for the '<em><b>Use Exponential Back Off</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__USE_EXPONENTIAL_BACK_OFF = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN__USE_EXPONENTIAL_BACK_OFF;

	/**
	 * The number of structural features of the '<em>Camel Redelivery Policy Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Camel Redelivery Policy Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REDELIVERY_POLICY_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_REDELIVERY_POLICY_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelRestContextFactoryBeanImpl <em>Camel Rest Context Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelRestContextFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelRestContextFactoryBean()
	 * @generated
	 */
	int CAMEL_REST_CONTEXT_FACTORY_BEAN = 48;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REST_CONTEXT_FACTORY_BEAN__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Rest</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REST_CONTEXT_FACTORY_BEAN__REST = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Camel Rest Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REST_CONTEXT_FACTORY_BEAN_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Camel Rest Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_REST_CONTEXT_FACTORY_BEAN_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelRouteConfigurationContextFactoryBeanImpl <em>Camel Route Configuration Context Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelRouteConfigurationContextFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelRouteConfigurationContextFactoryBean()
	 * @generated
	 */
	int CAMEL_ROUTE_CONFIGURATION_CONTEXT_FACTORY_BEAN = 49;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONFIGURATION_CONTEXT_FACTORY_BEAN__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Route Configuration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONFIGURATION_CONTEXT_FACTORY_BEAN__ROUTE_CONFIGURATION = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Camel Route Configuration Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONFIGURATION_CONTEXT_FACTORY_BEAN_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Camel Route Configuration Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONFIGURATION_CONTEXT_FACTORY_BEAN_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelRouteContextFactoryBeanImpl <em>Camel Route Context Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelRouteContextFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelRouteContextFactoryBean()
	 * @generated
	 */
	int CAMEL_ROUTE_CONTEXT_FACTORY_BEAN = 50;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTEXT_FACTORY_BEAN__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTEXT_FACTORY_BEAN__ROUTE = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Camel Route Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTEXT_FACTORY_BEAN_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Camel Route Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTEXT_FACTORY_BEAN_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelRouteControllerDefinitionImpl <em>Camel Route Controller Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelRouteControllerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelRouteControllerDefinition()
	 * @generated
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION = 51;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Back Off Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__BACK_OFF_DELAY = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Back Off Max Attempts</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__BACK_OFF_MAX_ATTEMPTS = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Back Off Max Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__BACK_OFF_MAX_DELAY = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Back Off Max Elapsed Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__BACK_OFF_MAX_ELAPSED_TIME = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Back Off Multiplier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__BACK_OFF_MULTIPLIER = IDENTIFIED_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Exclude Routes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__EXCLUDE_ROUTES = IDENTIFIED_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Include Routes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__INCLUDE_ROUTES = IDENTIFIED_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Initial Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__INITIAL_DELAY = IDENTIFIED_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Logging Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__LOGGING_LEVEL = IDENTIFIED_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Supervising</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__SUPERVISING = IDENTIFIED_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Thread Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__THREAD_POOL_SIZE = IDENTIFIED_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Unhealthy On Exhausted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__UNHEALTHY_ON_EXHAUSTED = IDENTIFIED_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Unhealthy On Restarting</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION__UNHEALTHY_ON_RESTARTING = IDENTIFIED_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Camel Route Controller Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>Camel Route Controller Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_CONTROLLER_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelRouteTemplateContextFactoryBeanImpl <em>Camel Route Template Context Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelRouteTemplateContextFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelRouteTemplateContextFactoryBean()
	 * @generated
	 */
	int CAMEL_ROUTE_TEMPLATE_CONTEXT_FACTORY_BEAN = 52;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_TEMPLATE_CONTEXT_FACTORY_BEAN__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Route Template</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_TEMPLATE_CONTEXT_FACTORY_BEAN__ROUTE_TEMPLATE = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Camel Route Template Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_TEMPLATE_CONTEXT_FACTORY_BEAN_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Camel Route Template Context Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_ROUTE_TEMPLATE_CONTEXT_FACTORY_BEAN_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelStreamCachingStrategyDefinitionImpl <em>Camel Stream Caching Strategy Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelStreamCachingStrategyDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelStreamCachingStrategyDefinition()
	 * @generated
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION = 53;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Allow Classes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__ALLOW_CLASSES = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Any Spool Rules</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__ANY_SPOOL_RULES = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Buffer Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__BUFFER_SIZE = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Deny Classes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__DENY_CLASSES = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Remove Spool Directory When Stopping</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__REMOVE_SPOOL_DIRECTORY_WHEN_STOPPING = IDENTIFIED_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Spool Cipher</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_CIPHER = IDENTIFIED_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Spool Directory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_DIRECTORY = IDENTIFIED_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Spool Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Spool Rules</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_RULES = IDENTIFIED_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Spool Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_THRESHOLD = IDENTIFIED_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Spool Used Heap Memory Limit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_USED_HEAP_MEMORY_LIMIT = IDENTIFIED_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Spool Used Heap Memory Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__SPOOL_USED_HEAP_MEMORY_THRESHOLD = IDENTIFIED_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Statistics Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION__STATISTICS_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>Camel Stream Caching Strategy Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of operations of the '<em>Camel Stream Caching Strategy Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_STREAM_CACHING_STRATEGY_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CamelThreadPoolFactoryBeanImpl <em>Camel Thread Pool Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelThreadPoolFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCamelThreadPoolFactoryBean()
	 * @generated
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN = 54;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__ID = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Allow Core Thread Time Out</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__ALLOW_CORE_THREAD_TIME_OUT = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__ALLOW_CORE_THREAD_TIME_OUT;

	/**
	 * The feature id for the '<em><b>Keep Alive Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__KEEP_ALIVE_TIME = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__KEEP_ALIVE_TIME;

	/**
	 * The feature id for the '<em><b>Max Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__MAX_POOL_SIZE = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__MAX_POOL_SIZE;

	/**
	 * The feature id for the '<em><b>Max Queue Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__MAX_QUEUE_SIZE = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__MAX_QUEUE_SIZE;

	/**
	 * The feature id for the '<em><b>Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__POOL_SIZE = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__POOL_SIZE;

	/**
	 * The feature id for the '<em><b>Rejected Policy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__REJECTED_POLICY = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__REJECTED_POLICY;

	/**
	 * The feature id for the '<em><b>Scheduled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__SCHEDULED = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__SCHEDULED;

	/**
	 * The feature id for the '<em><b>Thread Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__THREAD_NAME = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__THREAD_NAME;

	/**
	 * The feature id for the '<em><b>Time Unit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN__TIME_UNIT = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN__TIME_UNIT;

	/**
	 * The number of structural features of the '<em>Camel Thread Pool Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Camel Thread Pool Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_THREAD_POOL_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_CAMEL_THREAD_POOL_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CatchDefinitionImpl <em>Catch Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CatchDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCatchDefinition()
	 * @generated
	 */
	int CATCH_DEFINITION = 55;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Exception</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__EXCEPTION = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ON_WHEN = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The number of structural features of the '<em>Catch Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The number of operations of the '<em>Catch Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CborDataFormatImpl <em>Cbor Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CborDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCborDataFormat()
	 * @generated
	 */
	int CBOR_DATA_FORMAT = 56;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Jms Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__ALLOW_JMS_TYPE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Unmarshall Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__ALLOW_UNMARSHALL_TYPE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Collection Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__COLLECTION_TYPE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Disable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__DISABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Enable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__ENABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__PRETTY_PRINT = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Use Default Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__USE_DEFAULT_OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Use List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT__USE_LIST = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Cbor Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>Cbor Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CBOR_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ChoiceDefinitionImpl <em>Choice Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ChoiceDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getChoiceDefinition()
	 * @generated
	 */
	int CHOICE_DEFINITION = 57;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>When</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__WHEN = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Otherwise</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__OTHERWISE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Precondition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION__PRECONDITION = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Choice Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Choice Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHOICE_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CipherSuitesParametersImpl <em>Cipher Suites Parameters</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CipherSuitesParametersImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCipherSuitesParameters()
	 * @generated
	 */
	int CIPHER_SUITES_PARAMETERS = 58;

	/**
	 * The feature id for the '<em><b>Cipher Suite</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIPHER_SUITES_PARAMETERS__CIPHER_SUITE = 0;

	/**
	 * The number of structural features of the '<em>Cipher Suites Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIPHER_SUITES_PARAMETERS_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Cipher Suites Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIPHER_SUITES_PARAMETERS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CircuitBreakerDefinitionImpl <em>Circuit Breaker Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CircuitBreakerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCircuitBreakerDefinition()
	 * @generated
	 */
	int CIRCUIT_BREAKER_DEFINITION = 59;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Resilience4j Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__RESILIENCE4J_CONFIGURATION = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Fault Tolerance Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__FAULT_TOLERANCE_CONFIGURATION = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>On Fallback</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__ON_FALLBACK = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__CONFIGURATION = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Inherit Error Handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION__INHERIT_ERROR_HANDLER = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The number of structural features of the '<em>Circuit Breaker Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 76;

	/**
	 * The number of operations of the '<em>Circuit Breaker Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCUIT_BREAKER_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ClaimCheckDefinitionImpl <em>Claim Check Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ClaimCheckDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getClaimCheckDefinition()
	 * @generated
	 */
	int CLAIM_CHECK_DEFINITION = 60;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__AGGREGATION_STRATEGY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__AGGREGATION_STRATEGY_METHOD_NAME = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__FILTER = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__KEY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION__OPERATION = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Claim Check Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Claim Check Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAIM_CHECK_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CombinedServiceCallServiceDiscoveryConfigurationImpl <em>Combined Service Call Service Discovery Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CombinedServiceCallServiceDiscoveryConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCombinedServiceCallServiceDiscoveryConfiguration()
	 * @generated
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION = 61;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__GROUP = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Consul Service Discovery</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CONSUL_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dns Service Discovery</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__DNS_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Kubernetes Service Discovery</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__KUBERNETES_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Static Service Discovery</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__STATIC_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Caching Service Discovery</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CACHING_SERVICE_DISCOVERY = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Combined Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Combined Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CombinedServiceCallServiceFilterConfigurationImpl <em>Combined Service Call Service Filter Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CombinedServiceCallServiceFilterConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCombinedServiceCallServiceFilterConfiguration()
	 * @generated
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION = 62;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__GROUP = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Blacklist Service Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__BLACKLIST_SERVICE_FILTER = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Custom Service Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__CUSTOM_SERVICE_FILTER = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Healthy Service Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__HEALTHY_SERVICE_FILTER = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pass Through Service Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PASS_THROUGH_SERVICE_FILTER = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Combined Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Combined Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ComponentScanDefinitionImpl <em>Component Scan Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ComponentScanDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getComponentScanDefinition()
	 * @generated
	 */
	int COMPONENT_SCAN_DEFINITION = 63;

	/**
	 * The feature id for the '<em><b>Base Package</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCAN_DEFINITION__BASE_PACKAGE = 0;

	/**
	 * The number of structural features of the '<em>Component Scan Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCAN_DEFINITION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Component Scan Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SCAN_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ExpressionImpl <em>Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION = 98;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__ID = 1;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__TRIM = 2;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.TypedExpressionDefinitionImpl <em>Typed Expression Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.TypedExpressionDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getTypedExpressionDefinition()
	 * @generated
	 */
	int TYPED_EXPRESSION_DEFINITION = 311;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_EXPRESSION_DEFINITION__VALUE = EXPRESSION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_EXPRESSION_DEFINITION__ID = EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_EXPRESSION_DEFINITION__TRIM = EXPRESSION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_EXPRESSION_DEFINITION__RESULT_TYPE = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Typed Expression Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Typed Expression Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ConstantExpressionImpl <em>Constant Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ConstantExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getConstantExpression()
	 * @generated
	 */
	int CONSTANT_EXPRESSION = 64;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The number of structural features of the '<em>Constant Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Constant Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ConstantsImpl <em>Constants</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ConstantsImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getConstants()
	 * @generated
	 */
	int CONSTANTS = 65;

	/**
	 * The number of structural features of the '<em>Constants</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Constants</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ConsulServiceCallServiceDiscoveryConfigurationImpl <em>Consul Service Call Service Discovery Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ConsulServiceCallServiceDiscoveryConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getConsulServiceCallServiceDiscoveryConfiguration()
	 * @generated
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION = 66;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Acl Token</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ACL_TOKEN = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Block Seconds</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__BLOCK_SECONDS = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Connect Timeout Millis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CONNECT_TIMEOUT_MILLIS = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datacenter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__DATACENTER = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PASSWORD = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Read Timeout Millis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__READ_TIMEOUT_MILLIS = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__URL = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>User Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__USER_NAME = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Write Timeout Millis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__WRITE_TIMEOUT_MILLIS = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Consul Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>Consul Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUL_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ContextScanDefinitionImpl <em>Context Scan Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ContextScanDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getContextScanDefinition()
	 * @generated
	 */
	int CONTEXT_SCAN_DEFINITION = 67;

	/**
	 * The feature id for the '<em><b>Excludes</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_SCAN_DEFINITION__EXCLUDES = 0;

	/**
	 * The feature id for the '<em><b>Includes</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_SCAN_DEFINITION__INCLUDES = 1;

	/**
	 * The feature id for the '<em><b>Include Non Singletons</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_SCAN_DEFINITION__INCLUDE_NON_SINGLETONS = 2;

	/**
	 * The number of structural features of the '<em>Context Scan Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_SCAN_DEFINITION_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Context Scan Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_SCAN_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ConvertBodyDefinitionImpl <em>Convert Body Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ConvertBodyDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getConvertBodyDefinition()
	 * @generated
	 */
	int CONVERT_BODY_DEFINITION = 68;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Charset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__CHARSET = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mandatory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__MANDATORY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION__TYPE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Convert Body Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Convert Body Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_BODY_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ConvertHeaderDefinitionImpl <em>Convert Header Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ConvertHeaderDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getConvertHeaderDefinition()
	 * @generated
	 */
	int CONVERT_HEADER_DEFINITION = 69;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Charset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__CHARSET = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mandatory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__MANDATORY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__NAME = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>To Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__TO_NAME = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION__TYPE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Convert Header Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Convert Header Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_HEADER_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ConvertVariableDefinitionImpl <em>Convert Variable Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ConvertVariableDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getConvertVariableDefinition()
	 * @generated
	 */
	int CONVERT_VARIABLE_DEFINITION = 70;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Charset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__CHARSET = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Mandatory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__MANDATORY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__NAME = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>To Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__TO_NAME = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION__TYPE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Convert Variable Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Convert Variable Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERT_VARIABLE_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CryptoDataFormatImpl <em>Crypto Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CryptoDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCryptoDataFormat()
	 * @generated
	 */
	int CRYPTO_DATA_FORMAT = 71;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__ALGORITHM = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Algorithm Parameter Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__ALGORITHM_PARAMETER_REF = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Buffer Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__BUFFER_SIZE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Crypto Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__CRYPTO_PROVIDER = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Init Vector Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__INIT_VECTOR_REF = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Inline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__INLINE = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Key Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__KEY_REF = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Mac Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__MAC_ALGORITHM = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Should Append HMAC</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT__SHOULD_APPEND_HMAC = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Crypto Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>Crypto Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRYPTO_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CSimpleExpressionImpl <em>CSimple Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CSimpleExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCSimpleExpression()
	 * @generated
	 */
	int CSIMPLE_EXPRESSION = 72;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSIMPLE_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSIMPLE_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSIMPLE_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSIMPLE_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The number of structural features of the '<em>CSimple Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSIMPLE_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>CSimple Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSIMPLE_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CsvDataFormatImpl <em>Csv Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CsvDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCsvDataFormat()
	 * @generated
	 */
	int CSV_DATA_FORMAT = 73;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Header</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__HEADER = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Missing Column Names</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__ALLOW_MISSING_COLUMN_NAMES = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Capture Header Record</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__CAPTURE_HEADER_RECORD = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Comment Marker</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__COMMENT_MARKER = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Comment Marker Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__COMMENT_MARKER_DISABLED = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Delimiter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__DELIMITER = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Escape</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__ESCAPE = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Escape Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__ESCAPE_DISABLED = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Format Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__FORMAT_NAME = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Format Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__FORMAT_REF = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Header Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__HEADER_DISABLED = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Ignore Empty Lines</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__IGNORE_EMPTY_LINES = DATA_FORMAT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Ignore Header Case</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__IGNORE_HEADER_CASE = DATA_FORMAT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Ignore Surrounding Spaces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__IGNORE_SURROUNDING_SPACES = DATA_FORMAT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Lazy Load</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__LAZY_LOAD = DATA_FORMAT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Marshaller Factory Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__MARSHALLER_FACTORY_REF = DATA_FORMAT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Null String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__NULL_STRING = DATA_FORMAT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Null String Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__NULL_STRING_DISABLED = DATA_FORMAT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Quote</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__QUOTE = DATA_FORMAT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Quote Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__QUOTE_DISABLED = DATA_FORMAT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Quote Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__QUOTE_MODE = DATA_FORMAT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Record Converter Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__RECORD_CONVERTER_REF = DATA_FORMAT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Record Separator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__RECORD_SEPARATOR = DATA_FORMAT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Record Separator Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__RECORD_SEPARATOR_DISABLED = DATA_FORMAT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Skip Header Record</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__SKIP_HEADER_RECORD = DATA_FORMAT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Trailing Delimiter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__TRAILING_DELIMITER = DATA_FORMAT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__TRIM = DATA_FORMAT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Use Maps</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__USE_MAPS = DATA_FORMAT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Use Ordered Maps</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT__USE_ORDERED_MAPS = DATA_FORMAT_FEATURE_COUNT + 28;

	/**
	 * The number of structural features of the '<em>Csv Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 29;

	/**
	 * The number of operations of the '<em>Csv Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CSV_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CustomDataFormatImpl <em>Custom Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CustomDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCustomDataFormat()
	 * @generated
	 */
	int CUSTOM_DATA_FORMAT = 74;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_DATA_FORMAT__REF = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Custom Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LoadBalancerDefinitionImpl <em>Load Balancer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LoadBalancerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLoadBalancerDefinition()
	 * @generated
	 */
	int LOAD_BALANCER_DEFINITION = 153;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCER_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Load Balancer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCER_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Load Balancer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCER_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CustomLoadBalancerDefinitionImpl <em>Custom Load Balancer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CustomLoadBalancerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCustomLoadBalancerDefinition()
	 * @generated
	 */
	int CUSTOM_LOAD_BALANCER_DEFINITION = 75;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_LOAD_BALANCER_DEFINITION__ID = LOAD_BALANCER_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_LOAD_BALANCER_DEFINITION__REF = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Load Balancer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_LOAD_BALANCER_DEFINITION_FEATURE_COUNT = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Custom Load Balancer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_LOAD_BALANCER_DEFINITION_OPERATION_COUNT = LOAD_BALANCER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CustomServiceCallServiceFilterConfigurationImpl <em>Custom Service Call Service Filter Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CustomServiceCallServiceFilterConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCustomServiceCallServiceFilterConfiguration()
	 * @generated
	 */
	int CUSTOM_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION = 76;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__REF = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Custom Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Custom Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.TransformerImpl <em>Transformer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.TransformerImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getTransformer()
	 * @generated
	 */
	int TRANSFORMER = 307;

	/**
	 * The feature id for the '<em><b>From Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORMER__FROM_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORMER__NAME = 1;

	/**
	 * The feature id for the '<em><b>Scheme</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORMER__SCHEME = 2;

	/**
	 * The feature id for the '<em><b>To Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORMER__TO_TYPE = 3;

	/**
	 * The number of structural features of the '<em>Transformer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORMER_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Transformer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSFORMER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CustomTransformerDefinitionImpl <em>Custom Transformer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CustomTransformerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCustomTransformerDefinition()
	 * @generated
	 */
	int CUSTOM_TRANSFORMER_DEFINITION = 77;

	/**
	 * The feature id for the '<em><b>From Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION__FROM_TYPE = TRANSFORMER__FROM_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION__NAME = TRANSFORMER__NAME;

	/**
	 * The feature id for the '<em><b>Scheme</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION__SCHEME = TRANSFORMER__SCHEME;

	/**
	 * The feature id for the '<em><b>To Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION__TO_TYPE = TRANSFORMER__TO_TYPE;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION__CLASS_NAME = TRANSFORMER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION__REF = TRANSFORMER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Custom Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION_FEATURE_COUNT = TRANSFORMER_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Custom Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_TRANSFORMER_DEFINITION_OPERATION_COUNT = TRANSFORMER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ValidatorImpl <em>Validator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ValidatorImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getValidator()
	 * @generated
	 */
	int VALIDATOR = 319;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALIDATOR__TYPE = 0;

	/**
	 * The number of structural features of the '<em>Validator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALIDATOR_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Validator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALIDATOR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.CustomValidatorDefinitionImpl <em>Custom Validator Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.CustomValidatorDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getCustomValidatorDefinition()
	 * @generated
	 */
	int CUSTOM_VALIDATOR_DEFINITION = 78;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_VALIDATOR_DEFINITION__TYPE = VALIDATOR__TYPE;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_VALIDATOR_DEFINITION__CLASS_NAME = VALIDATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_VALIDATOR_DEFINITION__REF = VALIDATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Custom Validator Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_VALIDATOR_DEFINITION_FEATURE_COUNT = VALIDATOR_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Custom Validator Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_VALIDATOR_DEFINITION_OPERATION_COUNT = VALIDATOR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DataFormatsDefinitionImpl <em>Data Formats Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DataFormatsDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDataFormatsDefinition()
	 * @generated
	 */
	int DATA_FORMATS_DEFINITION = 80;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Asn1</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__ASN1 = 1;

	/**
	 * The feature id for the '<em><b>Avro</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__AVRO = 2;

	/**
	 * The feature id for the '<em><b>Barcode</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__BARCODE = 3;

	/**
	 * The feature id for the '<em><b>Base64</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__BASE64 = 4;

	/**
	 * The feature id for the '<em><b>Beanio</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__BEANIO = 5;

	/**
	 * The feature id for the '<em><b>Bindy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__BINDY = 6;

	/**
	 * The feature id for the '<em><b>Cbor</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__CBOR = 7;

	/**
	 * The feature id for the '<em><b>Crypto</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__CRYPTO = 8;

	/**
	 * The feature id for the '<em><b>Csv</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__CSV = 9;

	/**
	 * The feature id for the '<em><b>Custom</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__CUSTOM = 10;

	/**
	 * The feature id for the '<em><b>Fhir Json</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__FHIR_JSON = 11;

	/**
	 * The feature id for the '<em><b>Fhir Xml</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__FHIR_XML = 12;

	/**
	 * The feature id for the '<em><b>Flatpack</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__FLATPACK = 13;

	/**
	 * The feature id for the '<em><b>Fory</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__FORY = 14;

	/**
	 * The feature id for the '<em><b>Grok</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__GROK = 15;

	/**
	 * The feature id for the '<em><b>Gzip Deflater</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__GZIP_DEFLATER = 16;

	/**
	 * The feature id for the '<em><b>Hl7</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__HL7 = 17;

	/**
	 * The feature id for the '<em><b>Ical</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__ICAL = 18;

	/**
	 * The feature id for the '<em><b>Iso8583</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__ISO8583 = 19;

	/**
	 * The feature id for the '<em><b>Jackson Xml</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__JACKSON_XML = 20;

	/**
	 * The feature id for the '<em><b>Jaxb</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__JAXB = 21;

	/**
	 * The feature id for the '<em><b>Json</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__JSON = 22;

	/**
	 * The feature id for the '<em><b>Json Api</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__JSON_API = 23;

	/**
	 * The feature id for the '<em><b>Lzf</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__LZF = 24;

	/**
	 * The feature id for the '<em><b>Mime Multipart</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__MIME_MULTIPART = 25;

	/**
	 * The feature id for the '<em><b>Parquet Avro</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__PARQUET_AVRO = 26;

	/**
	 * The feature id for the '<em><b>Pgp</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__PGP = 27;

	/**
	 * The feature id for the '<em><b>Protobuf</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__PROTOBUF = 28;

	/**
	 * The feature id for the '<em><b>Rss</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__RSS = 29;

	/**
	 * The feature id for the '<em><b>Smooks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__SMOOKS = 30;

	/**
	 * The feature id for the '<em><b>Soap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__SOAP = 31;

	/**
	 * The feature id for the '<em><b>Swift Mt</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__SWIFT_MT = 32;

	/**
	 * The feature id for the '<em><b>Swift Mx</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__SWIFT_MX = 33;

	/**
	 * The feature id for the '<em><b>Syslog</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__SYSLOG = 34;

	/**
	 * The feature id for the '<em><b>Tar File</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__TAR_FILE = 35;

	/**
	 * The feature id for the '<em><b>Thrift</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__THRIFT = 36;

	/**
	 * The feature id for the '<em><b>Tidy Markup</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__TIDY_MARKUP = 37;

	/**
	 * The feature id for the '<em><b>Univocity Csv</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__UNIVOCITY_CSV = 38;

	/**
	 * The feature id for the '<em><b>Univocity Fixed</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__UNIVOCITY_FIXED = 39;

	/**
	 * The feature id for the '<em><b>Univocity Tsv</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__UNIVOCITY_TSV = 40;

	/**
	 * The feature id for the '<em><b>Xml Security</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__XML_SECURITY = 41;

	/**
	 * The feature id for the '<em><b>Yaml</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__YAML = 42;

	/**
	 * The feature id for the '<em><b>Zip Deflater</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__ZIP_DEFLATER = 43;

	/**
	 * The feature id for the '<em><b>Zip File</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION__ZIP_FILE = 44;

	/**
	 * The number of structural features of the '<em>Data Formats Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION_FEATURE_COUNT = 45;

	/**
	 * The number of operations of the '<em>Data Formats Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DataFormatsTypeImpl <em>Data Formats Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DataFormatsTypeImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDataFormatsType()
	 * @generated
	 */
	int DATA_FORMATS_TYPE = 81;

	/**
	 * The feature id for the '<em><b>Data Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_TYPE__DATA_FORMAT = 0;

	/**
	 * The number of structural features of the '<em>Data Formats Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Data Formats Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMATS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DataFormatTransformerDefinitionImpl <em>Data Format Transformer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DataFormatTransformerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDataFormatTransformerDefinition()
	 * @generated
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION = 82;

	/**
	 * The feature id for the '<em><b>From Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__FROM_TYPE = TRANSFORMER__FROM_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__NAME = TRANSFORMER__NAME;

	/**
	 * The feature id for the '<em><b>Scheme</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__SCHEME = TRANSFORMER__SCHEME;

	/**
	 * The feature id for the '<em><b>To Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__TO_TYPE = TRANSFORMER__TO_TYPE;

	/**
	 * The feature id for the '<em><b>Asn1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__ASN1 = TRANSFORMER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Avro</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__AVRO = TRANSFORMER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Barcode</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__BARCODE = TRANSFORMER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Base64</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__BASE64 = TRANSFORMER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Beanio</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__BEANIO = TRANSFORMER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Bindy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__BINDY = TRANSFORMER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Cbor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__CBOR = TRANSFORMER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Crypto</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__CRYPTO = TRANSFORMER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Csv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__CSV = TRANSFORMER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Custom</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__CUSTOM = TRANSFORMER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Fhir Json</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__FHIR_JSON = TRANSFORMER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Fhir Xml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__FHIR_XML = TRANSFORMER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Flatpack</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__FLATPACK = TRANSFORMER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Fory</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__FORY = TRANSFORMER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Grok</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__GROK = TRANSFORMER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Gzip Deflater</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__GZIP_DEFLATER = TRANSFORMER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Hl7</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__HL7 = TRANSFORMER_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Ical</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__ICAL = TRANSFORMER_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Iso8583</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__ISO8583 = TRANSFORMER_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Jackson Xml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__JACKSON_XML = TRANSFORMER_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Jaxb</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__JAXB = TRANSFORMER_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Json</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__JSON = TRANSFORMER_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Json Api</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__JSON_API = TRANSFORMER_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Lzf</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__LZF = TRANSFORMER_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Mime Multipart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__MIME_MULTIPART = TRANSFORMER_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Parquet Avro</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__PARQUET_AVRO = TRANSFORMER_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Protobuf</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__PROTOBUF = TRANSFORMER_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Rss</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__RSS = TRANSFORMER_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Smooks</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__SMOOKS = TRANSFORMER_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Soap</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__SOAP = TRANSFORMER_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Swift Mt</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__SWIFT_MT = TRANSFORMER_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Swift Mx</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__SWIFT_MX = TRANSFORMER_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Syslog</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__SYSLOG = TRANSFORMER_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Tar File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__TAR_FILE = TRANSFORMER_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Thrift</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__THRIFT = TRANSFORMER_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Tidy Markup</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__TIDY_MARKUP = TRANSFORMER_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Univocity Csv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__UNIVOCITY_CSV = TRANSFORMER_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Univocity Fixed</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__UNIVOCITY_FIXED = TRANSFORMER_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Univocity Tsv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__UNIVOCITY_TSV = TRANSFORMER_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Xml Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__XML_SECURITY = TRANSFORMER_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Pgp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__PGP = TRANSFORMER_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Yaml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__YAML = TRANSFORMER_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Zip Deflater</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__ZIP_DEFLATER = TRANSFORMER_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Zip File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION__ZIP_FILE = TRANSFORMER_FEATURE_COUNT + 43;

	/**
	 * The number of structural features of the '<em>Data Format Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION_FEATURE_COUNT = TRANSFORMER_FEATURE_COUNT + 44;

	/**
	 * The number of operations of the '<em>Data Format Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FORMAT_TRANSFORMER_DEFINITION_OPERATION_COUNT = TRANSFORMER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.SingleInputTypedExpressionDefinitionImpl <em>Single Input Typed Expression Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.SingleInputTypedExpressionDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getSingleInputTypedExpressionDefinition()
	 * @generated
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION = 268;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__SOURCE = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Single Input Typed Expression Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Single Input Typed Expression Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DatasonnetExpressionImpl <em>Datasonnet Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DatasonnetExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDatasonnetExpression()
	 * @generated
	 */
	int DATASONNET_EXPRESSION = 83;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__VALUE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__ID = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__TRIM = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__RESULT_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__SOURCE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Body Media Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__BODY_MEDIA_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Output Media Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION__OUTPUT_MEDIA_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Datasonnet Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION_FEATURE_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Datasonnet Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASONNET_EXPRESSION_OPERATION_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DefaultErrorHandlerDefinitionImpl <em>Default Error Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DefaultErrorHandlerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDefaultErrorHandlerDefinition()
	 * @generated
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION = 85;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__ID = BASE_ERROR_HANDLER_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Redelivery Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Executor Service Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__EXECUTOR_SERVICE_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__LEVEL = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Logger Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__LOGGER_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Log Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__LOG_NAME = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>On Exception Occurred Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__ON_EXCEPTION_OCCURRED_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>On Prepare Failure Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__ON_PREPARE_FAILURE_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>On Redelivery Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__ON_REDELIVERY_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Retry While Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__RETRY_WHILE_REF = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Use Original Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_BODY = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_MESSAGE = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Default Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>Default Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_ERROR_HANDLER_DEFINITION_OPERATION_COUNT = BASE_ERROR_HANDLER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DeadLetterChannelDefinitionImpl <em>Dead Letter Channel Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DeadLetterChannelDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDeadLetterChannelDefinition()
	 * @generated
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION = 84;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__ID = DEFAULT_ERROR_HANDLER_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Redelivery Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__REDELIVERY_POLICY = DEFAULT_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY;

	/**
	 * The feature id for the '<em><b>Executor Service Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__EXECUTOR_SERVICE_REF = DEFAULT_ERROR_HANDLER_DEFINITION__EXECUTOR_SERVICE_REF;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__LEVEL = DEFAULT_ERROR_HANDLER_DEFINITION__LEVEL;

	/**
	 * The feature id for the '<em><b>Logger Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__LOGGER_REF = DEFAULT_ERROR_HANDLER_DEFINITION__LOGGER_REF;

	/**
	 * The feature id for the '<em><b>Log Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__LOG_NAME = DEFAULT_ERROR_HANDLER_DEFINITION__LOG_NAME;

	/**
	 * The feature id for the '<em><b>On Exception Occurred Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__ON_EXCEPTION_OCCURRED_REF = DEFAULT_ERROR_HANDLER_DEFINITION__ON_EXCEPTION_OCCURRED_REF;

	/**
	 * The feature id for the '<em><b>On Prepare Failure Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__ON_PREPARE_FAILURE_REF = DEFAULT_ERROR_HANDLER_DEFINITION__ON_PREPARE_FAILURE_REF;

	/**
	 * The feature id for the '<em><b>On Redelivery Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__ON_REDELIVERY_REF = DEFAULT_ERROR_HANDLER_DEFINITION__ON_REDELIVERY_REF;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__REDELIVERY_POLICY_REF = DEFAULT_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY_REF;

	/**
	 * The feature id for the '<em><b>Retry While Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__RETRY_WHILE_REF = DEFAULT_ERROR_HANDLER_DEFINITION__RETRY_WHILE_REF;

	/**
	 * The feature id for the '<em><b>Use Original Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__USE_ORIGINAL_BODY = DEFAULT_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_BODY;

	/**
	 * The feature id for the '<em><b>Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__USE_ORIGINAL_MESSAGE = DEFAULT_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_MESSAGE;

	/**
	 * The feature id for the '<em><b>Dead Letter Handle New Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__DEAD_LETTER_HANDLE_NEW_EXCEPTION = DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dead Letter Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION__DEAD_LETTER_URI = DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Dead Letter Channel Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION_FEATURE_COUNT = DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Dead Letter Channel Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEAD_LETTER_CHANNEL_DEFINITION_OPERATION_COUNT = DEFAULT_ERROR_HANDLER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ServiceCallServiceLoadBalancerConfigurationImpl <em>Service Call Service Load Balancer Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ServiceCallServiceLoadBalancerConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getServiceCallServiceLoadBalancerConfiguration()
	 * @generated
	 */
	int SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION = 259;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION__ID = SERVICE_CALL_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION__PROPERTIES = SERVICE_CALL_CONFIGURATION__PROPERTIES;

	/**
	 * The number of structural features of the '<em>Service Call Service Load Balancer Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Service Call Service Load Balancer Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DefaultServiceCallServiceLoadBalancerConfigurationImpl <em>Default Service Call Service Load Balancer Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DefaultServiceCallServiceLoadBalancerConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDefaultServiceCallServiceLoadBalancerConfiguration()
	 * @generated
	 */
	int DEFAULT_SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION = 86;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION__ID = SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION__PROPERTIES;

	/**
	 * The number of structural features of the '<em>Default Service Call Service Load Balancer Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Default Service Call Service Load Balancer Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_LOAD_BALANCER_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DelayDefinitionImpl <em>Delay Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DelayDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDelayDefinition()
	 * @generated
	 */
	int DELAY_DEFINITION = 87;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__EXPRESSION_DEFINITION = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__CSIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__CONSTANT = PROCESSOR_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__DATASONNET = PROCESSOR_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__EXCHANGE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__GROOVY = PROCESSOR_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__HL7TERSER = PROCESSOR_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__JAVA = PROCESSOR_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__JS = PROCESSOR_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__JOOR = PROCESSOR_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__JQ = PROCESSOR_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__JSONPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__LANGUAGE = PROCESSOR_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__METHOD = PROCESSOR_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__MVEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__OGNL = PROCESSOR_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__PYTHON = PROCESSOR_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__REF = PROCESSOR_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__SIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__SPEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__TOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__WASM = PROCESSOR_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__XTOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__XPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__XQUERY = PROCESSOR_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Async Delayed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__ASYNC_DELAYED = PROCESSOR_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Caller Runs When Rejected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__CALLER_RUNS_WHEN_REJECTED = PROCESSOR_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION__EXECUTOR_SERVICE = PROCESSOR_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The number of structural features of the '<em>Delay Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The number of operations of the '<em>Delay Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.VerbDefinitionImpl <em>Verb Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.VerbDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getVerbDefinition()
	 * @generated
	 */
	int VERB_DEFINITION = 322;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Param</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__PARAM = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Response Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__RESPONSE_MESSAGE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__SECURITY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Api Docs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__API_DOCS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Binding Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__BINDING_MODE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Client Request Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__CLIENT_REQUEST_VALIDATION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Client Response Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__CLIENT_RESPONSE_VALIDATION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Consumes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__CONSUMES = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__DEPRECATED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__DISABLED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Enable CORS</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__ENABLE_CORS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Enable No Content Response</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__ENABLE_NO_CONTENT_RESPONSE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Out Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__OUT_TYPE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__PATH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Produces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__PRODUCES = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__ROUTE_ID = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Skip Binding On Error Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__SKIP_BINDING_ON_ERROR_CODE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Stream Cache</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__STREAM_CACHE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION__TYPE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The number of structural features of the '<em>Verb Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The number of operations of the '<em>Verb Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERB_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DeleteDefinitionImpl <em>Delete Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DeleteDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDeleteDefinition()
	 * @generated
	 */
	int DELETE_DEFINITION = 88;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__CUSTOM_ID = VERB_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__DESCRIPTION = VERB_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__ID = VERB_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Param</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__PARAM = VERB_DEFINITION__PARAM;

	/**
	 * The feature id for the '<em><b>Response Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__RESPONSE_MESSAGE = VERB_DEFINITION__RESPONSE_MESSAGE;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__SECURITY = VERB_DEFINITION__SECURITY;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__TO = VERB_DEFINITION__TO;

	/**
	 * The feature id for the '<em><b>Api Docs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__API_DOCS = VERB_DEFINITION__API_DOCS;

	/**
	 * The feature id for the '<em><b>Binding Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__BINDING_MODE = VERB_DEFINITION__BINDING_MODE;

	/**
	 * The feature id for the '<em><b>Client Request Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__CLIENT_REQUEST_VALIDATION = VERB_DEFINITION__CLIENT_REQUEST_VALIDATION;

	/**
	 * The feature id for the '<em><b>Client Response Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__CLIENT_RESPONSE_VALIDATION = VERB_DEFINITION__CLIENT_RESPONSE_VALIDATION;

	/**
	 * The feature id for the '<em><b>Consumes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__CONSUMES = VERB_DEFINITION__CONSUMES;

	/**
	 * The feature id for the '<em><b>Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__DEPRECATED = VERB_DEFINITION__DEPRECATED;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__DISABLED = VERB_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Enable CORS</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__ENABLE_CORS = VERB_DEFINITION__ENABLE_CORS;

	/**
	 * The feature id for the '<em><b>Enable No Content Response</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__ENABLE_NO_CONTENT_RESPONSE = VERB_DEFINITION__ENABLE_NO_CONTENT_RESPONSE;

	/**
	 * The feature id for the '<em><b>Out Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__OUT_TYPE = VERB_DEFINITION__OUT_TYPE;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__PATH = VERB_DEFINITION__PATH;

	/**
	 * The feature id for the '<em><b>Produces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__PRODUCES = VERB_DEFINITION__PRODUCES;

	/**
	 * The feature id for the '<em><b>Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__ROUTE_ID = VERB_DEFINITION__ROUTE_ID;

	/**
	 * The feature id for the '<em><b>Skip Binding On Error Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__SKIP_BINDING_ON_ERROR_CODE = VERB_DEFINITION__SKIP_BINDING_ON_ERROR_CODE;

	/**
	 * The feature id for the '<em><b>Stream Cache</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__STREAM_CACHE = VERB_DEFINITION__STREAM_CACHE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION__TYPE = VERB_DEFINITION__TYPE;

	/**
	 * The number of structural features of the '<em>Delete Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION_FEATURE_COUNT = VERB_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Delete Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELETE_DEFINITION_OPERATION_COUNT = VERB_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DfdlDataFormatImpl <em>Dfdl Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DfdlDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDfdlDataFormat()
	 * @generated
	 */
	int DFDL_DATA_FORMAT = 89;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DFDL_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Root Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DFDL_DATA_FORMAT__ROOT_ELEMENT = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Root Namespace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DFDL_DATA_FORMAT__ROOT_NAMESPACE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Schema Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DFDL_DATA_FORMAT__SCHEMA_URI = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Dfdl Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DFDL_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Dfdl Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DFDL_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DnsServiceCallServiceDiscoveryConfigurationImpl <em>Dns Service Call Service Discovery Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DnsServiceCallServiceDiscoveryConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDnsServiceCallServiceDiscoveryConfiguration()
	 * @generated
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION = 90;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Domain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__DOMAIN = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Proto</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROTO = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Dns Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Dns Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DNS_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DocumentRootImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDocumentRoot()
	 * @generated
	 */
	int DOCUMENT_ROOT = 91;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__AGGREGATE = 3;

	/**
	 * The feature id for the '<em><b>Api Key</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__API_KEY = 4;

	/**
	 * The feature id for the '<em><b>Asn1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ASN1 = 5;

	/**
	 * The feature id for the '<em><b>Avro</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__AVRO = 6;

	/**
	 * The feature id for the '<em><b>Barcode</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BARCODE = 7;

	/**
	 * The feature id for the '<em><b>Base64</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BASE64 = 8;

	/**
	 * The feature id for the '<em><b>Basic Auth</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BASIC_AUTH = 9;

	/**
	 * The feature id for the '<em><b>Batch Config</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BATCH_CONFIG = 10;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BEAN = 11;

	/**
	 * The feature id for the '<em><b>Bean Factory</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BEAN_FACTORY = 12;

	/**
	 * The feature id for the '<em><b>Beanio</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BEANIO = 13;

	/**
	 * The feature id for the '<em><b>Bean Post Processor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BEAN_POST_PROCESSOR = 14;

	/**
	 * The feature id for the '<em><b>Beans</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BEANS = 15;

	/**
	 * The feature id for the '<em><b>Bearer Token</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BEARER_TOKEN = 16;

	/**
	 * The feature id for the '<em><b>Bindy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BINDY = 17;

	/**
	 * The feature id for the '<em><b>Blacklist Service Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__BLACKLIST_SERVICE_FILTER = 18;

	/**
	 * The feature id for the '<em><b>Caching Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CACHING_SERVICE_DISCOVERY = 19;

	/**
	 * The feature id for the '<em><b>Camel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CAMEL = 20;

	/**
	 * The feature id for the '<em><b>Camel Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CAMEL_CONTEXT = 21;

	/**
	 * The feature id for the '<em><b>Cbor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CBOR = 22;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CHOICE = 23;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CIRCUIT_BREAKER = 24;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CLAIM_CHECK = 25;

	/**
	 * The feature id for the '<em><b>Combined Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__COMBINED_SERVICE_DISCOVERY = 26;

	/**
	 * The feature id for the '<em><b>Combined Service Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__COMBINED_SERVICE_FILTER = 27;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONSTANT = 28;

	/**
	 * The feature id for the '<em><b>Consul Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONSUL_SERVICE_DISCOVERY = 29;

	/**
	 * The feature id for the '<em><b>Consumer Template</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONSUMER_TEMPLATE = 30;

	/**
	 * The feature id for the '<em><b>Context Scan</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONTEXT_SCAN = 31;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONVERT_BODY_TO = 32;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONVERT_HEADER_TO = 33;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CONVERT_VARIABLE_TO = 34;

	/**
	 * The feature id for the '<em><b>Crypto</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CRYPTO = 35;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CSIMPLE = 36;

	/**
	 * The feature id for the '<em><b>Csv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CSV = 37;

	/**
	 * The feature id for the '<em><b>Custom</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CUSTOM = 38;

	/**
	 * The feature id for the '<em><b>Custom Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CUSTOM_LOAD_BALANCER = 39;

	/**
	 * The feature id for the '<em><b>Custom Service Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CUSTOM_SERVICE_FILTER = 40;

	/**
	 * The feature id for the '<em><b>Custom Transformer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CUSTOM_TRANSFORMER = 41;

	/**
	 * The feature id for the '<em><b>Custom Validator</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CUSTOM_VALIDATOR = 42;

	/**
	 * The feature id for the '<em><b>Data Formats</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DATA_FORMATS = 43;

	/**
	 * The feature id for the '<em><b>Data Format Transformer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DATA_FORMAT_TRANSFORMER = 44;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DATASONNET = 45;

	/**
	 * The feature id for the '<em><b>Dead Letter Channel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DEAD_LETTER_CHANNEL = 46;

	/**
	 * The feature id for the '<em><b>Default Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DEFAULT_ERROR_HANDLER = 47;

	/**
	 * The feature id for the '<em><b>Default Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DEFAULT_LOAD_BALANCER = 48;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DELAY = 49;

	/**
	 * The feature id for the '<em><b>Delete</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DELETE = 50;

	/**
	 * The feature id for the '<em><b>Dfdl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DFDL = 51;

	/**
	 * The feature id for the '<em><b>Dns Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DNS_SERVICE_DISCOVERY = 52;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DO_CATCH = 53;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DO_FINALLY = 54;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DO_TRY = 55;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DYNAMIC_ROUTER = 56;

	/**
	 * The feature id for the '<em><b>Endpoint</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ENDPOINT = 57;

	/**
	 * The feature id for the '<em><b>Endpoint Transformer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ENDPOINT_TRANSFORMER = 58;

	/**
	 * The feature id for the '<em><b>Endpoint Validator</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ENDPOINT_VALIDATOR = 59;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ENRICH = 60;

	/**
	 * The feature id for the '<em><b>Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ERROR_HANDLER = 61;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EXCHANGE_PROPERTY = 62;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EXPRESSION = 63;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EXPRESSION_DEFINITION = 64;

	/**
	 * The feature id for the '<em><b>Failover Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FAILOVER_LOAD_BALANCER = 65;

	/**
	 * The feature id for the '<em><b>Fault Tolerance Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FAULT_TOLERANCE_CONFIGURATION = 66;

	/**
	 * The feature id for the '<em><b>Fhir Json</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FHIR_JSON = 67;

	/**
	 * The feature id for the '<em><b>Fhir Xml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FHIR_XML = 68;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FILTER = 69;

	/**
	 * The feature id for the '<em><b>Flatpack</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FLATPACK = 70;

	/**
	 * The feature id for the '<em><b>Fluent Template</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FLUENT_TEMPLATE = 71;

	/**
	 * The feature id for the '<em><b>Fory</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FORY = 72;

	/**
	 * The feature id for the '<em><b>From</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FROM = 73;

	/**
	 * The feature id for the '<em><b>Get</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__GET = 74;

	/**
	 * The feature id for the '<em><b>Global Option</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__GLOBAL_OPTION = 75;

	/**
	 * The feature id for the '<em><b>Global Options</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__GLOBAL_OPTIONS = 76;

	/**
	 * The feature id for the '<em><b>Grok</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__GROK = 77;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__GROOVY = 78;

	/**
	 * The feature id for the '<em><b>Gzip Deflater</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__GZIP_DEFLATER = 79;

	/**
	 * The feature id for the '<em><b>Head</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__HEAD = 80;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__HEADER = 81;

	/**
	 * The feature id for the '<em><b>Healthy Service Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__HEALTHY_SERVICE_FILTER = 82;

	/**
	 * The feature id for the '<em><b>Hl7</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__HL7 = 83;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__HL7TERSER = 84;

	/**
	 * The feature id for the '<em><b>Ical</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ICAL = 85;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__IDEMPOTENT_CONSUMER = 86;

	/**
	 * The feature id for the '<em><b>Input Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__INPUT_TYPE = 87;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__INTERCEPT = 88;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__INTERCEPT_FROM = 89;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__INTERCEPT_SEND_TO_ENDPOINT = 90;

	/**
	 * The feature id for the '<em><b>Iso8583</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ISO8583 = 91;

	/**
	 * The feature id for the '<em><b>Jackson Xml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JACKSON_XML = 92;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JAVA = 93;

	/**
	 * The feature id for the '<em><b>Jaxb</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JAXB = 94;

	/**
	 * The feature id for the '<em><b>Jmx Agent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JMX_AGENT = 95;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JOOR = 96;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JQ = 97;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JS = 98;

	/**
	 * The feature id for the '<em><b>Json</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JSON = 99;

	/**
	 * The feature id for the '<em><b>Json Api</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JSON_API = 100;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JSONPATH = 101;

	/**
	 * The feature id for the '<em><b>Jta Transaction Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__JTA_TRANSACTION_ERROR_HANDLER = 102;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__KAMELET = 103;

	/**
	 * The feature id for the '<em><b>Key Store Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__KEY_STORE_PARAMETERS = 104;

	/**
	 * The feature id for the '<em><b>Kubernetes Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__KUBERNETES_SERVICE_DISCOVERY = 105;

	/**
	 * The feature id for the '<em><b>Lang Chain4j Character Tokenizer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANG_CHAIN4J_CHARACTER_TOKENIZER = 106;

	/**
	 * The feature id for the '<em><b>Lang Chain4j Line Tokenizer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANG_CHAIN4J_LINE_TOKENIZER = 107;

	/**
	 * The feature id for the '<em><b>Lang Chain4j Paragraph Tokenizer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANG_CHAIN4J_PARAGRAPH_TOKENIZER = 108;

	/**
	 * The feature id for the '<em><b>Lang Chain4j Sentence Tokenizer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANG_CHAIN4J_SENTENCE_TOKENIZER = 109;

	/**
	 * The feature id for the '<em><b>Lang Chain4j Word Tokenizer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANG_CHAIN4J_WORD_TOKENIZER = 110;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANGUAGE = 111;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LOAD_BALANCE = 112;

	/**
	 * The feature id for the '<em><b>Load Balancer Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LOAD_BALANCER_CONFIGURATION = 113;

	/**
	 * The feature id for the '<em><b>Load Transformer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LOAD_TRANSFORMER = 114;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LOG = 115;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LOOP = 116;

	/**
	 * The feature id for the '<em><b>Lzf</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LZF = 117;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MARSHAL = 118;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__METHOD = 119;

	/**
	 * The feature id for the '<em><b>Mime Multipart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIME_MULTIPART = 120;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MULTICAST = 121;

	/**
	 * The feature id for the '<em><b>Mutual TLS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MUTUAL_TLS = 122;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MVEL = 123;

	/**
	 * The feature id for the '<em><b>No Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__NO_ERROR_HANDLER = 124;

	/**
	 * The feature id for the '<em><b>Oauth2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OAUTH2 = 125;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OGNL = 126;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ON_COMPLETION = 127;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ON_EXCEPTION = 128;

	/**
	 * The feature id for the '<em><b>On Fallback</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ON_FALLBACK = 129;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ON_WHEN = 130;

	/**
	 * The feature id for the '<em><b>Open Api</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OPEN_API = 131;

	/**
	 * The feature id for the '<em><b>Open Id Connect</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OPEN_ID_CONNECT = 132;

	/**
	 * The feature id for the '<em><b>Optimistic Lock Retry Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OPTIMISTIC_LOCK_RETRY_POLICY = 133;

	/**
	 * The feature id for the '<em><b>Otherwise</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OTHERWISE = 134;

	/**
	 * The feature id for the '<em><b>Output Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__OUTPUT_TYPE = 135;

	/**
	 * The feature id for the '<em><b>Package Scan</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PACKAGE_SCAN = 136;

	/**
	 * The feature id for the '<em><b>Param</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PARAM = 137;

	/**
	 * The feature id for the '<em><b>Parquet Avro</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PARQUET_AVRO = 138;

	/**
	 * The feature id for the '<em><b>Pass Through Service Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PASS_THROUGH_SERVICE_FILTER = 139;

	/**
	 * The feature id for the '<em><b>Patch</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PATCH = 140;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PAUSABLE = 141;

	/**
	 * The feature id for the '<em><b>Pgp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PGP = 142;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PIPELINE = 143;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__POLICY = 144;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__POLL = 145;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__POLL_ENRICH = 146;

	/**
	 * The feature id for the '<em><b>Post</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__POST = 147;

	/**
	 * The feature id for the '<em><b>Predicate Validator</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PREDICATE_VALIDATOR = 148;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROCESS = 149;

	/**
	 * The feature id for the '<em><b>Properties Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROPERTIES_FUNCTION = 150;

	/**
	 * The feature id for the '<em><b>Properties Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROPERTIES_LOCATION = 151;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROPERTY = 152;

	/**
	 * The feature id for the '<em><b>Property Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROPERTY_EXPRESSION = 153;

	/**
	 * The feature id for the '<em><b>Property Placeholder</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROPERTY_PLACEHOLDER = 154;

	/**
	 * The feature id for the '<em><b>Protobuf</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PROTOBUF = 155;

	/**
	 * The feature id for the '<em><b>Put</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PUT = 156;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PYTHON = 157;

	/**
	 * The feature id for the '<em><b>Random Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RANDOM_LOAD_BALANCER = 158;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RECIPIENT_LIST = 159;

	/**
	 * The feature id for the '<em><b>Redelivery Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REDELIVERY_POLICY = 160;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Profile</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REDELIVERY_POLICY_PROFILE = 161;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REF = 162;

	/**
	 * The feature id for the '<em><b>Ref Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REF_ERROR_HANDLER = 163;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REMOVE_HEADER = 164;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REMOVE_HEADERS = 165;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REMOVE_PROPERTIES = 166;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REMOVE_PROPERTY = 167;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REMOVE_VARIABLE = 168;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RESEQUENCE = 169;

	/**
	 * The feature id for the '<em><b>Resilience4j Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RESILIENCE4J_CONFIGURATION = 170;

	/**
	 * The feature id for the '<em><b>Response Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RESPONSE_HEADER = 171;

	/**
	 * The feature id for the '<em><b>Response Message</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RESPONSE_MESSAGE = 172;

	/**
	 * The feature id for the '<em><b>Rest</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REST = 173;

	/**
	 * The feature id for the '<em><b>Rest Binding</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REST_BINDING = 174;

	/**
	 * The feature id for the '<em><b>Rest Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REST_CONFIGURATION = 175;

	/**
	 * The feature id for the '<em><b>Rest Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REST_CONTEXT = 176;

	/**
	 * The feature id for the '<em><b>Rest Context Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REST_CONTEXT_REF = 177;

	/**
	 * The feature id for the '<em><b>Rest Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__REST_PROPERTY = 178;

	/**
	 * The feature id for the '<em><b>Rests</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RESTS = 179;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RESUMABLE = 180;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROLLBACK = 181;

	/**
	 * The feature id for the '<em><b>Round Robin Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUND_ROBIN_LOAD_BALANCER = 182;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE = 183;

	/**
	 * The feature id for the '<em><b>Route Builder</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_BUILDER = 184;

	/**
	 * The feature id for the '<em><b>Route Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONFIGURATION = 185;

	/**
	 * The feature id for the '<em><b>Route Configuration Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONFIGURATION_CONTEXT = 186;

	/**
	 * The feature id for the '<em><b>Route Configuration Context Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONFIGURATION_CONTEXT_REF = 187;

	/**
	 * The feature id for the '<em><b>Route Configurations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONFIGURATIONS = 188;

	/**
	 * The feature id for the '<em><b>Route Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONTEXT = 189;

	/**
	 * The feature id for the '<em><b>Route Context Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONTEXT_REF = 190;

	/**
	 * The feature id for the '<em><b>Route Controller</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_CONTROLLER = 191;

	/**
	 * The feature id for the '<em><b>Routes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTES = 192;

	/**
	 * The feature id for the '<em><b>Route Template</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_TEMPLATE = 193;

	/**
	 * The feature id for the '<em><b>Route Template Context</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_TEMPLATE_CONTEXT = 194;

	/**
	 * The feature id for the '<em><b>Route Template Context Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_TEMPLATE_CONTEXT_REF = 195;

	/**
	 * The feature id for the '<em><b>Route Templates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTE_TEMPLATES = 196;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ROUTING_SLIP = 197;

	/**
	 * The feature id for the '<em><b>Rss</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RSS = 198;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SAGA = 199;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SAMPLE = 200;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SCRIPT = 201;

	/**
	 * The feature id for the '<em><b>Secure Random Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SECURE_RANDOM_PARAMETERS = 202;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SECURITY = 203;

	/**
	 * The feature id for the '<em><b>Security Definitions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SECURITY_DEFINITIONS = 204;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SERVICE_CALL = 205;

	/**
	 * The feature id for the '<em><b>Service Call Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SERVICE_CALL_CONFIGURATION = 206;

	/**
	 * The feature id for the '<em><b>Service Chooser Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SERVICE_CHOOSER_CONFIGURATION = 207;

	/**
	 * The feature id for the '<em><b>Service Discovery Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SERVICE_DISCOVERY_CONFIGURATION = 208;

	/**
	 * The feature id for the '<em><b>Service Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SERVICE_EXPRESSION = 209;

	/**
	 * The feature id for the '<em><b>Service Filter Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SERVICE_FILTER_CONFIGURATION = 210;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_BODY = 211;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_EXCHANGE_PATTERN = 212;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_HEADER = 213;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_HEADERS = 214;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_PROPERTY = 215;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_VARIABLE = 216;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SET_VARIABLES = 217;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SIMPLE = 218;

	/**
	 * The feature id for the '<em><b>Smooks</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SMOOKS = 219;

	/**
	 * The feature id for the '<em><b>Soap</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SOAP = 220;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SORT = 221;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SPEL = 222;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SPLIT = 223;

	/**
	 * The feature id for the '<em><b>Spring Transaction Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SPRING_TRANSACTION_ERROR_HANDLER = 224;

	/**
	 * The feature id for the '<em><b>Ssl Context Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SSL_CONTEXT_PARAMETERS = 225;

	/**
	 * The feature id for the '<em><b>Static Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STATIC_SERVICE_DISCOVERY = 226;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STEP = 227;

	/**
	 * The feature id for the '<em><b>Sticky Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STICKY_LOAD_BALANCER = 228;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STOP = 229;

	/**
	 * The feature id for the '<em><b>Stream Caching</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STREAM_CACHING = 230;

	/**
	 * The feature id for the '<em><b>Stream Config</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__STREAM_CONFIG = 231;

	/**
	 * The feature id for the '<em><b>Swift Mt</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SWIFT_MT = 232;

	/**
	 * The feature id for the '<em><b>Swift Mx</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SWIFT_MX = 233;

	/**
	 * The feature id for the '<em><b>Syslog</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__SYSLOG = 234;

	/**
	 * The feature id for the '<em><b>Tar File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TAR_FILE = 235;

	/**
	 * The feature id for the '<em><b>Template</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TEMPLATE = 236;

	/**
	 * The feature id for the '<em><b>Templated Route</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TEMPLATED_ROUTE = 237;

	/**
	 * The feature id for the '<em><b>Templated Route Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TEMPLATED_ROUTE_PARAMETER = 238;

	/**
	 * The feature id for the '<em><b>Templated Routes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TEMPLATED_ROUTES = 239;

	/**
	 * The feature id for the '<em><b>Template Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TEMPLATE_PARAMETER = 240;

	/**
	 * The feature id for the '<em><b>Thread Pool</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__THREAD_POOL = 241;

	/**
	 * The feature id for the '<em><b>Thread Pool Profile</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__THREAD_POOL_PROFILE = 242;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__THREADS = 243;

	/**
	 * The feature id for the '<em><b>Thrift</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__THRIFT = 244;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__THROTTLE = 245;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__THROW_EXCEPTION = 246;

	/**
	 * The feature id for the '<em><b>Tidy Markup</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TIDY_MARKUP = 247;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TO = 248;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TO_D = 249;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TOKENIZE = 250;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TOKENIZER = 251;

	/**
	 * The feature id for the '<em><b>Topic Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TOPIC_LOAD_BALANCER = 252;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TRANSACTED = 253;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TRANSFORM = 254;

	/**
	 * The feature id for the '<em><b>Transformers</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TRANSFORMERS = 255;

	/**
	 * The feature id for the '<em><b>Type Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__TYPE_FILTER = 256;

	/**
	 * The feature id for the '<em><b>Univocity Csv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNIVOCITY_CSV = 257;

	/**
	 * The feature id for the '<em><b>Univocity Fixed</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNIVOCITY_FIXED = 258;

	/**
	 * The feature id for the '<em><b>Univocity Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNIVOCITY_HEADER = 259;

	/**
	 * The feature id for the '<em><b>Univocity Tsv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNIVOCITY_TSV = 260;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__UNMARSHAL = 261;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__VALIDATE = 262;

	/**
	 * The feature id for the '<em><b>Validators</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__VALIDATORS = 263;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__VALUE = 264;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__VARIABLE = 265;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__WASM = 266;

	/**
	 * The feature id for the '<em><b>Weighted Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__WEIGHTED_LOAD_BALANCER = 267;

	/**
	 * The feature id for the '<em><b>When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__WHEN = 268;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__WIRE_TAP = 269;

	/**
	 * The feature id for the '<em><b>Xml Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XML_SECURITY = 270;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XPATH = 271;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XQUERY = 272;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XTOKENIZE = 273;

	/**
	 * The feature id for the '<em><b>Yaml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__YAML = 274;

	/**
	 * The feature id for the '<em><b>Zip Deflater</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ZIP_DEFLATER = 275;

	/**
	 * The feature id for the '<em><b>Zip File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ZIP_FILE = 276;

	/**
	 * The feature id for the '<em><b>Zookeeper Service Discovery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ZOOKEEPER_SERVICE_DISCOVERY = 277;

	/**
	 * The number of structural features of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_FEATURE_COUNT = 278;

	/**
	 * The number of operations of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.DynamicRouterDefinitionImpl <em>Dynamic Router Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.DynamicRouterDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getDynamicRouterDefinition()
	 * @generated
	 */
	int DYNAMIC_ROUTER_DEFINITION = 92;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__EXPRESSION_DEFINITION = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__CSIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__CONSTANT = PROCESSOR_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__DATASONNET = PROCESSOR_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__EXCHANGE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__GROOVY = PROCESSOR_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__HL7TERSER = PROCESSOR_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__JAVA = PROCESSOR_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__JS = PROCESSOR_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__JOOR = PROCESSOR_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__JQ = PROCESSOR_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__JSONPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__LANGUAGE = PROCESSOR_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__METHOD = PROCESSOR_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__MVEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__OGNL = PROCESSOR_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__PYTHON = PROCESSOR_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__REF = PROCESSOR_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__SIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__SPEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__TOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__WASM = PROCESSOR_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__XTOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__XPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__XQUERY = PROCESSOR_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__CACHE_SIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Ignore Invalid Endpoints</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__IGNORE_INVALID_ENDPOINTS = PROCESSOR_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Uri Delimiter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION__URI_DELIMITER = PROCESSOR_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The number of structural features of the '<em>Dynamic Router Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The number of operations of the '<em>Dynamic Router Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_ROUTER_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.EndpointTransformerDefinitionImpl <em>Endpoint Transformer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.EndpointTransformerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getEndpointTransformerDefinition()
	 * @generated
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION = 93;

	/**
	 * The feature id for the '<em><b>From Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION__FROM_TYPE = TRANSFORMER__FROM_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION__NAME = TRANSFORMER__NAME;

	/**
	 * The feature id for the '<em><b>Scheme</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION__SCHEME = TRANSFORMER__SCHEME;

	/**
	 * The feature id for the '<em><b>To Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION__TO_TYPE = TRANSFORMER__TO_TYPE;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION__REF = TRANSFORMER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION__URI = TRANSFORMER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Endpoint Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION_FEATURE_COUNT = TRANSFORMER_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Endpoint Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_TRANSFORMER_DEFINITION_OPERATION_COUNT = TRANSFORMER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.EndpointValidatorDefinitionImpl <em>Endpoint Validator Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.EndpointValidatorDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getEndpointValidatorDefinition()
	 * @generated
	 */
	int ENDPOINT_VALIDATOR_DEFINITION = 94;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_VALIDATOR_DEFINITION__TYPE = VALIDATOR__TYPE;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_VALIDATOR_DEFINITION__REF = VALIDATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_VALIDATOR_DEFINITION__URI = VALIDATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Endpoint Validator Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_VALIDATOR_DEFINITION_FEATURE_COUNT = VALIDATOR_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Endpoint Validator Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENDPOINT_VALIDATOR_DEFINITION_OPERATION_COUNT = VALIDATOR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.EnrichDefinitionImpl <em>Enrich Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.EnrichDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getEnrichDefinition()
	 * @generated
	 */
	int ENRICH_DEFINITION = 95;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__EXPRESSION_DEFINITION = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__CSIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__CONSTANT = PROCESSOR_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__DATASONNET = PROCESSOR_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__EXCHANGE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__GROOVY = PROCESSOR_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__HL7TERSER = PROCESSOR_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__JAVA = PROCESSOR_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__JS = PROCESSOR_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__JOOR = PROCESSOR_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__JQ = PROCESSOR_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__JSONPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__LANGUAGE = PROCESSOR_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__METHOD = PROCESSOR_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__MVEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__OGNL = PROCESSOR_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__PYTHON = PROCESSOR_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__REF = PROCESSOR_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__SIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__SPEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__TOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__WASM = PROCESSOR_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__XTOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__XPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__XQUERY = PROCESSOR_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Aggregate On Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__AGGREGATE_ON_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__AGGREGATION_STRATEGY = PROCESSOR_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Allow Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__AGGREGATION_STRATEGY_METHOD_ALLOW_NULL = PROCESSOR_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__AGGREGATION_STRATEGY_METHOD_NAME = PROCESSOR_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Allow Optimised Components</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__ALLOW_OPTIMISED_COMPONENTS = PROCESSOR_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Auto Start Components</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__AUTO_START_COMPONENTS = PROCESSOR_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__CACHE_SIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Ignore Invalid Endpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__IGNORE_INVALID_ENDPOINT = PROCESSOR_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Share Unit Of Work</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__SHARE_UNIT_OF_WORK = PROCESSOR_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Variable Receive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__VARIABLE_RECEIVE = PROCESSOR_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Variable Send</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION__VARIABLE_SEND = PROCESSOR_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The number of structural features of the '<em>Enrich Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The number of operations of the '<em>Enrich Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENRICH_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ErrorHandlerDefinitionImpl <em>Error Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ErrorHandlerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getErrorHandlerDefinition()
	 * @generated
	 */
	int ERROR_HANDLER_DEFINITION = 96;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Dead Letter Channel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__DEAD_LETTER_CHANNEL = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Default Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__DEFAULT_ERROR_HANDLER = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>No Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__NO_ERROR_HANDLER = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Ref Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__REF_ERROR_HANDLER = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Jta Transaction Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__JTA_TRANSACTION_ERROR_HANDLER = IDENTIFIED_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Spring Transaction Error Handler</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION__SPRING_TRANSACTION_ERROR_HANDLER = IDENTIFIED_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ERROR_HANDLER_DEFINITION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ExchangePropertyExpressionImpl <em>Exchange Property Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ExchangePropertyExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getExchangePropertyExpression()
	 * @generated
	 */
	int EXCHANGE_PROPERTY_EXPRESSION = 97;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCHANGE_PROPERTY_EXPRESSION__VALUE = EXPRESSION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCHANGE_PROPERTY_EXPRESSION__ID = EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCHANGE_PROPERTY_EXPRESSION__TRIM = EXPRESSION__TRIM;

	/**
	 * The number of structural features of the '<em>Exchange Property Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCHANGE_PROPERTY_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Exchange Property Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCHANGE_PROPERTY_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ExpressionSubElementDefinitionImpl <em>Expression Sub Element Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ExpressionSubElementDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getExpressionSubElementDefinition()
	 * @generated
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION = 99;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__EXPRESSION_DEFINITION = 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__CSIMPLE = 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__CONSTANT = 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__DATASONNET = 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__EXCHANGE_PROPERTY = 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__GROOVY = 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__HEADER = 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__HL7TERSER = 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__JAVA = 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__JS = 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__JOOR = 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__JQ = 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__JSONPATH = 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__LANGUAGE = 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__METHOD = 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__MVEL = 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__OGNL = 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__PYTHON = 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__REF = 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__SIMPLE = 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__SPEL = 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__TOKENIZE = 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__VARIABLE = 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__WASM = 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__XTOKENIZE = 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__XPATH = 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION__XQUERY = 26;

	/**
	 * The number of structural features of the '<em>Expression Sub Element Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION_FEATURE_COUNT = 27;

	/**
	 * The number of operations of the '<em>Expression Sub Element Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_SUB_ELEMENT_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FailoverLoadBalancerDefinitionImpl <em>Failover Load Balancer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FailoverLoadBalancerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFailoverLoadBalancerDefinition()
	 * @generated
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION = 100;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION__ID = LOAD_BALANCER_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Exception</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION__EXCEPTION = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inherit Error Handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION__INHERIT_ERROR_HANDLER = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Maximum Failover Attempts</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION__MAXIMUM_FAILOVER_ATTEMPTS = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Round Robin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION__ROUND_ROBIN = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Sticky</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION__STICKY = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Failover Load Balancer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION_FEATURE_COUNT = LOAD_BALANCER_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Failover Load Balancer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAILOVER_LOAD_BALANCER_DEFINITION_OPERATION_COUNT = LOAD_BALANCER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FaultToleranceConfigurationCommonImpl <em>Fault Tolerance Configuration Common</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FaultToleranceConfigurationCommonImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFaultToleranceConfigurationCommon()
	 * @generated
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON = 101;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bulkhead Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__BULKHEAD_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bulkhead Max Concurrent Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__BULKHEAD_MAX_CONCURRENT_CALLS = IDENTIFIED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bulkhead Waiting Task Queue</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__BULKHEAD_WAITING_TASK_QUEUE = IDENTIFIED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__DELAY = IDENTIFIED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Failure Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__FAILURE_RATIO = IDENTIFIED_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Request Volume Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__REQUEST_VOLUME_THRESHOLD = IDENTIFIED_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Success Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__SUCCESS_THRESHOLD = IDENTIFIED_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Thread Offload Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__THREAD_OFFLOAD_EXECUTOR_SERVICE = IDENTIFIED_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Timeout Duration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__TIMEOUT_DURATION = IDENTIFIED_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Timeout Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__TIMEOUT_ENABLED = IDENTIFIED_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Timeout Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__TIMEOUT_POOL_SIZE = IDENTIFIED_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Typed Guard</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON__TYPED_GUARD = IDENTIFIED_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Fault Tolerance Configuration Common</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>Fault Tolerance Configuration Common</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_COMMON_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FaultToleranceConfigurationDefinitionImpl <em>Fault Tolerance Configuration Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FaultToleranceConfigurationDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFaultToleranceConfigurationDefinition()
	 * @generated
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION = 102;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__ID = FAULT_TOLERANCE_CONFIGURATION_COMMON__ID;

	/**
	 * The feature id for the '<em><b>Bulkhead Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__BULKHEAD_ENABLED = FAULT_TOLERANCE_CONFIGURATION_COMMON__BULKHEAD_ENABLED;

	/**
	 * The feature id for the '<em><b>Bulkhead Max Concurrent Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__BULKHEAD_MAX_CONCURRENT_CALLS = FAULT_TOLERANCE_CONFIGURATION_COMMON__BULKHEAD_MAX_CONCURRENT_CALLS;

	/**
	 * The feature id for the '<em><b>Bulkhead Waiting Task Queue</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__BULKHEAD_WAITING_TASK_QUEUE = FAULT_TOLERANCE_CONFIGURATION_COMMON__BULKHEAD_WAITING_TASK_QUEUE;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__DELAY = FAULT_TOLERANCE_CONFIGURATION_COMMON__DELAY;

	/**
	 * The feature id for the '<em><b>Failure Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__FAILURE_RATIO = FAULT_TOLERANCE_CONFIGURATION_COMMON__FAILURE_RATIO;

	/**
	 * The feature id for the '<em><b>Request Volume Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__REQUEST_VOLUME_THRESHOLD = FAULT_TOLERANCE_CONFIGURATION_COMMON__REQUEST_VOLUME_THRESHOLD;

	/**
	 * The feature id for the '<em><b>Success Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__SUCCESS_THRESHOLD = FAULT_TOLERANCE_CONFIGURATION_COMMON__SUCCESS_THRESHOLD;

	/**
	 * The feature id for the '<em><b>Thread Offload Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__THREAD_OFFLOAD_EXECUTOR_SERVICE = FAULT_TOLERANCE_CONFIGURATION_COMMON__THREAD_OFFLOAD_EXECUTOR_SERVICE;

	/**
	 * The feature id for the '<em><b>Timeout Duration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__TIMEOUT_DURATION = FAULT_TOLERANCE_CONFIGURATION_COMMON__TIMEOUT_DURATION;

	/**
	 * The feature id for the '<em><b>Timeout Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__TIMEOUT_ENABLED = FAULT_TOLERANCE_CONFIGURATION_COMMON__TIMEOUT_ENABLED;

	/**
	 * The feature id for the '<em><b>Timeout Pool Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__TIMEOUT_POOL_SIZE = FAULT_TOLERANCE_CONFIGURATION_COMMON__TIMEOUT_POOL_SIZE;

	/**
	 * The feature id for the '<em><b>Typed Guard</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION__TYPED_GUARD = FAULT_TOLERANCE_CONFIGURATION_COMMON__TYPED_GUARD;

	/**
	 * The number of structural features of the '<em>Fault Tolerance Configuration Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION_FEATURE_COUNT = FAULT_TOLERANCE_CONFIGURATION_COMMON_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fault Tolerance Configuration Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FAULT_TOLERANCE_CONFIGURATION_DEFINITION_OPERATION_COUNT = FAULT_TOLERANCE_CONFIGURATION_COMMON_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FhirDataformatImpl <em>Fhir Dataformat</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FhirDataformatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFhirDataformat()
	 * @generated
	 */
	int FHIR_DATAFORMAT = 103;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__CONTENT_TYPE_HEADER = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dont Encode Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__DONT_ENCODE_ELEMENTS = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dont Strip Versions From References At Paths</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__DONT_STRIP_VERSIONS_FROM_REFERENCES_AT_PATHS = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Encode Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__ENCODE_ELEMENTS = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Encode Elements Applies To Child Resources Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__ENCODE_ELEMENTS_APPLIES_TO_CHILD_RESOURCES_ONLY = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Fhir Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__FHIR_CONTEXT = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Fhir Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__FHIR_VERSION = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Force Resource Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__FORCE_RESOURCE_ID = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Omit Resource Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__OMIT_RESOURCE_ID = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Override Resource Id With Bundle Entry Full Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__OVERRIDE_RESOURCE_ID_WITH_BUNDLE_ENTRY_FULL_URL = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Parser Error Handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__PARSER_ERROR_HANDLER = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Parser Options</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__PARSER_OPTIONS = DATA_FORMAT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Prefer Types</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__PREFER_TYPES = DATA_FORMAT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__PRETTY_PRINT = DATA_FORMAT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Server Base Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__SERVER_BASE_URL = DATA_FORMAT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Strip Versions From References</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__STRIP_VERSIONS_FROM_REFERENCES = DATA_FORMAT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Summary Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__SUMMARY_MODE = DATA_FORMAT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Suppress Narratives</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT__SUPPRESS_NARRATIVES = DATA_FORMAT_FEATURE_COUNT + 17;

	/**
	 * The number of structural features of the '<em>Fhir Dataformat</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 18;

	/**
	 * The number of operations of the '<em>Fhir Dataformat</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_DATAFORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FhirJsonDataFormatImpl <em>Fhir Json Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FhirJsonDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFhirJsonDataFormat()
	 * @generated
	 */
	int FHIR_JSON_DATA_FORMAT = 104;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__ID = FHIR_DATAFORMAT__ID;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__CONTENT_TYPE_HEADER = FHIR_DATAFORMAT__CONTENT_TYPE_HEADER;

	/**
	 * The feature id for the '<em><b>Dont Encode Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__DONT_ENCODE_ELEMENTS = FHIR_DATAFORMAT__DONT_ENCODE_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Dont Strip Versions From References At Paths</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__DONT_STRIP_VERSIONS_FROM_REFERENCES_AT_PATHS = FHIR_DATAFORMAT__DONT_STRIP_VERSIONS_FROM_REFERENCES_AT_PATHS;

	/**
	 * The feature id for the '<em><b>Encode Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__ENCODE_ELEMENTS = FHIR_DATAFORMAT__ENCODE_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Encode Elements Applies To Child Resources Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__ENCODE_ELEMENTS_APPLIES_TO_CHILD_RESOURCES_ONLY = FHIR_DATAFORMAT__ENCODE_ELEMENTS_APPLIES_TO_CHILD_RESOURCES_ONLY;

	/**
	 * The feature id for the '<em><b>Fhir Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__FHIR_CONTEXT = FHIR_DATAFORMAT__FHIR_CONTEXT;

	/**
	 * The feature id for the '<em><b>Fhir Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__FHIR_VERSION = FHIR_DATAFORMAT__FHIR_VERSION;

	/**
	 * The feature id for the '<em><b>Force Resource Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__FORCE_RESOURCE_ID = FHIR_DATAFORMAT__FORCE_RESOURCE_ID;

	/**
	 * The feature id for the '<em><b>Omit Resource Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__OMIT_RESOURCE_ID = FHIR_DATAFORMAT__OMIT_RESOURCE_ID;

	/**
	 * The feature id for the '<em><b>Override Resource Id With Bundle Entry Full Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__OVERRIDE_RESOURCE_ID_WITH_BUNDLE_ENTRY_FULL_URL = FHIR_DATAFORMAT__OVERRIDE_RESOURCE_ID_WITH_BUNDLE_ENTRY_FULL_URL;

	/**
	 * The feature id for the '<em><b>Parser Error Handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__PARSER_ERROR_HANDLER = FHIR_DATAFORMAT__PARSER_ERROR_HANDLER;

	/**
	 * The feature id for the '<em><b>Parser Options</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__PARSER_OPTIONS = FHIR_DATAFORMAT__PARSER_OPTIONS;

	/**
	 * The feature id for the '<em><b>Prefer Types</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__PREFER_TYPES = FHIR_DATAFORMAT__PREFER_TYPES;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__PRETTY_PRINT = FHIR_DATAFORMAT__PRETTY_PRINT;

	/**
	 * The feature id for the '<em><b>Server Base Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__SERVER_BASE_URL = FHIR_DATAFORMAT__SERVER_BASE_URL;

	/**
	 * The feature id for the '<em><b>Strip Versions From References</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__STRIP_VERSIONS_FROM_REFERENCES = FHIR_DATAFORMAT__STRIP_VERSIONS_FROM_REFERENCES;

	/**
	 * The feature id for the '<em><b>Summary Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__SUMMARY_MODE = FHIR_DATAFORMAT__SUMMARY_MODE;

	/**
	 * The feature id for the '<em><b>Suppress Narratives</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT__SUPPRESS_NARRATIVES = FHIR_DATAFORMAT__SUPPRESS_NARRATIVES;

	/**
	 * The number of structural features of the '<em>Fhir Json Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT_FEATURE_COUNT = FHIR_DATAFORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fhir Json Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_JSON_DATA_FORMAT_OPERATION_COUNT = FHIR_DATAFORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FhirXmlDataFormatImpl <em>Fhir Xml Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FhirXmlDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFhirXmlDataFormat()
	 * @generated
	 */
	int FHIR_XML_DATA_FORMAT = 105;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__ID = FHIR_DATAFORMAT__ID;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__CONTENT_TYPE_HEADER = FHIR_DATAFORMAT__CONTENT_TYPE_HEADER;

	/**
	 * The feature id for the '<em><b>Dont Encode Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__DONT_ENCODE_ELEMENTS = FHIR_DATAFORMAT__DONT_ENCODE_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Dont Strip Versions From References At Paths</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__DONT_STRIP_VERSIONS_FROM_REFERENCES_AT_PATHS = FHIR_DATAFORMAT__DONT_STRIP_VERSIONS_FROM_REFERENCES_AT_PATHS;

	/**
	 * The feature id for the '<em><b>Encode Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__ENCODE_ELEMENTS = FHIR_DATAFORMAT__ENCODE_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Encode Elements Applies To Child Resources Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__ENCODE_ELEMENTS_APPLIES_TO_CHILD_RESOURCES_ONLY = FHIR_DATAFORMAT__ENCODE_ELEMENTS_APPLIES_TO_CHILD_RESOURCES_ONLY;

	/**
	 * The feature id for the '<em><b>Fhir Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__FHIR_CONTEXT = FHIR_DATAFORMAT__FHIR_CONTEXT;

	/**
	 * The feature id for the '<em><b>Fhir Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__FHIR_VERSION = FHIR_DATAFORMAT__FHIR_VERSION;

	/**
	 * The feature id for the '<em><b>Force Resource Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__FORCE_RESOURCE_ID = FHIR_DATAFORMAT__FORCE_RESOURCE_ID;

	/**
	 * The feature id for the '<em><b>Omit Resource Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__OMIT_RESOURCE_ID = FHIR_DATAFORMAT__OMIT_RESOURCE_ID;

	/**
	 * The feature id for the '<em><b>Override Resource Id With Bundle Entry Full Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__OVERRIDE_RESOURCE_ID_WITH_BUNDLE_ENTRY_FULL_URL = FHIR_DATAFORMAT__OVERRIDE_RESOURCE_ID_WITH_BUNDLE_ENTRY_FULL_URL;

	/**
	 * The feature id for the '<em><b>Parser Error Handler</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__PARSER_ERROR_HANDLER = FHIR_DATAFORMAT__PARSER_ERROR_HANDLER;

	/**
	 * The feature id for the '<em><b>Parser Options</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__PARSER_OPTIONS = FHIR_DATAFORMAT__PARSER_OPTIONS;

	/**
	 * The feature id for the '<em><b>Prefer Types</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__PREFER_TYPES = FHIR_DATAFORMAT__PREFER_TYPES;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__PRETTY_PRINT = FHIR_DATAFORMAT__PRETTY_PRINT;

	/**
	 * The feature id for the '<em><b>Server Base Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__SERVER_BASE_URL = FHIR_DATAFORMAT__SERVER_BASE_URL;

	/**
	 * The feature id for the '<em><b>Strip Versions From References</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__STRIP_VERSIONS_FROM_REFERENCES = FHIR_DATAFORMAT__STRIP_VERSIONS_FROM_REFERENCES;

	/**
	 * The feature id for the '<em><b>Summary Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__SUMMARY_MODE = FHIR_DATAFORMAT__SUMMARY_MODE;

	/**
	 * The feature id for the '<em><b>Suppress Narratives</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT__SUPPRESS_NARRATIVES = FHIR_DATAFORMAT__SUPPRESS_NARRATIVES;

	/**
	 * The number of structural features of the '<em>Fhir Xml Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT_FEATURE_COUNT = FHIR_DATAFORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Fhir Xml Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FHIR_XML_DATA_FORMAT_OPERATION_COUNT = FHIR_DATAFORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FilterDefinitionImpl <em>Filter Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FilterDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFilterDefinition()
	 * @generated
	 */
	int FILTER_DEFINITION = 106;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__EXPRESSION_DEFINITION = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CSIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CONSTANT = PROCESSOR_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DATASONNET = PROCESSOR_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__EXCHANGE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__GROOVY = PROCESSOR_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__HL7TERSER = PROCESSOR_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__JAVA = PROCESSOR_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__JS = PROCESSOR_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__JOOR = PROCESSOR_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__JQ = PROCESSOR_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__JSONPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__LANGUAGE = PROCESSOR_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__METHOD = PROCESSOR_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__MVEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__OGNL = PROCESSOR_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__PYTHON = PROCESSOR_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__REF = PROCESSOR_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SPEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__TOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__WASM = PROCESSOR_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__XTOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__XPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__XQUERY = PROCESSOR_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__GROUP = PROCESSOR_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__AGGREGATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__BEAN = PROCESSOR_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DO_CATCH = PROCESSOR_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CHOICE = PROCESSOR_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CIRCUIT_BREAKER = PROCESSOR_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CLAIM_CHECK = PROCESSOR_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CONVERT_BODY_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CONVERT_HEADER_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__CONVERT_VARIABLE_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DELAY = PROCESSOR_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DYNAMIC_ROUTER = PROCESSOR_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ENRICH = PROCESSOR_DEFINITION_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__FILTER = PROCESSOR_DEFINITION_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DO_FINALLY = PROCESSOR_DEFINITION_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__IDEMPOTENT_CONSUMER = PROCESSOR_DEFINITION_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__INTERCEPT = PROCESSOR_DEFINITION_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__INTERCEPT_FROM = PROCESSOR_DEFINITION_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = PROCESSOR_DEFINITION_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__KAMELET = PROCESSOR_DEFINITION_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__LOAD_BALANCE = PROCESSOR_DEFINITION_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__LOG = PROCESSOR_DEFINITION_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__LOOP = PROCESSOR_DEFINITION_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__MARSHAL = PROCESSOR_DEFINITION_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__MULTICAST = PROCESSOR_DEFINITION_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ON_COMPLETION = PROCESSOR_DEFINITION_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ON_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__PAUSABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__PIPELINE = PROCESSOR_DEFINITION_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__POLICY = PROCESSOR_DEFINITION_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__POLL = PROCESSOR_DEFINITION_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__POLL_ENRICH = PROCESSOR_DEFINITION_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__PROCESS = PROCESSOR_DEFINITION_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__RECIPIENT_LIST = PROCESSOR_DEFINITION_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__REMOVE_HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__REMOVE_HEADERS = PROCESSOR_DEFINITION_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__REMOVE_PROPERTIES = PROCESSOR_DEFINITION_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__REMOVE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__REMOVE_VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__RESEQUENCE = PROCESSOR_DEFINITION_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__RESUMABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ROLLBACK = PROCESSOR_DEFINITION_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ROUTE = PROCESSOR_DEFINITION_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__ROUTING_SLIP = PROCESSOR_DEFINITION_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SAGA = PROCESSOR_DEFINITION_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SAMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SCRIPT = PROCESSOR_DEFINITION_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_BODY = PROCESSOR_DEFINITION_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_EXCHANGE_PATTERN = PROCESSOR_DEFINITION_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_HEADERS = PROCESSOR_DEFINITION_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SET_VARIABLES = PROCESSOR_DEFINITION_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SORT = PROCESSOR_DEFINITION_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SPLIT = PROCESSOR_DEFINITION_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__STEP = PROCESSOR_DEFINITION_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__STOP = PROCESSOR_DEFINITION_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__THREADS = PROCESSOR_DEFINITION_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__THROTTLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__THROW_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__TO_D = PROCESSOR_DEFINITION_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__TOKENIZER = PROCESSOR_DEFINITION_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__TRANSACTED = PROCESSOR_DEFINITION_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__TRANSFORM = PROCESSOR_DEFINITION_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__DO_TRY = PROCESSOR_DEFINITION_FEATURE_COUNT + 93;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__UNMARSHAL = PROCESSOR_DEFINITION_FEATURE_COUNT + 94;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__VALIDATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 95;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__WIRE_TAP = PROCESSOR_DEFINITION_FEATURE_COUNT + 96;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__SERVICE_CALL = PROCESSOR_DEFINITION_FEATURE_COUNT + 97;

	/**
	 * The feature id for the '<em><b>Status Property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION__STATUS_PROPERTY_NAME = PROCESSOR_DEFINITION_FEATURE_COUNT + 98;

	/**
	 * The number of structural features of the '<em>Filter Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 99;

	/**
	 * The number of operations of the '<em>Filter Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FilterParametersImpl <em>Filter Parameters</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FilterParametersImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFilterParameters()
	 * @generated
	 */
	int FILTER_PARAMETERS = 107;

	/**
	 * The feature id for the '<em><b>Include</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PARAMETERS__INCLUDE = 0;

	/**
	 * The feature id for the '<em><b>Exclude</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PARAMETERS__EXCLUDE = 1;

	/**
	 * The number of structural features of the '<em>Filter Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PARAMETERS_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Filter Parameters</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_PARAMETERS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FinallyDefinitionImpl <em>Finally Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FinallyDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFinallyDefinition()
	 * @generated
	 */
	int FINALLY_DEFINITION = 108;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The number of structural features of the '<em>Finally Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The number of operations of the '<em>Finally Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FINALLY_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FlatpackDataFormatImpl <em>Flatpack Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FlatpackDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFlatpackDataFormat()
	 * @generated
	 */
	int FLATPACK_DATA_FORMAT = 109;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Short Lines</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__ALLOW_SHORT_LINES = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__DEFINITION = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Delimiter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__DELIMITER = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Fixed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__FIXED = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Ignore Extra Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__IGNORE_EXTRA_COLUMNS = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Ignore First Record</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__IGNORE_FIRST_RECORD = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Parser Factory Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__PARSER_FACTORY_REF = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Text Qualifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT__TEXT_QUALIFIER = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Flatpack Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Flatpack Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLATPACK_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ForyDataFormatImpl <em>Fory Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ForyDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getForyDataFormat()
	 * @generated
	 */
	int FORY_DATA_FORMAT = 110;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Auto Wired Fory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT__ALLOW_AUTO_WIRED_FORY = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Require Class Registration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT__REQUIRE_CLASS_REGISTRATION = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Thread Safe</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT__THREAD_SAFE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Fory Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Fory Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORY_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.FromDefinitionImpl <em>From Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.FromDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getFromDefinition()
	 * @generated
	 */
	int FROM_DEFINITION = 111;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION__URI = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Variable Receive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION__VARIABLE_RECEIVE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>From Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>From Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.GetDefinitionImpl <em>Get Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.GetDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getGetDefinition()
	 * @generated
	 */
	int GET_DEFINITION = 112;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__CUSTOM_ID = VERB_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__DESCRIPTION = VERB_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__ID = VERB_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Param</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__PARAM = VERB_DEFINITION__PARAM;

	/**
	 * The feature id for the '<em><b>Response Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__RESPONSE_MESSAGE = VERB_DEFINITION__RESPONSE_MESSAGE;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__SECURITY = VERB_DEFINITION__SECURITY;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__TO = VERB_DEFINITION__TO;

	/**
	 * The feature id for the '<em><b>Api Docs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__API_DOCS = VERB_DEFINITION__API_DOCS;

	/**
	 * The feature id for the '<em><b>Binding Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__BINDING_MODE = VERB_DEFINITION__BINDING_MODE;

	/**
	 * The feature id for the '<em><b>Client Request Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__CLIENT_REQUEST_VALIDATION = VERB_DEFINITION__CLIENT_REQUEST_VALIDATION;

	/**
	 * The feature id for the '<em><b>Client Response Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__CLIENT_RESPONSE_VALIDATION = VERB_DEFINITION__CLIENT_RESPONSE_VALIDATION;

	/**
	 * The feature id for the '<em><b>Consumes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__CONSUMES = VERB_DEFINITION__CONSUMES;

	/**
	 * The feature id for the '<em><b>Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__DEPRECATED = VERB_DEFINITION__DEPRECATED;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__DISABLED = VERB_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Enable CORS</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__ENABLE_CORS = VERB_DEFINITION__ENABLE_CORS;

	/**
	 * The feature id for the '<em><b>Enable No Content Response</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__ENABLE_NO_CONTENT_RESPONSE = VERB_DEFINITION__ENABLE_NO_CONTENT_RESPONSE;

	/**
	 * The feature id for the '<em><b>Out Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__OUT_TYPE = VERB_DEFINITION__OUT_TYPE;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__PATH = VERB_DEFINITION__PATH;

	/**
	 * The feature id for the '<em><b>Produces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__PRODUCES = VERB_DEFINITION__PRODUCES;

	/**
	 * The feature id for the '<em><b>Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__ROUTE_ID = VERB_DEFINITION__ROUTE_ID;

	/**
	 * The feature id for the '<em><b>Skip Binding On Error Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__SKIP_BINDING_ON_ERROR_CODE = VERB_DEFINITION__SKIP_BINDING_ON_ERROR_CODE;

	/**
	 * The feature id for the '<em><b>Stream Cache</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__STREAM_CACHE = VERB_DEFINITION__STREAM_CACHE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION__TYPE = VERB_DEFINITION__TYPE;

	/**
	 * The number of structural features of the '<em>Get Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION_FEATURE_COUNT = VERB_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Get Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GET_DEFINITION_OPERATION_COUNT = VERB_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.GlobalOptionDefinitionImpl <em>Global Option Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.GlobalOptionDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getGlobalOptionDefinition()
	 * @generated
	 */
	int GLOBAL_OPTION_DEFINITION = 113;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTION_DEFINITION__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTION_DEFINITION__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Global Option Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTION_DEFINITION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Global Option Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTION_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.GlobalOptionsDefinitionImpl <em>Global Options Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.GlobalOptionsDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getGlobalOptionsDefinition()
	 * @generated
	 */
	int GLOBAL_OPTIONS_DEFINITION = 114;

	/**
	 * The feature id for the '<em><b>Global Option</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTIONS_DEFINITION__GLOBAL_OPTION = 0;

	/**
	 * The number of structural features of the '<em>Global Options Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTIONS_DEFINITION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Global Options Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GLOBAL_OPTIONS_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.GrokDataFormatImpl <em>Grok Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.GrokDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getGrokDataFormat()
	 * @generated
	 */
	int GROK_DATA_FORMAT = 115;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Multiple Matches Per Line</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT__ALLOW_MULTIPLE_MATCHES_PER_LINE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Flattened</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT__FLATTENED = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Named Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT__NAMED_ONLY = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT__PATTERN = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Grok Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Grok Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROK_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.GroovyExpressionImpl <em>Groovy Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.GroovyExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getGroovyExpression()
	 * @generated
	 */
	int GROOVY_EXPRESSION = 116;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROOVY_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROOVY_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROOVY_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROOVY_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The number of structural features of the '<em>Groovy Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROOVY_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Groovy Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GROOVY_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.GzipDeflaterDataFormatImpl <em>Gzip Deflater Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.GzipDeflaterDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getGzipDeflaterDataFormat()
	 * @generated
	 */
	int GZIP_DEFLATER_DATA_FORMAT = 117;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GZIP_DEFLATER_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The number of structural features of the '<em>Gzip Deflater Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GZIP_DEFLATER_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Gzip Deflater Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GZIP_DEFLATER_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.HeadDefinitionImpl <em>Head Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.HeadDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getHeadDefinition()
	 * @generated
	 */
	int HEAD_DEFINITION = 118;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__CUSTOM_ID = VERB_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__DESCRIPTION = VERB_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__ID = VERB_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Param</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__PARAM = VERB_DEFINITION__PARAM;

	/**
	 * The feature id for the '<em><b>Response Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__RESPONSE_MESSAGE = VERB_DEFINITION__RESPONSE_MESSAGE;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__SECURITY = VERB_DEFINITION__SECURITY;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__TO = VERB_DEFINITION__TO;

	/**
	 * The feature id for the '<em><b>Api Docs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__API_DOCS = VERB_DEFINITION__API_DOCS;

	/**
	 * The feature id for the '<em><b>Binding Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__BINDING_MODE = VERB_DEFINITION__BINDING_MODE;

	/**
	 * The feature id for the '<em><b>Client Request Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__CLIENT_REQUEST_VALIDATION = VERB_DEFINITION__CLIENT_REQUEST_VALIDATION;

	/**
	 * The feature id for the '<em><b>Client Response Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__CLIENT_RESPONSE_VALIDATION = VERB_DEFINITION__CLIENT_RESPONSE_VALIDATION;

	/**
	 * The feature id for the '<em><b>Consumes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__CONSUMES = VERB_DEFINITION__CONSUMES;

	/**
	 * The feature id for the '<em><b>Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__DEPRECATED = VERB_DEFINITION__DEPRECATED;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__DISABLED = VERB_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Enable CORS</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__ENABLE_CORS = VERB_DEFINITION__ENABLE_CORS;

	/**
	 * The feature id for the '<em><b>Enable No Content Response</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__ENABLE_NO_CONTENT_RESPONSE = VERB_DEFINITION__ENABLE_NO_CONTENT_RESPONSE;

	/**
	 * The feature id for the '<em><b>Out Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__OUT_TYPE = VERB_DEFINITION__OUT_TYPE;

	/**
	 * The feature id for the '<em><b>Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__PATH = VERB_DEFINITION__PATH;

	/**
	 * The feature id for the '<em><b>Produces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__PRODUCES = VERB_DEFINITION__PRODUCES;

	/**
	 * The feature id for the '<em><b>Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__ROUTE_ID = VERB_DEFINITION__ROUTE_ID;

	/**
	 * The feature id for the '<em><b>Skip Binding On Error Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__SKIP_BINDING_ON_ERROR_CODE = VERB_DEFINITION__SKIP_BINDING_ON_ERROR_CODE;

	/**
	 * The feature id for the '<em><b>Stream Cache</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__STREAM_CACHE = VERB_DEFINITION__STREAM_CACHE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION__TYPE = VERB_DEFINITION__TYPE;

	/**
	 * The number of structural features of the '<em>Head Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION_FEATURE_COUNT = VERB_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Head Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEAD_DEFINITION_OPERATION_COUNT = VERB_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.HeaderExpressionImpl <em>Header Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.HeaderExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getHeaderExpression()
	 * @generated
	 */
	int HEADER_EXPRESSION = 119;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEADER_EXPRESSION__VALUE = EXPRESSION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEADER_EXPRESSION__ID = EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEADER_EXPRESSION__TRIM = EXPRESSION__TRIM;

	/**
	 * The number of structural features of the '<em>Header Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEADER_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Header Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEADER_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.HealthyServiceCallServiceFilterConfigurationImpl <em>Healthy Service Call Service Filter Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.HealthyServiceCallServiceFilterConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getHealthyServiceCallServiceFilterConfiguration()
	 * @generated
	 */
	int HEALTHY_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION = 120;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEALTHY_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEALTHY_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES;

	/**
	 * The number of structural features of the '<em>Healthy Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEALTHY_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Healthy Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEALTHY_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.Hl7DataFormatImpl <em>Hl7 Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.Hl7DataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getHl7DataFormat()
	 * @generated
	 */
	int HL7_DATA_FORMAT = 121;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_DATA_FORMAT__VALIDATE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hl7 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Hl7 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.Hl7TerserExpressionImpl <em>Hl7 Terser Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.Hl7TerserExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getHl7TerserExpression()
	 * @generated
	 */
	int HL7_TERSER_EXPRESSION = 122;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION__VALUE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION__ID = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION__TRIM = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION__RESULT_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION__SOURCE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__SOURCE;

	/**
	 * The number of structural features of the '<em>Hl7 Terser Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION_FEATURE_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Hl7 Terser Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HL7_TERSER_EXPRESSION_OPERATION_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.IcalDataFormatImpl <em>Ical Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.IcalDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getIcalDataFormat()
	 * @generated
	 */
	int ICAL_DATA_FORMAT = 123;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICAL_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Validating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICAL_DATA_FORMAT__VALIDATING = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ical Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICAL_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Ical Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ICAL_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.IdempotentConsumerDefinitionImpl <em>Idempotent Consumer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.IdempotentConsumerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getIdempotentConsumerDefinition()
	 * @generated
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION = 124;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__EXPRESSION_DEFINITION = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CSIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CONSTANT = PROCESSOR_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DATASONNET = PROCESSOR_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__EXCHANGE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__GROOVY = PROCESSOR_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__HL7TERSER = PROCESSOR_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__JAVA = PROCESSOR_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__JS = PROCESSOR_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__JOOR = PROCESSOR_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__JQ = PROCESSOR_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__JSONPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__LANGUAGE = PROCESSOR_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__METHOD = PROCESSOR_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__MVEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__OGNL = PROCESSOR_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__PYTHON = PROCESSOR_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REF = PROCESSOR_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SPEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__TOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__WASM = PROCESSOR_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__XTOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__XPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__XQUERY = PROCESSOR_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__GROUP = PROCESSOR_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__AGGREGATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__BEAN = PROCESSOR_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DO_CATCH = PROCESSOR_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CHOICE = PROCESSOR_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CIRCUIT_BREAKER = PROCESSOR_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CLAIM_CHECK = PROCESSOR_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CONVERT_BODY_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CONVERT_HEADER_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__CONVERT_VARIABLE_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DELAY = PROCESSOR_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DYNAMIC_ROUTER = PROCESSOR_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ENRICH = PROCESSOR_DEFINITION_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__FILTER = PROCESSOR_DEFINITION_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DO_FINALLY = PROCESSOR_DEFINITION_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__IDEMPOTENT_CONSUMER = PROCESSOR_DEFINITION_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__INTERCEPT = PROCESSOR_DEFINITION_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__INTERCEPT_FROM = PROCESSOR_DEFINITION_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = PROCESSOR_DEFINITION_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__KAMELET = PROCESSOR_DEFINITION_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__LOAD_BALANCE = PROCESSOR_DEFINITION_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__LOG = PROCESSOR_DEFINITION_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__LOOP = PROCESSOR_DEFINITION_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__MARSHAL = PROCESSOR_DEFINITION_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__MULTICAST = PROCESSOR_DEFINITION_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ON_COMPLETION = PROCESSOR_DEFINITION_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ON_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__PAUSABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__PIPELINE = PROCESSOR_DEFINITION_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__POLICY = PROCESSOR_DEFINITION_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__POLL = PROCESSOR_DEFINITION_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__POLL_ENRICH = PROCESSOR_DEFINITION_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__PROCESS = PROCESSOR_DEFINITION_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__RECIPIENT_LIST = PROCESSOR_DEFINITION_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REMOVE_HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REMOVE_HEADERS = PROCESSOR_DEFINITION_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REMOVE_PROPERTIES = PROCESSOR_DEFINITION_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REMOVE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REMOVE_VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__RESEQUENCE = PROCESSOR_DEFINITION_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__RESUMABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ROLLBACK = PROCESSOR_DEFINITION_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ROUTE = PROCESSOR_DEFINITION_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__ROUTING_SLIP = PROCESSOR_DEFINITION_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SAGA = PROCESSOR_DEFINITION_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SAMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SCRIPT = PROCESSOR_DEFINITION_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_BODY = PROCESSOR_DEFINITION_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_EXCHANGE_PATTERN = PROCESSOR_DEFINITION_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_HEADERS = PROCESSOR_DEFINITION_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SET_VARIABLES = PROCESSOR_DEFINITION_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SORT = PROCESSOR_DEFINITION_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SPLIT = PROCESSOR_DEFINITION_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__STEP = PROCESSOR_DEFINITION_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__STOP = PROCESSOR_DEFINITION_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__THREADS = PROCESSOR_DEFINITION_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__THROTTLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__THROW_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__TO_D = PROCESSOR_DEFINITION_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__TOKENIZER = PROCESSOR_DEFINITION_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__TRANSACTED = PROCESSOR_DEFINITION_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__TRANSFORM = PROCESSOR_DEFINITION_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__DO_TRY = PROCESSOR_DEFINITION_FEATURE_COUNT + 93;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__UNMARSHAL = PROCESSOR_DEFINITION_FEATURE_COUNT + 94;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__VALIDATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 95;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__WIRE_TAP = PROCESSOR_DEFINITION_FEATURE_COUNT + 96;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SERVICE_CALL = PROCESSOR_DEFINITION_FEATURE_COUNT + 97;

	/**
	 * The feature id for the '<em><b>Completion Eager</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__COMPLETION_EAGER = PROCESSOR_DEFINITION_FEATURE_COUNT + 98;

	/**
	 * The feature id for the '<em><b>Eager</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__EAGER = PROCESSOR_DEFINITION_FEATURE_COUNT + 99;

	/**
	 * The feature id for the '<em><b>Idempotent Repository</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__IDEMPOTENT_REPOSITORY = PROCESSOR_DEFINITION_FEATURE_COUNT + 100;

	/**
	 * The feature id for the '<em><b>Remove On Failure</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__REMOVE_ON_FAILURE = PROCESSOR_DEFINITION_FEATURE_COUNT + 101;

	/**
	 * The feature id for the '<em><b>Skip Duplicate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION__SKIP_DUPLICATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 102;

	/**
	 * The number of structural features of the '<em>Idempotent Consumer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 103;

	/**
	 * The number of operations of the '<em>Idempotent Consumer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDEMPOTENT_CONSUMER_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.InputTypeDefinitionImpl <em>Input Type Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.InputTypeDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getInputTypeDefinition()
	 * @generated
	 */
	int INPUT_TYPE_DEFINITION = 126;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Urn</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION__URN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION__VALIDATE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Input Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Input Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_TYPE_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.InterceptDefinitionImpl <em>Intercept Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.InterceptDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getInterceptDefinition()
	 * @generated
	 */
	int INTERCEPT_DEFINITION = 127;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ON_WHEN = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Intercept Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The number of operations of the '<em>Intercept Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.InterceptFromDefinitionImpl <em>Intercept From Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.InterceptFromDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getInterceptFromDefinition()
	 * @generated
	 */
	int INTERCEPT_FROM_DEFINITION = 128;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CUSTOM_ID = INTERCEPT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DESCRIPTION = INTERCEPT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ID = INTERCEPT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DISABLED = INTERCEPT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ON_WHEN = INTERCEPT_DEFINITION__ON_WHEN;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__GROUP = INTERCEPT_DEFINITION__GROUP;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__AGGREGATE = INTERCEPT_DEFINITION__AGGREGATE;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__BEAN = INTERCEPT_DEFINITION__BEAN;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DO_CATCH = INTERCEPT_DEFINITION__DO_CATCH;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CHOICE = INTERCEPT_DEFINITION__CHOICE;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CIRCUIT_BREAKER = INTERCEPT_DEFINITION__CIRCUIT_BREAKER;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CLAIM_CHECK = INTERCEPT_DEFINITION__CLAIM_CHECK;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CONVERT_BODY_TO = INTERCEPT_DEFINITION__CONVERT_BODY_TO;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CONVERT_HEADER_TO = INTERCEPT_DEFINITION__CONVERT_HEADER_TO;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__CONVERT_VARIABLE_TO = INTERCEPT_DEFINITION__CONVERT_VARIABLE_TO;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DELAY = INTERCEPT_DEFINITION__DELAY;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DYNAMIC_ROUTER = INTERCEPT_DEFINITION__DYNAMIC_ROUTER;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ENRICH = INTERCEPT_DEFINITION__ENRICH;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__FILTER = INTERCEPT_DEFINITION__FILTER;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DO_FINALLY = INTERCEPT_DEFINITION__DO_FINALLY;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__IDEMPOTENT_CONSUMER = INTERCEPT_DEFINITION__IDEMPOTENT_CONSUMER;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__INTERCEPT = INTERCEPT_DEFINITION__INTERCEPT;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__INTERCEPT_FROM = INTERCEPT_DEFINITION__INTERCEPT_FROM;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = INTERCEPT_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__KAMELET = INTERCEPT_DEFINITION__KAMELET;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__LOAD_BALANCE = INTERCEPT_DEFINITION__LOAD_BALANCE;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__LOG = INTERCEPT_DEFINITION__LOG;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__LOOP = INTERCEPT_DEFINITION__LOOP;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__MARSHAL = INTERCEPT_DEFINITION__MARSHAL;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__MULTICAST = INTERCEPT_DEFINITION__MULTICAST;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ON_COMPLETION = INTERCEPT_DEFINITION__ON_COMPLETION;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ON_EXCEPTION = INTERCEPT_DEFINITION__ON_EXCEPTION;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__PAUSABLE = INTERCEPT_DEFINITION__PAUSABLE;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__PIPELINE = INTERCEPT_DEFINITION__PIPELINE;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__POLICY = INTERCEPT_DEFINITION__POLICY;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__POLL = INTERCEPT_DEFINITION__POLL;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__POLL_ENRICH = INTERCEPT_DEFINITION__POLL_ENRICH;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__PROCESS = INTERCEPT_DEFINITION__PROCESS;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__RECIPIENT_LIST = INTERCEPT_DEFINITION__RECIPIENT_LIST;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__REMOVE_HEADER = INTERCEPT_DEFINITION__REMOVE_HEADER;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__REMOVE_HEADERS = INTERCEPT_DEFINITION__REMOVE_HEADERS;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__REMOVE_PROPERTIES = INTERCEPT_DEFINITION__REMOVE_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__REMOVE_PROPERTY = INTERCEPT_DEFINITION__REMOVE_PROPERTY;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__REMOVE_VARIABLE = INTERCEPT_DEFINITION__REMOVE_VARIABLE;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__RESEQUENCE = INTERCEPT_DEFINITION__RESEQUENCE;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__RESUMABLE = INTERCEPT_DEFINITION__RESUMABLE;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ROLLBACK = INTERCEPT_DEFINITION__ROLLBACK;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ROUTE = INTERCEPT_DEFINITION__ROUTE;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__ROUTING_SLIP = INTERCEPT_DEFINITION__ROUTING_SLIP;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SAGA = INTERCEPT_DEFINITION__SAGA;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SAMPLE = INTERCEPT_DEFINITION__SAMPLE;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SCRIPT = INTERCEPT_DEFINITION__SCRIPT;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_BODY = INTERCEPT_DEFINITION__SET_BODY;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_EXCHANGE_PATTERN = INTERCEPT_DEFINITION__SET_EXCHANGE_PATTERN;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_HEADER = INTERCEPT_DEFINITION__SET_HEADER;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_HEADERS = INTERCEPT_DEFINITION__SET_HEADERS;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_PROPERTY = INTERCEPT_DEFINITION__SET_PROPERTY;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_VARIABLE = INTERCEPT_DEFINITION__SET_VARIABLE;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SET_VARIABLES = INTERCEPT_DEFINITION__SET_VARIABLES;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SORT = INTERCEPT_DEFINITION__SORT;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SPLIT = INTERCEPT_DEFINITION__SPLIT;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__STEP = INTERCEPT_DEFINITION__STEP;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__STOP = INTERCEPT_DEFINITION__STOP;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__THREADS = INTERCEPT_DEFINITION__THREADS;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__THROTTLE = INTERCEPT_DEFINITION__THROTTLE;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__THROW_EXCEPTION = INTERCEPT_DEFINITION__THROW_EXCEPTION;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__TO = INTERCEPT_DEFINITION__TO;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__TO_D = INTERCEPT_DEFINITION__TO_D;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__TOKENIZER = INTERCEPT_DEFINITION__TOKENIZER;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__TRANSACTED = INTERCEPT_DEFINITION__TRANSACTED;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__TRANSFORM = INTERCEPT_DEFINITION__TRANSFORM;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__DO_TRY = INTERCEPT_DEFINITION__DO_TRY;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__UNMARSHAL = INTERCEPT_DEFINITION__UNMARSHAL;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__VALIDATE = INTERCEPT_DEFINITION__VALIDATE;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__WIRE_TAP = INTERCEPT_DEFINITION__WIRE_TAP;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__SERVICE_CALL = INTERCEPT_DEFINITION__SERVICE_CALL;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION__URI = INTERCEPT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Intercept From Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION_FEATURE_COUNT = INTERCEPT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Intercept From Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_FROM_DEFINITION_OPERATION_COUNT = INTERCEPT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.InterceptSendToEndpointDefinitionImpl <em>Intercept Send To Endpoint Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.InterceptSendToEndpointDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getInterceptSendToEndpointDefinition()
	 * @generated
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION = 129;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ON_WHEN = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>After Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__AFTER_URI = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Skip Send To Original Endpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__SKIP_SEND_TO_ORIGINAL_ENDPOINT = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION__URI = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The number of structural features of the '<em>Intercept Send To Endpoint Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The number of operations of the '<em>Intercept Send To Endpoint Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERCEPT_SEND_TO_ENDPOINT_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.Iso8583DataFormatImpl <em>Iso8583 Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.Iso8583DataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getIso8583DataFormat()
	 * @generated
	 */
	int ISO8583_DATA_FORMAT = 130;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISO8583_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Auto Wired Message Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISO8583_DATA_FORMAT__ALLOW_AUTO_WIRED_MESSAGE_FORMAT = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Config File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISO8583_DATA_FORMAT__CONFIG_FILE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Iso Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISO8583_DATA_FORMAT__ISO_TYPE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Iso8583 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISO8583_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Iso8583 Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISO8583_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JacksonXMLDataFormatImpl <em>Jackson XML Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JacksonXMLDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJacksonXMLDataFormat()
	 * @generated
	 */
	int JACKSON_XML_DATA_FORMAT = 131;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Jms Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__ALLOW_JMS_TYPE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Unmarshall Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__ALLOW_UNMARSHALL_TYPE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Collection Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__COLLECTION_TYPE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__CONTENT_TYPE_HEADER = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Disable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__DISABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Enable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__ENABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Enable Jaxb Annotation Module</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__ENABLE_JAXB_ANNOTATION_MODULE = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Include</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__INCLUDE = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Json View</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__JSON_VIEW = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Max String Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__MAX_STRING_LENGTH = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Module Class Names</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__MODULE_CLASS_NAMES = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Module Refs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__MODULE_REFS = DATA_FORMAT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__PRETTY_PRINT = DATA_FORMAT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__TIMEZONE = DATA_FORMAT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Use List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__USE_LIST = DATA_FORMAT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Xml Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT__XML_MAPPER = DATA_FORMAT_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>Jackson XML Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 17;

	/**
	 * The number of operations of the '<em>Jackson XML Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JACKSON_XML_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JavaExpressionImpl <em>Java Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JavaExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJavaExpression()
	 * @generated
	 */
	int JAVA_EXPRESSION = 132;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Pre Compile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION__PRE_COMPILE = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Single Quotes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION__SINGLE_QUOTES = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Java Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Java Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JavaScriptExpressionImpl <em>Java Script Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JavaScriptExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJavaScriptExpression()
	 * @generated
	 */
	int JAVA_SCRIPT_EXPRESSION = 133;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_SCRIPT_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_SCRIPT_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_SCRIPT_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_SCRIPT_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The number of structural features of the '<em>Java Script Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_SCRIPT_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Java Script Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAVA_SCRIPT_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JaxbDataFormatImpl <em>Jaxb Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JaxbDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJaxbDataFormat()
	 * @generated
	 */
	int JAXB_DATA_FORMAT = 134;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Access External Schema Protocols</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__ACCESS_EXTERNAL_SCHEMA_PROTOCOLS = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__CONTENT_TYPE_HEADER = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Context Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__CONTEXT_PATH = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Context Path Is Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__CONTEXT_PATH_IS_CLASS_NAME = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Encoding</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__ENCODING = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Filter Non Xml Chars</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__FILTER_NON_XML_CHARS = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Fragment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__FRAGMENT = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Ignore JAXB Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__IGNORE_JAXB_ELEMENT = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Jaxb Provider Properties</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__JAXB_PROVIDER_PROPERTIES = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Must Be JAXB Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__MUST_BE_JAXB_ELEMENT = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Namespace Prefix Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__NAMESPACE_PREFIX_REF = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>No Namespace Schema Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__NO_NAMESPACE_SCHEMA_LOCATION = DATA_FORMAT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Object Factory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__OBJECT_FACTORY = DATA_FORMAT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Part Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__PART_CLASS = DATA_FORMAT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Part Namespace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__PART_NAMESPACE = DATA_FORMAT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__PRETTY_PRINT = DATA_FORMAT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__SCHEMA = DATA_FORMAT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Schema Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__SCHEMA_LOCATION = DATA_FORMAT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Schema Severity Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__SCHEMA_SEVERITY_LEVEL = DATA_FORMAT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Xml Stream Writer Wrapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT__XML_STREAM_WRITER_WRAPPER = DATA_FORMAT_FEATURE_COUNT + 19;

	/**
	 * The number of structural features of the '<em>Jaxb Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 20;

	/**
	 * The number of operations of the '<em>Jaxb Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JAXB_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JoorExpressionImpl <em>Joor Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JoorExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJoorExpression()
	 * @generated
	 */
	int JOOR_EXPRESSION = 135;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Pre Compile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION__PRE_COMPILE = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Single Quotes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION__SINGLE_QUOTES = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Joor Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Joor Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JOOR_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JqExpressionImpl <em>Jq Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JqExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJqExpression()
	 * @generated
	 */
	int JQ_EXPRESSION = 136;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION__VALUE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION__ID = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION__TRIM = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION__RESULT_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION__SOURCE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__SOURCE;

	/**
	 * The number of structural features of the '<em>Jq Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION_FEATURE_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Jq Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JQ_EXPRESSION_OPERATION_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JsonApiDataFormatImpl <em>Json Api Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JsonApiDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJsonApiDataFormat()
	 * @generated
	 */
	int JSON_API_DATA_FORMAT = 137;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_API_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Data Format Types</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_API_DATA_FORMAT__DATA_FORMAT_TYPES = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Main Format Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_API_DATA_FORMAT__MAIN_FORMAT_TYPE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Json Api Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_API_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Json Api Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_API_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JsonDataFormatImpl <em>Json Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JsonDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJsonDataFormat()
	 * @generated
	 */
	int JSON_DATA_FORMAT = 138;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Allow Jms Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__ALLOW_JMS_TYPE = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Unmarshall Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__ALLOW_UNMARSHALL_TYPE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Auto Discover Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__AUTO_DISCOVER_OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Auto Discover Schema Resolver</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__AUTO_DISCOVER_SCHEMA_RESOLVER = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Collection Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__COLLECTION_TYPE = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Combine Unicode Surrogates</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__COMBINE_UNICODE_SURROGATES = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Content Type Header</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__CONTENT_TYPE_HEADER = DATA_FORMAT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Date Format Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__DATE_FORMAT_PATTERN = DATA_FORMAT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Disable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__DISABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Enable Features</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__ENABLE_FEATURES = DATA_FORMAT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Include</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__INCLUDE = DATA_FORMAT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Json View</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__JSON_VIEW = DATA_FORMAT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Library</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__LIBRARY = DATA_FORMAT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Max String Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__MAX_STRING_LENGTH = DATA_FORMAT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Module Class Names</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__MODULE_CLASS_NAMES = DATA_FORMAT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Module Refs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__MODULE_REFS = DATA_FORMAT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Naming Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__NAMING_STRATEGY = DATA_FORMAT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Pretty Print</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__PRETTY_PRINT = DATA_FORMAT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Schema Resolver</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__SCHEMA_RESOLVER = DATA_FORMAT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__TIMEZONE = DATA_FORMAT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Use Default Object Mapper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__USE_DEFAULT_OBJECT_MAPPER = DATA_FORMAT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Use List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT__USE_LIST = DATA_FORMAT_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>Json Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 24;

	/**
	 * The number of operations of the '<em>Json Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JsonPathExpressionImpl <em>Json Path Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JsonPathExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJsonPathExpression()
	 * @generated
	 */
	int JSON_PATH_EXPRESSION = 139;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__VALUE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__ID = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__TRIM = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__RESULT_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__SOURCE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Allow Easy Predicate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__ALLOW_EASY_PREDICATE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Allow Simple</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__ALLOW_SIMPLE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Option</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__OPTION = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Suppress Exceptions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__SUPPRESS_EXCEPTIONS = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Unpack Array</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__UNPACK_ARRAY = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Write As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION__WRITE_AS_STRING = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Json Path Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION_FEATURE_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Json Path Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JSON_PATH_EXPRESSION_OPERATION_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.TransactionErrorHandlerDefinitionImpl <em>Transaction Error Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.TransactionErrorHandlerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getTransactionErrorHandlerDefinition()
	 * @generated
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION = 305;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__ID = DEFAULT_ERROR_HANDLER_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Redelivery Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY = DEFAULT_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY;

	/**
	 * The feature id for the '<em><b>Executor Service Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__EXECUTOR_SERVICE_REF = DEFAULT_ERROR_HANDLER_DEFINITION__EXECUTOR_SERVICE_REF;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__LEVEL = DEFAULT_ERROR_HANDLER_DEFINITION__LEVEL;

	/**
	 * The feature id for the '<em><b>Logger Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__LOGGER_REF = DEFAULT_ERROR_HANDLER_DEFINITION__LOGGER_REF;

	/**
	 * The feature id for the '<em><b>Log Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__LOG_NAME = DEFAULT_ERROR_HANDLER_DEFINITION__LOG_NAME;

	/**
	 * The feature id for the '<em><b>On Exception Occurred Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__ON_EXCEPTION_OCCURRED_REF = DEFAULT_ERROR_HANDLER_DEFINITION__ON_EXCEPTION_OCCURRED_REF;

	/**
	 * The feature id for the '<em><b>On Prepare Failure Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__ON_PREPARE_FAILURE_REF = DEFAULT_ERROR_HANDLER_DEFINITION__ON_PREPARE_FAILURE_REF;

	/**
	 * The feature id for the '<em><b>On Redelivery Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__ON_REDELIVERY_REF = DEFAULT_ERROR_HANDLER_DEFINITION__ON_REDELIVERY_REF;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY_REF = DEFAULT_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY_REF;

	/**
	 * The feature id for the '<em><b>Retry While Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__RETRY_WHILE_REF = DEFAULT_ERROR_HANDLER_DEFINITION__RETRY_WHILE_REF;

	/**
	 * The feature id for the '<em><b>Use Original Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_BODY = DEFAULT_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_BODY;

	/**
	 * The feature id for the '<em><b>Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_MESSAGE = DEFAULT_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_MESSAGE;

	/**
	 * The feature id for the '<em><b>Rollback Logging Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__ROLLBACK_LOGGING_LEVEL = DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Transacted Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION__TRANSACTED_POLICY_REF = DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Transaction Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION_FEATURE_COUNT = DEFAULT_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Transaction Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ERROR_HANDLER_DEFINITION_OPERATION_COUNT = DEFAULT_ERROR_HANDLER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.JtaTransactionErrorHandlerDefinitionImpl <em>Jta Transaction Error Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.JtaTransactionErrorHandlerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getJtaTransactionErrorHandlerDefinition()
	 * @generated
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION = 140;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__ID = TRANSACTION_ERROR_HANDLER_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Redelivery Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY = TRANSACTION_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY;

	/**
	 * The feature id for the '<em><b>Executor Service Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__EXECUTOR_SERVICE_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__EXECUTOR_SERVICE_REF;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__LEVEL = TRANSACTION_ERROR_HANDLER_DEFINITION__LEVEL;

	/**
	 * The feature id for the '<em><b>Logger Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__LOGGER_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__LOGGER_REF;

	/**
	 * The feature id for the '<em><b>Log Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__LOG_NAME = TRANSACTION_ERROR_HANDLER_DEFINITION__LOG_NAME;

	/**
	 * The feature id for the '<em><b>On Exception Occurred Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__ON_EXCEPTION_OCCURRED_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__ON_EXCEPTION_OCCURRED_REF;

	/**
	 * The feature id for the '<em><b>On Prepare Failure Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__ON_PREPARE_FAILURE_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__ON_PREPARE_FAILURE_REF;

	/**
	 * The feature id for the '<em><b>On Redelivery Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__ON_REDELIVERY_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__ON_REDELIVERY_REF;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__REDELIVERY_POLICY_REF;

	/**
	 * The feature id for the '<em><b>Retry While Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__RETRY_WHILE_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__RETRY_WHILE_REF;

	/**
	 * The feature id for the '<em><b>Use Original Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_BODY = TRANSACTION_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_BODY;

	/**
	 * The feature id for the '<em><b>Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_MESSAGE = TRANSACTION_ERROR_HANDLER_DEFINITION__USE_ORIGINAL_MESSAGE;

	/**
	 * The feature id for the '<em><b>Rollback Logging Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__ROLLBACK_LOGGING_LEVEL = TRANSACTION_ERROR_HANDLER_DEFINITION__ROLLBACK_LOGGING_LEVEL;

	/**
	 * The feature id for the '<em><b>Transacted Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION__TRANSACTED_POLICY_REF = TRANSACTION_ERROR_HANDLER_DEFINITION__TRANSACTED_POLICY_REF;

	/**
	 * The number of structural features of the '<em>Jta Transaction Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION_FEATURE_COUNT = TRANSACTION_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Jta Transaction Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JTA_TRANSACTION_ERROR_HANDLER_DEFINITION_OPERATION_COUNT = TRANSACTION_ERROR_HANDLER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.KameletDefinitionImpl <em>Kamelet Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.KameletDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getKameletDefinition()
	 * @generated
	 */
	int KAMELET_DEFINITION = 141;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION__NAME = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Kamelet Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The number of operations of the '<em>Kamelet Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KAMELET_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.KeyManagersParametersFactoryBeanImpl <em>Key Managers Parameters Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.KeyManagersParametersFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getKeyManagersParametersFactoryBean()
	 * @generated
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN = 142;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__ID = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Algorithm</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__ALGORITHM = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__ALGORITHM;

	/**
	 * The feature id for the '<em><b>Key Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__KEY_PASSWORD = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__KEY_PASSWORD;

	/**
	 * The feature id for the '<em><b>Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__PROVIDER = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__PROVIDER;

	/**
	 * The feature id for the '<em><b>Key Store</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN__KEY_STORE = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Key Managers Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Key Managers Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_KEY_MANAGERS_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.KeyStoreParametersFactoryBeanImpl <em>Key Store Parameters Factory Bean</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.KeyStoreParametersFactoryBeanImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getKeyStoreParametersFactoryBean()
	 * @generated
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN = 143;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__ID = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__ID;

	/**
	 * The feature id for the '<em><b>Camel Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__CAMEL_CONTEXT_ID;

	/**
	 * The feature id for the '<em><b>Key Store</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__KEY_STORE = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__KEY_STORE;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__PASSWORD = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__PASSWORD;

	/**
	 * The feature id for the '<em><b>Provider</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__PROVIDER = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__PROVIDER;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__RESOURCE = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__RESOURCE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN__TYPE = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN__TYPE;

	/**
	 * The number of structural features of the '<em>Key Store Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Key Store Parameters Factory Bean</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KEY_STORE_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT = ABSTRACT_KEY_STORE_PARAMETERS_FACTORY_BEAN_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.KubernetesServiceCallServiceDiscoveryConfigurationImpl <em>Kubernetes Service Call Service Discovery Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.KubernetesServiceCallServiceDiscoveryConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getKubernetesServiceCallServiceDiscoveryConfiguration()
	 * @generated
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION = 144;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Api Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__API_VERSION = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ca Cert Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CA_CERT_DATA = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ca Cert File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CA_CERT_FILE = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Client Cert Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CLIENT_CERT_DATA = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Client Cert File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CLIENT_CERT_FILE = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Client Key Algo</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CLIENT_KEY_ALGO = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Client Key Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CLIENT_KEY_DATA = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Client Key File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CLIENT_KEY_FILE = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Client Key Passphrase</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__CLIENT_KEY_PASSPHRASE = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Dns Domain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__DNS_DOMAIN = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Lookup</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__LOOKUP = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Master Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__MASTER_URL = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__NAMESPACE = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Oauth Token</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__OAUTH_TOKEN = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PASSWORD = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Port Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PORT_NAME = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Port Protocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__PORT_PROTOCOL = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Trust Certs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__TRUST_CERTS = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Username</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION__USERNAME = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>Kubernetes Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_FEATURE_COUNT + 19;

	/**
	 * The number of operations of the '<em>Kubernetes Service Call Service Discovery Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KUBERNETES_SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_DISCOVERY_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.TokenizerImplementationImpl <em>Tokenizer Implementation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.TokenizerImplementationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getTokenizerImplementation()
	 * @generated
	 */
	int TOKENIZER_IMPLEMENTATION = 302;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOKENIZER_IMPLEMENTATION__ID = IDENTIFIED_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Tokenizer Implementation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOKENIZER_IMPLEMENTATION_FEATURE_COUNT = IDENTIFIED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Tokenizer Implementation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOKENIZER_IMPLEMENTATION_OPERATION_COUNT = IDENTIFIED_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LangChain4jTokenizerImplementationImpl <em>Lang Chain4j Tokenizer Implementation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LangChain4jTokenizerImplementationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLangChain4jTokenizerImplementation()
	 * @generated
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION = 149;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__ID = TOKENIZER_IMPLEMENTATION__ID;

	/**
	 * The feature id for the '<em><b>Max Overlap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_OVERLAP = TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_TOKENS = TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MODEL_NAME = TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Tokenizer Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__TOKENIZER_TYPE = TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Lang Chain4j Tokenizer Implementation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_FEATURE_COUNT = TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Lang Chain4j Tokenizer Implementation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_OPERATION_COUNT = TOKENIZER_IMPLEMENTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LangChain4JCharacterTokenizerDefinitionImpl <em>Lang Chain4 JCharacter Tokenizer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LangChain4JCharacterTokenizerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLangChain4JCharacterTokenizerDefinition()
	 * @generated
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION = 145;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION__ID = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__ID;

	/**
	 * The feature id for the '<em><b>Max Overlap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION__MAX_OVERLAP = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_OVERLAP;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION__MAX_TOKENS = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_TOKENS;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION__MODEL_NAME = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Tokenizer Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION__TOKENIZER_TYPE = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__TOKENIZER_TYPE;

	/**
	 * The number of structural features of the '<em>Lang Chain4 JCharacter Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION_FEATURE_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Lang Chain4 JCharacter Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JCHARACTER_TOKENIZER_DEFINITION_OPERATION_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LangChain4JLineTokenizerDefinitionImpl <em>Lang Chain4 JLine Tokenizer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LangChain4JLineTokenizerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLangChain4JLineTokenizerDefinition()
	 * @generated
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION = 146;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION__ID = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__ID;

	/**
	 * The feature id for the '<em><b>Max Overlap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION__MAX_OVERLAP = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_OVERLAP;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION__MAX_TOKENS = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_TOKENS;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION__MODEL_NAME = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Tokenizer Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION__TOKENIZER_TYPE = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__TOKENIZER_TYPE;

	/**
	 * The number of structural features of the '<em>Lang Chain4 JLine Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION_FEATURE_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Lang Chain4 JLine Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JLINE_TOKENIZER_DEFINITION_OPERATION_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LangChain4JParagraphTokenizerDefinitionImpl <em>Lang Chain4 JParagraph Tokenizer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LangChain4JParagraphTokenizerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLangChain4JParagraphTokenizerDefinition()
	 * @generated
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION = 147;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION__ID = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__ID;

	/**
	 * The feature id for the '<em><b>Max Overlap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION__MAX_OVERLAP = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_OVERLAP;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION__MAX_TOKENS = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_TOKENS;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION__MODEL_NAME = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Tokenizer Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION__TOKENIZER_TYPE = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__TOKENIZER_TYPE;

	/**
	 * The number of structural features of the '<em>Lang Chain4 JParagraph Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION_FEATURE_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Lang Chain4 JParagraph Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JPARAGRAPH_TOKENIZER_DEFINITION_OPERATION_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LangChain4JSentenceTokenizerDefinitionImpl <em>Lang Chain4 JSentence Tokenizer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LangChain4JSentenceTokenizerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLangChain4JSentenceTokenizerDefinition()
	 * @generated
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION = 148;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION__ID = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__ID;

	/**
	 * The feature id for the '<em><b>Max Overlap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION__MAX_OVERLAP = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_OVERLAP;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION__MAX_TOKENS = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_TOKENS;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION__MODEL_NAME = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Tokenizer Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION__TOKENIZER_TYPE = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__TOKENIZER_TYPE;

	/**
	 * The number of structural features of the '<em>Lang Chain4 JSentence Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION_FEATURE_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Lang Chain4 JSentence Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JSENTENCE_TOKENIZER_DEFINITION_OPERATION_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LangChain4JWordTokenizerDefinitionImpl <em>Lang Chain4 JWord Tokenizer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LangChain4JWordTokenizerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLangChain4JWordTokenizerDefinition()
	 * @generated
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION = 150;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION__ID = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__ID;

	/**
	 * The feature id for the '<em><b>Max Overlap</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION__MAX_OVERLAP = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_OVERLAP;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION__MAX_TOKENS = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MAX_TOKENS;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION__MODEL_NAME = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__MODEL_NAME;

	/**
	 * The feature id for the '<em><b>Tokenizer Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION__TOKENIZER_TYPE = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION__TOKENIZER_TYPE;

	/**
	 * The number of structural features of the '<em>Lang Chain4 JWord Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION_FEATURE_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Lang Chain4 JWord Tokenizer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANG_CHAIN4_JWORD_TOKENIZER_DEFINITION_OPERATION_COUNT = LANG_CHAIN4J_TOKENIZER_IMPLEMENTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LanguageExpressionImpl <em>Language Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LanguageExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLanguageExpression()
	 * @generated
	 */
	int LANGUAGE_EXPRESSION = 151;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_EXPRESSION__VALUE = EXPRESSION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_EXPRESSION__ID = EXPRESSION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_EXPRESSION__TRIM = EXPRESSION__TRIM;

	/**
	 * The feature id for the '<em><b>Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_EXPRESSION__LANGUAGE = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Language Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Language Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LoadBalanceDefinitionImpl <em>Load Balance Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LoadBalanceDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLoadBalanceDefinition()
	 * @generated
	 */
	int LOAD_BALANCE_DEFINITION = 152;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Custom Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CUSTOM_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Failover Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__FAILOVER_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Random Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__RANDOM_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Round Robin Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ROUND_ROBIN_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Sticky Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__STICKY_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Topic Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__TOPIC_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Weighted Load Balancer</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__WEIGHTED_LOAD_BALANCER = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 77;

	/**
	 * The number of structural features of the '<em>Load Balance Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 78;

	/**
	 * The number of operations of the '<em>Load Balance Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_BALANCE_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LoadTransformerDefinitionImpl <em>Load Transformer Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LoadTransformerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLoadTransformerDefinition()
	 * @generated
	 */
	int LOAD_TRANSFORMER_DEFINITION = 154;

	/**
	 * The feature id for the '<em><b>From Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION__FROM_TYPE = TRANSFORMER__FROM_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION__NAME = TRANSFORMER__NAME;

	/**
	 * The feature id for the '<em><b>Scheme</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION__SCHEME = TRANSFORMER__SCHEME;

	/**
	 * The feature id for the '<em><b>To Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION__TO_TYPE = TRANSFORMER__TO_TYPE;

	/**
	 * The feature id for the '<em><b>Defaults</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION__DEFAULTS = TRANSFORMER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Package Scan</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION__PACKAGE_SCAN = TRANSFORMER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Load Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION_FEATURE_COUNT = TRANSFORMER_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Load Transformer Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOAD_TRANSFORMER_DEFINITION_OPERATION_COUNT = TRANSFORMER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LogDefinitionImpl <em>Log Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LogDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLogDefinition()
	 * @generated
	 */
	int LOG_DEFINITION = 155;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Logger</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__LOGGER = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Logging Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__LOGGING_LEVEL = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Log Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__LOG_LANGUAGE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Log Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__LOG_NAME = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Marker</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__MARKER = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION__MESSAGE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Log Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Log Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LoopDefinitionImpl <em>Loop Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LoopDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLoopDefinition()
	 * @generated
	 */
	int LOOP_DEFINITION = 156;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CUSTOM_ID = PROCESSOR_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DESCRIPTION = PROCESSOR_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ID = PROCESSOR_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DISABLED = PROCESSOR_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__EXPRESSION_DEFINITION = PROCESSOR_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CSIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CONSTANT = PROCESSOR_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DATASONNET = PROCESSOR_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__EXCHANGE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__GROOVY = PROCESSOR_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__HL7TERSER = PROCESSOR_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__JAVA = PROCESSOR_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__JS = PROCESSOR_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__JOOR = PROCESSOR_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__JQ = PROCESSOR_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__JSONPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__LANGUAGE = PROCESSOR_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__METHOD = PROCESSOR_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__MVEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__OGNL = PROCESSOR_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__PYTHON = PROCESSOR_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__REF = PROCESSOR_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SIMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SPEL = PROCESSOR_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__TOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__WASM = PROCESSOR_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__XTOKENIZE = PROCESSOR_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__XPATH = PROCESSOR_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__XQUERY = PROCESSOR_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__GROUP = PROCESSOR_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__AGGREGATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__BEAN = PROCESSOR_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DO_CATCH = PROCESSOR_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CHOICE = PROCESSOR_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CIRCUIT_BREAKER = PROCESSOR_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CLAIM_CHECK = PROCESSOR_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CONVERT_BODY_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CONVERT_HEADER_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__CONVERT_VARIABLE_TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DELAY = PROCESSOR_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DYNAMIC_ROUTER = PROCESSOR_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ENRICH = PROCESSOR_DEFINITION_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__FILTER = PROCESSOR_DEFINITION_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DO_FINALLY = PROCESSOR_DEFINITION_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__IDEMPOTENT_CONSUMER = PROCESSOR_DEFINITION_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__INTERCEPT = PROCESSOR_DEFINITION_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__INTERCEPT_FROM = PROCESSOR_DEFINITION_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = PROCESSOR_DEFINITION_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__KAMELET = PROCESSOR_DEFINITION_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__LOAD_BALANCE = PROCESSOR_DEFINITION_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__LOG = PROCESSOR_DEFINITION_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__LOOP = PROCESSOR_DEFINITION_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__MARSHAL = PROCESSOR_DEFINITION_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__MULTICAST = PROCESSOR_DEFINITION_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ON_COMPLETION = PROCESSOR_DEFINITION_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ON_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__PAUSABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__PIPELINE = PROCESSOR_DEFINITION_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__POLICY = PROCESSOR_DEFINITION_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__POLL = PROCESSOR_DEFINITION_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__POLL_ENRICH = PROCESSOR_DEFINITION_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__PROCESS = PROCESSOR_DEFINITION_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__RECIPIENT_LIST = PROCESSOR_DEFINITION_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__REMOVE_HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__REMOVE_HEADERS = PROCESSOR_DEFINITION_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__REMOVE_PROPERTIES = PROCESSOR_DEFINITION_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__REMOVE_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__REMOVE_VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__RESEQUENCE = PROCESSOR_DEFINITION_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__RESUMABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ROLLBACK = PROCESSOR_DEFINITION_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ROUTE = PROCESSOR_DEFINITION_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ROUTING_SLIP = PROCESSOR_DEFINITION_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SAGA = PROCESSOR_DEFINITION_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SAMPLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SCRIPT = PROCESSOR_DEFINITION_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_BODY = PROCESSOR_DEFINITION_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_EXCHANGE_PATTERN = PROCESSOR_DEFINITION_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_HEADER = PROCESSOR_DEFINITION_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_HEADERS = PROCESSOR_DEFINITION_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_PROPERTY = PROCESSOR_DEFINITION_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_VARIABLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SET_VARIABLES = PROCESSOR_DEFINITION_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SORT = PROCESSOR_DEFINITION_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SPLIT = PROCESSOR_DEFINITION_FEATURE_COUNT + 82;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__STEP = PROCESSOR_DEFINITION_FEATURE_COUNT + 83;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__STOP = PROCESSOR_DEFINITION_FEATURE_COUNT + 84;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__THREADS = PROCESSOR_DEFINITION_FEATURE_COUNT + 85;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__THROTTLE = PROCESSOR_DEFINITION_FEATURE_COUNT + 86;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__THROW_EXCEPTION = PROCESSOR_DEFINITION_FEATURE_COUNT + 87;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__TO = PROCESSOR_DEFINITION_FEATURE_COUNT + 88;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__TO_D = PROCESSOR_DEFINITION_FEATURE_COUNT + 89;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__TOKENIZER = PROCESSOR_DEFINITION_FEATURE_COUNT + 90;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__TRANSACTED = PROCESSOR_DEFINITION_FEATURE_COUNT + 91;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__TRANSFORM = PROCESSOR_DEFINITION_FEATURE_COUNT + 92;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DO_TRY = PROCESSOR_DEFINITION_FEATURE_COUNT + 93;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__UNMARSHAL = PROCESSOR_DEFINITION_FEATURE_COUNT + 94;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__VALIDATE = PROCESSOR_DEFINITION_FEATURE_COUNT + 95;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__WIRE_TAP = PROCESSOR_DEFINITION_FEATURE_COUNT + 96;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__SERVICE_CALL = PROCESSOR_DEFINITION_FEATURE_COUNT + 97;

	/**
	 * The feature id for the '<em><b>Break On Shutdown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__BREAK_ON_SHUTDOWN = PROCESSOR_DEFINITION_FEATURE_COUNT + 98;

	/**
	 * The feature id for the '<em><b>Copy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__COPY = PROCESSOR_DEFINITION_FEATURE_COUNT + 99;

	/**
	 * The feature id for the '<em><b>Do While</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__DO_WHILE = PROCESSOR_DEFINITION_FEATURE_COUNT + 100;

	/**
	 * The feature id for the '<em><b>On Prepare</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION__ON_PREPARE = PROCESSOR_DEFINITION_FEATURE_COUNT + 101;

	/**
	 * The number of structural features of the '<em>Loop Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION_FEATURE_COUNT = PROCESSOR_DEFINITION_FEATURE_COUNT + 102;

	/**
	 * The number of operations of the '<em>Loop Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_DEFINITION_OPERATION_COUNT = PROCESSOR_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.LzfDataFormatImpl <em>Lzf Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.LzfDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getLzfDataFormat()
	 * @generated
	 */
	int LZF_DATA_FORMAT = 157;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LZF_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Using Parallel Compression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LZF_DATA_FORMAT__USING_PARALLEL_COMPRESSION = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Lzf Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LZF_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Lzf Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LZF_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.MarshalDefinitionImpl <em>Marshal Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.MarshalDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getMarshalDefinition()
	 * @generated
	 */
	int MARSHAL_DEFINITION = 158;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__CUSTOM_ID = NO_OUTPUT_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__DESCRIPTION = NO_OUTPUT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__ID = NO_OUTPUT_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__DISABLED = NO_OUTPUT_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Asn1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__ASN1 = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Avro</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__AVRO = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Barcode</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__BARCODE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Base64</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__BASE64 = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Beanio</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__BEANIO = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Bindy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__BINDY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Cbor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__CBOR = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Crypto</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__CRYPTO = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Csv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__CSV = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Custom</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__CUSTOM = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Dfdl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__DFDL = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Fhir Json</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__FHIR_JSON = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Fhir Xml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__FHIR_XML = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Flatpack</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__FLATPACK = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Fory</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__FORY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Grok</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__GROK = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Gzip Deflater</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__GZIP_DEFLATER = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Hl7</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__HL7 = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ical</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__ICAL = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Iso8583</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__ISO8583 = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Jackson Xml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__JACKSON_XML = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Jaxb</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__JAXB = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Json</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__JSON = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Json Api</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__JSON_API = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Lzf</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__LZF = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Mime Multipart</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__MIME_MULTIPART = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Parquet Avro</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__PARQUET_AVRO = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Protobuf</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__PROTOBUF = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Rss</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__RSS = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Smooks</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__SMOOKS = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Soap</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__SOAP = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Swift Mt</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__SWIFT_MT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Swift Mx</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__SWIFT_MX = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Syslog</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__SYSLOG = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Tar File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__TAR_FILE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Thrift</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__THRIFT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Tidy Markup</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__TIDY_MARKUP = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Univocity Csv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__UNIVOCITY_CSV = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Univocity Fixed</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__UNIVOCITY_FIXED = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Univocity Tsv</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__UNIVOCITY_TSV = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Xml Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__XML_SECURITY = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Pgp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__PGP = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Yaml</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__YAML = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Zip Deflater</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__ZIP_DEFLATER = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Zip File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__ZIP_FILE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Variable Receive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__VARIABLE_RECEIVE = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Variable Send</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION__VARIABLE_SEND = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 46;

	/**
	 * The number of structural features of the '<em>Marshal Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION_FEATURE_COUNT = NO_OUTPUT_DEFINITION_FEATURE_COUNT + 47;

	/**
	 * The number of operations of the '<em>Marshal Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MARSHAL_DEFINITION_OPERATION_COUNT = NO_OUTPUT_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.MethodCallExpressionImpl <em>Method Call Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.MethodCallExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getMethodCallExpression()
	 * @generated
	 */
	int METHOD_CALL_EXPRESSION = 159;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Bean Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__BEAN_TYPE = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Method</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__METHOD = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__REF = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__SCOPE = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION__VALIDATE = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Method Call Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Method Call Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METHOD_CALL_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.MimeMultipartDataFormatImpl <em>Mime Multipart Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.MimeMultipartDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getMimeMultipartDataFormat()
	 * @generated
	 */
	int MIME_MULTIPART_DATA_FORMAT = 160;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Binary Content</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT__BINARY_CONTENT = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Headers Inline</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT__HEADERS_INLINE = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Include Headers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT__INCLUDE_HEADERS = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Multipart Sub Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT__MULTIPART_SUB_TYPE = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Multipart Without Attachment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT__MULTIPART_WITHOUT_ATTACHMENT = DATA_FORMAT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Mime Multipart Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Mime Multipart Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIME_MULTIPART_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ModelLifecycleStrategySupportImpl <em>Model Lifecycle Strategy Support</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ModelLifecycleStrategySupportImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getModelLifecycleStrategySupport()
	 * @generated
	 */
	int MODEL_LIFECYCLE_STRATEGY_SUPPORT = 161;

	/**
	 * The number of structural features of the '<em>Model Lifecycle Strategy Support</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_LIFECYCLE_STRATEGY_SUPPORT_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Model Lifecycle Strategy Support</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODEL_LIFECYCLE_STRATEGY_SUPPORT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.MulticastDefinitionImpl <em>Multicast Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.MulticastDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getMulticastDefinition()
	 * @generated
	 */
	int MULTICAST_DEFINITION = 162;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__AGGREGATION_STRATEGY = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Allow Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__AGGREGATION_STRATEGY_METHOD_ALLOW_NULL = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Aggregation Strategy Method Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__AGGREGATION_STRATEGY_METHOD_NAME = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__EXECUTOR_SERVICE = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>On Prepare</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__ON_PREPARE = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Parallel Aggregate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__PARALLEL_AGGREGATE = OUTPUT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Parallel Processing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__PARALLEL_PROCESSING = OUTPUT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>Share Unit Of Work</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SHARE_UNIT_OF_WORK = OUTPUT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Stop On Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__STOP_ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Streaming</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__STREAMING = OUTPUT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Synchronous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__SYNCHRONOUS = OUTPUT_FEATURE_COUNT + 81;

	/**
	 * The feature id for the '<em><b>Timeout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION__TIMEOUT = OUTPUT_FEATURE_COUNT + 82;

	/**
	 * The number of structural features of the '<em>Multicast Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 83;

	/**
	 * The number of operations of the '<em>Multicast Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTICAST_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.MutualTLSDefinitionImpl <em>Mutual TLS Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.MutualTLSDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getMutualTLSDefinition()
	 * @generated
	 */
	int MUTUAL_TLS_DEFINITION = 163;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MUTUAL_TLS_DEFINITION__DESCRIPTION = REST_SECURITY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MUTUAL_TLS_DEFINITION__KEY = REST_SECURITY_DEFINITION__KEY;

	/**
	 * The number of structural features of the '<em>Mutual TLS Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MUTUAL_TLS_DEFINITION_FEATURE_COUNT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mutual TLS Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MUTUAL_TLS_DEFINITION_OPERATION_COUNT = REST_SECURITY_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.MvelExpressionImpl <em>Mvel Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.MvelExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getMvelExpression()
	 * @generated
	 */
	int MVEL_EXPRESSION = 164;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MVEL_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MVEL_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MVEL_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MVEL_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The number of structural features of the '<em>Mvel Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MVEL_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mvel Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MVEL_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.NamespaceAwareExpressionImpl <em>Namespace Aware Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.NamespaceAwareExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getNamespaceAwareExpression()
	 * @generated
	 */
	int NAMESPACE_AWARE_EXPRESSION = 165;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION__VALUE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION__ID = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION__TRIM = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION__RESULT_TYPE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION__SOURCE = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION__SOURCE;

	/**
	 * The number of structural features of the '<em>Namespace Aware Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION_FEATURE_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Namespace Aware Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMESPACE_AWARE_EXPRESSION_OPERATION_COUNT = SINGLE_INPUT_TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.NoErrorHandlerDefinitionImpl <em>No Error Handler Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.NoErrorHandlerDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getNoErrorHandlerDefinition()
	 * @generated
	 */
	int NO_ERROR_HANDLER_DEFINITION = 166;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_ERROR_HANDLER_DEFINITION__ID = BASE_ERROR_HANDLER_DEFINITION__ID;

	/**
	 * The number of structural features of the '<em>No Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_ERROR_HANDLER_DEFINITION_FEATURE_COUNT = BASE_ERROR_HANDLER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>No Error Handler Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NO_ERROR_HANDLER_DEFINITION_OPERATION_COUNT = BASE_ERROR_HANDLER_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OAuth2DefinitionImpl <em>OAuth2 Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OAuth2DefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOAuth2Definition()
	 * @generated
	 */
	int OAUTH2_DEFINITION = 168;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__DESCRIPTION = REST_SECURITY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__KEY = REST_SECURITY_DEFINITION__KEY;

	/**
	 * The feature id for the '<em><b>Scopes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__SCOPES = REST_SECURITY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Authorization Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__AUTHORIZATION_URL = REST_SECURITY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Flow</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__FLOW = REST_SECURITY_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Refresh Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__REFRESH_URL = REST_SECURITY_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Token Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION__TOKEN_URL = REST_SECURITY_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>OAuth2 Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION_FEATURE_COUNT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>OAuth2 Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OAUTH2_DEFINITION_OPERATION_COUNT = REST_SECURITY_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OgnlExpressionImpl <em>Ognl Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OgnlExpressionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOgnlExpression()
	 * @generated
	 */
	int OGNL_EXPRESSION = 169;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OGNL_EXPRESSION__VALUE = TYPED_EXPRESSION_DEFINITION__VALUE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OGNL_EXPRESSION__ID = TYPED_EXPRESSION_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Trim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OGNL_EXPRESSION__TRIM = TYPED_EXPRESSION_DEFINITION__TRIM;

	/**
	 * The feature id for the '<em><b>Result Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OGNL_EXPRESSION__RESULT_TYPE = TYPED_EXPRESSION_DEFINITION__RESULT_TYPE;

	/**
	 * The number of structural features of the '<em>Ognl Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OGNL_EXPRESSION_FEATURE_COUNT = TYPED_EXPRESSION_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Ognl Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OGNL_EXPRESSION_OPERATION_COUNT = TYPED_EXPRESSION_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OnCompletionDefinitionImpl <em>On Completion Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OnCompletionDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOnCompletionDefinition()
	 * @generated
	 */
	int ON_COMPLETION_DEFINITION = 170;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ON_WHEN = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Executor Service</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__EXECUTOR_SERVICE = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__MODE = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>On Complete Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ON_COMPLETE_ONLY = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>On Failure Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__ON_FAILURE_ONLY = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Parallel Processing</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__PARALLEL_PROCESSING = OUTPUT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION__USE_ORIGINAL_MESSAGE = OUTPUT_FEATURE_COUNT + 77;

	/**
	 * The number of structural features of the '<em>On Completion Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 78;

	/**
	 * The number of operations of the '<em>On Completion Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_COMPLETION_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl <em>On Exception Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOnExceptionDefinition()
	 * @generated
	 */
	int ON_EXCEPTION_DEFINITION = 171;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CUSTOM_ID = OUTPUT__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DESCRIPTION = OUTPUT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ID = OUTPUT__ID;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DISABLED = OUTPUT__DISABLED;

	/**
	 * The feature id for the '<em><b>Exception</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__EXCEPTION = OUTPUT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>On When</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ON_WHEN = OUTPUT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Retry While</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__RETRY_WHILE = OUTPUT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Redelivery Policy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY = OUTPUT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Handled</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__HANDLED = OUTPUT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Continued</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CONTINUED = OUTPUT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__GROUP = OUTPUT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__AGGREGATE = OUTPUT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__BEAN = OUTPUT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DO_CATCH = OUTPUT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CHOICE = OUTPUT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CIRCUIT_BREAKER = OUTPUT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CLAIM_CHECK = OUTPUT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CONVERT_BODY_TO = OUTPUT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CONVERT_HEADER_TO = OUTPUT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__CONVERT_VARIABLE_TO = OUTPUT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DELAY = OUTPUT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DYNAMIC_ROUTER = OUTPUT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ENRICH = OUTPUT_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__FILTER = OUTPUT_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DO_FINALLY = OUTPUT_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__IDEMPOTENT_CONSUMER = OUTPUT_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__INTERCEPT = OUTPUT_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__INTERCEPT_FROM = OUTPUT_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OUTPUT_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__KAMELET = OUTPUT_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__LOAD_BALANCE = OUTPUT_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__LOG = OUTPUT_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__LOOP = OUTPUT_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__MARSHAL = OUTPUT_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__MULTICAST = OUTPUT_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ON_COMPLETION = OUTPUT_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ON_EXCEPTION = OUTPUT_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__PAUSABLE = OUTPUT_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__PIPELINE = OUTPUT_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__POLICY = OUTPUT_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__POLL = OUTPUT_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__POLL_ENRICH = OUTPUT_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__PROCESS = OUTPUT_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__RECIPIENT_LIST = OUTPUT_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REMOVE_HEADER = OUTPUT_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REMOVE_HEADERS = OUTPUT_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REMOVE_PROPERTIES = OUTPUT_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REMOVE_PROPERTY = OUTPUT_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REMOVE_VARIABLE = OUTPUT_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__RESEQUENCE = OUTPUT_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__RESUMABLE = OUTPUT_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ROLLBACK = OUTPUT_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ROUTE = OUTPUT_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ROUTING_SLIP = OUTPUT_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SAGA = OUTPUT_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SAMPLE = OUTPUT_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SCRIPT = OUTPUT_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_BODY = OUTPUT_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_EXCHANGE_PATTERN = OUTPUT_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_HEADER = OUTPUT_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_HEADERS = OUTPUT_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_PROPERTY = OUTPUT_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_VARIABLE = OUTPUT_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SET_VARIABLES = OUTPUT_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SORT = OUTPUT_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SPLIT = OUTPUT_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__STEP = OUTPUT_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__STOP = OUTPUT_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__THREADS = OUTPUT_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__THROTTLE = OUTPUT_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__THROW_EXCEPTION = OUTPUT_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__TO = OUTPUT_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__TO_D = OUTPUT_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__TOKENIZER = OUTPUT_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__TRANSACTED = OUTPUT_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__TRANSFORM = OUTPUT_FEATURE_COUNT + 71;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__DO_TRY = OUTPUT_FEATURE_COUNT + 72;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__UNMARSHAL = OUTPUT_FEATURE_COUNT + 73;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__VALIDATE = OUTPUT_FEATURE_COUNT + 74;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__WIRE_TAP = OUTPUT_FEATURE_COUNT + 75;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__SERVICE_CALL = OUTPUT_FEATURE_COUNT + 76;

	/**
	 * The feature id for the '<em><b>On Exception Occurred Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ON_EXCEPTION_OCCURRED_REF = OUTPUT_FEATURE_COUNT + 77;

	/**
	 * The feature id for the '<em><b>On Redelivery Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__ON_REDELIVERY_REF = OUTPUT_FEATURE_COUNT + 78;

	/**
	 * The feature id for the '<em><b>Redelivery Policy Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY_REF = OUTPUT_FEATURE_COUNT + 79;

	/**
	 * The feature id for the '<em><b>Use Original Body</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__USE_ORIGINAL_BODY = OUTPUT_FEATURE_COUNT + 80;

	/**
	 * The feature id for the '<em><b>Use Original Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION__USE_ORIGINAL_MESSAGE = OUTPUT_FEATURE_COUNT + 81;

	/**
	 * The number of structural features of the '<em>On Exception Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION_FEATURE_COUNT = OUTPUT_FEATURE_COUNT + 82;

	/**
	 * The number of operations of the '<em>On Exception Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXCEPTION_DEFINITION_OPERATION_COUNT = OUTPUT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OnFallbackDefinitionImpl <em>On Fallback Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OnFallbackDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOnFallbackDefinition()
	 * @generated
	 */
	int ON_FALLBACK_DEFINITION = 172;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__GROUP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__AGGREGATE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__BEAN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__DO_CATCH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CHOICE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CIRCUIT_BREAKER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CLAIM_CHECK = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CONVERT_BODY_TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CONVERT_HEADER_TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__CONVERT_VARIABLE_TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__DELAY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__DYNAMIC_ROUTER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ENRICH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__FILTER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__DO_FINALLY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__IDEMPOTENT_CONSUMER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__INTERCEPT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__INTERCEPT_FROM = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__KAMELET = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__LOAD_BALANCE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__LOG = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__LOOP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__MARSHAL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__MULTICAST = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ON_COMPLETION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ON_EXCEPTION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__PAUSABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__PIPELINE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__POLICY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__POLL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__POLL_ENRICH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__PROCESS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__RECIPIENT_LIST = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__REMOVE_HEADER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__REMOVE_HEADERS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__REMOVE_PROPERTIES = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__REMOVE_PROPERTY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__REMOVE_VARIABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__RESEQUENCE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__RESUMABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ROLLBACK = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ROUTE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__ROUTING_SLIP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SAGA = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SAMPLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SCRIPT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_BODY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_EXCHANGE_PATTERN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_HEADER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_HEADERS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_PROPERTY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_VARIABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SET_VARIABLES = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SORT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SPLIT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__STEP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__STOP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__THREADS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__THROTTLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__THROW_EXCEPTION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__TO_D = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__TOKENIZER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__TRANSACTED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__TRANSFORM = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__DO_TRY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__UNMARSHAL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__VALIDATE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__WIRE_TAP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__SERVICE_CALL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Fallback Via Network</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION__FALLBACK_VIA_NETWORK = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>On Fallback Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 72;

	/**
	 * The number of operations of the '<em>On Fallback Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_FALLBACK_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OnWhenDefinitionImpl <em>On When Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OnWhenDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOnWhenDefinition()
	 * @generated
	 */
	int ON_WHEN_DEFINITION = 173;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Expression Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__EXPRESSION_DEFINITION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Csimple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__CSIMPLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__CONSTANT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Datasonnet</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__DATASONNET = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Exchange Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__EXCHANGE_PROPERTY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Groovy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__GROOVY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Header</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__HEADER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Hl7terser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__HL7TERSER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Java</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__JAVA = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Js</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__JS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Joor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__JOOR = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Jq</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__JQ = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Jsonpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__JSONPATH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__LANGUAGE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__METHOD = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Mvel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__MVEL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Ognl</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__OGNL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Python</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__PYTHON = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__REF = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Simple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__SIMPLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Spel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__SPEL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Tokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__TOKENIZE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__VARIABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Wasm</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__WASM = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Xtokenize</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__XTOKENIZE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Xpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__XPATH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Xquery</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION__XQUERY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The number of structural features of the '<em>On When Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The number of operations of the '<em>On When Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_WHEN_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OpenApiDefinitionImpl <em>Open Api Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OpenApiDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOpenApiDefinition()
	 * @generated
	 */
	int OPEN_API_DEFINITION = 174;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Api Context Path</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__API_CONTEXT_PATH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__DISABLED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Missing Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__MISSING_OPERATION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mock Include Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__MOCK_INCLUDE_PATTERN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Route Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__ROUTE_ID = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Specification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION__SPECIFICATION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Open Api Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Open Api Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_API_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OpenIdConnectDefinitionImpl <em>Open Id Connect Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OpenIdConnectDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOpenIdConnectDefinition()
	 * @generated
	 */
	int OPEN_ID_CONNECT_DEFINITION = 175;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_ID_CONNECT_DEFINITION__DESCRIPTION = REST_SECURITY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_ID_CONNECT_DEFINITION__KEY = REST_SECURITY_DEFINITION__KEY;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_ID_CONNECT_DEFINITION__URL = REST_SECURITY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Open Id Connect Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_ID_CONNECT_DEFINITION_FEATURE_COUNT = REST_SECURITY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Open Id Connect Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPEN_ID_CONNECT_DEFINITION_OPERATION_COUNT = REST_SECURITY_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OptimisticLockRetryPolicyDefinitionImpl <em>Optimistic Lock Retry Policy Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OptimisticLockRetryPolicyDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOptimisticLockRetryPolicyDefinition()
	 * @generated
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION = 176;

	/**
	 * The feature id for the '<em><b>Exponential Back Off</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION__EXPONENTIAL_BACK_OFF = 0;

	/**
	 * The feature id for the '<em><b>Maximum Retries</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION__MAXIMUM_RETRIES = 1;

	/**
	 * The feature id for the '<em><b>Maximum Retry Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION__MAXIMUM_RETRY_DELAY = 2;

	/**
	 * The feature id for the '<em><b>Random Back Off</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION__RANDOM_BACK_OFF = 3;

	/**
	 * The feature id for the '<em><b>Retry Delay</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION__RETRY_DELAY = 4;

	/**
	 * The number of structural features of the '<em>Optimistic Lock Retry Policy Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Optimistic Lock Retry Policy Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTIMISTIC_LOCK_RETRY_POLICY_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OtherwiseDefinitionImpl <em>Otherwise Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OtherwiseDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOtherwiseDefinition()
	 * @generated
	 */
	int OTHERWISE_DEFINITION = 178;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__GROUP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__AGGREGATE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bean</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__BEAN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Do Catch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DO_CATCH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Choice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CHOICE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Circuit Breaker</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CIRCUIT_BREAKER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Claim Check</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CLAIM_CHECK = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Convert Body To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CONVERT_BODY_TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Convert Header To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CONVERT_HEADER_TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Convert Variable To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__CONVERT_VARIABLE_TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Delay</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DELAY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Dynamic Router</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DYNAMIC_ROUTER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ENRICH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__FILTER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Do Finally</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DO_FINALLY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Idempotent Consumer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__IDEMPOTENT_CONSUMER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Intercept</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__INTERCEPT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Intercept From</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__INTERCEPT_FROM = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Intercept Send To Endpoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Kamelet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__KAMELET = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Load Balance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__LOAD_BALANCE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Log</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__LOG = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Loop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__LOOP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Marshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__MARSHAL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Multicast</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__MULTICAST = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>On Completion</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ON_COMPLETION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>On Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ON_EXCEPTION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Pausable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__PAUSABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Pipeline</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__PIPELINE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 28;

	/**
	 * The feature id for the '<em><b>Policy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__POLICY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 29;

	/**
	 * The feature id for the '<em><b>Poll</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__POLL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 30;

	/**
	 * The feature id for the '<em><b>Poll Enrich</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__POLL_ENRICH = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 31;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__PROCESS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 32;

	/**
	 * The feature id for the '<em><b>Recipient List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__RECIPIENT_LIST = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 33;

	/**
	 * The feature id for the '<em><b>Remove Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__REMOVE_HEADER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 34;

	/**
	 * The feature id for the '<em><b>Remove Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__REMOVE_HEADERS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 35;

	/**
	 * The feature id for the '<em><b>Remove Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__REMOVE_PROPERTIES = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 36;

	/**
	 * The feature id for the '<em><b>Remove Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__REMOVE_PROPERTY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 37;

	/**
	 * The feature id for the '<em><b>Remove Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__REMOVE_VARIABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 38;

	/**
	 * The feature id for the '<em><b>Resequence</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__RESEQUENCE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 39;

	/**
	 * The feature id for the '<em><b>Resumable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__RESUMABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 40;

	/**
	 * The feature id for the '<em><b>Rollback</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ROLLBACK = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 41;

	/**
	 * The feature id for the '<em><b>Route</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ROUTE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 42;

	/**
	 * The feature id for the '<em><b>Routing Slip</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__ROUTING_SLIP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 43;

	/**
	 * The feature id for the '<em><b>Saga</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SAGA = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 44;

	/**
	 * The feature id for the '<em><b>Sample</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SAMPLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 45;

	/**
	 * The feature id for the '<em><b>Script</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SCRIPT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 46;

	/**
	 * The feature id for the '<em><b>Set Body</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_BODY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 47;

	/**
	 * The feature id for the '<em><b>Set Exchange Pattern</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_EXCHANGE_PATTERN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 48;

	/**
	 * The feature id for the '<em><b>Set Header</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_HEADER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 49;

	/**
	 * The feature id for the '<em><b>Set Headers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_HEADERS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 50;

	/**
	 * The feature id for the '<em><b>Set Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_PROPERTY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 51;

	/**
	 * The feature id for the '<em><b>Set Variable</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_VARIABLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 52;

	/**
	 * The feature id for the '<em><b>Set Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SET_VARIABLES = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 53;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SORT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 54;

	/**
	 * The feature id for the '<em><b>Split</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SPLIT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 55;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__STEP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 56;

	/**
	 * The feature id for the '<em><b>Stop</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__STOP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 57;

	/**
	 * The feature id for the '<em><b>Threads</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__THREADS = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 58;

	/**
	 * The feature id for the '<em><b>Throttle</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__THROTTLE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 59;

	/**
	 * The feature id for the '<em><b>Throw Exception</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__THROW_EXCEPTION = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 60;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__TO = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 61;

	/**
	 * The feature id for the '<em><b>To D</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__TO_D = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 62;

	/**
	 * The feature id for the '<em><b>Tokenizer</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__TOKENIZER = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 63;

	/**
	 * The feature id for the '<em><b>Transacted</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__TRANSACTED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 64;

	/**
	 * The feature id for the '<em><b>Transform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__TRANSFORM = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 65;

	/**
	 * The feature id for the '<em><b>Do Try</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DO_TRY = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 66;

	/**
	 * The feature id for the '<em><b>Unmarshal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__UNMARSHAL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 67;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__VALIDATE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 68;

	/**
	 * The feature id for the '<em><b>Wire Tap</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__WIRE_TAP = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 69;

	/**
	 * The feature id for the '<em><b>Service Call</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__SERVICE_CALL = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 70;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION__DISABLED = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 71;

	/**
	 * The number of structural features of the '<em>Otherwise Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 72;

	/**
	 * The number of operations of the '<em>Otherwise Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OTHERWISE_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.OutputTypeDefinitionImpl <em>Output Type Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.OutputTypeDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getOutputTypeDefinition()
	 * @generated
	 */
	int OUTPUT_TYPE_DEFINITION = 180;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION__CUSTOM_ID = OPTIONAL_IDENTIFIED_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION__DESCRIPTION = OPTIONAL_IDENTIFIED_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION__ID = OPTIONAL_IDENTIFIED_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Urn</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION__URN = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Validate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION__VALIDATE = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Output Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION_FEATURE_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Output Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_TYPE_DEFINITION_OPERATION_COUNT = OPTIONAL_IDENTIFIED_DEFINITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.PackageScanDefinitionImpl <em>Package Scan Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.PackageScanDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getPackageScanDefinition()
	 * @generated
	 */
	int PACKAGE_SCAN_DEFINITION = 181;

	/**
	 * The feature id for the '<em><b>Package</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SCAN_DEFINITION__PACKAGE = 0;

	/**
	 * The feature id for the '<em><b>Excludes</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SCAN_DEFINITION__EXCLUDES = 1;

	/**
	 * The feature id for the '<em><b>Includes</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SCAN_DEFINITION__INCLUDES = 2;

	/**
	 * The number of structural features of the '<em>Package Scan Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SCAN_DEFINITION_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Package Scan Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SCAN_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ParamDefinitionImpl <em>Param Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ParamDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getParamDefinition()
	 * @generated
	 */
	int PARAM_DEFINITION = 182;

	/**
	 * The feature id for the '<em><b>Allowable Values</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__ALLOWABLE_VALUES = 0;

	/**
	 * The feature id for the '<em><b>Examples</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__EXAMPLES = 1;

	/**
	 * The feature id for the '<em><b>Array Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__ARRAY_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Collection Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__COLLECTION_FORMAT = 3;

	/**
	 * The feature id for the '<em><b>Data Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__DATA_FORMAT = 4;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__DATA_TYPE = 5;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__DEFAULT_VALUE = 6;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__DESCRIPTION = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__NAME = 8;

	/**
	 * The feature id for the '<em><b>Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__REQUIRED = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Param Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Param Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAM_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.ParquetAvroDataFormatImpl <em>Parquet Avro Data Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.ParquetAvroDataFormatImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getParquetAvroDataFormat()
	 * @generated
	 */
	int PARQUET_AVRO_DATA_FORMAT = 183;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARQUET_AVRO_DATA_FORMAT__ID = DATA_FORMAT__ID;

	/**
	 * The feature id for the '<em><b>Compression Codec Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARQUET_AVRO_DATA_FORMAT__COMPRESSION_CODEC_NAME = DATA_FORMAT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lazy Load</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARQUET_AVRO_DATA_FORMAT__LAZY_LOAD = DATA_FORMAT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Unmarshal Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARQUET_AVRO_DATA_FORMAT__UNMARSHAL_TYPE = DATA_FORMAT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Parquet Avro Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARQUET_AVRO_DATA_FORMAT_FEATURE_COUNT = DATA_FORMAT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Parquet Avro Data Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARQUET_AVRO_DATA_FORMAT_OPERATION_COUNT = DATA_FORMAT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.PassThroughServiceCallServiceFilterConfigurationImpl <em>Pass Through Service Call Service Filter Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.PassThroughServiceCallServiceFilterConfigurationImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getPassThroughServiceCallServiceFilterConfiguration()
	 * @generated
	 */
	int PASS_THROUGH_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION = 184;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__ID;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION__PROPERTIES;

	/**
	 * The number of structural features of the '<em>Pass Through Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Pass Through Service Call Service Filter Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT = SERVICE_CALL_SERVICE_FILTER_CONFIGURATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.camel.camelspring.impl.PatchDefinitionImpl <em>Patch Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.camel.camelspring.impl.PatchDefinitionImpl
	 * @see org.eclipse.fennec.camel.camelspring.impl.CamelSpringPackageImpl#getPatchDefinition()
	 * @generated
	 */
	int PATCH_DEFINITION = 185;

	/**
	 * The feature id for the '<em><b>Custom Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__CUSTOM_ID = VERB_DEFINITION__CUSTOM_ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__DESCRIPTION = VERB_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__ID = VERB_DEFINITION__ID;

	/**
	 * The feature id for the '<em><b>Param</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__PARAM = VERB_DEFINITION__PARAM;

	/**
	 * The feature id for the '<em><b>Response Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__RESPONSE_MESSAGE = VERB_DEFINITION__RESPONSE_MESSAGE;

	/**
	 * The feature id for the '<em><b>Security</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__SECURITY = VERB_DEFINITION__SECURITY;

	/**
	 * The feature id for the '<em><b>To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__TO = VERB_DEFINITION__TO;

	/**
	 * The feature id for the '<em><b>Api Docs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__API_DOCS = VERB_DEFINITION__API_DOCS;

	/**
	 * The feature id for the '<em><b>Binding Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__BINDING_MODE = VERB_DEFINITION__BINDING_MODE;

	/**
	 * The feature id for the '<em><b>Client Request Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__CLIENT_REQUEST_VALIDATION = VERB_DEFINITION__CLIENT_REQUEST_VALIDATION;

	/**
	 * The feature id for the '<em><b>Client Response Validation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__CLIENT_RESPONSE_VALIDATION = VERB_DEFINITION__CLIENT_RESPONSE_VALIDATION;

	/**
	 * The feature id for the '<em><b>Consumes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__CONSUMES = VERB_DEFINITION__CONSUMES;

	/**
	 * The feature id for the '<em><b>Deprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__DEPRECATED = VERB_DEFINITION__DEPRECATED;

	/**
	 * The feature id for the '<em><b>Disabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__DISABLED = VERB_DEFINITION__DISABLED;

	/**
	 * The feature id for the '<em><b>Enable CORS</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__ENABLE_CORS = VERB_DEFINITION__ENABLE_CORS;

	/**
	 * The feature id for the '<em><b>Enable No Content Response</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__ENABLE_NO_CONTENT_RESPONSE = VERB_DEFINITION__ENABLE_NO_CONTENT_RESPONSE;

	/**
	 * The feature id for the '<em><b>Out Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATCH_DEFINITION__OUT_TYPE = VERB_DEFINITION__OUT_TYPE;

	/**
	 * The feature