/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.camel.camelspring.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.camel.camelspring.AggregateDefinition;
import org.eclipse.fennec.camel.camelspring.BeanDefinition;
import org.eclipse.fennec.camel.camelspring.CamelSpringPackage;
import org.eclipse.fennec.camel.camelspring.CatchDefinition;
import org.eclipse.fennec.camel.camelspring.ChoiceDefinition;
import org.eclipse.fennec.camel.camelspring.CircuitBreakerDefinition;
import org.eclipse.fennec.camel.camelspring.ClaimCheckDefinition;
import org.eclipse.fennec.camel.camelspring.ConvertBodyDefinition;
import org.eclipse.fennec.camel.camelspring.ConvertHeaderDefinition;
import org.eclipse.fennec.camel.camelspring.ConvertVariableDefinition;
import org.eclipse.fennec.camel.camelspring.DelayDefinition;
import org.eclipse.fennec.camel.camelspring.DynamicRouterDefinition;
import org.eclipse.fennec.camel.camelspring.EnrichDefinition;
import org.eclipse.fennec.camel.camelspring.ExpressionSubElementDefinition;
import org.eclipse.fennec.camel.camelspring.FilterDefinition;
import org.eclipse.fennec.camel.camelspring.FinallyDefinition;
import org.eclipse.fennec.camel.camelspring.IdempotentConsumerDefinition;
import org.eclipse.fennec.camel.camelspring.InterceptDefinition;
import org.eclipse.fennec.camel.camelspring.InterceptFromDefinition;
import org.eclipse.fennec.camel.camelspring.InterceptSendToEndpointDefinition;
import org.eclipse.fennec.camel.camelspring.KameletDefinition;
import org.eclipse.fennec.camel.camelspring.LoadBalanceDefinition;
import org.eclipse.fennec.camel.camelspring.LogDefinition;
import org.eclipse.fennec.camel.camelspring.LoopDefinition;
import org.eclipse.fennec.camel.camelspring.MarshalDefinition;
import org.eclipse.fennec.camel.camelspring.MulticastDefinition;
import org.eclipse.fennec.camel.camelspring.OnCompletionDefinition;
import org.eclipse.fennec.camel.camelspring.OnExceptionDefinition;
import org.eclipse.fennec.camel.camelspring.OnWhenDefinition;
import org.eclipse.fennec.camel.camelspring.PausableDefinition;
import org.eclipse.fennec.camel.camelspring.PipelineDefinition;
import org.eclipse.fennec.camel.camelspring.PolicyDefinition;
import org.eclipse.fennec.camel.camelspring.PollDefinition;
import org.eclipse.fennec.camel.camelspring.PollEnrichDefinition;
import org.eclipse.fennec.camel.camelspring.ProcessDefinition;
import org.eclipse.fennec.camel.camelspring.RecipientListDefinition;
import org.eclipse.fennec.camel.camelspring.RedeliveryPolicyDefinition;
import org.eclipse.fennec.camel.camelspring.RemoveHeaderDefinition;
import org.eclipse.fennec.camel.camelspring.RemoveHeadersDefinition;
import org.eclipse.fennec.camel.camelspring.RemovePropertiesDefinition;
import org.eclipse.fennec.camel.camelspring.RemovePropertyDefinition;
import org.eclipse.fennec.camel.camelspring.RemoveVariableDefinition;
import org.eclipse.fennec.camel.camelspring.ResequenceDefinition;
import org.eclipse.fennec.camel.camelspring.ResumableDefinition;
import org.eclipse.fennec.camel.camelspring.RollbackDefinition;
import org.eclipse.fennec.camel.camelspring.RouteDefinition;
import org.eclipse.fennec.camel.camelspring.RoutingSlipDefinition;
import org.eclipse.fennec.camel.camelspring.SagaDefinition;
import org.eclipse.fennec.camel.camelspring.SamplingDefinition;
import org.eclipse.fennec.camel.camelspring.ScriptDefinition;
import org.eclipse.fennec.camel.camelspring.ServiceCallDefinition;
import org.eclipse.fennec.camel.camelspring.SetBodyDefinition;
import org.eclipse.fennec.camel.camelspring.SetExchangePatternDefinition;
import org.eclipse.fennec.camel.camelspring.SetHeaderDefinition;
import org.eclipse.fennec.camel.camelspring.SetHeadersDefinition;
import org.eclipse.fennec.camel.camelspring.SetPropertyDefinition;
import org.eclipse.fennec.camel.camelspring.SetVariableDefinition;
import org.eclipse.fennec.camel.camelspring.SetVariablesDefinition;
import org.eclipse.fennec.camel.camelspring.SortDefinition;
import org.eclipse.fennec.camel.camelspring.SplitDefinition;
import org.eclipse.fennec.camel.camelspring.StepDefinition;
import org.eclipse.fennec.camel.camelspring.StopDefinition;
import org.eclipse.fennec.camel.camelspring.ThreadsDefinition;
import org.eclipse.fennec.camel.camelspring.ThrottleDefinition;
import org.eclipse.fennec.camel.camelspring.ThrowExceptionDefinition;
import org.eclipse.fennec.camel.camelspring.ToDefinition;
import org.eclipse.fennec.camel.camelspring.ToDynamicDefinition;
import org.eclipse.fennec.camel.camelspring.TokenizerDefinition;
import org.eclipse.fennec.camel.camelspring.TransactedDefinition;
import org.eclipse.fennec.camel.camelspring.TransformDefinition;
import org.eclipse.fennec.camel.camelspring.TryDefinition;
import org.eclipse.fennec.camel.camelspring.UnmarshalDefinition;
import org.eclipse.fennec.camel.camelspring.ValidateDefinition;
import org.eclipse.fennec.camel.camelspring.WireTapDefinition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>On Exception Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getException <em>Exception</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getOnWhen <em>On When</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRetryWhile <em>Retry While</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRedeliveryPolicy <em>Redelivery Policy</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getHandled <em>Handled</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getContinued <em>Continued</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getAggregate <em>Aggregate</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getBean <em>Bean</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getDoCatch <em>Do Catch</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getChoice <em>Choice</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getCircuitBreaker <em>Circuit Breaker</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getClaimCheck <em>Claim Check</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getConvertBodyTo <em>Convert Body To</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getConvertHeaderTo <em>Convert Header To</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getConvertVariableTo <em>Convert Variable To</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getDelay <em>Delay</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getDynamicRouter <em>Dynamic Router</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getEnrich <em>Enrich</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getFilter <em>Filter</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getDoFinally <em>Do Finally</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getIdempotentConsumer <em>Idempotent Consumer</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getIntercept <em>Intercept</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getInterceptFrom <em>Intercept From</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getInterceptSendToEndpoint <em>Intercept Send To Endpoint</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getKamelet <em>Kamelet</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getLoadBalance <em>Load Balance</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getLog <em>Log</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getLoop <em>Loop</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getMarshal <em>Marshal</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getMulticast <em>Multicast</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getOnCompletion <em>On Completion</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getOnException <em>On Exception</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getPausable <em>Pausable</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getPipeline <em>Pipeline</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getPolicy <em>Policy</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getPoll <em>Poll</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getPollEnrich <em>Poll Enrich</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRecipientList <em>Recipient List</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRemoveHeader <em>Remove Header</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRemoveHeaders <em>Remove Headers</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRemoveProperties <em>Remove Properties</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRemoveProperty <em>Remove Property</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRemoveVariable <em>Remove Variable</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getResequence <em>Resequence</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getResumable <em>Resumable</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRollback <em>Rollback</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRoute <em>Route</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRoutingSlip <em>Routing Slip</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSaga <em>Saga</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSample <em>Sample</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getScript <em>Script</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetBody <em>Set Body</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetExchangePattern <em>Set Exchange Pattern</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetHeader <em>Set Header</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetHeaders <em>Set Headers</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetProperty <em>Set Property</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetVariable <em>Set Variable</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSetVariables <em>Set Variables</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSort <em>Sort</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getSplit <em>Split</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getStep <em>Step</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getStop <em>Stop</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getThreads <em>Threads</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getThrottle <em>Throttle</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getThrowException <em>Throw Exception</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getTo <em>To</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getToD <em>To D</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getTokenizer <em>Tokenizer</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getTransacted <em>Transacted</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getTransform <em>Transform</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getDoTry <em>Do Try</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getUnmarshal <em>Unmarshal</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getValidate <em>Validate</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getWireTap <em>Wire Tap</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getServiceCall <em>Service Call</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getOnExceptionOccurredRef <em>On Exception Occurred Ref</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getOnRedeliveryRef <em>On Redelivery Ref</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getRedeliveryPolicyRef <em>Redelivery Policy Ref</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getUseOriginalBody <em>Use Original Body</em>}</li>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.OnExceptionDefinitionImpl#getUseOriginalMessage <em>Use Original Message</em>}</li>
 * </ul>
 *
 * @generated
 */
public class OnExceptionDefinitionImpl extends OutputImpl implements OnExceptionDefinition {
	/**
	 * The cached value of the '{@link #getException() <em>Exception</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getException()
	 * @generated
	 * @ordered
	 */
	protected EList<String> exception;

	/**
	 * The cached value of the '{@link #getOnWhen() <em>On When</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnWhen()
	 * @generated
	 * @ordered
	 */
	protected OnWhenDefinition onWhen;

	/**
	 * The cached value of the '{@link #getRetryWhile() <em>Retry While</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRetryWhile()
	 * @generated
	 * @ordered
	 */
	protected ExpressionSubElementDefinition retryWhile;

	/**
	 * The cached value of the '{@link #getRedeliveryPolicy() <em>Redelivery Policy</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRedeliveryPolicy()
	 * @generated
	 * @ordered
	 */
	protected RedeliveryPolicyDefinition redeliveryPolicy;

	/**
	 * The cached value of the '{@link #getHandled() <em>Handled</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHandled()
	 * @generated
	 * @ordered
	 */
	protected ExpressionSubElementDefinition handled;

	/**
	 * The cached value of the '{@link #getContinued() <em>Continued</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContinued()
	 * @generated
	 * @ordered
	 */
	protected ExpressionSubElementDefinition continued;

	/**
	 * The cached value of the '{@link #getGroup() <em>Group</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroup()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap group;

	/**
	 * The default value of the '{@link #getOnExceptionOccurredRef() <em>On Exception Occurred Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnExceptionOccurredRef()
	 * @generated
	 * @ordered
	 */
	protected static final String ON_EXCEPTION_OCCURRED_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOnExceptionOccurredRef() <em>On Exception Occurred Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnExceptionOccurredRef()
	 * @generated
	 * @ordered
	 */
	protected String onExceptionOccurredRef = ON_EXCEPTION_OCCURRED_REF_EDEFAULT;

	/**
	 * The default value of the '{@link #getOnRedeliveryRef() <em>On Redelivery Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnRedeliveryRef()
	 * @generated
	 * @ordered
	 */
	protected static final String ON_REDELIVERY_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOnRedeliveryRef() <em>On Redelivery Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOnRedeliveryRef()
	 * @generated
	 * @ordered
	 */
	protected String onRedeliveryRef = ON_REDELIVERY_REF_EDEFAULT;

	/**
	 * The default value of the '{@link #getRedeliveryPolicyRef() <em>Redelivery Policy Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRedeliveryPolicyRef()
	 * @generated
	 * @ordered
	 */
	protected static final String REDELIVERY_POLICY_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRedeliveryPolicyRef() <em>Redelivery Policy Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRedeliveryPolicyRef()
	 * @generated
	 * @ordered
	 */
	protected String redeliveryPolicyRef = REDELIVERY_POLICY_REF_EDEFAULT;

	/**
	 * The default value of the '{@link #getUseOriginalBody() <em>Use Original Body</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUseOriginalBody()
	 * @generated
	 * @ordered
	 */
	protected static final String USE_ORIGINAL_BODY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUseOriginalBody() <em>Use Original Body</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUseOriginalBody()
	 * @generated
	 * @ordered
	 */
	protected String useOriginalBody = USE_ORIGINAL_BODY_EDEFAULT;

	/**
	 * The default value of the '{@link #getUseOriginalMessage() <em>Use Original Message</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUseOriginalMessage()
	 * @generated
	 * @ordered
	 */
	protected static final String USE_ORIGINAL_MESSAGE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUseOriginalMessage() <em>Use Original Message</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUseOriginalMessage()
	 * @generated
	 * @ordered
	 */
	protected String useOriginalMessage = USE_ORIGINAL_MESSAGE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OnExceptionDefinitionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CamelSpringPackage.eINSTANCE.getOnExceptionDefinition();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getException() {
		if (exception == null) {
			exception = new EDataTypeEList<String>(String.class, this, CamelSpringPackage.ON_EXCEPTION_DEFINITION__EXCEPTION);
		}
		return exception;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OnWhenDefinition getOnWhen() {
		return onWhen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOnWhen(OnWhenDefinition newOnWhen, NotificationChain msgs) {
		OnWhenDefinition oldOnWhen = onWhen;
		onWhen = newOnWhen;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN, oldOnWhen, newOnWhen);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOnWhen(OnWhenDefinition newOnWhen) {
		if (newOnWhen != onWhen) {
			NotificationChain msgs = null;
			if (onWhen != null)
				msgs = ((InternalEObject)onWhen).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN, null, msgs);
			if (newOnWhen != null)
				msgs = ((InternalEObject)newOnWhen).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN, null, msgs);
			msgs = basicSetOnWhen(newOnWhen, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN, newOnWhen, newOnWhen));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExpressionSubElementDefinition getRetryWhile() {
		return retryWhile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRetryWhile(ExpressionSubElementDefinition newRetryWhile, NotificationChain msgs) {
		ExpressionSubElementDefinition oldRetryWhile = retryWhile;
		retryWhile = newRetryWhile;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE, oldRetryWhile, newRetryWhile);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRetryWhile(ExpressionSubElementDefinition newRetryWhile) {
		if (newRetryWhile != retryWhile) {
			NotificationChain msgs = null;
			if (retryWhile != null)
				msgs = ((InternalEObject)retryWhile).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE, null, msgs);
			if (newRetryWhile != null)
				msgs = ((InternalEObject)newRetryWhile).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE, null, msgs);
			msgs = basicSetRetryWhile(newRetryWhile, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE, newRetryWhile, newRetryWhile));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RedeliveryPolicyDefinition getRedeliveryPolicy() {
		return redeliveryPolicy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRedeliveryPolicy(RedeliveryPolicyDefinition newRedeliveryPolicy, NotificationChain msgs) {
		RedeliveryPolicyDefinition oldRedeliveryPolicy = redeliveryPolicy;
		redeliveryPolicy = newRedeliveryPolicy;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY, oldRedeliveryPolicy, newRedeliveryPolicy);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRedeliveryPolicy(RedeliveryPolicyDefinition newRedeliveryPolicy) {
		if (newRedeliveryPolicy != redeliveryPolicy) {
			NotificationChain msgs = null;
			if (redeliveryPolicy != null)
				msgs = ((InternalEObject)redeliveryPolicy).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY, null, msgs);
			if (newRedeliveryPolicy != null)
				msgs = ((InternalEObject)newRedeliveryPolicy).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY, null, msgs);
			msgs = basicSetRedeliveryPolicy(newRedeliveryPolicy, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY, newRedeliveryPolicy, newRedeliveryPolicy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExpressionSubElementDefinition getHandled() {
		return handled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetHandled(ExpressionSubElementDefinition newHandled, NotificationChain msgs) {
		ExpressionSubElementDefinition oldHandled = handled;
		handled = newHandled;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED, oldHandled, newHandled);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHandled(ExpressionSubElementDefinition newHandled) {
		if (newHandled != handled) {
			NotificationChain msgs = null;
			if (handled != null)
				msgs = ((InternalEObject)handled).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED, null, msgs);
			if (newHandled != null)
				msgs = ((InternalEObject)newHandled).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED, null, msgs);
			msgs = basicSetHandled(newHandled, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED, newHandled, newHandled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExpressionSubElementDefinition getContinued() {
		return continued;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContinued(ExpressionSubElementDefinition newContinued, NotificationChain msgs) {
		ExpressionSubElementDefinition oldContinued = continued;
		continued = newContinued;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED, oldContinued, newContinued);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContinued(ExpressionSubElementDefinition newContinued) {
		if (newContinued != continued) {
			NotificationChain msgs = null;
			if (continued != null)
				msgs = ((InternalEObject)continued).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED, null, msgs);
			if (newContinued != null)
				msgs = ((InternalEObject)newContinued).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED, null, msgs);
			msgs = basicSetContinued(newContinued, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED, newContinued, newContinued));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureMap getGroup() {
		if (group == null) {
			group = new BasicFeatureMap(this, CamelSpringPackage.ON_EXCEPTION_DEFINITION__GROUP);
		}
		return group;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AggregateDefinition> getAggregate() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Aggregate());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<BeanDefinition> getBean() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Bean());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<CatchDefinition> getDoCatch() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_DoCatch());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ChoiceDefinition> getChoice() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Choice());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<CircuitBreakerDefinition> getCircuitBreaker() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_CircuitBreaker());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ClaimCheckDefinition> getClaimCheck() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ClaimCheck());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ConvertBodyDefinition> getConvertBodyTo() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ConvertBodyTo());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ConvertHeaderDefinition> getConvertHeaderTo() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ConvertHeaderTo());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ConvertVariableDefinition> getConvertVariableTo() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ConvertVariableTo());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DelayDefinition> getDelay() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Delay());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DynamicRouterDefinition> getDynamicRouter() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_DynamicRouter());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EnrichDefinition> getEnrich() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Enrich());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<FilterDefinition> getFilter() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Filter());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<FinallyDefinition> getDoFinally() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_DoFinally());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<IdempotentConsumerDefinition> getIdempotentConsumer() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_IdempotentConsumer());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<InterceptDefinition> getIntercept() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Intercept());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<InterceptFromDefinition> getInterceptFrom() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_InterceptFrom());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<InterceptSendToEndpointDefinition> getInterceptSendToEndpoint() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_InterceptSendToEndpoint());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<KameletDefinition> getKamelet() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Kamelet());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LoadBalanceDefinition> getLoadBalance() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_LoadBalance());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LogDefinition> getLog() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Log());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LoopDefinition> getLoop() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Loop());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<MarshalDefinition> getMarshal() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Marshal());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<MulticastDefinition> getMulticast() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Multicast());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<OnCompletionDefinition> getOnCompletion() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_OnCompletion());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<OnExceptionDefinition> getOnException() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_OnException());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PausableDefinition> getPausable() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Pausable());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PipelineDefinition> getPipeline() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Pipeline());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PolicyDefinition> getPolicy() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Policy());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PollDefinition> getPoll() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Poll());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PollEnrichDefinition> getPollEnrich() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_PollEnrich());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ProcessDefinition> getProcess() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Process());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RecipientListDefinition> getRecipientList() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RecipientList());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RemoveHeaderDefinition> getRemoveHeader() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RemoveHeader());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RemoveHeadersDefinition> getRemoveHeaders() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RemoveHeaders());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RemovePropertiesDefinition> getRemoveProperties() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RemoveProperties());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RemovePropertyDefinition> getRemoveProperty() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RemoveProperty());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RemoveVariableDefinition> getRemoveVariable() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RemoveVariable());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ResequenceDefinition> getResequence() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Resequence());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ResumableDefinition> getResumable() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Resumable());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RollbackDefinition> getRollback() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Rollback());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RouteDefinition> getRoute() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Route());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RoutingSlipDefinition> getRoutingSlip() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_RoutingSlip());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SagaDefinition> getSaga() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Saga());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SamplingDefinition> getSample() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Sample());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ScriptDefinition> getScript() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Script());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetBodyDefinition> getSetBody() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetBody());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetExchangePatternDefinition> getSetExchangePattern() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetExchangePattern());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetHeaderDefinition> getSetHeader() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetHeader());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetHeadersDefinition> getSetHeaders() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetHeaders());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetPropertyDefinition> getSetProperty() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetProperty());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetVariableDefinition> getSetVariable() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetVariable());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SetVariablesDefinition> getSetVariables() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_SetVariables());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SortDefinition> getSort() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Sort());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SplitDefinition> getSplit() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Split());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<StepDefinition> getStep() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Step());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<StopDefinition> getStop() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Stop());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ThreadsDefinition> getThreads() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Threads());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ThrottleDefinition> getThrottle() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Throttle());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ThrowExceptionDefinition> getThrowException() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ThrowException());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ToDefinition> getTo() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_To());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ToDynamicDefinition> getToD() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ToD());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TokenizerDefinition> getTokenizer() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Tokenizer());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TransactedDefinition> getTransacted() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Transacted());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TransformDefinition> getTransform() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Transform());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<TryDefinition> getDoTry() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_DoTry());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<UnmarshalDefinition> getUnmarshal() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Unmarshal());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ValidateDefinition> getValidate() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_Validate());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<WireTapDefinition> getWireTap() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_WireTap());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ServiceCallDefinition> getServiceCall() {
		return getGroup().list(CamelSpringPackage.eINSTANCE.getOnExceptionDefinition_ServiceCall());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getOnExceptionOccurredRef() {
		return onExceptionOccurredRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOnExceptionOccurredRef(String newOnExceptionOccurredRef) {
		String oldOnExceptionOccurredRef = onExceptionOccurredRef;
		onExceptionOccurredRef = newOnExceptionOccurredRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION_OCCURRED_REF, oldOnExceptionOccurredRef, onExceptionOccurredRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getOnRedeliveryRef() {
		return onRedeliveryRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOnRedeliveryRef(String newOnRedeliveryRef) {
		String oldOnRedeliveryRef = onRedeliveryRef;
		onRedeliveryRef = newOnRedeliveryRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_REDELIVERY_REF, oldOnRedeliveryRef, onRedeliveryRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getRedeliveryPolicyRef() {
		return redeliveryPolicyRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRedeliveryPolicyRef(String newRedeliveryPolicyRef) {
		String oldRedeliveryPolicyRef = redeliveryPolicyRef;
		redeliveryPolicyRef = newRedeliveryPolicyRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY_REF, oldRedeliveryPolicyRef, redeliveryPolicyRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUseOriginalBody() {
		return useOriginalBody;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUseOriginalBody(String newUseOriginalBody) {
		String oldUseOriginalBody = useOriginalBody;
		useOriginalBody = newUseOriginalBody;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_BODY, oldUseOriginalBody, useOriginalBody));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUseOriginalMessage() {
		return useOriginalMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUseOriginalMessage(String newUseOriginalMessage) {
		String oldUseOriginalMessage = useOriginalMessage;
		useOriginalMessage = newUseOriginalMessage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_MESSAGE, oldUseOriginalMessage, useOriginalMessage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN:
				return basicSetOnWhen(null, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE:
				return basicSetRetryWhile(null, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY:
				return basicSetRedeliveryPolicy(null, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED:
				return basicSetHandled(null, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED:
				return basicSetContinued(null, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__GROUP:
				return ((InternalEList<?>)getGroup()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__AGGREGATE:
				return ((InternalEList<?>)getAggregate()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__BEAN:
				return ((InternalEList<?>)getBean()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_CATCH:
				return ((InternalEList<?>)getDoCatch()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CHOICE:
				return ((InternalEList<?>)getChoice()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CIRCUIT_BREAKER:
				return ((InternalEList<?>)getCircuitBreaker()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CLAIM_CHECK:
				return ((InternalEList<?>)getClaimCheck()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_BODY_TO:
				return ((InternalEList<?>)getConvertBodyTo()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_HEADER_TO:
				return ((InternalEList<?>)getConvertHeaderTo()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_VARIABLE_TO:
				return ((InternalEList<?>)getConvertVariableTo()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DELAY:
				return ((InternalEList<?>)getDelay()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DYNAMIC_ROUTER:
				return ((InternalEList<?>)getDynamicRouter()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ENRICH:
				return ((InternalEList<?>)getEnrich()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__FILTER:
				return ((InternalEList<?>)getFilter()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_FINALLY:
				return ((InternalEList<?>)getDoFinally()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__IDEMPOTENT_CONSUMER:
				return ((InternalEList<?>)getIdempotentConsumer()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT:
				return ((InternalEList<?>)getIntercept()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_FROM:
				return ((InternalEList<?>)getInterceptFrom()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT:
				return ((InternalEList<?>)getInterceptSendToEndpoint()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__KAMELET:
				return ((InternalEList<?>)getKamelet()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOAD_BALANCE:
				return ((InternalEList<?>)getLoadBalance()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOG:
				return ((InternalEList<?>)getLog()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOOP:
				return ((InternalEList<?>)getLoop()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MARSHAL:
				return ((InternalEList<?>)getMarshal()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MULTICAST:
				return ((InternalEList<?>)getMulticast()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_COMPLETION:
				return ((InternalEList<?>)getOnCompletion()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION:
				return ((InternalEList<?>)getOnException()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PAUSABLE:
				return ((InternalEList<?>)getPausable()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PIPELINE:
				return ((InternalEList<?>)getPipeline()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLICY:
				return ((InternalEList<?>)getPolicy()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL:
				return ((InternalEList<?>)getPoll()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL_ENRICH:
				return ((InternalEList<?>)getPollEnrich()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PROCESS:
				return ((InternalEList<?>)getProcess()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RECIPIENT_LIST:
				return ((InternalEList<?>)getRecipientList()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADER:
				return ((InternalEList<?>)getRemoveHeader()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADERS:
				return ((InternalEList<?>)getRemoveHeaders()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTIES:
				return ((InternalEList<?>)getRemoveProperties()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTY:
				return ((InternalEList<?>)getRemoveProperty()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_VARIABLE:
				return ((InternalEList<?>)getRemoveVariable()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESEQUENCE:
				return ((InternalEList<?>)getResequence()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESUMABLE:
				return ((InternalEList<?>)getResumable()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROLLBACK:
				return ((InternalEList<?>)getRollback()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTE:
				return ((InternalEList<?>)getRoute()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTING_SLIP:
				return ((InternalEList<?>)getRoutingSlip()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAGA:
				return ((InternalEList<?>)getSaga()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAMPLE:
				return ((InternalEList<?>)getSample()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SCRIPT:
				return ((InternalEList<?>)getScript()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_BODY:
				return ((InternalEList<?>)getSetBody()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_EXCHANGE_PATTERN:
				return ((InternalEList<?>)getSetExchangePattern()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADER:
				return ((InternalEList<?>)getSetHeader()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADERS:
				return ((InternalEList<?>)getSetHeaders()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_PROPERTY:
				return ((InternalEList<?>)getSetProperty()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLE:
				return ((InternalEList<?>)getSetVariable()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLES:
				return ((InternalEList<?>)getSetVariables()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SORT:
				return ((InternalEList<?>)getSort()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SPLIT:
				return ((InternalEList<?>)getSplit()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STEP:
				return ((InternalEList<?>)getStep()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STOP:
				return ((InternalEList<?>)getStop()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THREADS:
				return ((InternalEList<?>)getThreads()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROTTLE:
				return ((InternalEList<?>)getThrottle()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROW_EXCEPTION:
				return ((InternalEList<?>)getThrowException()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO:
				return ((InternalEList<?>)getTo()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO_D:
				return ((InternalEList<?>)getToD()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TOKENIZER:
				return ((InternalEList<?>)getTokenizer()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSACTED:
				return ((InternalEList<?>)getTransacted()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSFORM:
				return ((InternalEList<?>)getTransform()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_TRY:
				return ((InternalEList<?>)getDoTry()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__UNMARSHAL:
				return ((InternalEList<?>)getUnmarshal()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__VALIDATE:
				return ((InternalEList<?>)getValidate()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__WIRE_TAP:
				return ((InternalEList<?>)getWireTap()).basicRemove(otherEnd, msgs);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SERVICE_CALL:
				return ((InternalEList<?>)getServiceCall()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__EXCEPTION:
				return getException();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN:
				return getOnWhen();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE:
				return getRetryWhile();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY:
				return getRedeliveryPolicy();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED:
				return getHandled();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED:
				return getContinued();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__GROUP:
				if (coreType) return getGroup();
				return ((FeatureMap.Internal)getGroup()).getWrapper();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__AGGREGATE:
				return getAggregate();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__BEAN:
				return getBean();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_CATCH:
				return getDoCatch();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CHOICE:
				return getChoice();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CIRCUIT_BREAKER:
				return getCircuitBreaker();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CLAIM_CHECK:
				return getClaimCheck();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_BODY_TO:
				return getConvertBodyTo();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_HEADER_TO:
				return getConvertHeaderTo();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_VARIABLE_TO:
				return getConvertVariableTo();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DELAY:
				return getDelay();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DYNAMIC_ROUTER:
				return getDynamicRouter();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ENRICH:
				return getEnrich();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__FILTER:
				return getFilter();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_FINALLY:
				return getDoFinally();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__IDEMPOTENT_CONSUMER:
				return getIdempotentConsumer();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT:
				return getIntercept();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_FROM:
				return getInterceptFrom();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT:
				return getInterceptSendToEndpoint();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__KAMELET:
				return getKamelet();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOAD_BALANCE:
				return getLoadBalance();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOG:
				return getLog();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOOP:
				return getLoop();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MARSHAL:
				return getMarshal();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MULTICAST:
				return getMulticast();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_COMPLETION:
				return getOnCompletion();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION:
				return getOnException();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PAUSABLE:
				return getPausable();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PIPELINE:
				return getPipeline();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLICY:
				return getPolicy();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL:
				return getPoll();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL_ENRICH:
				return getPollEnrich();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PROCESS:
				return getProcess();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RECIPIENT_LIST:
				return getRecipientList();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADER:
				return getRemoveHeader();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADERS:
				return getRemoveHeaders();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTIES:
				return getRemoveProperties();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTY:
				return getRemoveProperty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_VARIABLE:
				return getRemoveVariable();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESEQUENCE:
				return getResequence();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESUMABLE:
				return getResumable();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROLLBACK:
				return getRollback();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTE:
				return getRoute();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTING_SLIP:
				return getRoutingSlip();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAGA:
				return getSaga();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAMPLE:
				return getSample();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SCRIPT:
				return getScript();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_BODY:
				return getSetBody();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_EXCHANGE_PATTERN:
				return getSetExchangePattern();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADER:
				return getSetHeader();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADERS:
				return getSetHeaders();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_PROPERTY:
				return getSetProperty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLE:
				return getSetVariable();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLES:
				return getSetVariables();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SORT:
				return getSort();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SPLIT:
				return getSplit();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STEP:
				return getStep();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STOP:
				return getStop();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THREADS:
				return getThreads();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROTTLE:
				return getThrottle();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROW_EXCEPTION:
				return getThrowException();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO:
				return getTo();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO_D:
				return getToD();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TOKENIZER:
				return getTokenizer();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSACTED:
				return getTransacted();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSFORM:
				return getTransform();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_TRY:
				return getDoTry();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__UNMARSHAL:
				return getUnmarshal();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__VALIDATE:
				return getValidate();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__WIRE_TAP:
				return getWireTap();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SERVICE_CALL:
				return getServiceCall();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION_OCCURRED_REF:
				return getOnExceptionOccurredRef();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_REDELIVERY_REF:
				return getOnRedeliveryRef();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY_REF:
				return getRedeliveryPolicyRef();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_BODY:
				return getUseOriginalBody();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_MESSAGE:
				return getUseOriginalMessage();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__EXCEPTION:
				getException().clear();
				getException().addAll((Collection<? extends String>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN:
				setOnWhen((OnWhenDefinition)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE:
				setRetryWhile((ExpressionSubElementDefinition)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY:
				setRedeliveryPolicy((RedeliveryPolicyDefinition)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED:
				setHandled((ExpressionSubElementDefinition)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED:
				setContinued((ExpressionSubElementDefinition)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__GROUP:
				((FeatureMap.Internal)getGroup()).set(newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__AGGREGATE:
				getAggregate().clear();
				getAggregate().addAll((Collection<? extends AggregateDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__BEAN:
				getBean().clear();
				getBean().addAll((Collection<? extends BeanDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_CATCH:
				getDoCatch().clear();
				getDoCatch().addAll((Collection<? extends CatchDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CHOICE:
				getChoice().clear();
				getChoice().addAll((Collection<? extends ChoiceDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CIRCUIT_BREAKER:
				getCircuitBreaker().clear();
				getCircuitBreaker().addAll((Collection<? extends CircuitBreakerDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CLAIM_CHECK:
				getClaimCheck().clear();
				getClaimCheck().addAll((Collection<? extends ClaimCheckDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_BODY_TO:
				getConvertBodyTo().clear();
				getConvertBodyTo().addAll((Collection<? extends ConvertBodyDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_HEADER_TO:
				getConvertHeaderTo().clear();
				getConvertHeaderTo().addAll((Collection<? extends ConvertHeaderDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_VARIABLE_TO:
				getConvertVariableTo().clear();
				getConvertVariableTo().addAll((Collection<? extends ConvertVariableDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DELAY:
				getDelay().clear();
				getDelay().addAll((Collection<? extends DelayDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DYNAMIC_ROUTER:
				getDynamicRouter().clear();
				getDynamicRouter().addAll((Collection<? extends DynamicRouterDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ENRICH:
				getEnrich().clear();
				getEnrich().addAll((Collection<? extends EnrichDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__FILTER:
				getFilter().clear();
				getFilter().addAll((Collection<? extends FilterDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_FINALLY:
				getDoFinally().clear();
				getDoFinally().addAll((Collection<? extends FinallyDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__IDEMPOTENT_CONSUMER:
				getIdempotentConsumer().clear();
				getIdempotentConsumer().addAll((Collection<? extends IdempotentConsumerDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT:
				getIntercept().clear();
				getIntercept().addAll((Collection<? extends InterceptDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_FROM:
				getInterceptFrom().clear();
				getInterceptFrom().addAll((Collection<? extends InterceptFromDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT:
				getInterceptSendToEndpoint().clear();
				getInterceptSendToEndpoint().addAll((Collection<? extends InterceptSendToEndpointDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__KAMELET:
				getKamelet().clear();
				getKamelet().addAll((Collection<? extends KameletDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOAD_BALANCE:
				getLoadBalance().clear();
				getLoadBalance().addAll((Collection<? extends LoadBalanceDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOG:
				getLog().clear();
				getLog().addAll((Collection<? extends LogDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOOP:
				getLoop().clear();
				getLoop().addAll((Collection<? extends LoopDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MARSHAL:
				getMarshal().clear();
				getMarshal().addAll((Collection<? extends MarshalDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MULTICAST:
				getMulticast().clear();
				getMulticast().addAll((Collection<? extends MulticastDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_COMPLETION:
				getOnCompletion().clear();
				getOnCompletion().addAll((Collection<? extends OnCompletionDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION:
				getOnException().clear();
				getOnException().addAll((Collection<? extends OnExceptionDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PAUSABLE:
				getPausable().clear();
				getPausable().addAll((Collection<? extends PausableDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PIPELINE:
				getPipeline().clear();
				getPipeline().addAll((Collection<? extends PipelineDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLICY:
				getPolicy().clear();
				getPolicy().addAll((Collection<? extends PolicyDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL:
				getPoll().clear();
				getPoll().addAll((Collection<? extends PollDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL_ENRICH:
				getPollEnrich().clear();
				getPollEnrich().addAll((Collection<? extends PollEnrichDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PROCESS:
				getProcess().clear();
				getProcess().addAll((Collection<? extends ProcessDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RECIPIENT_LIST:
				getRecipientList().clear();
				getRecipientList().addAll((Collection<? extends RecipientListDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADER:
				getRemoveHeader().clear();
				getRemoveHeader().addAll((Collection<? extends RemoveHeaderDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADERS:
				getRemoveHeaders().clear();
				getRemoveHeaders().addAll((Collection<? extends RemoveHeadersDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTIES:
				getRemoveProperties().clear();
				getRemoveProperties().addAll((Collection<? extends RemovePropertiesDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTY:
				getRemoveProperty().clear();
				getRemoveProperty().addAll((Collection<? extends RemovePropertyDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_VARIABLE:
				getRemoveVariable().clear();
				getRemoveVariable().addAll((Collection<? extends RemoveVariableDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESEQUENCE:
				getResequence().clear();
				getResequence().addAll((Collection<? extends ResequenceDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESUMABLE:
				getResumable().clear();
				getResumable().addAll((Collection<? extends ResumableDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROLLBACK:
				getRollback().clear();
				getRollback().addAll((Collection<? extends RollbackDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTE:
				getRoute().clear();
				getRoute().addAll((Collection<? extends RouteDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTING_SLIP:
				getRoutingSlip().clear();
				getRoutingSlip().addAll((Collection<? extends RoutingSlipDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAGA:
				getSaga().clear();
				getSaga().addAll((Collection<? extends SagaDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAMPLE:
				getSample().clear();
				getSample().addAll((Collection<? extends SamplingDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SCRIPT:
				getScript().clear();
				getScript().addAll((Collection<? extends ScriptDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_BODY:
				getSetBody().clear();
				getSetBody().addAll((Collection<? extends SetBodyDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_EXCHANGE_PATTERN:
				getSetExchangePattern().clear();
				getSetExchangePattern().addAll((Collection<? extends SetExchangePatternDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADER:
				getSetHeader().clear();
				getSetHeader().addAll((Collection<? extends SetHeaderDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADERS:
				getSetHeaders().clear();
				getSetHeaders().addAll((Collection<? extends SetHeadersDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_PROPERTY:
				getSetProperty().clear();
				getSetProperty().addAll((Collection<? extends SetPropertyDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLE:
				getSetVariable().clear();
				getSetVariable().addAll((Collection<? extends SetVariableDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLES:
				getSetVariables().clear();
				getSetVariables().addAll((Collection<? extends SetVariablesDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SORT:
				getSort().clear();
				getSort().addAll((Collection<? extends SortDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SPLIT:
				getSplit().clear();
				getSplit().addAll((Collection<? extends SplitDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STEP:
				getStep().clear();
				getStep().addAll((Collection<? extends StepDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STOP:
				getStop().clear();
				getStop().addAll((Collection<? extends StopDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THREADS:
				getThreads().clear();
				getThreads().addAll((Collection<? extends ThreadsDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROTTLE:
				getThrottle().clear();
				getThrottle().addAll((Collection<? extends ThrottleDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROW_EXCEPTION:
				getThrowException().clear();
				getThrowException().addAll((Collection<? extends ThrowExceptionDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO:
				getTo().clear();
				getTo().addAll((Collection<? extends ToDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO_D:
				getToD().clear();
				getToD().addAll((Collection<? extends ToDynamicDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TOKENIZER:
				getTokenizer().clear();
				getTokenizer().addAll((Collection<? extends TokenizerDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSACTED:
				getTransacted().clear();
				getTransacted().addAll((Collection<? extends TransactedDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSFORM:
				getTransform().clear();
				getTransform().addAll((Collection<? extends TransformDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_TRY:
				getDoTry().clear();
				getDoTry().addAll((Collection<? extends TryDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__UNMARSHAL:
				getUnmarshal().clear();
				getUnmarshal().addAll((Collection<? extends UnmarshalDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__VALIDATE:
				getValidate().clear();
				getValidate().addAll((Collection<? extends ValidateDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__WIRE_TAP:
				getWireTap().clear();
				getWireTap().addAll((Collection<? extends WireTapDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SERVICE_CALL:
				getServiceCall().clear();
				getServiceCall().addAll((Collection<? extends ServiceCallDefinition>)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION_OCCURRED_REF:
				setOnExceptionOccurredRef((String)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_REDELIVERY_REF:
				setOnRedeliveryRef((String)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY_REF:
				setRedeliveryPolicyRef((String)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_BODY:
				setUseOriginalBody((String)newValue);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_MESSAGE:
				setUseOriginalMessage((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__EXCEPTION:
				getException().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN:
				setOnWhen((OnWhenDefinition)null);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE:
				setRetryWhile((ExpressionSubElementDefinition)null);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY:
				setRedeliveryPolicy((RedeliveryPolicyDefinition)null);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED:
				setHandled((ExpressionSubElementDefinition)null);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED:
				setContinued((ExpressionSubElementDefinition)null);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__GROUP:
				getGroup().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__AGGREGATE:
				getAggregate().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__BEAN:
				getBean().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_CATCH:
				getDoCatch().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CHOICE:
				getChoice().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CIRCUIT_BREAKER:
				getCircuitBreaker().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CLAIM_CHECK:
				getClaimCheck().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_BODY_TO:
				getConvertBodyTo().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_HEADER_TO:
				getConvertHeaderTo().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_VARIABLE_TO:
				getConvertVariableTo().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DELAY:
				getDelay().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DYNAMIC_ROUTER:
				getDynamicRouter().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ENRICH:
				getEnrich().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__FILTER:
				getFilter().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_FINALLY:
				getDoFinally().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__IDEMPOTENT_CONSUMER:
				getIdempotentConsumer().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT:
				getIntercept().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_FROM:
				getInterceptFrom().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT:
				getInterceptSendToEndpoint().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__KAMELET:
				getKamelet().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOAD_BALANCE:
				getLoadBalance().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOG:
				getLog().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOOP:
				getLoop().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MARSHAL:
				getMarshal().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MULTICAST:
				getMulticast().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_COMPLETION:
				getOnCompletion().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION:
				getOnException().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PAUSABLE:
				getPausable().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PIPELINE:
				getPipeline().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLICY:
				getPolicy().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL:
				getPoll().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL_ENRICH:
				getPollEnrich().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PROCESS:
				getProcess().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RECIPIENT_LIST:
				getRecipientList().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADER:
				getRemoveHeader().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADERS:
				getRemoveHeaders().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTIES:
				getRemoveProperties().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTY:
				getRemoveProperty().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_VARIABLE:
				getRemoveVariable().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESEQUENCE:
				getResequence().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESUMABLE:
				getResumable().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROLLBACK:
				getRollback().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTE:
				getRoute().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTING_SLIP:
				getRoutingSlip().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAGA:
				getSaga().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAMPLE:
				getSample().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SCRIPT:
				getScript().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_BODY:
				getSetBody().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_EXCHANGE_PATTERN:
				getSetExchangePattern().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADER:
				getSetHeader().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADERS:
				getSetHeaders().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_PROPERTY:
				getSetProperty().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLE:
				getSetVariable().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLES:
				getSetVariables().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SORT:
				getSort().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SPLIT:
				getSplit().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STEP:
				getStep().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STOP:
				getStop().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THREADS:
				getThreads().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROTTLE:
				getThrottle().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROW_EXCEPTION:
				getThrowException().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO:
				getTo().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO_D:
				getToD().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TOKENIZER:
				getTokenizer().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSACTED:
				getTransacted().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSFORM:
				getTransform().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_TRY:
				getDoTry().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__UNMARSHAL:
				getUnmarshal().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__VALIDATE:
				getValidate().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__WIRE_TAP:
				getWireTap().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SERVICE_CALL:
				getServiceCall().clear();
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION_OCCURRED_REF:
				setOnExceptionOccurredRef(ON_EXCEPTION_OCCURRED_REF_EDEFAULT);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_REDELIVERY_REF:
				setOnRedeliveryRef(ON_REDELIVERY_REF_EDEFAULT);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY_REF:
				setRedeliveryPolicyRef(REDELIVERY_POLICY_REF_EDEFAULT);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_BODY:
				setUseOriginalBody(USE_ORIGINAL_BODY_EDEFAULT);
				return;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_MESSAGE:
				setUseOriginalMessage(USE_ORIGINAL_MESSAGE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__EXCEPTION:
				return exception != null && !exception.isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_WHEN:
				return onWhen != null;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RETRY_WHILE:
				return retryWhile != null;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY:
				return redeliveryPolicy != null;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__HANDLED:
				return handled != null;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONTINUED:
				return continued != null;
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__GROUP:
				return group != null && !group.isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__AGGREGATE:
				return !getAggregate().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__BEAN:
				return !getBean().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_CATCH:
				return !getDoCatch().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CHOICE:
				return !getChoice().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CIRCUIT_BREAKER:
				return !getCircuitBreaker().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CLAIM_CHECK:
				return !getClaimCheck().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_BODY_TO:
				return !getConvertBodyTo().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_HEADER_TO:
				return !getConvertHeaderTo().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__CONVERT_VARIABLE_TO:
				return !getConvertVariableTo().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DELAY:
				return !getDelay().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DYNAMIC_ROUTER:
				return !getDynamicRouter().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ENRICH:
				return !getEnrich().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__FILTER:
				return !getFilter().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_FINALLY:
				return !getDoFinally().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__IDEMPOTENT_CONSUMER:
				return !getIdempotentConsumer().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT:
				return !getIntercept().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_FROM:
				return !getInterceptFrom().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__INTERCEPT_SEND_TO_ENDPOINT:
				return !getInterceptSendToEndpoint().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__KAMELET:
				return !getKamelet().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOAD_BALANCE:
				return !getLoadBalance().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOG:
				return !getLog().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__LOOP:
				return !getLoop().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MARSHAL:
				return !getMarshal().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__MULTICAST:
				return !getMulticast().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_COMPLETION:
				return !getOnCompletion().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION:
				return !getOnException().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PAUSABLE:
				return !getPausable().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PIPELINE:
				return !getPipeline().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLICY:
				return !getPolicy().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL:
				return !getPoll().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__POLL_ENRICH:
				return !getPollEnrich().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__PROCESS:
				return !getProcess().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RECIPIENT_LIST:
				return !getRecipientList().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADER:
				return !getRemoveHeader().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_HEADERS:
				return !getRemoveHeaders().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTIES:
				return !getRemoveProperties().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_PROPERTY:
				return !getRemoveProperty().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REMOVE_VARIABLE:
				return !getRemoveVariable().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESEQUENCE:
				return !getResequence().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__RESUMABLE:
				return !getResumable().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROLLBACK:
				return !getRollback().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTE:
				return !getRoute().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ROUTING_SLIP:
				return !getRoutingSlip().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAGA:
				return !getSaga().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SAMPLE:
				return !getSample().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SCRIPT:
				return !getScript().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_BODY:
				return !getSetBody().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_EXCHANGE_PATTERN:
				return !getSetExchangePattern().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADER:
				return !getSetHeader().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_HEADERS:
				return !getSetHeaders().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_PROPERTY:
				return !getSetProperty().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLE:
				return !getSetVariable().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SET_VARIABLES:
				return !getSetVariables().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SORT:
				return !getSort().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SPLIT:
				return !getSplit().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STEP:
				return !getStep().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__STOP:
				return !getStop().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THREADS:
				return !getThreads().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROTTLE:
				return !getThrottle().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__THROW_EXCEPTION:
				return !getThrowException().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO:
				return !getTo().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TO_D:
				return !getToD().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TOKENIZER:
				return !getTokenizer().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSACTED:
				return !getTransacted().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__TRANSFORM:
				return !getTransform().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__DO_TRY:
				return !getDoTry().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__UNMARSHAL:
				return !getUnmarshal().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__VALIDATE:
				return !getValidate().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__WIRE_TAP:
				return !getWireTap().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__SERVICE_CALL:
				return !getServiceCall().isEmpty();
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_EXCEPTION_OCCURRED_REF:
				return ON_EXCEPTION_OCCURRED_REF_EDEFAULT == null ? onExceptionOccurredRef != null : !ON_EXCEPTION_OCCURRED_REF_EDEFAULT.equals(onExceptionOccurredRef);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__ON_REDELIVERY_REF:
				return ON_REDELIVERY_REF_EDEFAULT == null ? onRedeliveryRef != null : !ON_REDELIVERY_REF_EDEFAULT.equals(onRedeliveryRef);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__REDELIVERY_POLICY_REF:
				return REDELIVERY_POLICY_REF_EDEFAULT == null ? redeliveryPolicyRef != null : !REDELIVERY_POLICY_REF_EDEFAULT.equals(redeliveryPolicyRef);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_BODY:
				return USE_ORIGINAL_BODY_EDEFAULT == null ? useOriginalBody != null : !USE_ORIGINAL_BODY_EDEFAULT.equals(useOriginalBody);
			case CamelSpringPackage.ON_EXCEPTION_DEFINITION__USE_ORIGINAL_MESSAGE:
				return USE_ORIGINAL_MESSAGE_EDEFAULT == null ? useOriginalMessage != null : !USE_ORIGINAL_MESSAGE_EDEFAULT.equals(useOriginalMessage);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (exception: ");
		result.append(exception);
		result.append(", group: ");
		result.append(group);
		result.append(", onExceptionOccurredRef: ");
		result.append(onExceptionOccurredRef);
		result.append(", onRedeliveryRef: ");
		result.append(onRedeliveryRef);
		result.append(", redeliveryPolicyRef: ");
		result.append(redeliveryPolicyRef);
		result.append(", useOriginalBody: ");
		result.append(useOriginalBody);
		result.append(", useOriginalMessage: ");
		result.append(useOriginalMessage);
		result.append(')');
		return result.toString();
	}

} //OnExceptionDefinitionImpl
