/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.fennec.camel.camelspring.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.camel.camelspring.CamelSpringPackage;
import org.eclipse.fennec.camel.camelspring.RouteTemplateDefinition;
import org.eclipse.fennec.camel.camelspring.RouteTemplatesDefinition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Route Templates Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.camel.camelspring.impl.RouteTemplatesDefinitionImpl#getRouteTemplate <em>Route Template</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RouteTemplatesDefinitionImpl extends OptionalIdentifiedDefinitionImpl implements RouteTemplatesDefinition {
	/**
	 * The cached value of the '{@link #getRouteTemplate() <em>Route Template</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRouteTemplate()
	 * @generated
	 * @ordered
	 */
	protected EList<RouteTemplateDefinition> routeTemplate;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RouteTemplatesDefinitionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CamelSpringPackage.eINSTANCE.getRouteTemplatesDefinition();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RouteTemplateDefinition> getRouteTemplate() {
		if (routeTemplate == null) {
			routeTemplate = new EObjectContainmentEList<RouteTemplateDefinition>(RouteTemplateDefinition.class, this, CamelSpringPackage.ROUTE_TEMPLATES_DEFINITION__ROUTE_TEMPLATE);
		}
		return routeTemplate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CamelSpringPackage.ROUTE_TEMPLATES_DEFINITION__ROUTE_TEMPLATE:
				return ((InternalEList<?>)getRouteTemplate()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CamelSpringPackage.ROUTE_TEMPLATES_DEFINITION__ROUTE_TEMPLATE:
				return getRouteTemplate();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CamelSpringPackage.ROUTE_TEMPLATES_DEFINITION__ROUTE_TEMPLATE:
				getRouteTemplate().clear();
				getRouteTemplate().addAll((Collection<? extends RouteTemplateDefinition>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CamelSpringPackage.ROUTE_TEMPLATES_DEFINITION__ROUTE_TEMPLATE:
				getRouteTemplate().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CamelSpringPackage.ROUTE_TEMPLATES_DEFINITION__ROUTE_TEMPLATE:
				return routeTemplate != null && !routeTemplate.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //RouteTemplatesDefinitionImpl
