/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package de.jena.mdo.emf.common.configurator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;

/**
 * A {@link PrototypeServiceFactory} that provides a Copy of the provided {@link EObject}
 * @author Juergen Albert
 * @since 13 Jan 2025
 */
public class PrototypeEObjectServiceFactory<S extends EObject> implements PrototypeServiceFactory<S> {

	
	private S eObject;

	public PrototypeEObjectServiceFactory(S eObject) {
		this.eObject = eObject;
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.PrototypeServiceFactory#getService(org.osgi.framework.Bundle, org.osgi.framework.ServiceRegistration)
	 */
	@Override
	public S getService(Bundle bundle, ServiceRegistration<S> registration) {
		return (S) EcoreUtil.copy(eObject);
	}

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.PrototypeServiceFactory#ungetService(org.osgi.framework.Bundle, org.osgi.framework.ServiceRegistration, java.lang.Object)
	 */
	@Override
	public void ungetService(Bundle bundle, ServiceRegistration<S> registration, S service) {
	}

}
