/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Entity Mapping Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Configuration for mapping EMF EClass to NGSI-LD Entity structure.
 * 
 * Defines how attributes and references from the source EClass are transformed into NGSI-LD properties and relationships. Supports automatic synchronization and custom mapping rules.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getSourceEClass <em>Source EClass</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getPropertyMappings <em>Property Mappings</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getRelationshipMappings <em>Relationship Mappings</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.EntityMappingConfiguration#isAutoSync <em>Auto Sync</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.NGSIPackage#getEntityMappingConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface EntityMappingConfiguration extends EObject {
	/**
	 * Returns the value of the '<em><b>Source EClass</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The source EMF EClass that is being mapped to NGSI-LD.
	 * 
	 * This defines the metamodel class whose instances will be wrapped in NGSI-LD structure.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Source EClass</em>' reference.
	 * @see #setSourceEClass(EClass)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getEntityMappingConfiguration_SourceEClass()
	 * @model required="true"
	 * @generated
	 */
	EClass getSourceEClass();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getSourceEClass <em>Source EClass</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source EClass</em>' reference.
	 * @see #getSourceEClass()
	 * @generated
	 */
	void setSourceEClass(EClass value);

	/**
	 * Returns the value of the '<em><b>Property Mappings</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.PropertyMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of mappings from EAttributes to NGSI-LD Properties.
	 * 
	 * Each mapping defines how a specific EAttribute should be transformed into an NGSI-LD property.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Property Mappings</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.NGSIPackage#getEntityMappingConfiguration_PropertyMappings()
	 * @model containment="true"
	 * @generated
	 */
	EList<PropertyMapping> getPropertyMappings();

	/**
	 * Returns the value of the '<em><b>Relationship Mappings</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.RelationshipMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of mappings from EReferences to NGSI-LD Relationships.
	 * 
	 * Each mapping defines how a specific EReference should be transformed into an NGSI-LD relationship.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Relationship Mappings</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.NGSIPackage#getEntityMappingConfiguration_RelationshipMappings()
	 * @model containment="true"
	 * @generated
	 */
	EList<RelationshipMapping> getRelationshipMappings();

	/**
	 * Returns the value of the '<em><b>Auto Sync</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Enable automatic synchronization between EObject and NGSI-LD structure.
	 * 
	 * When true, changes to the wrapped EObject automatically update the corresponding NGSI-LD properties and relationships.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Auto Sync</em>' attribute.
	 * @see #setAutoSync(boolean)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getEntityMappingConfiguration_AutoSync()
	 * @model default="true"
	 * @generated
	 */
	boolean isAutoSync();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.EntityMappingConfiguration#isAutoSync <em>Auto Sync</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Auto Sync</em>' attribute.
	 * @see #isAutoSync()
	 * @generated
	 */
	void setAutoSync(boolean value);

} // EntityMappingConfiguration
