/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Container</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Root container for NGSI-LD entities and subscriptions.
 * 
 * This class serves as the top-level container that holds all NGSI-LD entities and their associated subscriptions. It provides the entry point for managing NGSI-LD data models within an EMF-based application.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.NGSIContainer#getEntities <em>Entities</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIContainer#getSubscriptions <em>Subscriptions</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIContainer()
 * @model
 * @generated
 */
@ProviderType
public interface NGSIContainer extends EObject {
	/**
	 * Returns the value of the '<em><b>Entities</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.NGSIEntity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of NGSI-LD entities contained in this container.
	 * 
	 * Each entity represents a real-world object or concept that has been wrapped in NGSI-LD compliant structure.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Entities</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIContainer_Entities()
	 * @model containment="true"
	 * @generated
	 */
	EList<NGSIEntity> getEntities();

	/**
	 * Returns the value of the '<em><b>Subscriptions</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.NGSISubscription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of NGSI-LD subscriptions for monitoring entity changes.
	 * 
	 * Subscriptions allow clients to receive notifications when specific entities or their attributes change.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Subscriptions</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIContainer_Subscriptions()
	 * @model containment="true"
	 * @generated
	 */
	EList<NGSISubscription> getSubscriptions();

} // NGSIContainer
