/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import java.util.Date;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Entity</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Main NGSI-LD Entity wrapper class.
 * 
 * This class wraps any EMF EObject in NGSI-LD compliant structure, providing properties, relationships, and temporal information. It maintains a bidirectional link to the original EObject while exposing NGSI-LD semantics.
 * 
 * Conforms to ETSI GS CIM 009 Entity specification.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getType <em>Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getWrappedObject <em>Wrapped Object</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getRelationships <em>Relationships</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getContext <em>Context</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getCreatedAt <em>Created At</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getModifiedAt <em>Modified At</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.NGSIEntity#getMappingConfiguration <em>Mapping Configuration</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity()
 * @model
 * @generated
 */
@ProviderType
public interface NGSIEntity extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier for the NGSI-LD entity.
	 * 
	 * Must be a valid URI. Typically follows the pattern 'urn:ngsi-ld:EntityType:uniqueId' as specified in NGSI-LD specification.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_Id()
	 * @model required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Type of the NGSI-LD entity.
	 * 
	 * Defines the semantic type of the entity. Should preferably be a URI that references a well-known vocabulary or ontology.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_Type()
	 * @model required="true"
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Wrapped Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to the original EMF EObject being wrapped.
	 * 
	 * This maintains the link to the source object, allowing for bidirectional synchronization and unwrapping operations.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Wrapped Object</em>' reference.
	 * @see #setWrappedObject(EObject)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_WrappedObject()
	 * @model
	 * @generated
	 */
	EObject getWrappedObject();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getWrappedObject <em>Wrapped Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Wrapped Object</em>' reference.
	 * @see #getWrappedObject()
	 * @generated
	 */
	void setWrappedObject(EObject value);

	/**
	 * Returns the value of the '<em><b>Properties</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.NGSIProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of NGSI-LD Properties associated with this entity.
	 * 
	 * Properties represent attributes or characteristics of the entity. Each property has a value, type, and optional metadata.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Properties</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_Properties()
	 * @model containment="true"
	 * @generated
	 */
	EList<NGSIProperty> getProperties();

	/**
	 * Returns the value of the '<em><b>Relationships</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.NGSIRelationship}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of NGSI-LD Relationships to other entities.
	 * 
	 * Relationships define connections between entities, representing semantic links in the data model.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Relationships</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_Relationships()
	 * @model containment="true"
	 * @generated
	 */
	EList<NGSIRelationship> getRelationships();

	/**
	 * Returns the value of the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * JSON-LD context information for this entity.
	 * 
	 * Provides the semantic context for interpreting property and relationship names as URIs.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Context</em>' reference.
	 * @see #setContext(NGSIContext)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_Context()
	 * @model
	 * @generated
	 */
	NGSIContext getContext();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getContext <em>Context</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Context</em>' reference.
	 * @see #getContext()
	 * @generated
	 */
	void setContext(NGSIContext value);

	/**
	 * Returns the value of the '<em><b>Created At</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Timestamp when the entity was created.
	 * 
	 * Automatically set when the entity is first created. Follows ISO 8601 format.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Created At</em>' attribute.
	 * @see #setCreatedAt(Date)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_CreatedAt()
	 * @model
	 * @generated
	 */
	Date getCreatedAt();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getCreatedAt <em>Created At</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Created At</em>' attribute.
	 * @see #getCreatedAt()
	 * @generated
	 */
	void setCreatedAt(Date value);

	/**
	 * Returns the value of the '<em><b>Modified At</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Timestamp when the entity was last modified.
	 * 
	 * Automatically updated when properties or relationships change. Follows ISO 8601 format.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Modified At</em>' attribute.
	 * @see #setModifiedAt(Date)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_ModifiedAt()
	 * @model
	 * @generated
	 */
	Date getModifiedAt();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getModifiedAt <em>Modified At</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Modified At</em>' attribute.
	 * @see #getModifiedAt()
	 * @generated
	 */
	void setModifiedAt(Date value);

	/**
	 * Returns the value of the '<em><b>Mapping Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Configuration for mapping between EMF EObject and NGSI-LD structure.
	 * 
	 * Defines how EObject attributes and references are mapped to NGSI-LD properties and relationships.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Mapping Configuration</em>' containment reference.
	 * @see #setMappingConfiguration(EntityMappingConfiguration)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIEntity_MappingConfiguration()
	 * @model containment="true"
	 * @generated
	 */
	EntityMappingConfiguration getMappingConfiguration();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.NGSIEntity#getMappingConfiguration <em>Mapping Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mapping Configuration</em>' containment reference.
	 * @see #getMappingConfiguration()
	 * @generated
	 */
	void setMappingConfiguration(EntityMappingConfiguration value);

} // NGSIEntity
