/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.gecko.emf.ngsi.NGSIPackage
 * @generated
 */
@ProviderType
public interface NGSIFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	NGSIFactory eINSTANCE = org.gecko.emf.ngsi.impl.NGSIFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Container</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Container</em>'.
	 * @generated
	 */
	NGSIContainer createNGSIContainer();

	/**
	 * Returns a new object of class '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Entity</em>'.
	 * @generated
	 */
	NGSIEntity createNGSIEntity();

	/**
	 * Returns a new object of class '<em>Entity Mapping Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Entity Mapping Configuration</em>'.
	 * @generated
	 */
	EntityMappingConfiguration createEntityMappingConfiguration();

	/**
	 * Returns a new object of class '<em>Property Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Mapping</em>'.
	 * @generated
	 */
	PropertyMapping createPropertyMapping();

	/**
	 * Returns a new object of class '<em>Relationship Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Relationship Mapping</em>'.
	 * @generated
	 */
	RelationshipMapping createRelationshipMapping();

	/**
	 * Returns a new object of class '<em>Property</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property</em>'.
	 * @generated
	 */
	NGSIProperty createNGSIProperty();

	/**
	 * Returns a new object of class '<em>Relationship</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Relationship</em>'.
	 * @generated
	 */
	NGSIRelationship createNGSIRelationship();

	/**
	 * Returns a new object of class '<em>Context</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Context</em>'.
	 * @generated
	 */
	NGSIContext createNGSIContext();

	/**
	 * Returns a new object of class '<em>Context Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Context Mapping</em>'.
	 * @generated
	 */
	ContextMapping createContextMapping();

	/**
	 * Returns a new object of class '<em>Subscription</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Subscription</em>'.
	 * @generated
	 */
	NGSISubscription createNGSISubscription();

	/**
	 * Returns a new object of class '<em>Entity Info</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Entity Info</em>'.
	 * @generated
	 */
	EntityInfo createEntityInfo();

	/**
	 * Returns a new object of class '<em>Notification Params</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Notification Params</em>'.
	 * @generated
	 */
	NotificationParams createNotificationParams();

	/**
	 * Returns a new object of class '<em>Subscription Condition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Subscription Condition</em>'.
	 * @generated
	 */
	SubscriptionCondition createSubscriptionCondition();

	/**
	 * Returns a new object of class '<em>Date Time Converter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Date Time Converter</em>'.
	 * @generated
	 */
	DateTimeConverter createDateTimeConverter();

	/**
	 * Returns a new object of class '<em>Enum Converter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Enum Converter</em>'.
	 * @generated
	 */
	EnumConverter createEnumConverter();

	/**
	 * Returns a new object of class '<em>Custom Converter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Converter</em>'.
	 * @generated
	 */
	CustomConverter createCustomConverter();

	/**
	 * Returns a new object of class '<em>String Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Value</em>'.
	 * @generated
	 */
	NGSIStringValue createNGSIStringValue();

	/**
	 * Returns a new object of class '<em>Number Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Number Value</em>'.
	 * @generated
	 */
	NGSINumberValue createNGSINumberValue();

	/**
	 * Returns a new object of class '<em>Boolean Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Value</em>'.
	 * @generated
	 */
	NGSIBooleanValue createNGSIBooleanValue();

	/**
	 * Returns a new object of class '<em>Object Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Object Value</em>'.
	 * @generated
	 */
	NGSIObjectValue createNGSIObjectValue();

	/**
	 * Returns a new object of class '<em>Array Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Value</em>'.
	 * @generated
	 */
	NGSIArrayValue createNGSIArrayValue();

	/**
	 * Returns a new object of class '<em>Geo Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geo Value</em>'.
	 * @generated
	 */
	NGSIGeoValue createNGSIGeoValue();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	NGSIPackage getNGSIPackage();

} //NGSIFactory
