/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * NGSI-LD Wrapper Model
 * 
 * This model provides a complete EMF-based wrapper for NGSI-LD entities, allowing any EObject to be wrapped in NGSI-LD compliant structure. It supports entity mapping, property synchronization, subscriptions, and multi-protocol notifications.
 * 
 * Based on ETSI GS CIM 009 NGSI-LD API specification.
 * <!-- end-model-doc -->
 * @see org.gecko.emf.ngsi.NGSIFactory
 * @model kind="package"
 * @generated
 */
@ProviderType
@EPackage(uri = NGSIPackage.eNS_URI, genModel = "/model/ngsi.genmodel", genModelSourceLocations = {"model/ngsi.genmodel","org.gecko.emf.ngsi/model/ngsi.genmodel"}, ecore="/model/ngsi-wrapper.ecore", ecoreSourceLocations="/model/ngsi-wrapper.ecore")
public interface NGSIPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "ngsi";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "https://uri.etsi.org/ngsi-ld/v1/";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "ngsi";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	NGSIPackage eINSTANCE = org.gecko.emf.ngsi.impl.NGSIPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIContainerImpl <em>Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIContainerImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIContainer()
	 * @generated
	 */
	int NGSI_CONTAINER = 0;

	/**
	 * The feature id for the '<em><b>Entities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_CONTAINER__ENTITIES = 0;

	/**
	 * The feature id for the '<em><b>Subscriptions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_CONTAINER__SUBSCRIPTIONS = 1;

	/**
	 * The number of structural features of the '<em>Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_CONTAINER_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_CONTAINER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl <em>Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIEntityImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIEntity()
	 * @generated
	 */
	int NGSI_ENTITY = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__ID = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Wrapped Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__WRAPPED_OBJECT = 2;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__PROPERTIES = 3;

	/**
	 * The feature id for the '<em><b>Relationships</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__RELATIONSHIPS = 4;

	/**
	 * The feature id for the '<em><b>Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__CONTEXT = 5;

	/**
	 * The feature id for the '<em><b>Created At</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__CREATED_AT = 6;

	/**
	 * The feature id for the '<em><b>Modified At</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__MODIFIED_AT = 7;

	/**
	 * The feature id for the '<em><b>Mapping Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY__MAPPING_CONFIGURATION = 8;

	/**
	 * The number of structural features of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY_FEATURE_COUNT = 9;

	/**
	 * The number of operations of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ENTITY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl <em>Entity Mapping Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getEntityMappingConfiguration()
	 * @generated
	 */
	int ENTITY_MAPPING_CONFIGURATION = 2;

	/**
	 * The feature id for the '<em><b>Source EClass</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS = 0;

	/**
	 * The feature id for the '<em><b>Property Mappings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS = 1;

	/**
	 * The feature id for the '<em><b>Relationship Mappings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS = 2;

	/**
	 * The feature id for the '<em><b>Auto Sync</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC = 3;

	/**
	 * The number of structural features of the '<em>Entity Mapping Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MAPPING_CONFIGURATION_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Entity Mapping Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_MAPPING_CONFIGURATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl <em>Property Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.PropertyMappingImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getPropertyMapping()
	 * @generated
	 */
	int PROPERTY_MAPPING = 3;

	/**
	 * The feature id for the '<em><b>Source Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING__SOURCE_ATTRIBUTE = 0;

	/**
	 * The feature id for the '<em><b>Target Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING__TARGET_PROPERTY = 1;

	/**
	 * The feature id for the '<em><b>Custom Property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME = 2;

	/**
	 * The feature id for the '<em><b>Include In NGSI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING__INCLUDE_IN_NGSI = 3;

	/**
	 * The feature id for the '<em><b>Value Converter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING__VALUE_CONVERTER = 4;

	/**
	 * The number of structural features of the '<em>Property Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Property Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_MAPPING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.RelationshipMappingImpl <em>Relationship Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.RelationshipMappingImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getRelationshipMapping()
	 * @generated
	 */
	int RELATIONSHIP_MAPPING = 4;

	/**
	 * The feature id for the '<em><b>Source Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_MAPPING__SOURCE_REFERENCE = 0;

	/**
	 * The feature id for the '<em><b>Target Relationship</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP = 1;

	/**
	 * The feature id for the '<em><b>Custom Relationship Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME = 2;

	/**
	 * The feature id for the '<em><b>Include In NGSI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI = 3;

	/**
	 * The number of structural features of the '<em>Relationship Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_MAPPING_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Relationship Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_MAPPING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIPropertyImpl <em>Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIPropertyImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIProperty()
	 * @generated
	 */
	int NGSI_PROPERTY = 5;

	/**
	 * The number of structural features of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_PROPERTY_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIRelationshipImpl <em>Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIRelationshipImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIRelationship()
	 * @generated
	 */
	int NGSI_RELATIONSHIP = 6;

	/**
	 * The number of structural features of the '<em>Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_RELATIONSHIP_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_RELATIONSHIP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIContextImpl <em>Context</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIContextImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIContext()
	 * @generated
	 */
	int NGSI_CONTEXT = 7;

	/**
	 * The number of structural features of the '<em>Context</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_CONTEXT_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Context</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_CONTEXT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.ContextMappingImpl <em>Context Mapping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.ContextMappingImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getContextMapping()
	 * @generated
	 */
	int CONTEXT_MAPPING = 8;

	/**
	 * The number of structural features of the '<em>Context Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_MAPPING_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Context Mapping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_MAPPING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSISubscriptionImpl <em>Subscription</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSISubscriptionImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSISubscription()
	 * @generated
	 */
	int NGSI_SUBSCRIPTION = 9;

	/**
	 * The number of structural features of the '<em>Subscription</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_SUBSCRIPTION_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Subscription</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_SUBSCRIPTION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.EntityInfoImpl <em>Entity Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.EntityInfoImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getEntityInfo()
	 * @generated
	 */
	int ENTITY_INFO = 10;

	/**
	 * The number of structural features of the '<em>Entity Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_INFO_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Entity Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_INFO_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NotificationParamsImpl <em>Notification Params</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NotificationParamsImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNotificationParams()
	 * @generated
	 */
	int NOTIFICATION_PARAMS = 11;

	/**
	 * The number of structural features of the '<em>Notification Params</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_PARAMS_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Notification Params</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_PARAMS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.SubscriptionConditionImpl <em>Subscription Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.SubscriptionConditionImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getSubscriptionCondition()
	 * @generated
	 */
	int SUBSCRIPTION_CONDITION = 12;

	/**
	 * The number of structural features of the '<em>Subscription Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSCRIPTION_CONDITION_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Subscription Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBSCRIPTION_CONDITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl <em>Protocol Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getProtocolConfiguration()
	 * @generated
	 */
	int PROTOCOL_CONFIGURATION = 13;

	/**
	 * The number of structural features of the '<em>Protocol Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_CONFIGURATION_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Protocol Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_CONFIGURATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.ValueConverterImpl <em>Value Converter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.ValueConverterImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getValueConverter()
	 * @generated
	 */
	int VALUE_CONVERTER = 14;

	/**
	 * The number of structural features of the '<em>Value Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_CONVERTER_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Value Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VALUE_CONVERTER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.DateTimeConverterImpl <em>Date Time Converter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.DateTimeConverterImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getDateTimeConverter()
	 * @generated
	 */
	int DATE_TIME_CONVERTER = 15;

	/**
	 * The number of structural features of the '<em>Date Time Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE_TIME_CONVERTER_FEATURE_COUNT = VALUE_CONVERTER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Date Time Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE_TIME_CONVERTER_OPERATION_COUNT = VALUE_CONVERTER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.EnumConverterImpl <em>Enum Converter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.EnumConverterImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getEnumConverter()
	 * @generated
	 */
	int ENUM_CONVERTER = 16;

	/**
	 * The number of structural features of the '<em>Enum Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_CONVERTER_FEATURE_COUNT = VALUE_CONVERTER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Enum Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUM_CONVERTER_OPERATION_COUNT = VALUE_CONVERTER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.CustomConverterImpl <em>Custom Converter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.CustomConverterImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getCustomConverter()
	 * @generated
	 */
	int CUSTOM_CONVERTER = 17;

	/**
	 * The number of structural features of the '<em>Custom Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_CONVERTER_FEATURE_COUNT = VALUE_CONVERTER_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Custom Converter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOM_CONVERTER_OPERATION_COUNT = VALUE_CONVERTER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIValueImpl <em>Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIValue()
	 * @generated
	 */
	int NGSI_VALUE = 18;

	/**
	 * The number of structural features of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_VALUE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_VALUE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIStringValueImpl <em>String Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIStringValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIStringValue()
	 * @generated
	 */
	int NGSI_STRING_VALUE = 19;

	/**
	 * The number of structural features of the '<em>String Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_STRING_VALUE_FEATURE_COUNT = NGSI_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>String Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_STRING_VALUE_OPERATION_COUNT = NGSI_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSINumberValueImpl <em>Number Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSINumberValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSINumberValue()
	 * @generated
	 */
	int NGSI_NUMBER_VALUE = 20;

	/**
	 * The number of structural features of the '<em>Number Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_NUMBER_VALUE_FEATURE_COUNT = NGSI_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Number Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_NUMBER_VALUE_OPERATION_COUNT = NGSI_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIBooleanValueImpl <em>Boolean Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIBooleanValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIBooleanValue()
	 * @generated
	 */
	int NGSI_BOOLEAN_VALUE = 21;

	/**
	 * The number of structural features of the '<em>Boolean Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_BOOLEAN_VALUE_FEATURE_COUNT = NGSI_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Boolean Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_BOOLEAN_VALUE_OPERATION_COUNT = NGSI_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIObjectValueImpl <em>Object Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIObjectValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIObjectValue()
	 * @generated
	 */
	int NGSI_OBJECT_VALUE = 22;

	/**
	 * The number of structural features of the '<em>Object Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_OBJECT_VALUE_FEATURE_COUNT = NGSI_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Object Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_OBJECT_VALUE_OPERATION_COUNT = NGSI_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIArrayValueImpl <em>Array Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIArrayValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIArrayValue()
	 * @generated
	 */
	int NGSI_ARRAY_VALUE = 23;

	/**
	 * The number of structural features of the '<em>Array Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ARRAY_VALUE_FEATURE_COUNT = NGSI_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Array Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_ARRAY_VALUE_OPERATION_COUNT = NGSI_VALUE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.emf.ngsi.impl.NGSIGeoValueImpl <em>Geo Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.emf.ngsi.impl.NGSIGeoValueImpl
	 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIGeoValue()
	 * @generated
	 */
	int NGSI_GEO_VALUE = 24;

	/**
	 * The number of structural features of the '<em>Geo Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_GEO_VALUE_FEATURE_COUNT = NGSI_VALUE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Geo Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NGSI_GEO_VALUE_OPERATION_COUNT = NGSI_VALUE_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIContainer <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Container</em>'.
	 * @see org.gecko.emf.ngsi.NGSIContainer
	 * @generated
	 */
	EClass getNGSIContainer();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.NGSIContainer#getEntities <em>Entities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Entities</em>'.
	 * @see org.gecko.emf.ngsi.NGSIContainer#getEntities()
	 * @see #getNGSIContainer()
	 * @generated
	 */
	EReference getNGSIContainer_Entities();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.NGSIContainer#getSubscriptions <em>Subscriptions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Subscriptions</em>'.
	 * @see org.gecko.emf.ngsi.NGSIContainer#getSubscriptions()
	 * @see #getNGSIContainer()
	 * @generated
	 */
	EReference getNGSIContainer_Subscriptions();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIEntity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity
	 * @generated
	 */
	EClass getNGSIEntity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.NGSIEntity#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getId()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EAttribute getNGSIEntity_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.NGSIEntity#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getType()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EAttribute getNGSIEntity_Type();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.NGSIEntity#getWrappedObject <em>Wrapped Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Wrapped Object</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getWrappedObject()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EReference getNGSIEntity_WrappedObject();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.NGSIEntity#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getProperties()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EReference getNGSIEntity_Properties();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.NGSIEntity#getRelationships <em>Relationships</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Relationships</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getRelationships()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EReference getNGSIEntity_Relationships();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.NGSIEntity#getContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Context</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getContext()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EReference getNGSIEntity_Context();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.NGSIEntity#getCreatedAt <em>Created At</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Created At</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getCreatedAt()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EAttribute getNGSIEntity_CreatedAt();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.NGSIEntity#getModifiedAt <em>Modified At</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Modified At</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getModifiedAt()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EAttribute getNGSIEntity_ModifiedAt();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.emf.ngsi.NGSIEntity#getMappingConfiguration <em>Mapping Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mapping Configuration</em>'.
	 * @see org.gecko.emf.ngsi.NGSIEntity#getMappingConfiguration()
	 * @see #getNGSIEntity()
	 * @generated
	 */
	EReference getNGSIEntity_MappingConfiguration();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.EntityMappingConfiguration <em>Entity Mapping Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Mapping Configuration</em>'.
	 * @see org.gecko.emf.ngsi.EntityMappingConfiguration
	 * @generated
	 */
	EClass getEntityMappingConfiguration();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getSourceEClass <em>Source EClass</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source EClass</em>'.
	 * @see org.gecko.emf.ngsi.EntityMappingConfiguration#getSourceEClass()
	 * @see #getEntityMappingConfiguration()
	 * @generated
	 */
	EReference getEntityMappingConfiguration_SourceEClass();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getPropertyMappings <em>Property Mappings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Property Mappings</em>'.
	 * @see org.gecko.emf.ngsi.EntityMappingConfiguration#getPropertyMappings()
	 * @see #getEntityMappingConfiguration()
	 * @generated
	 */
	EReference getEntityMappingConfiguration_PropertyMappings();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.emf.ngsi.EntityMappingConfiguration#getRelationshipMappings <em>Relationship Mappings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Relationship Mappings</em>'.
	 * @see org.gecko.emf.ngsi.EntityMappingConfiguration#getRelationshipMappings()
	 * @see #getEntityMappingConfiguration()
	 * @generated
	 */
	EReference getEntityMappingConfiguration_RelationshipMappings();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.EntityMappingConfiguration#isAutoSync <em>Auto Sync</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Auto Sync</em>'.
	 * @see org.gecko.emf.ngsi.EntityMappingConfiguration#isAutoSync()
	 * @see #getEntityMappingConfiguration()
	 * @generated
	 */
	EAttribute getEntityMappingConfiguration_AutoSync();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.PropertyMapping <em>Property Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property Mapping</em>'.
	 * @see org.gecko.emf.ngsi.PropertyMapping
	 * @generated
	 */
	EClass getPropertyMapping();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.PropertyMapping#getSourceAttribute <em>Source Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source Attribute</em>'.
	 * @see org.gecko.emf.ngsi.PropertyMapping#getSourceAttribute()
	 * @see #getPropertyMapping()
	 * @generated
	 */
	EReference getPropertyMapping_SourceAttribute();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.PropertyMapping#getTargetProperty <em>Target Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Property</em>'.
	 * @see org.gecko.emf.ngsi.PropertyMapping#getTargetProperty()
	 * @see #getPropertyMapping()
	 * @generated
	 */
	EReference getPropertyMapping_TargetProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.PropertyMapping#getCustomPropertyName <em>Custom Property Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Custom Property Name</em>'.
	 * @see org.gecko.emf.ngsi.PropertyMapping#getCustomPropertyName()
	 * @see #getPropertyMapping()
	 * @generated
	 */
	EAttribute getPropertyMapping_CustomPropertyName();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.PropertyMapping#isIncludeInNGSI <em>Include In NGSI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Include In NGSI</em>'.
	 * @see org.gecko.emf.ngsi.PropertyMapping#isIncludeInNGSI()
	 * @see #getPropertyMapping()
	 * @generated
	 */
	EAttribute getPropertyMapping_IncludeInNGSI();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.PropertyMapping#getValueConverter <em>Value Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Value Converter</em>'.
	 * @see org.gecko.emf.ngsi.PropertyMapping#getValueConverter()
	 * @see #getPropertyMapping()
	 * @generated
	 */
	EReference getPropertyMapping_ValueConverter();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.RelationshipMapping <em>Relationship Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Relationship Mapping</em>'.
	 * @see org.gecko.emf.ngsi.RelationshipMapping
	 * @generated
	 */
	EClass getRelationshipMapping();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.RelationshipMapping#getSourceReference <em>Source Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source Reference</em>'.
	 * @see org.gecko.emf.ngsi.RelationshipMapping#getSourceReference()
	 * @see #getRelationshipMapping()
	 * @generated
	 */
	EReference getRelationshipMapping_SourceReference();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.emf.ngsi.RelationshipMapping#getTargetRelationship <em>Target Relationship</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target Relationship</em>'.
	 * @see org.gecko.emf.ngsi.RelationshipMapping#getTargetRelationship()
	 * @see #getRelationshipMapping()
	 * @generated
	 */
	EReference getRelationshipMapping_TargetRelationship();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.RelationshipMapping#getCustomRelationshipName <em>Custom Relationship Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Custom Relationship Name</em>'.
	 * @see org.gecko.emf.ngsi.RelationshipMapping#getCustomRelationshipName()
	 * @see #getRelationshipMapping()
	 * @generated
	 */
	EAttribute getRelationshipMapping_CustomRelationshipName();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.emf.ngsi.RelationshipMapping#isIncludeInNGSI <em>Include In NGSI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Include In NGSI</em>'.
	 * @see org.gecko.emf.ngsi.RelationshipMapping#isIncludeInNGSI()
	 * @see #getRelationshipMapping()
	 * @generated
	 */
	EAttribute getRelationshipMapping_IncludeInNGSI();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property</em>'.
	 * @see org.gecko.emf.ngsi.NGSIProperty
	 * @generated
	 */
	EClass getNGSIProperty();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIRelationship <em>Relationship</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Relationship</em>'.
	 * @see org.gecko.emf.ngsi.NGSIRelationship
	 * @generated
	 */
	EClass getNGSIRelationship();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Context</em>'.
	 * @see org.gecko.emf.ngsi.NGSIContext
	 * @generated
	 */
	EClass getNGSIContext();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.ContextMapping <em>Context Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Context Mapping</em>'.
	 * @see org.gecko.emf.ngsi.ContextMapping
	 * @generated
	 */
	EClass getContextMapping();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSISubscription <em>Subscription</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Subscription</em>'.
	 * @see org.gecko.emf.ngsi.NGSISubscription
	 * @generated
	 */
	EClass getNGSISubscription();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.EntityInfo <em>Entity Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity Info</em>'.
	 * @see org.gecko.emf.ngsi.EntityInfo
	 * @generated
	 */
	EClass getEntityInfo();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NotificationParams <em>Notification Params</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification Params</em>'.
	 * @see org.gecko.emf.ngsi.NotificationParams
	 * @generated
	 */
	EClass getNotificationParams();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.SubscriptionCondition <em>Subscription Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Subscription Condition</em>'.
	 * @see org.gecko.emf.ngsi.SubscriptionCondition
	 * @generated
	 */
	EClass getSubscriptionCondition();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.ProtocolConfiguration <em>Protocol Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Protocol Configuration</em>'.
	 * @see org.gecko.emf.ngsi.ProtocolConfiguration
	 * @generated
	 */
	EClass getProtocolConfiguration();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.ValueConverter <em>Value Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value Converter</em>'.
	 * @see org.gecko.emf.ngsi.ValueConverter
	 * @generated
	 */
	EClass getValueConverter();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.DateTimeConverter <em>Date Time Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Date Time Converter</em>'.
	 * @see org.gecko.emf.ngsi.DateTimeConverter
	 * @generated
	 */
	EClass getDateTimeConverter();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.EnumConverter <em>Enum Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enum Converter</em>'.
	 * @see org.gecko.emf.ngsi.EnumConverter
	 * @generated
	 */
	EClass getEnumConverter();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.CustomConverter <em>Custom Converter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Custom Converter</em>'.
	 * @see org.gecko.emf.ngsi.CustomConverter
	 * @generated
	 */
	EClass getCustomConverter();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSIValue
	 * @generated
	 */
	EClass getNGSIValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIStringValue <em>String Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSIStringValue
	 * @generated
	 */
	EClass getNGSIStringValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSINumberValue <em>Number Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Number Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSINumberValue
	 * @generated
	 */
	EClass getNGSINumberValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIBooleanValue <em>Boolean Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSIBooleanValue
	 * @generated
	 */
	EClass getNGSIBooleanValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIObjectValue <em>Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Object Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSIObjectValue
	 * @generated
	 */
	EClass getNGSIObjectValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIArrayValue <em>Array Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSIArrayValue
	 * @generated
	 */
	EClass getNGSIArrayValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.emf.ngsi.NGSIGeoValue <em>Geo Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Geo Value</em>'.
	 * @see org.gecko.emf.ngsi.NGSIGeoValue
	 * @generated
	 */
	EClass getNGSIGeoValue();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	NGSIFactory getNGSIFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIContainerImpl <em>Container</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIContainerImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIContainer()
		 * @generated
		 */
		EClass NGSI_CONTAINER = eINSTANCE.getNGSIContainer();

		/**
		 * The meta object literal for the '<em><b>Entities</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_CONTAINER__ENTITIES = eINSTANCE.getNGSIContainer_Entities();

		/**
		 * The meta object literal for the '<em><b>Subscriptions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_CONTAINER__SUBSCRIPTIONS = eINSTANCE.getNGSIContainer_Subscriptions();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl <em>Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIEntityImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIEntity()
		 * @generated
		 */
		EClass NGSI_ENTITY = eINSTANCE.getNGSIEntity();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NGSI_ENTITY__ID = eINSTANCE.getNGSIEntity_Id();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NGSI_ENTITY__TYPE = eINSTANCE.getNGSIEntity_Type();

		/**
		 * The meta object literal for the '<em><b>Wrapped Object</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_ENTITY__WRAPPED_OBJECT = eINSTANCE.getNGSIEntity_WrappedObject();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_ENTITY__PROPERTIES = eINSTANCE.getNGSIEntity_Properties();

		/**
		 * The meta object literal for the '<em><b>Relationships</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_ENTITY__RELATIONSHIPS = eINSTANCE.getNGSIEntity_Relationships();

		/**
		 * The meta object literal for the '<em><b>Context</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_ENTITY__CONTEXT = eINSTANCE.getNGSIEntity_Context();

		/**
		 * The meta object literal for the '<em><b>Created At</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NGSI_ENTITY__CREATED_AT = eINSTANCE.getNGSIEntity_CreatedAt();

		/**
		 * The meta object literal for the '<em><b>Modified At</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NGSI_ENTITY__MODIFIED_AT = eINSTANCE.getNGSIEntity_ModifiedAt();

		/**
		 * The meta object literal for the '<em><b>Mapping Configuration</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NGSI_ENTITY__MAPPING_CONFIGURATION = eINSTANCE.getNGSIEntity_MappingConfiguration();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl <em>Entity Mapping Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getEntityMappingConfiguration()
		 * @generated
		 */
		EClass ENTITY_MAPPING_CONFIGURATION = eINSTANCE.getEntityMappingConfiguration();

		/**
		 * The meta object literal for the '<em><b>Source EClass</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS = eINSTANCE.getEntityMappingConfiguration_SourceEClass();

		/**
		 * The meta object literal for the '<em><b>Property Mappings</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS = eINSTANCE.getEntityMappingConfiguration_PropertyMappings();

		/**
		 * The meta object literal for the '<em><b>Relationship Mappings</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS = eINSTANCE.getEntityMappingConfiguration_RelationshipMappings();

		/**
		 * The meta object literal for the '<em><b>Auto Sync</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC = eINSTANCE.getEntityMappingConfiguration_AutoSync();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl <em>Property Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.PropertyMappingImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getPropertyMapping()
		 * @generated
		 */
		EClass PROPERTY_MAPPING = eINSTANCE.getPropertyMapping();

		/**
		 * The meta object literal for the '<em><b>Source Attribute</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_MAPPING__SOURCE_ATTRIBUTE = eINSTANCE.getPropertyMapping_SourceAttribute();

		/**
		 * The meta object literal for the '<em><b>Target Property</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_MAPPING__TARGET_PROPERTY = eINSTANCE.getPropertyMapping_TargetProperty();

		/**
		 * The meta object literal for the '<em><b>Custom Property Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME = eINSTANCE.getPropertyMapping_CustomPropertyName();

		/**
		 * The meta object literal for the '<em><b>Include In NGSI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROPERTY_MAPPING__INCLUDE_IN_NGSI = eINSTANCE.getPropertyMapping_IncludeInNGSI();

		/**
		 * The meta object literal for the '<em><b>Value Converter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROPERTY_MAPPING__VALUE_CONVERTER = eINSTANCE.getPropertyMapping_ValueConverter();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.RelationshipMappingImpl <em>Relationship Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.RelationshipMappingImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getRelationshipMapping()
		 * @generated
		 */
		EClass RELATIONSHIP_MAPPING = eINSTANCE.getRelationshipMapping();

		/**
		 * The meta object literal for the '<em><b>Source Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELATIONSHIP_MAPPING__SOURCE_REFERENCE = eINSTANCE.getRelationshipMapping_SourceReference();

		/**
		 * The meta object literal for the '<em><b>Target Relationship</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP = eINSTANCE.getRelationshipMapping_TargetRelationship();

		/**
		 * The meta object literal for the '<em><b>Custom Relationship Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME = eINSTANCE.getRelationshipMapping_CustomRelationshipName();

		/**
		 * The meta object literal for the '<em><b>Include In NGSI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI = eINSTANCE.getRelationshipMapping_IncludeInNGSI();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIPropertyImpl <em>Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIPropertyImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIProperty()
		 * @generated
		 */
		EClass NGSI_PROPERTY = eINSTANCE.getNGSIProperty();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIRelationshipImpl <em>Relationship</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIRelationshipImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIRelationship()
		 * @generated
		 */
		EClass NGSI_RELATIONSHIP = eINSTANCE.getNGSIRelationship();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIContextImpl <em>Context</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIContextImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIContext()
		 * @generated
		 */
		EClass NGSI_CONTEXT = eINSTANCE.getNGSIContext();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.ContextMappingImpl <em>Context Mapping</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.ContextMappingImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getContextMapping()
		 * @generated
		 */
		EClass CONTEXT_MAPPING = eINSTANCE.getContextMapping();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSISubscriptionImpl <em>Subscription</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSISubscriptionImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSISubscription()
		 * @generated
		 */
		EClass NGSI_SUBSCRIPTION = eINSTANCE.getNGSISubscription();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.EntityInfoImpl <em>Entity Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.EntityInfoImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getEntityInfo()
		 * @generated
		 */
		EClass ENTITY_INFO = eINSTANCE.getEntityInfo();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NotificationParamsImpl <em>Notification Params</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NotificationParamsImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNotificationParams()
		 * @generated
		 */
		EClass NOTIFICATION_PARAMS = eINSTANCE.getNotificationParams();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.SubscriptionConditionImpl <em>Subscription Condition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.SubscriptionConditionImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getSubscriptionCondition()
		 * @generated
		 */
		EClass SUBSCRIPTION_CONDITION = eINSTANCE.getSubscriptionCondition();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl <em>Protocol Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.ProtocolConfigurationImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getProtocolConfiguration()
		 * @generated
		 */
		EClass PROTOCOL_CONFIGURATION = eINSTANCE.getProtocolConfiguration();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.ValueConverterImpl <em>Value Converter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.ValueConverterImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getValueConverter()
		 * @generated
		 */
		EClass VALUE_CONVERTER = eINSTANCE.getValueConverter();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.DateTimeConverterImpl <em>Date Time Converter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.DateTimeConverterImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getDateTimeConverter()
		 * @generated
		 */
		EClass DATE_TIME_CONVERTER = eINSTANCE.getDateTimeConverter();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.EnumConverterImpl <em>Enum Converter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.EnumConverterImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getEnumConverter()
		 * @generated
		 */
		EClass ENUM_CONVERTER = eINSTANCE.getEnumConverter();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.CustomConverterImpl <em>Custom Converter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.CustomConverterImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getCustomConverter()
		 * @generated
		 */
		EClass CUSTOM_CONVERTER = eINSTANCE.getCustomConverter();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIValueImpl <em>Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIValue()
		 * @generated
		 */
		EClass NGSI_VALUE = eINSTANCE.getNGSIValue();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIStringValueImpl <em>String Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIStringValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIStringValue()
		 * @generated
		 */
		EClass NGSI_STRING_VALUE = eINSTANCE.getNGSIStringValue();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSINumberValueImpl <em>Number Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSINumberValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSINumberValue()
		 * @generated
		 */
		EClass NGSI_NUMBER_VALUE = eINSTANCE.getNGSINumberValue();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIBooleanValueImpl <em>Boolean Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIBooleanValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIBooleanValue()
		 * @generated
		 */
		EClass NGSI_BOOLEAN_VALUE = eINSTANCE.getNGSIBooleanValue();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIObjectValueImpl <em>Object Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIObjectValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIObjectValue()
		 * @generated
		 */
		EClass NGSI_OBJECT_VALUE = eINSTANCE.getNGSIObjectValue();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIArrayValueImpl <em>Array Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIArrayValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIArrayValue()
		 * @generated
		 */
		EClass NGSI_ARRAY_VALUE = eINSTANCE.getNGSIArrayValue();

		/**
		 * The meta object literal for the '{@link org.gecko.emf.ngsi.impl.NGSIGeoValueImpl <em>Geo Value</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.emf.ngsi.impl.NGSIGeoValueImpl
		 * @see org.gecko.emf.ngsi.impl.NGSIPackageImpl#getNGSIGeoValue()
		 * @generated
		 */
		EClass NGSI_GEO_VALUE = eINSTANCE.getNGSIGeoValue();

	}

} //NGSIPackage
