/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Relationship</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * NGSI-LD Relationship representation.
 * 
 * Represents a directed relationship between entities. Relationships define semantic connections in the data model and can have their own metadata.
 * 
 * Conforms to ETSI GS CIM 009 Relationship specification.
 * <!-- end-model-doc -->
 *
 *
 * @see org.gecko.emf.ngsi.NGSIPackage#getNGSIRelationship()
 * @model
 * @generated
 */
@ProviderType
public interface NGSIRelationship extends EObject {
} // NGSIRelationship
