/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Property Mapping</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Mapping configuration from EMF EAttribute to NGSI-LD Property.
 * 
 * Defines how a specific EAttribute should be transformed into an NGSI-LD property, including naming conventions, value conversion, and synchronization behavior.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.PropertyMapping#getSourceAttribute <em>Source Attribute</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.PropertyMapping#getTargetProperty <em>Target Property</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.PropertyMapping#getCustomPropertyName <em>Custom Property Name</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.PropertyMapping#isIncludeInNGSI <em>Include In NGSI</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.PropertyMapping#getValueConverter <em>Value Converter</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.NGSIPackage#getPropertyMapping()
 * @model
 * @generated
 */
@ProviderType
public interface PropertyMapping extends EObject {
	/**
	 * Returns the value of the '<em><b>Source Attribute</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The source EMF EAttribute being mapped.
	 * 
	 * This is the attribute from the wrapped EObject that will be exposed as an NGSI-LD property.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Source Attribute</em>' reference.
	 * @see #setSourceAttribute(EAttribute)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getPropertyMapping_SourceAttribute()
	 * @model required="true"
	 * @generated
	 */
	EAttribute getSourceAttribute();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.PropertyMapping#getSourceAttribute <em>Source Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Attribute</em>' reference.
	 * @see #getSourceAttribute()
	 * @generated
	 */
	void setSourceAttribute(EAttribute value);

	/**
	 * Returns the value of the '<em><b>Target Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The target NGSI-LD Property that represents the mapped attribute.
	 * 
	 * This property will be automatically updated when the source attribute changes (if autoSync is enabled).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Target Property</em>' reference.
	 * @see #setTargetProperty(NGSIProperty)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getPropertyMapping_TargetProperty()
	 * @model required="true"
	 * @generated
	 */
	NGSIProperty getTargetProperty();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.PropertyMapping#getTargetProperty <em>Target Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target Property</em>' reference.
	 * @see #getTargetProperty()
	 * @generated
	 */
	void setTargetProperty(NGSIProperty value);

	/**
	 * Returns the value of the '<em><b>Custom Property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Custom name for the NGSI-LD property.
	 * 
	 * If specified, this name will be used instead of the EAttribute name. Should preferably be a URI for semantic clarity.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Custom Property Name</em>' attribute.
	 * @see #setCustomPropertyName(String)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getPropertyMapping_CustomPropertyName()
	 * @model
	 * @generated
	 */
	String getCustomPropertyName();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.PropertyMapping#getCustomPropertyName <em>Custom Property Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Custom Property Name</em>' attribute.
	 * @see #getCustomPropertyName()
	 * @generated
	 */
	void setCustomPropertyName(String value);

	/**
	 * Returns the value of the '<em><b>Include In NGSI</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to include this attribute in the NGSI-LD representation.
	 * 
	 * Set to false to exclude specific attributes from the NGSI-LD entity structure.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Include In NGSI</em>' attribute.
	 * @see #setIncludeInNGSI(boolean)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getPropertyMapping_IncludeInNGSI()
	 * @model default="true"
	 * @generated
	 */
	boolean isIncludeInNGSI();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.PropertyMapping#isIncludeInNGSI <em>Include In NGSI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Include In NGSI</em>' attribute.
	 * @see #isIncludeInNGSI()
	 * @generated
	 */
	void setIncludeInNGSI(boolean value);

	/**
	 * Returns the value of the '<em><b>Value Converter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional value converter for custom transformations.
	 * 
	 * Allows custom conversion logic between EMF attribute values and NGSI-LD property values.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Value Converter</em>' reference.
	 * @see #setValueConverter(ValueConverter)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getPropertyMapping_ValueConverter()
	 * @model
	 * @generated
	 */
	ValueConverter getValueConverter();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.PropertyMapping#getValueConverter <em>Value Converter</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value Converter</em>' reference.
	 * @see #getValueConverter()
	 * @generated
	 */
	void setValueConverter(ValueConverter value);

} // PropertyMapping
