/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Relationship Mapping</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Mapping configuration from EMF EReference to NGSI-LD Relationship.
 * 
 * Defines how a specific EReference should be transformed into an NGSI-LD relationship, including naming conventions and synchronization behavior.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.RelationshipMapping#getSourceReference <em>Source Reference</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.RelationshipMapping#getTargetRelationship <em>Target Relationship</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.RelationshipMapping#getCustomRelationshipName <em>Custom Relationship Name</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.RelationshipMapping#isIncludeInNGSI <em>Include In NGSI</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.NGSIPackage#getRelationshipMapping()
 * @model
 * @generated
 */
@ProviderType
public interface RelationshipMapping extends EObject {
	/**
	 * Returns the value of the '<em><b>Source Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The source EMF EReference being mapped.
	 * 
	 * This is the reference from the wrapped EObject that will be exposed as an NGSI-LD relationship.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Source Reference</em>' reference.
	 * @see #setSourceReference(EReference)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getRelationshipMapping_SourceReference()
	 * @model required="true"
	 * @generated
	 */
	EReference getSourceReference();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.RelationshipMapping#getSourceReference <em>Source Reference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Reference</em>' reference.
	 * @see #getSourceReference()
	 * @generated
	 */
	void setSourceReference(EReference value);

	/**
	 * Returns the value of the '<em><b>Target Relationship</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The target NGSI-LD Relationship that represents the mapped reference.
	 * 
	 * This relationship will be automatically updated when the source reference changes (if autoSync is enabled).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Target Relationship</em>' reference.
	 * @see #setTargetRelationship(NGSIRelationship)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getRelationshipMapping_TargetRelationship()
	 * @model required="true"
	 * @generated
	 */
	NGSIRelationship getTargetRelationship();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.RelationshipMapping#getTargetRelationship <em>Target Relationship</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target Relationship</em>' reference.
	 * @see #getTargetRelationship()
	 * @generated
	 */
	void setTargetRelationship(NGSIRelationship value);

	/**
	 * Returns the value of the '<em><b>Custom Relationship Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Custom name for the NGSI-LD relationship.
	 * 
	 * If specified, this name will be used instead of the EReference name. Should preferably be a URI for semantic clarity.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Custom Relationship Name</em>' attribute.
	 * @see #setCustomRelationshipName(String)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getRelationshipMapping_CustomRelationshipName()
	 * @model
	 * @generated
	 */
	String getCustomRelationshipName();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.RelationshipMapping#getCustomRelationshipName <em>Custom Relationship Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Custom Relationship Name</em>' attribute.
	 * @see #getCustomRelationshipName()
	 * @generated
	 */
	void setCustomRelationshipName(String value);

	/**
	 * Returns the value of the '<em><b>Include In NGSI</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to include this reference in the NGSI-LD representation.
	 * 
	 * Set to false to exclude specific references from the NGSI-LD entity structure.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Include In NGSI</em>' attribute.
	 * @see #setIncludeInNGSI(boolean)
	 * @see org.gecko.emf.ngsi.NGSIPackage#getRelationshipMapping_IncludeInNGSI()
	 * @model default="true"
	 * @generated
	 */
	boolean isIncludeInNGSI();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.RelationshipMapping#isIncludeInNGSI <em>Include In NGSI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Include In NGSI</em>' attribute.
	 * @see #isIncludeInNGSI()
	 * @generated
	 */
	void setIncludeInNGSI(boolean value);

} // RelationshipMapping
