/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.emf.ngsi.EntityMappingConfiguration;
import org.gecko.emf.ngsi.NGSIPackage;
import org.gecko.emf.ngsi.PropertyMapping;
import org.gecko.emf.ngsi.RelationshipMapping;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Entity Mapping Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl#getSourceEClass <em>Source EClass</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl#getPropertyMappings <em>Property Mappings</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl#getRelationshipMappings <em>Relationship Mappings</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.EntityMappingConfigurationImpl#isAutoSync <em>Auto Sync</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EntityMappingConfigurationImpl extends MinimalEObjectImpl.Container implements EntityMappingConfiguration {
	/**
	 * The cached value of the '{@link #getSourceEClass() <em>Source EClass</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceEClass()
	 * @generated
	 * @ordered
	 */
	protected EClass sourceEClass;

	/**
	 * The cached value of the '{@link #getPropertyMappings() <em>Property Mappings</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyMappings()
	 * @generated
	 * @ordered
	 */
	protected EList<PropertyMapping> propertyMappings;

	/**
	 * The cached value of the '{@link #getRelationshipMappings() <em>Relationship Mappings</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelationshipMappings()
	 * @generated
	 * @ordered
	 */
	protected EList<RelationshipMapping> relationshipMappings;

	/**
	 * The default value of the '{@link #isAutoSync() <em>Auto Sync</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAutoSync()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AUTO_SYNC_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isAutoSync() <em>Auto Sync</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAutoSync()
	 * @generated
	 * @ordered
	 */
	protected boolean autoSync = AUTO_SYNC_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityMappingConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIPackage.Literals.ENTITY_MAPPING_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSourceEClass() {
		if (sourceEClass != null && sourceEClass.eIsProxy()) {
			InternalEObject oldSourceEClass = (InternalEObject)sourceEClass;
			sourceEClass = (EClass)eResolveProxy(oldSourceEClass);
			if (sourceEClass != oldSourceEClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS, oldSourceEClass, sourceEClass));
			}
		}
		return sourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass basicGetSourceEClass() {
		return sourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSourceEClass(EClass newSourceEClass) {
		EClass oldSourceEClass = sourceEClass;
		sourceEClass = newSourceEClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS, oldSourceEClass, sourceEClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<PropertyMapping> getPropertyMappings() {
		if (propertyMappings == null) {
			propertyMappings = new EObjectContainmentEList<PropertyMapping>(PropertyMapping.class, this, NGSIPackage.ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS);
		}
		return propertyMappings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<RelationshipMapping> getRelationshipMappings() {
		if (relationshipMappings == null) {
			relationshipMappings = new EObjectContainmentEList<RelationshipMapping>(RelationshipMapping.class, this, NGSIPackage.ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS);
		}
		return relationshipMappings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAutoSync() {
		return autoSync;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAutoSync(boolean newAutoSync) {
		boolean oldAutoSync = autoSync;
		autoSync = newAutoSync;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC, oldAutoSync, autoSync));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS:
				return ((InternalEList<?>)getPropertyMappings()).basicRemove(otherEnd, msgs);
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS:
				return ((InternalEList<?>)getRelationshipMappings()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS:
				if (resolve) return getSourceEClass();
				return basicGetSourceEClass();
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS:
				return getPropertyMappings();
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS:
				return getRelationshipMappings();
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC:
				return isAutoSync();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS:
				setSourceEClass((EClass)newValue);
				return;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS:
				getPropertyMappings().clear();
				getPropertyMappings().addAll((Collection<? extends PropertyMapping>)newValue);
				return;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS:
				getRelationshipMappings().clear();
				getRelationshipMappings().addAll((Collection<? extends RelationshipMapping>)newValue);
				return;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC:
				setAutoSync((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS:
				setSourceEClass((EClass)null);
				return;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS:
				getPropertyMappings().clear();
				return;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS:
				getRelationshipMappings().clear();
				return;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC:
				setAutoSync(AUTO_SYNC_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS:
				return sourceEClass != null;
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS:
				return propertyMappings != null && !propertyMappings.isEmpty();
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS:
				return relationshipMappings != null && !relationshipMappings.isEmpty();
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC:
				return autoSync != AUTO_SYNC_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (autoSync: ");
		result.append(autoSync);
		result.append(')');
		return result.toString();
	}

} //EntityMappingConfigurationImpl
