/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.impl;

import java.util.Collection;
import java.util.Date;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.emf.ngsi.EntityMappingConfiguration;
import org.gecko.emf.ngsi.NGSIContext;
import org.gecko.emf.ngsi.NGSIEntity;
import org.gecko.emf.ngsi.NGSIPackage;
import org.gecko.emf.ngsi.NGSIProperty;
import org.gecko.emf.ngsi.NGSIRelationship;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Entity</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getWrappedObject <em>Wrapped Object</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getRelationships <em>Relationships</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getContext <em>Context</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getCreatedAt <em>Created At</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getModifiedAt <em>Modified At</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.NGSIEntityImpl#getMappingConfiguration <em>Mapping Configuration</em>}</li>
 * </ul>
 *
 * @generated
 */
public class NGSIEntityImpl extends MinimalEObjectImpl.Container implements NGSIEntity {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getWrappedObject() <em>Wrapped Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWrappedObject()
	 * @generated
	 * @ordered
	 */
	protected EObject wrappedObject;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<NGSIProperty> properties;

	/**
	 * The cached value of the '{@link #getRelationships() <em>Relationships</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRelationships()
	 * @generated
	 * @ordered
	 */
	protected EList<NGSIRelationship> relationships;

	/**
	 * The cached value of the '{@link #getContext() <em>Context</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected NGSIContext context;

	/**
	 * The default value of the '{@link #getCreatedAt() <em>Created At</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreatedAt()
	 * @generated
	 * @ordered
	 */
	protected static final Date CREATED_AT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCreatedAt() <em>Created At</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreatedAt()
	 * @generated
	 * @ordered
	 */
	protected Date createdAt = CREATED_AT_EDEFAULT;

	/**
	 * The default value of the '{@link #getModifiedAt() <em>Modified At</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModifiedAt()
	 * @generated
	 * @ordered
	 */
	protected static final Date MODIFIED_AT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModifiedAt() <em>Modified At</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModifiedAt()
	 * @generated
	 * @ordered
	 */
	protected Date modifiedAt = MODIFIED_AT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMappingConfiguration() <em>Mapping Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMappingConfiguration()
	 * @generated
	 * @ordered
	 */
	protected EntityMappingConfiguration mappingConfiguration;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NGSIEntityImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIPackage.Literals.NGSI_ENTITY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject getWrappedObject() {
		if (wrappedObject != null && wrappedObject.eIsProxy()) {
			InternalEObject oldWrappedObject = (InternalEObject)wrappedObject;
			wrappedObject = eResolveProxy(oldWrappedObject);
			if (wrappedObject != oldWrappedObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.NGSI_ENTITY__WRAPPED_OBJECT, oldWrappedObject, wrappedObject));
			}
		}
		return wrappedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetWrappedObject() {
		return wrappedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWrappedObject(EObject newWrappedObject) {
		EObject oldWrappedObject = wrappedObject;
		wrappedObject = newWrappedObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__WRAPPED_OBJECT, oldWrappedObject, wrappedObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<NGSIProperty> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<NGSIProperty>(NGSIProperty.class, this, NGSIPackage.NGSI_ENTITY__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<NGSIRelationship> getRelationships() {
		if (relationships == null) {
			relationships = new EObjectContainmentEList<NGSIRelationship>(NGSIRelationship.class, this, NGSIPackage.NGSI_ENTITY__RELATIONSHIPS);
		}
		return relationships;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIContext getContext() {
		if (context != null && context.eIsProxy()) {
			InternalEObject oldContext = (InternalEObject)context;
			context = (NGSIContext)eResolveProxy(oldContext);
			if (context != oldContext) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.NGSI_ENTITY__CONTEXT, oldContext, context));
			}
		}
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIContext basicGetContext() {
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContext(NGSIContext newContext) {
		NGSIContext oldContext = context;
		context = newContext;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__CONTEXT, oldContext, context));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCreatedAt(Date newCreatedAt) {
		Date oldCreatedAt = createdAt;
		createdAt = newCreatedAt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__CREATED_AT, oldCreatedAt, createdAt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getModifiedAt() {
		return modifiedAt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModifiedAt(Date newModifiedAt) {
		Date oldModifiedAt = modifiedAt;
		modifiedAt = newModifiedAt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__MODIFIED_AT, oldModifiedAt, modifiedAt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EntityMappingConfiguration getMappingConfiguration() {
		return mappingConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMappingConfiguration(EntityMappingConfiguration newMappingConfiguration, NotificationChain msgs) {
		EntityMappingConfiguration oldMappingConfiguration = mappingConfiguration;
		mappingConfiguration = newMappingConfiguration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION, oldMappingConfiguration, newMappingConfiguration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMappingConfiguration(EntityMappingConfiguration newMappingConfiguration) {
		if (newMappingConfiguration != mappingConfiguration) {
			NotificationChain msgs = null;
			if (mappingConfiguration != null)
				msgs = ((InternalEObject)mappingConfiguration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION, null, msgs);
			if (newMappingConfiguration != null)
				msgs = ((InternalEObject)newMappingConfiguration).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION, null, msgs);
			msgs = basicSetMappingConfiguration(newMappingConfiguration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION, newMappingConfiguration, newMappingConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NGSIPackage.NGSI_ENTITY__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
			case NGSIPackage.NGSI_ENTITY__RELATIONSHIPS:
				return ((InternalEList<?>)getRelationships()).basicRemove(otherEnd, msgs);
			case NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION:
				return basicSetMappingConfiguration(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIPackage.NGSI_ENTITY__ID:
				return getId();
			case NGSIPackage.NGSI_ENTITY__TYPE:
				return getType();
			case NGSIPackage.NGSI_ENTITY__WRAPPED_OBJECT:
				if (resolve) return getWrappedObject();
				return basicGetWrappedObject();
			case NGSIPackage.NGSI_ENTITY__PROPERTIES:
				return getProperties();
			case NGSIPackage.NGSI_ENTITY__RELATIONSHIPS:
				return getRelationships();
			case NGSIPackage.NGSI_ENTITY__CONTEXT:
				if (resolve) return getContext();
				return basicGetContext();
			case NGSIPackage.NGSI_ENTITY__CREATED_AT:
				return getCreatedAt();
			case NGSIPackage.NGSI_ENTITY__MODIFIED_AT:
				return getModifiedAt();
			case NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION:
				return getMappingConfiguration();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIPackage.NGSI_ENTITY__ID:
				setId((String)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__TYPE:
				setType((String)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__WRAPPED_OBJECT:
				setWrappedObject((EObject)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends NGSIProperty>)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__RELATIONSHIPS:
				getRelationships().clear();
				getRelationships().addAll((Collection<? extends NGSIRelationship>)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__CONTEXT:
				setContext((NGSIContext)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__CREATED_AT:
				setCreatedAt((Date)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__MODIFIED_AT:
				setModifiedAt((Date)newValue);
				return;
			case NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION:
				setMappingConfiguration((EntityMappingConfiguration)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIPackage.NGSI_ENTITY__ID:
				setId(ID_EDEFAULT);
				return;
			case NGSIPackage.NGSI_ENTITY__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case NGSIPackage.NGSI_ENTITY__WRAPPED_OBJECT:
				setWrappedObject((EObject)null);
				return;
			case NGSIPackage.NGSI_ENTITY__PROPERTIES:
				getProperties().clear();
				return;
			case NGSIPackage.NGSI_ENTITY__RELATIONSHIPS:
				getRelationships().clear();
				return;
			case NGSIPackage.NGSI_ENTITY__CONTEXT:
				setContext((NGSIContext)null);
				return;
			case NGSIPackage.NGSI_ENTITY__CREATED_AT:
				setCreatedAt(CREATED_AT_EDEFAULT);
				return;
			case NGSIPackage.NGSI_ENTITY__MODIFIED_AT:
				setModifiedAt(MODIFIED_AT_EDEFAULT);
				return;
			case NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION:
				setMappingConfiguration((EntityMappingConfiguration)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIPackage.NGSI_ENTITY__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case NGSIPackage.NGSI_ENTITY__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case NGSIPackage.NGSI_ENTITY__WRAPPED_OBJECT:
				return wrappedObject != null;
			case NGSIPackage.NGSI_ENTITY__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case NGSIPackage.NGSI_ENTITY__RELATIONSHIPS:
				return relationships != null && !relationships.isEmpty();
			case NGSIPackage.NGSI_ENTITY__CONTEXT:
				return context != null;
			case NGSIPackage.NGSI_ENTITY__CREATED_AT:
				return CREATED_AT_EDEFAULT == null ? createdAt != null : !CREATED_AT_EDEFAULT.equals(createdAt);
			case NGSIPackage.NGSI_ENTITY__MODIFIED_AT:
				return MODIFIED_AT_EDEFAULT == null ? modifiedAt != null : !MODIFIED_AT_EDEFAULT.equals(modifiedAt);
			case NGSIPackage.NGSI_ENTITY__MAPPING_CONFIGURATION:
				return mappingConfiguration != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", type: ");
		result.append(type);
		result.append(", createdAt: ");
		result.append(createdAt);
		result.append(", modifiedAt: ");
		result.append(modifiedAt);
		result.append(')');
		return result.toString();
	}

} //NGSIEntityImpl
