/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.gecko.emf.ngsi.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class NGSIFactoryImpl extends EFactoryImpl implements NGSIFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static NGSIFactory init() {
		try {
			NGSIFactory theNGSIFactory = (NGSIFactory)EPackage.Registry.INSTANCE.getEFactory(NGSIPackage.eNS_URI);
			if (theNGSIFactory != null) {
				return theNGSIFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new NGSIFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case NGSIPackage.NGSI_CONTAINER: return createNGSIContainer();
			case NGSIPackage.NGSI_ENTITY: return createNGSIEntity();
			case NGSIPackage.ENTITY_MAPPING_CONFIGURATION: return createEntityMappingConfiguration();
			case NGSIPackage.PROPERTY_MAPPING: return createPropertyMapping();
			case NGSIPackage.RELATIONSHIP_MAPPING: return createRelationshipMapping();
			case NGSIPackage.NGSI_PROPERTY: return createNGSIProperty();
			case NGSIPackage.NGSI_RELATIONSHIP: return createNGSIRelationship();
			case NGSIPackage.NGSI_CONTEXT: return createNGSIContext();
			case NGSIPackage.CONTEXT_MAPPING: return createContextMapping();
			case NGSIPackage.NGSI_SUBSCRIPTION: return createNGSISubscription();
			case NGSIPackage.ENTITY_INFO: return createEntityInfo();
			case NGSIPackage.NOTIFICATION_PARAMS: return createNotificationParams();
			case NGSIPackage.SUBSCRIPTION_CONDITION: return createSubscriptionCondition();
			case NGSIPackage.DATE_TIME_CONVERTER: return createDateTimeConverter();
			case NGSIPackage.ENUM_CONVERTER: return createEnumConverter();
			case NGSIPackage.CUSTOM_CONVERTER: return createCustomConverter();
			case NGSIPackage.NGSI_STRING_VALUE: return createNGSIStringValue();
			case NGSIPackage.NGSI_NUMBER_VALUE: return createNGSINumberValue();
			case NGSIPackage.NGSI_BOOLEAN_VALUE: return createNGSIBooleanValue();
			case NGSIPackage.NGSI_OBJECT_VALUE: return createNGSIObjectValue();
			case NGSIPackage.NGSI_ARRAY_VALUE: return createNGSIArrayValue();
			case NGSIPackage.NGSI_GEO_VALUE: return createNGSIGeoValue();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIContainer createNGSIContainer() {
		NGSIContainerImpl ngsiContainer = new NGSIContainerImpl();
		return ngsiContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIEntity createNGSIEntity() {
		NGSIEntityImpl ngsiEntity = new NGSIEntityImpl();
		return ngsiEntity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EntityMappingConfiguration createEntityMappingConfiguration() {
		EntityMappingConfigurationImpl entityMappingConfiguration = new EntityMappingConfigurationImpl();
		return entityMappingConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PropertyMapping createPropertyMapping() {
		PropertyMappingImpl propertyMapping = new PropertyMappingImpl();
		return propertyMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public RelationshipMapping createRelationshipMapping() {
		RelationshipMappingImpl relationshipMapping = new RelationshipMappingImpl();
		return relationshipMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIProperty createNGSIProperty() {
		NGSIPropertyImpl ngsiProperty = new NGSIPropertyImpl();
		return ngsiProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIRelationship createNGSIRelationship() {
		NGSIRelationshipImpl ngsiRelationship = new NGSIRelationshipImpl();
		return ngsiRelationship;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIContext createNGSIContext() {
		NGSIContextImpl ngsiContext = new NGSIContextImpl();
		return ngsiContext;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ContextMapping createContextMapping() {
		ContextMappingImpl contextMapping = new ContextMappingImpl();
		return contextMapping;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSISubscription createNGSISubscription() {
		NGSISubscriptionImpl ngsiSubscription = new NGSISubscriptionImpl();
		return ngsiSubscription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EntityInfo createEntityInfo() {
		EntityInfoImpl entityInfo = new EntityInfoImpl();
		return entityInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationParams createNotificationParams() {
		NotificationParamsImpl notificationParams = new NotificationParamsImpl();
		return notificationParams;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SubscriptionCondition createSubscriptionCondition() {
		SubscriptionConditionImpl subscriptionCondition = new SubscriptionConditionImpl();
		return subscriptionCondition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DateTimeConverter createDateTimeConverter() {
		DateTimeConverterImpl dateTimeConverter = new DateTimeConverterImpl();
		return dateTimeConverter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EnumConverter createEnumConverter() {
		EnumConverterImpl enumConverter = new EnumConverterImpl();
		return enumConverter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CustomConverter createCustomConverter() {
		CustomConverterImpl customConverter = new CustomConverterImpl();
		return customConverter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIStringValue createNGSIStringValue() {
		NGSIStringValueImpl ngsiStringValue = new NGSIStringValueImpl();
		return ngsiStringValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSINumberValue createNGSINumberValue() {
		NGSINumberValueImpl ngsiNumberValue = new NGSINumberValueImpl();
		return ngsiNumberValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIBooleanValue createNGSIBooleanValue() {
		NGSIBooleanValueImpl ngsiBooleanValue = new NGSIBooleanValueImpl();
		return ngsiBooleanValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIObjectValue createNGSIObjectValue() {
		NGSIObjectValueImpl ngsiObjectValue = new NGSIObjectValueImpl();
		return ngsiObjectValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIArrayValue createNGSIArrayValue() {
		NGSIArrayValueImpl ngsiArrayValue = new NGSIArrayValueImpl();
		return ngsiArrayValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIGeoValue createNGSIGeoValue() {
		NGSIGeoValueImpl ngsiGeoValue = new NGSIGeoValueImpl();
		return ngsiGeoValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIPackage getNGSIPackage() {
		return (NGSIPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static NGSIPackage getPackage() {
		return NGSIPackage.eINSTANCE;
	}

} //NGSIFactoryImpl
