/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.emf.ngsi.ContextMapping;
import org.gecko.emf.ngsi.CustomConverter;
import org.gecko.emf.ngsi.DateTimeConverter;
import org.gecko.emf.ngsi.EntityInfo;
import org.gecko.emf.ngsi.EntityMappingConfiguration;
import org.gecko.emf.ngsi.EnumConverter;
import org.gecko.emf.ngsi.NGSIArrayValue;
import org.gecko.emf.ngsi.NGSIBooleanValue;
import org.gecko.emf.ngsi.NGSIContainer;
import org.gecko.emf.ngsi.NGSIContext;
import org.gecko.emf.ngsi.NGSIEntity;
import org.gecko.emf.ngsi.NGSIFactory;
import org.gecko.emf.ngsi.NGSIGeoValue;
import org.gecko.emf.ngsi.NGSINumberValue;
import org.gecko.emf.ngsi.NGSIObjectValue;
import org.gecko.emf.ngsi.NGSIPackage;
import org.gecko.emf.ngsi.NGSIProperty;
import org.gecko.emf.ngsi.NGSIRelationship;
import org.gecko.emf.ngsi.NGSIStringValue;
import org.gecko.emf.ngsi.NGSISubscription;
import org.gecko.emf.ngsi.NGSIValue;
import org.gecko.emf.ngsi.NotificationParams;
import org.gecko.emf.ngsi.PropertyMapping;
import org.gecko.emf.ngsi.ProtocolConfiguration;
import org.gecko.emf.ngsi.RelationshipMapping;
import org.gecko.emf.ngsi.SubscriptionCondition;
import org.gecko.emf.ngsi.ValueConverter;

import org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage;

import org.gecko.emf.ngsi.protocols.impl.NGSIProtocolsPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class NGSIPackageImpl extends EPackageImpl implements NGSIPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiContainerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiEntityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass entityMappingConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass propertyMappingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass relationshipMappingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiPropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiRelationshipEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiContextEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextMappingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiSubscriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass entityInfoEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass notificationParamsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass subscriptionConditionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass protocolConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass valueConverterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass dateTimeConverterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass enumConverterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass customConverterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiStringValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiNumberValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiBooleanValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiObjectValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiArrayValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ngsiGeoValueEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.emf.ngsi.NGSIPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private NGSIPackageImpl() {
		super(eNS_URI, NGSIFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link NGSIPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static NGSIPackage init() {
		if (isInited) return (NGSIPackage)EPackage.Registry.INSTANCE.getEPackage(NGSIPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredNGSIPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		NGSIPackageImpl theNGSIPackage = registeredNGSIPackage instanceof NGSIPackageImpl ? (NGSIPackageImpl)registeredNGSIPackage : new NGSIPackageImpl();

		isInited = true;

		// Obtain or create and register interdependencies
		Object registeredPackage = EPackage.Registry.INSTANCE.getEPackage(NGSIProtocolsPackage.eNS_URI);
		NGSIProtocolsPackageImpl theNGSIProtocolsPackage = (NGSIProtocolsPackageImpl)(registeredPackage instanceof NGSIProtocolsPackageImpl ? registeredPackage : NGSIProtocolsPackage.eINSTANCE);

		// Create package meta-data objects
		theNGSIPackage.createPackageContents();
		theNGSIProtocolsPackage.createPackageContents();

		// Initialize created meta-data
		theNGSIPackage.initializePackageContents();
		theNGSIProtocolsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theNGSIPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(NGSIPackage.eNS_URI, theNGSIPackage);
		return theNGSIPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIContainer() {
		return ngsiContainerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIContainer_Entities() {
		return (EReference)ngsiContainerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIContainer_Subscriptions() {
		return (EReference)ngsiContainerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIEntity() {
		return ngsiEntityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getNGSIEntity_Id() {
		return (EAttribute)ngsiEntityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getNGSIEntity_Type() {
		return (EAttribute)ngsiEntityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIEntity_WrappedObject() {
		return (EReference)ngsiEntityEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIEntity_Properties() {
		return (EReference)ngsiEntityEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIEntity_Relationships() {
		return (EReference)ngsiEntityEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIEntity_Context() {
		return (EReference)ngsiEntityEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getNGSIEntity_CreatedAt() {
		return (EAttribute)ngsiEntityEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getNGSIEntity_ModifiedAt() {
		return (EAttribute)ngsiEntityEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getNGSIEntity_MappingConfiguration() {
		return (EReference)ngsiEntityEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEntityMappingConfiguration() {
		return entityMappingConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getEntityMappingConfiguration_SourceEClass() {
		return (EReference)entityMappingConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getEntityMappingConfiguration_PropertyMappings() {
		return (EReference)entityMappingConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getEntityMappingConfiguration_RelationshipMappings() {
		return (EReference)entityMappingConfigurationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEntityMappingConfiguration_AutoSync() {
		return (EAttribute)entityMappingConfigurationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPropertyMapping() {
		return propertyMappingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPropertyMapping_SourceAttribute() {
		return (EReference)propertyMappingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPropertyMapping_TargetProperty() {
		return (EReference)propertyMappingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPropertyMapping_CustomPropertyName() {
		return (EAttribute)propertyMappingEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPropertyMapping_IncludeInNGSI() {
		return (EAttribute)propertyMappingEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getPropertyMapping_ValueConverter() {
		return (EReference)propertyMappingEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRelationshipMapping() {
		return relationshipMappingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRelationshipMapping_SourceReference() {
		return (EReference)relationshipMappingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getRelationshipMapping_TargetRelationship() {
		return (EReference)relationshipMappingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRelationshipMapping_CustomRelationshipName() {
		return (EAttribute)relationshipMappingEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRelationshipMapping_IncludeInNGSI() {
		return (EAttribute)relationshipMappingEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIProperty() {
		return ngsiPropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIRelationship() {
		return ngsiRelationshipEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIContext() {
		return ngsiContextEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContextMapping() {
		return contextMappingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSISubscription() {
		return ngsiSubscriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEntityInfo() {
		return entityInfoEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNotificationParams() {
		return notificationParamsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSubscriptionCondition() {
		return subscriptionConditionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProtocolConfiguration() {
		return protocolConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getValueConverter() {
		return valueConverterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDateTimeConverter() {
		return dateTimeConverterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEnumConverter() {
		return enumConverterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCustomConverter() {
		return customConverterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIValue() {
		return ngsiValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIStringValue() {
		return ngsiStringValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSINumberValue() {
		return ngsiNumberValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIBooleanValue() {
		return ngsiBooleanValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIObjectValue() {
		return ngsiObjectValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIArrayValue() {
		return ngsiArrayValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNGSIGeoValue() {
		return ngsiGeoValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIFactory getNGSIFactory() {
		return (NGSIFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		ngsiContainerEClass = createEClass(NGSI_CONTAINER);
		createEReference(ngsiContainerEClass, NGSI_CONTAINER__ENTITIES);
		createEReference(ngsiContainerEClass, NGSI_CONTAINER__SUBSCRIPTIONS);

		ngsiEntityEClass = createEClass(NGSI_ENTITY);
		createEAttribute(ngsiEntityEClass, NGSI_ENTITY__ID);
		createEAttribute(ngsiEntityEClass, NGSI_ENTITY__TYPE);
		createEReference(ngsiEntityEClass, NGSI_ENTITY__WRAPPED_OBJECT);
		createEReference(ngsiEntityEClass, NGSI_ENTITY__PROPERTIES);
		createEReference(ngsiEntityEClass, NGSI_ENTITY__RELATIONSHIPS);
		createEReference(ngsiEntityEClass, NGSI_ENTITY__CONTEXT);
		createEAttribute(ngsiEntityEClass, NGSI_ENTITY__CREATED_AT);
		createEAttribute(ngsiEntityEClass, NGSI_ENTITY__MODIFIED_AT);
		createEReference(ngsiEntityEClass, NGSI_ENTITY__MAPPING_CONFIGURATION);

		entityMappingConfigurationEClass = createEClass(ENTITY_MAPPING_CONFIGURATION);
		createEReference(entityMappingConfigurationEClass, ENTITY_MAPPING_CONFIGURATION__SOURCE_ECLASS);
		createEReference(entityMappingConfigurationEClass, ENTITY_MAPPING_CONFIGURATION__PROPERTY_MAPPINGS);
		createEReference(entityMappingConfigurationEClass, ENTITY_MAPPING_CONFIGURATION__RELATIONSHIP_MAPPINGS);
		createEAttribute(entityMappingConfigurationEClass, ENTITY_MAPPING_CONFIGURATION__AUTO_SYNC);

		propertyMappingEClass = createEClass(PROPERTY_MAPPING);
		createEReference(propertyMappingEClass, PROPERTY_MAPPING__SOURCE_ATTRIBUTE);
		createEReference(propertyMappingEClass, PROPERTY_MAPPING__TARGET_PROPERTY);
		createEAttribute(propertyMappingEClass, PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME);
		createEAttribute(propertyMappingEClass, PROPERTY_MAPPING__INCLUDE_IN_NGSI);
		createEReference(propertyMappingEClass, PROPERTY_MAPPING__VALUE_CONVERTER);

		relationshipMappingEClass = createEClass(RELATIONSHIP_MAPPING);
		createEReference(relationshipMappingEClass, RELATIONSHIP_MAPPING__SOURCE_REFERENCE);
		createEReference(relationshipMappingEClass, RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP);
		createEAttribute(relationshipMappingEClass, RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME);
		createEAttribute(relationshipMappingEClass, RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI);

		ngsiPropertyEClass = createEClass(NGSI_PROPERTY);

		ngsiRelationshipEClass = createEClass(NGSI_RELATIONSHIP);

		ngsiContextEClass = createEClass(NGSI_CONTEXT);

		contextMappingEClass = createEClass(CONTEXT_MAPPING);

		ngsiSubscriptionEClass = createEClass(NGSI_SUBSCRIPTION);

		entityInfoEClass = createEClass(ENTITY_INFO);

		notificationParamsEClass = createEClass(NOTIFICATION_PARAMS);

		subscriptionConditionEClass = createEClass(SUBSCRIPTION_CONDITION);

		protocolConfigurationEClass = createEClass(PROTOCOL_CONFIGURATION);

		valueConverterEClass = createEClass(VALUE_CONVERTER);

		dateTimeConverterEClass = createEClass(DATE_TIME_CONVERTER);

		enumConverterEClass = createEClass(ENUM_CONVERTER);

		customConverterEClass = createEClass(CUSTOM_CONVERTER);

		ngsiValueEClass = createEClass(NGSI_VALUE);

		ngsiStringValueEClass = createEClass(NGSI_STRING_VALUE);

		ngsiNumberValueEClass = createEClass(NGSI_NUMBER_VALUE);

		ngsiBooleanValueEClass = createEClass(NGSI_BOOLEAN_VALUE);

		ngsiObjectValueEClass = createEClass(NGSI_OBJECT_VALUE);

		ngsiArrayValueEClass = createEClass(NGSI_ARRAY_VALUE);

		ngsiGeoValueEClass = createEClass(NGSI_GEO_VALUE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		dateTimeConverterEClass.getESuperTypes().add(this.getValueConverter());
		enumConverterEClass.getESuperTypes().add(this.getValueConverter());
		customConverterEClass.getESuperTypes().add(this.getValueConverter());
		ngsiStringValueEClass.getESuperTypes().add(this.getNGSIValue());
		ngsiNumberValueEClass.getESuperTypes().add(this.getNGSIValue());
		ngsiBooleanValueEClass.getESuperTypes().add(this.getNGSIValue());
		ngsiObjectValueEClass.getESuperTypes().add(this.getNGSIValue());
		ngsiArrayValueEClass.getESuperTypes().add(this.getNGSIValue());
		ngsiGeoValueEClass.getESuperTypes().add(this.getNGSIValue());

		// Initialize classes, features, and operations; add parameters
		initEClass(ngsiContainerEClass, NGSIContainer.class, "NGSIContainer", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getNGSIContainer_Entities(), this.getNGSIEntity(), null, "entities", null, 0, -1, NGSIContainer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNGSIContainer_Subscriptions(), this.getNGSISubscription(), null, "subscriptions", null, 0, -1, NGSIContainer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ngsiEntityEClass, NGSIEntity.class, "NGSIEntity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNGSIEntity_Id(), ecorePackage.getEString(), "id", null, 1, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getNGSIEntity_Type(), ecorePackage.getEString(), "type", null, 1, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNGSIEntity_WrappedObject(), ecorePackage.getEObject(), null, "wrappedObject", null, 0, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNGSIEntity_Properties(), this.getNGSIProperty(), null, "properties", null, 0, -1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNGSIEntity_Relationships(), this.getNGSIRelationship(), null, "relationships", null, 0, -1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNGSIEntity_Context(), this.getNGSIContext(), null, "context", null, 0, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getNGSIEntity_CreatedAt(), ecorePackage.getEDate(), "createdAt", null, 0, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getNGSIEntity_ModifiedAt(), ecorePackage.getEDate(), "modifiedAt", null, 0, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNGSIEntity_MappingConfiguration(), this.getEntityMappingConfiguration(), null, "mappingConfiguration", null, 0, 1, NGSIEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(entityMappingConfigurationEClass, EntityMappingConfiguration.class, "EntityMappingConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEntityMappingConfiguration_SourceEClass(), ecorePackage.getEClass(), null, "sourceEClass", null, 1, 1, EntityMappingConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMappingConfiguration_PropertyMappings(), this.getPropertyMapping(), null, "propertyMappings", null, 0, -1, EntityMappingConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEntityMappingConfiguration_RelationshipMappings(), this.getRelationshipMapping(), null, "relationshipMappings", null, 0, -1, EntityMappingConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEntityMappingConfiguration_AutoSync(), ecorePackage.getEBoolean(), "autoSync", "true", 0, 1, EntityMappingConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(propertyMappingEClass, PropertyMapping.class, "PropertyMapping", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPropertyMapping_SourceAttribute(), ecorePackage.getEAttribute(), null, "sourceAttribute", null, 1, 1, PropertyMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPropertyMapping_TargetProperty(), this.getNGSIProperty(), null, "targetProperty", null, 1, 1, PropertyMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPropertyMapping_CustomPropertyName(), ecorePackage.getEString(), "customPropertyName", null, 0, 1, PropertyMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPropertyMapping_IncludeInNGSI(), ecorePackage.getEBoolean(), "includeInNGSI", "true", 0, 1, PropertyMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPropertyMapping_ValueConverter(), this.getValueConverter(), null, "valueConverter", null, 0, 1, PropertyMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(relationshipMappingEClass, RelationshipMapping.class, "RelationshipMapping", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRelationshipMapping_SourceReference(), ecorePackage.getEReference(), null, "sourceReference", null, 1, 1, RelationshipMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRelationshipMapping_TargetRelationship(), this.getNGSIRelationship(), null, "targetRelationship", null, 1, 1, RelationshipMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRelationshipMapping_CustomRelationshipName(), ecorePackage.getEString(), "customRelationshipName", null, 0, 1, RelationshipMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRelationshipMapping_IncludeInNGSI(), ecorePackage.getEBoolean(), "includeInNGSI", "true", 0, 1, RelationshipMapping.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ngsiPropertyEClass, NGSIProperty.class, "NGSIProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiRelationshipEClass, NGSIRelationship.class, "NGSIRelationship", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiContextEClass, NGSIContext.class, "NGSIContext", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(contextMappingEClass, ContextMapping.class, "ContextMapping", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiSubscriptionEClass, NGSISubscription.class, "NGSISubscription", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(entityInfoEClass, EntityInfo.class, "EntityInfo", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(notificationParamsEClass, NotificationParams.class, "NotificationParams", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(subscriptionConditionEClass, SubscriptionCondition.class, "SubscriptionCondition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(protocolConfigurationEClass, ProtocolConfiguration.class, "ProtocolConfiguration", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(valueConverterEClass, ValueConverter.class, "ValueConverter", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(dateTimeConverterEClass, DateTimeConverter.class, "DateTimeConverter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(enumConverterEClass, EnumConverter.class, "EnumConverter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(customConverterEClass, CustomConverter.class, "CustomConverter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiValueEClass, NGSIValue.class, "NGSIValue", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiStringValueEClass, NGSIStringValue.class, "NGSIStringValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiNumberValueEClass, NGSINumberValue.class, "NGSINumberValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiBooleanValueEClass, NGSIBooleanValue.class, "NGSIBooleanValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiObjectValueEClass, NGSIObjectValue.class, "NGSIObjectValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiArrayValueEClass, NGSIArrayValue.class, "NGSIArrayValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ngsiGeoValueEClass, NGSIGeoValue.class, "NGSIGeoValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} //NGSIPackageImpl
