/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.emf.ngsi.NGSIPackage;
import org.gecko.emf.ngsi.NGSIProperty;
import org.gecko.emf.ngsi.PropertyMapping;
import org.gecko.emf.ngsi.ValueConverter;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Property Mapping</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl#getSourceAttribute <em>Source Attribute</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl#getTargetProperty <em>Target Property</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl#getCustomPropertyName <em>Custom Property Name</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl#isIncludeInNGSI <em>Include In NGSI</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.PropertyMappingImpl#getValueConverter <em>Value Converter</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PropertyMappingImpl extends MinimalEObjectImpl.Container implements PropertyMapping {
	/**
	 * The cached value of the '{@link #getSourceAttribute() <em>Source Attribute</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceAttribute()
	 * @generated
	 * @ordered
	 */
	protected EAttribute sourceAttribute;

	/**
	 * The cached value of the '{@link #getTargetProperty() <em>Target Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetProperty()
	 * @generated
	 * @ordered
	 */
	protected NGSIProperty targetProperty;

	/**
	 * The default value of the '{@link #getCustomPropertyName() <em>Custom Property Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomPropertyName()
	 * @generated
	 * @ordered
	 */
	protected static final String CUSTOM_PROPERTY_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCustomPropertyName() <em>Custom Property Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomPropertyName()
	 * @generated
	 * @ordered
	 */
	protected String customPropertyName = CUSTOM_PROPERTY_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isIncludeInNGSI() <em>Include In NGSI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeInNGSI()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INCLUDE_IN_NGSI_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isIncludeInNGSI() <em>Include In NGSI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeInNGSI()
	 * @generated
	 * @ordered
	 */
	protected boolean includeInNGSI = INCLUDE_IN_NGSI_EDEFAULT;

	/**
	 * The cached value of the '{@link #getValueConverter() <em>Value Converter</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueConverter()
	 * @generated
	 * @ordered
	 */
	protected ValueConverter valueConverter;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyMappingImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIPackage.Literals.PROPERTY_MAPPING;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSourceAttribute() {
		if (sourceAttribute != null && sourceAttribute.eIsProxy()) {
			InternalEObject oldSourceAttribute = (InternalEObject)sourceAttribute;
			sourceAttribute = (EAttribute)eResolveProxy(oldSourceAttribute);
			if (sourceAttribute != oldSourceAttribute) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.PROPERTY_MAPPING__SOURCE_ATTRIBUTE, oldSourceAttribute, sourceAttribute));
			}
		}
		return sourceAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute basicGetSourceAttribute() {
		return sourceAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSourceAttribute(EAttribute newSourceAttribute) {
		EAttribute oldSourceAttribute = sourceAttribute;
		sourceAttribute = newSourceAttribute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.PROPERTY_MAPPING__SOURCE_ATTRIBUTE, oldSourceAttribute, sourceAttribute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIProperty getTargetProperty() {
		if (targetProperty != null && targetProperty.eIsProxy()) {
			InternalEObject oldTargetProperty = (InternalEObject)targetProperty;
			targetProperty = (NGSIProperty)eResolveProxy(oldTargetProperty);
			if (targetProperty != oldTargetProperty) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.PROPERTY_MAPPING__TARGET_PROPERTY, oldTargetProperty, targetProperty));
			}
		}
		return targetProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIProperty basicGetTargetProperty() {
		return targetProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTargetProperty(NGSIProperty newTargetProperty) {
		NGSIProperty oldTargetProperty = targetProperty;
		targetProperty = newTargetProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.PROPERTY_MAPPING__TARGET_PROPERTY, oldTargetProperty, targetProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCustomPropertyName() {
		return customPropertyName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCustomPropertyName(String newCustomPropertyName) {
		String oldCustomPropertyName = customPropertyName;
		customPropertyName = newCustomPropertyName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME, oldCustomPropertyName, customPropertyName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIncludeInNGSI() {
		return includeInNGSI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIncludeInNGSI(boolean newIncludeInNGSI) {
		boolean oldIncludeInNGSI = includeInNGSI;
		includeInNGSI = newIncludeInNGSI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.PROPERTY_MAPPING__INCLUDE_IN_NGSI, oldIncludeInNGSI, includeInNGSI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ValueConverter getValueConverter() {
		if (valueConverter != null && valueConverter.eIsProxy()) {
			InternalEObject oldValueConverter = (InternalEObject)valueConverter;
			valueConverter = (ValueConverter)eResolveProxy(oldValueConverter);
			if (valueConverter != oldValueConverter) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.PROPERTY_MAPPING__VALUE_CONVERTER, oldValueConverter, valueConverter));
			}
		}
		return valueConverter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueConverter basicGetValueConverter() {
		return valueConverter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setValueConverter(ValueConverter newValueConverter) {
		ValueConverter oldValueConverter = valueConverter;
		valueConverter = newValueConverter;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.PROPERTY_MAPPING__VALUE_CONVERTER, oldValueConverter, valueConverter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIPackage.PROPERTY_MAPPING__SOURCE_ATTRIBUTE:
				if (resolve) return getSourceAttribute();
				return basicGetSourceAttribute();
			case NGSIPackage.PROPERTY_MAPPING__TARGET_PROPERTY:
				if (resolve) return getTargetProperty();
				return basicGetTargetProperty();
			case NGSIPackage.PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME:
				return getCustomPropertyName();
			case NGSIPackage.PROPERTY_MAPPING__INCLUDE_IN_NGSI:
				return isIncludeInNGSI();
			case NGSIPackage.PROPERTY_MAPPING__VALUE_CONVERTER:
				if (resolve) return getValueConverter();
				return basicGetValueConverter();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIPackage.PROPERTY_MAPPING__SOURCE_ATTRIBUTE:
				setSourceAttribute((EAttribute)newValue);
				return;
			case NGSIPackage.PROPERTY_MAPPING__TARGET_PROPERTY:
				setTargetProperty((NGSIProperty)newValue);
				return;
			case NGSIPackage.PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME:
				setCustomPropertyName((String)newValue);
				return;
			case NGSIPackage.PROPERTY_MAPPING__INCLUDE_IN_NGSI:
				setIncludeInNGSI((Boolean)newValue);
				return;
			case NGSIPackage.PROPERTY_MAPPING__VALUE_CONVERTER:
				setValueConverter((ValueConverter)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIPackage.PROPERTY_MAPPING__SOURCE_ATTRIBUTE:
				setSourceAttribute((EAttribute)null);
				return;
			case NGSIPackage.PROPERTY_MAPPING__TARGET_PROPERTY:
				setTargetProperty((NGSIProperty)null);
				return;
			case NGSIPackage.PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME:
				setCustomPropertyName(CUSTOM_PROPERTY_NAME_EDEFAULT);
				return;
			case NGSIPackage.PROPERTY_MAPPING__INCLUDE_IN_NGSI:
				setIncludeInNGSI(INCLUDE_IN_NGSI_EDEFAULT);
				return;
			case NGSIPackage.PROPERTY_MAPPING__VALUE_CONVERTER:
				setValueConverter((ValueConverter)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIPackage.PROPERTY_MAPPING__SOURCE_ATTRIBUTE:
				return sourceAttribute != null;
			case NGSIPackage.PROPERTY_MAPPING__TARGET_PROPERTY:
				return targetProperty != null;
			case NGSIPackage.PROPERTY_MAPPING__CUSTOM_PROPERTY_NAME:
				return CUSTOM_PROPERTY_NAME_EDEFAULT == null ? customPropertyName != null : !CUSTOM_PROPERTY_NAME_EDEFAULT.equals(customPropertyName);
			case NGSIPackage.PROPERTY_MAPPING__INCLUDE_IN_NGSI:
				return includeInNGSI != INCLUDE_IN_NGSI_EDEFAULT;
			case NGSIPackage.PROPERTY_MAPPING__VALUE_CONVERTER:
				return valueConverter != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (customPropertyName: ");
		result.append(customPropertyName);
		result.append(", includeInNGSI: ");
		result.append(includeInNGSI);
		result.append(')');
		return result.toString();
	}

} //PropertyMappingImpl
