/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.emf.ngsi.NGSIPackage;
import org.gecko.emf.ngsi.NGSIRelationship;
import org.gecko.emf.ngsi.RelationshipMapping;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Relationship Mapping</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.impl.RelationshipMappingImpl#getSourceReference <em>Source Reference</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.RelationshipMappingImpl#getTargetRelationship <em>Target Relationship</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.RelationshipMappingImpl#getCustomRelationshipName <em>Custom Relationship Name</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.impl.RelationshipMappingImpl#isIncludeInNGSI <em>Include In NGSI</em>}</li>
 * </ul>
 *
 * @generated
 */
public class RelationshipMappingImpl extends MinimalEObjectImpl.Container implements RelationshipMapping {
	/**
	 * The cached value of the '{@link #getSourceReference() <em>Source Reference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceReference()
	 * @generated
	 * @ordered
	 */
	protected EReference sourceReference;

	/**
	 * The cached value of the '{@link #getTargetRelationship() <em>Target Relationship</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetRelationship()
	 * @generated
	 * @ordered
	 */
	protected NGSIRelationship targetRelationship;

	/**
	 * The default value of the '{@link #getCustomRelationshipName() <em>Custom Relationship Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomRelationshipName()
	 * @generated
	 * @ordered
	 */
	protected static final String CUSTOM_RELATIONSHIP_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCustomRelationshipName() <em>Custom Relationship Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomRelationshipName()
	 * @generated
	 * @ordered
	 */
	protected String customRelationshipName = CUSTOM_RELATIONSHIP_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isIncludeInNGSI() <em>Include In NGSI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeInNGSI()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INCLUDE_IN_NGSI_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isIncludeInNGSI() <em>Include In NGSI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIncludeInNGSI()
	 * @generated
	 * @ordered
	 */
	protected boolean includeInNGSI = INCLUDE_IN_NGSI_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationshipMappingImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NGSIPackage.Literals.RELATIONSHIP_MAPPING;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getSourceReference() {
		if (sourceReference != null && sourceReference.eIsProxy()) {
			InternalEObject oldSourceReference = (InternalEObject)sourceReference;
			sourceReference = (EReference)eResolveProxy(oldSourceReference);
			if (sourceReference != oldSourceReference) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.RELATIONSHIP_MAPPING__SOURCE_REFERENCE, oldSourceReference, sourceReference));
			}
		}
		return sourceReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference basicGetSourceReference() {
		return sourceReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSourceReference(EReference newSourceReference) {
		EReference oldSourceReference = sourceReference;
		sourceReference = newSourceReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.RELATIONSHIP_MAPPING__SOURCE_REFERENCE, oldSourceReference, sourceReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NGSIRelationship getTargetRelationship() {
		if (targetRelationship != null && targetRelationship.eIsProxy()) {
			InternalEObject oldTargetRelationship = (InternalEObject)targetRelationship;
			targetRelationship = (NGSIRelationship)eResolveProxy(oldTargetRelationship);
			if (targetRelationship != oldTargetRelationship) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NGSIPackage.RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP, oldTargetRelationship, targetRelationship));
			}
		}
		return targetRelationship;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NGSIRelationship basicGetTargetRelationship() {
		return targetRelationship;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTargetRelationship(NGSIRelationship newTargetRelationship) {
		NGSIRelationship oldTargetRelationship = targetRelationship;
		targetRelationship = newTargetRelationship;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP, oldTargetRelationship, targetRelationship));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCustomRelationshipName() {
		return customRelationshipName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCustomRelationshipName(String newCustomRelationshipName) {
		String oldCustomRelationshipName = customRelationshipName;
		customRelationshipName = newCustomRelationshipName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME, oldCustomRelationshipName, customRelationshipName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isIncludeInNGSI() {
		return includeInNGSI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIncludeInNGSI(boolean newIncludeInNGSI) {
		boolean oldIncludeInNGSI = includeInNGSI;
		includeInNGSI = newIncludeInNGSI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NGSIPackage.RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI, oldIncludeInNGSI, includeInNGSI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NGSIPackage.RELATIONSHIP_MAPPING__SOURCE_REFERENCE:
				if (resolve) return getSourceReference();
				return basicGetSourceReference();
			case NGSIPackage.RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP:
				if (resolve) return getTargetRelationship();
				return basicGetTargetRelationship();
			case NGSIPackage.RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME:
				return getCustomRelationshipName();
			case NGSIPackage.RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI:
				return isIncludeInNGSI();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NGSIPackage.RELATIONSHIP_MAPPING__SOURCE_REFERENCE:
				setSourceReference((EReference)newValue);
				return;
			case NGSIPackage.RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP:
				setTargetRelationship((NGSIRelationship)newValue);
				return;
			case NGSIPackage.RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME:
				setCustomRelationshipName((String)newValue);
				return;
			case NGSIPackage.RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI:
				setIncludeInNGSI((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NGSIPackage.RELATIONSHIP_MAPPING__SOURCE_REFERENCE:
				setSourceReference((EReference)null);
				return;
			case NGSIPackage.RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP:
				setTargetRelationship((NGSIRelationship)null);
				return;
			case NGSIPackage.RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME:
				setCustomRelationshipName(CUSTOM_RELATIONSHIP_NAME_EDEFAULT);
				return;
			case NGSIPackage.RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI:
				setIncludeInNGSI(INCLUDE_IN_NGSI_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NGSIPackage.RELATIONSHIP_MAPPING__SOURCE_REFERENCE:
				return sourceReference != null;
			case NGSIPackage.RELATIONSHIP_MAPPING__TARGET_RELATIONSHIP:
				return targetRelationship != null;
			case NGSIPackage.RELATIONSHIP_MAPPING__CUSTOM_RELATIONSHIP_NAME:
				return CUSTOM_RELATIONSHIP_NAME_EDEFAULT == null ? customRelationshipName != null : !CUSTOM_RELATIONSHIP_NAME_EDEFAULT.equals(customRelationshipName);
			case NGSIPackage.RELATIONSHIP_MAPPING__INCLUDE_IN_NGSI:
				return includeInNGSI != INCLUDE_IN_NGSI_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (customRelationshipName: ");
		result.append(customRelationshipName);
		result.append(", includeInNGSI: ");
		result.append(includeInNGSI);
		result.append(')');
		return result.toString();
	}

} //RelationshipMappingImpl
