/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.gecko.emf.ngsi.ProtocolConfiguration;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>AMQP Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * AMQP protocol configuration for NGSI-LD notifications.
 * 
 * Provides AMQP-based notification delivery for enterprise messaging scenarios. Supports exchanges, queues, and routing keys.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getHost <em>Host</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getPort <em>Port</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getVirtualHost <em>Virtual Host</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getExchange <em>Exchange</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getRoutingKey <em>Routing Key</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getQueue <em>Queue</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#isDurable <em>Durable</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#isAutoDelete <em>Auto Delete</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface AMQPConfiguration extends ProtocolConfiguration {
	/**
	 * Returns the value of the '<em><b>Host</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * AMQP broker hostname or IP address.
	 * 
	 * The address of the AMQP broker where notifications will be published.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Host</em>' attribute.
	 * @see #setHost(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_Host()
	 * @model required="true"
	 * @generated
	 */
	String getHost();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getHost <em>Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Host</em>' attribute.
	 * @see #getHost()
	 * @generated
	 */
	void setHost(String value);

	/**
	 * Returns the value of the '<em><b>Port</b></em>' attribute.
	 * The default value is <code>"5672"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * AMQP broker port number.
	 * 
	 * Standard port is 5672 for AMQP, 5671 for AMQP over TLS.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Port</em>' attribute.
	 * @see #setPort(int)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_Port()
	 * @model default="5672"
	 * @generated
	 */
	int getPort();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getPort <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Port</em>' attribute.
	 * @see #getPort()
	 * @generated
	 */
	void setPort(int value);

	/**
	 * Returns the value of the '<em><b>Virtual Host</b></em>' attribute.
	 * The default value is <code>"/"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * AMQP virtual host.
	 * 
	 * Virtual host for logical separation of resources.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Virtual Host</em>' attribute.
	 * @see #setVirtualHost(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_VirtualHost()
	 * @model default="/"
	 * @generated
	 */
	String getVirtualHost();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getVirtualHost <em>Virtual Host</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Virtual Host</em>' attribute.
	 * @see #getVirtualHost()
	 * @generated
	 */
	void setVirtualHost(String value);

	/**
	 * Returns the value of the '<em><b>Exchange</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * AMQP exchange name.
	 * 
	 * Exchange where notifications will be published.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Exchange</em>' attribute.
	 * @see #setExchange(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_Exchange()
	 * @model required="true"
	 * @generated
	 */
	String getExchange();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getExchange <em>Exchange</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Exchange</em>' attribute.
	 * @see #getExchange()
	 * @generated
	 */
	void setExchange(String value);

	/**
	 * Returns the value of the '<em><b>Routing Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * AMQP routing key.
	 * 
	 * Routing key for message routing within the exchange.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Routing Key</em>' attribute.
	 * @see #setRoutingKey(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_RoutingKey()
	 * @model
	 * @generated
	 */
	String getRoutingKey();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getRoutingKey <em>Routing Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Routing Key</em>' attribute.
	 * @see #getRoutingKey()
	 * @generated
	 */
	void setRoutingKey(String value);

	/**
	 * Returns the value of the '<em><b>Queue</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * AMQP queue name.
	 * 
	 * Optional queue name for direct queue publishing.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Queue</em>' attribute.
	 * @see #setQueue(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_Queue()
	 * @model
	 * @generated
	 */
	String getQueue();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getQueue <em>Queue</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Queue</em>' attribute.
	 * @see #getQueue()
	 * @generated
	 */
	void setQueue(String value);

	/**
	 * Returns the value of the '<em><b>Durable</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether the exchange/queue is durable.
	 * 
	 * If true, the exchange/queue will survive broker restarts.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Durable</em>' attribute.
	 * @see #setDurable(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_Durable()
	 * @model default="true"
	 * @generated
	 */
	boolean isDurable();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#isDurable <em>Durable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Durable</em>' attribute.
	 * @see #isDurable()
	 * @generated
	 */
	void setDurable(boolean value);

	/**
	 * Returns the value of the '<em><b>Auto Delete</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether the exchange/queue should be auto-deleted.
	 * 
	 * If true, the exchange/queue will be deleted when no longer in use.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Auto Delete</em>' attribute.
	 * @see #setAutoDelete(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_AutoDelete()
	 * @model default="false"
	 * @generated
	 */
	boolean isAutoDelete();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#isAutoDelete <em>Auto Delete</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Auto Delete</em>' attribute.
	 * @see #isAutoDelete()
	 * @generated
	 */
	void setAutoDelete(boolean value);

	/**
	 * Returns the value of the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Security configuration for AMQP notifications.
	 * 
	 * Supports username/password authentication and TLS encryption.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Security</em>' containment reference.
	 * @see #setSecurity(Security)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getAMQPConfiguration_Security()
	 * @model containment="true"
	 * @generated
	 */
	Security getSecurity();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.AMQPConfiguration#getSecurity <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Security</em>' containment reference.
	 * @see #getSecurity()
	 * @generated
	 */
	void setSecurity(Security value);

} // AMQPConfiguration
