/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.eclipse.emf.common.util.EList;

import org.gecko.emf.ngsi.ProtocolConfiguration;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>HTTP Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * HTTP/HTTPS protocol configuration for NGSI-LD notifications.
 * 
 * Provides standard HTTP-based notification delivery as specified in NGSI-LD specification. Supports custom headers, authentication, and connection management.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getUrl <em>Url</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getMethod <em>Method</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getHeaders <em>Headers</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#isFollowRedirects <em>Follow Redirects</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getContentType <em>Content Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface HTTPConfiguration extends ProtocolConfiguration {
	/**
	 * Returns the value of the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Target URL for HTTP notifications.
	 * 
	 * Must be a valid HTTP or HTTPS URL that can receive POST requests with notification payloads.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Url</em>' attribute.
	 * @see #setUrl(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration_Url()
	 * @model required="true"
	 * @generated
	 */
	String getUrl();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getUrl <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Url</em>' attribute.
	 * @see #getUrl()
	 * @generated
	 */
	void setUrl(String value);

	/**
	 * Returns the value of the '<em><b>Method</b></em>' attribute.
	 * The default value is <code>"POST"</code>.
	 * The literals are from the enumeration {@link org.gecko.emf.ngsi.protocols.HTTPMethod}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * HTTP method to use for sending notifications.
	 * 
	 * Typically POST for NGSI-LD notifications, but other methods may be supported.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Method</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.HTTPMethod
	 * @see #setMethod(HTTPMethod)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration_Method()
	 * @model default="POST"
	 * @generated
	 */
	HTTPMethod getMethod();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getMethod <em>Method</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Method</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.HTTPMethod
	 * @see #getMethod()
	 * @generated
	 */
	void setMethod(HTTPMethod value);

	/**
	 * Returns the value of the '<em><b>Headers</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.protocols.HTTPHeader}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Custom HTTP headers to include in notification requests.
	 * 
	 * Allows for custom authentication, content negotiation, and other HTTP-specific requirements.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Headers</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration_Headers()
	 * @model containment="true"
	 * @generated
	 */
	EList<HTTPHeader> getHeaders();

	/**
	 * Returns the value of the '<em><b>Follow Redirects</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to follow HTTP redirects automatically.
	 * 
	 * If true, 3xx redirect responses will be followed automatically.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Follow Redirects</em>' attribute.
	 * @see #setFollowRedirects(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration_FollowRedirects()
	 * @model default="true"
	 * @generated
	 */
	boolean isFollowRedirects();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#isFollowRedirects <em>Follow Redirects</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Follow Redirects</em>' attribute.
	 * @see #isFollowRedirects()
	 * @generated
	 */
	void setFollowRedirects(boolean value);

	/**
	 * Returns the value of the '<em><b>Content Type</b></em>' attribute.
	 * The default value is <code>"application/json"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Content-Type header for notification requests.
	 * 
	 * Typically 'application/json' for NGSI-LD notifications, but can be customized.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Content Type</em>' attribute.
	 * @see #setContentType(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration_ContentType()
	 * @model default="application/json"
	 * @generated
	 */
	String getContentType();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getContentType <em>Content Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Content Type</em>' attribute.
	 * @see #getContentType()
	 * @generated
	 */
	void setContentType(String value);

	/**
	 * Returns the value of the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Security configuration for HTTP notifications.
	 * 
	 * Supports various authentication methods including basic auth, bearer tokens, and SSL/TLS.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Security</em>' containment reference.
	 * @see #setSecurity(Security)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPConfiguration_Security()
	 * @model containment="true"
	 * @generated
	 */
	Security getSecurity();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPConfiguration#getSecurity <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Security</em>' containment reference.
	 * @see #getSecurity()
	 * @generated
	 */
	void setSecurity(Security value);

} // HTTPConfiguration
