/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>HTTP Security</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * HTTP-specific security configuration.
 * 
 * Extends the base security configuration with HTTP-specific authentication methods including bearer tokens and custom authentication headers.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getAuthType <em>Auth Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getBearerToken <em>Bearer Token</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKey <em>Api Key</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKeyHeader <em>Api Key Header</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#isVerifyHostname <em>Verify Hostname</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPSecurity()
 * @model
 * @generated
 */
@ProviderType
public interface HTTPSecurity extends Security {
	/**
	 * Returns the value of the '<em><b>Auth Type</b></em>' attribute.
	 * The default value is <code>"none"</code>.
	 * The literals are from the enumeration {@link org.gecko.emf.ngsi.protocols.HTTPAuthType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * HTTP authentication type to use.
	 * 
	 * Determines which authentication method will be applied.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Auth Type</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.HTTPAuthType
	 * @see #setAuthType(HTTPAuthType)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPSecurity_AuthType()
	 * @model default="none"
	 * @generated
	 */
	HTTPAuthType getAuthType();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getAuthType <em>Auth Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Auth Type</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.HTTPAuthType
	 * @see #getAuthType()
	 * @generated
	 */
	void setAuthType(HTTPAuthType value);

	/**
	 * Returns the value of the '<em><b>Bearer Token</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bearer token for token-based authentication.
	 * 
	 * Used when authType is BEARER. Should be stored securely.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Bearer Token</em>' attribute.
	 * @see #setBearerToken(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPSecurity_BearerToken()
	 * @model
	 * @generated
	 */
	String getBearerToken();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getBearerToken <em>Bearer Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Bearer Token</em>' attribute.
	 * @see #getBearerToken()
	 * @generated
	 */
	void setBearerToken(String value);

	/**
	 * Returns the value of the '<em><b>Api Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * API key for API key-based authentication.
	 * 
	 * Used when authType is API_KEY. Should be stored securely.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Api Key</em>' attribute.
	 * @see #setApiKey(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPSecurity_ApiKey()
	 * @model
	 * @generated
	 */
	String getApiKey();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKey <em>Api Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Api Key</em>' attribute.
	 * @see #getApiKey()
	 * @generated
	 */
	void setApiKey(String value);

	/**
	 * Returns the value of the '<em><b>Api Key Header</b></em>' attribute.
	 * The default value is <code>"X-API-Key"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Header name for API key authentication.
	 * 
	 * Specifies which HTTP header will contain the API key.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Api Key Header</em>' attribute.
	 * @see #setApiKeyHeader(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPSecurity_ApiKeyHeader()
	 * @model default="X-API-Key"
	 * @generated
	 */
	String getApiKeyHeader();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#getApiKeyHeader <em>Api Key Header</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Api Key Header</em>' attribute.
	 * @see #getApiKeyHeader()
	 * @generated
	 */
	void setApiKeyHeader(String value);

	/**
	 * Returns the value of the '<em><b>Verify Hostname</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to verify SSL certificate hostname.
	 * 
	 * If false, hostname verification will be skipped (not recommended for production).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Verify Hostname</em>' attribute.
	 * @see #setVerifyHostname(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getHTTPSecurity_VerifyHostname()
	 * @model default="true"
	 * @generated
	 */
	boolean isVerifyHostname();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.HTTPSecurity#isVerifyHostname <em>Verify Hostname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Verify Hostname</em>' attribute.
	 * @see #isVerifyHostname()
	 * @generated
	 */
	void setVerifyHostname(boolean value);

} // HTTPSecurity
