/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Kafka Compression Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Kafka compression types.
 * <!-- end-model-doc -->
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaCompressionType()
 * @model
 * @generated
 */
@ProviderType
public enum KafkaCompressionType implements Enumerator {
	/**
	 * The '<em><b>NONE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NONE_VALUE
	 * @generated
	 * @ordered
	 */
	NONE(0, "NONE", "none"),

	/**
	 * The '<em><b>GZIP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GZIP_VALUE
	 * @generated
	 * @ordered
	 */
	GZIP(1, "GZIP", "gzip"),

	/**
	 * The '<em><b>SNAPPY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SNAPPY_VALUE
	 * @generated
	 * @ordered
	 */
	SNAPPY(2, "SNAPPY", "snappy"),

	/**
	 * The '<em><b>LZ4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LZ4_VALUE
	 * @generated
	 * @ordered
	 */
	LZ4(3, "LZ4", "lz4"),

	/**
	 * The '<em><b>ZSTD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZSTD_VALUE
	 * @generated
	 * @ordered
	 */
	ZSTD(4, "ZSTD", "zstd");

	/**
	 * The '<em><b>NONE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NONE
	 * @model literal="none"
	 * @generated
	 * @ordered
	 */
	public static final int NONE_VALUE = 0;

	/**
	 * The '<em><b>GZIP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GZIP
	 * @model literal="gzip"
	 * @generated
	 * @ordered
	 */
	public static final int GZIP_VALUE = 1;

	/**
	 * The '<em><b>SNAPPY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SNAPPY
	 * @model literal="snappy"
	 * @generated
	 * @ordered
	 */
	public static final int SNAPPY_VALUE = 2;

	/**
	 * The '<em><b>LZ4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LZ4
	 * @model literal="lz4"
	 * @generated
	 * @ordered
	 */
	public static final int LZ4_VALUE = 3;

	/**
	 * The '<em><b>ZSTD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZSTD
	 * @model literal="zstd"
	 * @generated
	 * @ordered
	 */
	public static final int ZSTD_VALUE = 4;

	/**
	 * An array of all the '<em><b>Kafka Compression Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final KafkaCompressionType[] VALUES_ARRAY =
		new KafkaCompressionType[] {
			NONE,
			GZIP,
			SNAPPY,
			LZ4,
			ZSTD,
		};

	/**
	 * A public read-only list of all the '<em><b>Kafka Compression Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<KafkaCompressionType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Kafka Compression Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static KafkaCompressionType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			KafkaCompressionType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Kafka Compression Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static KafkaCompressionType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			KafkaCompressionType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Kafka Compression Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static KafkaCompressionType get(int value) {
		switch (value) {
			case NONE_VALUE: return NONE;
			case GZIP_VALUE: return GZIP;
			case SNAPPY_VALUE: return SNAPPY;
			case LZ4_VALUE: return LZ4;
			case ZSTD_VALUE: return ZSTD;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private KafkaCompressionType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //KafkaCompressionType
