/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.eclipse.emf.common.util.EList;

import org.gecko.emf.ngsi.ProtocolConfiguration;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Kafka Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Apache Kafka protocol configuration for NGSI-LD notifications.
 * 
 * Provides Kafka-based notification delivery for high-throughput scenarios. Supports partitioning, compression, and producer configuration.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getBootstrapServers <em>Bootstrap Servers</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getTopic <em>Topic</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getPartition <em>Partition</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getKey <em>Key</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getCompressionType <em>Compression Type</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getAcks <em>Acks</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface KafkaConfiguration extends ProtocolConfiguration {
	/**
	 * Returns the value of the '<em><b>Bootstrap Servers</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kafka bootstrap servers.
	 * 
	 * Comma-separated list of Kafka broker addresses (host:port).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Bootstrap Servers</em>' attribute.
	 * @see #setBootstrapServers(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_BootstrapServers()
	 * @model required="true"
	 * @generated
	 */
	String getBootstrapServers();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getBootstrapServers <em>Bootstrap Servers</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Bootstrap Servers</em>' attribute.
	 * @see #getBootstrapServers()
	 * @generated
	 */
	void setBootstrapServers(String value);

	/**
	 * Returns the value of the '<em><b>Topic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kafka topic for notifications.
	 * 
	 * Topic where notification messages will be published.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Topic</em>' attribute.
	 * @see #setTopic(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_Topic()
	 * @model required="true"
	 * @generated
	 */
	String getTopic();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getTopic <em>Topic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Topic</em>' attribute.
	 * @see #getTopic()
	 * @generated
	 */
	void setTopic(String value);

	/**
	 * Returns the value of the '<em><b>Partition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Specific partition to send messages to.
	 * 
	 * If not specified, Kafka will use partitioning strategy based on key or round-robin.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Partition</em>' attribute.
	 * @see #setPartition(int)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_Partition()
	 * @model
	 * @generated
	 */
	int getPartition();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getPartition <em>Partition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Partition</em>' attribute.
	 * @see #getPartition()
	 * @generated
	 */
	void setPartition(int value);

	/**
	 * Returns the value of the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Message key for partitioning.
	 * 
	 * Key used for message partitioning and ordering within partitions.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Key</em>' attribute.
	 * @see #setKey(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_Key()
	 * @model
	 * @generated
	 */
	String getKey();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getKey <em>Key</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Key</em>' attribute.
	 * @see #getKey()
	 * @generated
	 */
	void setKey(String value);

	/**
	 * Returns the value of the '<em><b>Compression Type</b></em>' attribute.
	 * The default value is <code>"none"</code>.
	 * The literals are from the enumeration {@link org.gecko.emf.ngsi.protocols.KafkaCompressionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Compression type for messages.
	 * 
	 * Compression algorithm to use for message compression.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Compression Type</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.KafkaCompressionType
	 * @see #setCompressionType(KafkaCompressionType)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_CompressionType()
	 * @model default="none"
	 * @generated
	 */
	KafkaCompressionType getCompressionType();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getCompressionType <em>Compression Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Compression Type</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.KafkaCompressionType
	 * @see #getCompressionType()
	 * @generated
	 */
	void setCompressionType(KafkaCompressionType value);

	/**
	 * Returns the value of the '<em><b>Acks</b></em>' attribute.
	 * The default value is <code>"1"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Acknowledgment configuration.
	 * 
	 * Number of acknowledgments the producer requires: 0 (none), 1 (leader), all (all replicas).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Acks</em>' attribute.
	 * @see #setAcks(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_Acks()
	 * @model default="1"
	 * @generated
	 */
	String getAcks();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getAcks <em>Acks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Acks</em>' attribute.
	 * @see #getAcks()
	 * @generated
	 */
	void setAcks(String value);

	/**
	 * Returns the value of the '<em><b>Properties</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.emf.ngsi.protocols.KafkaProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Additional Kafka producer properties.
	 * 
	 * Custom configuration properties for the Kafka producer.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Properties</em>' containment reference list.
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_Properties()
	 * @model containment="true"
	 * @generated
	 */
	EList<KafkaProperty> getProperties();

	/**
	 * Returns the value of the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Security configuration for Kafka notifications.
	 * 
	 * Supports SASL authentication and SSL/TLS encryption.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Security</em>' containment reference.
	 * @see #setSecurity(KafkaSecurity)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaConfiguration_Security()
	 * @model containment="true"
	 * @generated
	 */
	KafkaSecurity getSecurity();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaConfiguration#getSecurity <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Security</em>' containment reference.
	 * @see #getSecurity()
	 * @generated
	 */
	void setSecurity(KafkaSecurity value);

} // KafkaConfiguration
