/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Kafka Security</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Kafka-specific security configuration.
 * 
 * Extends the base security configuration with Kafka-specific SASL mechanisms and security protocols.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSecurityProtocol <em>Security Protocol</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslMechanism <em>Sasl Mechanism</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslJaasConfig <em>Sasl Jaas Config</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaSecurity()
 * @model
 * @generated
 */
@ProviderType
public interface KafkaSecurity extends Security {
	/**
	 * Returns the value of the '<em><b>Security Protocol</b></em>' attribute.
	 * The default value is <code>"PLAINTEXT"</code>.
	 * The literals are from the enumeration {@link org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Kafka security protocol.
	 * 
	 * Determines the combination of authentication and encryption used.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Security Protocol</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol
	 * @see #setSecurityProtocol(KafkaSecurityProtocol)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaSecurity_SecurityProtocol()
	 * @model default="PLAINTEXT"
	 * @generated
	 */
	KafkaSecurityProtocol getSecurityProtocol();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSecurityProtocol <em>Security Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Security Protocol</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.KafkaSecurityProtocol
	 * @see #getSecurityProtocol()
	 * @generated
	 */
	void setSecurityProtocol(KafkaSecurityProtocol value);

	/**
	 * Returns the value of the '<em><b>Sasl Mechanism</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.emf.ngsi.protocols.SASLMechanism}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * SASL mechanism for authentication.
	 * 
	 * Specifies the SASL authentication mechanism to use.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sasl Mechanism</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.SASLMechanism
	 * @see #setSaslMechanism(SASLMechanism)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaSecurity_SaslMechanism()
	 * @model
	 * @generated
	 */
	SASLMechanism getSaslMechanism();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslMechanism <em>Sasl Mechanism</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sasl Mechanism</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.SASLMechanism
	 * @see #getSaslMechanism()
	 * @generated
	 */
	void setSaslMechanism(SASLMechanism value);

	/**
	 * Returns the value of the '<em><b>Sasl Jaas Config</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * SASL JAAS configuration string.
	 * 
	 * Complete JAAS configuration for SASL authentication.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sasl Jaas Config</em>' attribute.
	 * @see #setSaslJaasConfig(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaSecurity_SaslJaasConfig()
	 * @model
	 * @generated
	 */
	String getSaslJaasConfig();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.KafkaSecurity#getSaslJaasConfig <em>Sasl Jaas Config</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sasl Jaas Config</em>' attribute.
	 * @see #getSaslJaasConfig()
	 * @generated
	 */
	void setSaslJaasConfig(String value);

} // KafkaSecurity
