/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Kafka Security Protocol</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Kafka security protocols.
 * <!-- end-model-doc -->
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getKafkaSecurityProtocol()
 * @model
 * @generated
 */
@ProviderType
public enum KafkaSecurityProtocol implements Enumerator {
	/**
	 * The '<em><b>PLAINTEXT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PLAINTEXT_VALUE
	 * @generated
	 * @ordered
	 */
	PLAINTEXT(0, "PLAINTEXT", "PLAINTEXT"),

	/**
	 * The '<em><b>SSL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSL_VALUE
	 * @generated
	 * @ordered
	 */
	SSL(1, "SSL", "SSL"),

	/**
	 * The '<em><b>SASL PLAINTEXT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SASL_PLAINTEXT_VALUE
	 * @generated
	 * @ordered
	 */
	SASL_PLAINTEXT(2, "SASL_PLAINTEXT", "SASL_PLAINTEXT"),

	/**
	 * The '<em><b>SASL SSL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SASL_SSL_VALUE
	 * @generated
	 * @ordered
	 */
	SASL_SSL(3, "SASL_SSL", "SASL_SSL");

	/**
	 * The '<em><b>PLAINTEXT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PLAINTEXT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PLAINTEXT_VALUE = 0;

	/**
	 * The '<em><b>SSL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SSL_VALUE = 1;

	/**
	 * The '<em><b>SASL PLAINTEXT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SASL_PLAINTEXT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SASL_PLAINTEXT_VALUE = 2;

	/**
	 * The '<em><b>SASL SSL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SASL_SSL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SASL_SSL_VALUE = 3;

	/**
	 * An array of all the '<em><b>Kafka Security Protocol</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final KafkaSecurityProtocol[] VALUES_ARRAY =
		new KafkaSecurityProtocol[] {
			PLAINTEXT,
			SSL,
			SASL_PLAINTEXT,
			SASL_SSL,
		};

	/**
	 * A public read-only list of all the '<em><b>Kafka Security Protocol</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<KafkaSecurityProtocol> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Kafka Security Protocol</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static KafkaSecurityProtocol get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			KafkaSecurityProtocol result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Kafka Security Protocol</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static KafkaSecurityProtocol getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			KafkaSecurityProtocol result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Kafka Security Protocol</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static KafkaSecurityProtocol get(int value) {
		switch (value) {
			case PLAINTEXT_VALUE: return PLAINTEXT;
			case SSL_VALUE: return SSL;
			case SASL_PLAINTEXT_VALUE: return SASL_PLAINTEXT;
			case SASL_SSL_VALUE: return SASL_SSL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private KafkaSecurityProtocol(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //KafkaSecurityProtocol
