/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.emf.ngsi.protocols;

import org.gecko.emf.ngsi.ProtocolConfiguration;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>MQTT Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * MQTT protocol configuration for NGSI-LD notifications.
 * 
 * Provides MQTT-based notification delivery for IoT scenarios and pub/sub architectures. Supports QoS levels, retained messages, and connection management.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getBroker <em>Broker</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getPort <em>Port</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getTopic <em>Topic</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getQos <em>Qos</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#isRetain <em>Retain</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getClientId <em>Client Id</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#isCleanSession <em>Clean Session</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getKeepAlive <em>Keep Alive</em>}</li>
 *   <li>{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getSecurity <em>Security</em>}</li>
 * </ul>
 *
 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface MQTTConfiguration extends ProtocolConfiguration {
	/**
	 * Returns the value of the '<em><b>Broker</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * MQTT broker hostname or IP address.
	 * 
	 * The address of the MQTT broker where notifications will be published.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Broker</em>' attribute.
	 * @see #setBroker(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_Broker()
	 * @model required="true"
	 * @generated
	 */
	String getBroker();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getBroker <em>Broker</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Broker</em>' attribute.
	 * @see #getBroker()
	 * @generated
	 */
	void setBroker(String value);

	/**
	 * Returns the value of the '<em><b>Port</b></em>' attribute.
	 * The default value is <code>"1883"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * MQTT broker port number.
	 * 
	 * Standard port is 1883 for MQTT, 8883 for MQTT over TLS.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Port</em>' attribute.
	 * @see #setPort(int)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_Port()
	 * @model default="1883"
	 * @generated
	 */
	int getPort();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getPort <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Port</em>' attribute.
	 * @see #getPort()
	 * @generated
	 */
	void setPort(int value);

	/**
	 * Returns the value of the '<em><b>Topic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * MQTT topic where notifications will be published.
	 * 
	 * Should follow MQTT topic naming conventions and consider subscription patterns.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Topic</em>' attribute.
	 * @see #setTopic(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_Topic()
	 * @model required="true"
	 * @generated
	 */
	String getTopic();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getTopic <em>Topic</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Topic</em>' attribute.
	 * @see #getTopic()
	 * @generated
	 */
	void setTopic(String value);

	/**
	 * Returns the value of the '<em><b>Qos</b></em>' attribute.
	 * The default value is <code>"AT_LEAST_ONCE"</code>.
	 * The literals are from the enumeration {@link org.gecko.emf.ngsi.protocols.MQTTQoS}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Quality of Service level for MQTT messages.
	 * 
	 * Determines delivery guarantees: 0 (at most once), 1 (at least once), 2 (exactly once).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Qos</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.MQTTQoS
	 * @see #setQos(MQTTQoS)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_Qos()
	 * @model default="AT_LEAST_ONCE"
	 * @generated
	 */
	MQTTQoS getQos();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getQos <em>Qos</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Qos</em>' attribute.
	 * @see org.gecko.emf.ngsi.protocols.MQTTQoS
	 * @see #getQos()
	 * @generated
	 */
	void setQos(MQTTQoS value);

	/**
	 * Returns the value of the '<em><b>Retain</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to retain messages on the broker.
	 * 
	 * If true, the broker will store the last message and deliver it to new subscribers.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Retain</em>' attribute.
	 * @see #setRetain(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_Retain()
	 * @model default="false"
	 * @generated
	 */
	boolean isRetain();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#isRetain <em>Retain</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Retain</em>' attribute.
	 * @see #isRetain()
	 * @generated
	 */
	void setRetain(boolean value);

	/**
	 * Returns the value of the '<em><b>Client Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * MQTT client identifier.
	 * 
	 * Unique identifier for the MQTT client. If not specified, a random ID will be generated.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Client Id</em>' attribute.
	 * @see #setClientId(String)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_ClientId()
	 * @model
	 * @generated
	 */
	String getClientId();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getClientId <em>Client Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Client Id</em>' attribute.
	 * @see #getClientId()
	 * @generated
	 */
	void setClientId(String value);

	/**
	 * Returns the value of the '<em><b>Clean Session</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether to start with a clean session.
	 * 
	 * If true, the broker will not store session information between connections.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clean Session</em>' attribute.
	 * @see #setCleanSession(boolean)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_CleanSession()
	 * @model default="true"
	 * @generated
	 */
	boolean isCleanSession();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#isCleanSession <em>Clean Session</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clean Session</em>' attribute.
	 * @see #isCleanSession()
	 * @generated
	 */
	void setCleanSession(boolean value);

	/**
	 * Returns the value of the '<em><b>Keep Alive</b></em>' attribute.
	 * The default value is <code>"60"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Keep alive interval in seconds.
	 * 
	 * Maximum time between client communications with the broker.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Keep Alive</em>' attribute.
	 * @see #setKeepAlive(int)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_KeepAlive()
	 * @model default="60"
	 * @generated
	 */
	int getKeepAlive();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getKeepAlive <em>Keep Alive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keep Alive</em>' attribute.
	 * @see #getKeepAlive()
	 * @generated
	 */
	void setKeepAlive(int value);

	/**
	 * Returns the value of the '<em><b>Security</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Security configuration for MQTT notifications.
	 * 
	 * Supports username/password authentication and TLS encryption.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Security</em>' containment reference.
	 * @see #setSecurity(Security)
	 * @see org.gecko.emf.ngsi.protocols.NGSIProtocolsPackage#getMQTTConfiguration_Security()
	 * @model containment="true"
	 * @generated
	 */
	Security getSecurity();

	/**
	 * Sets the value of the '{@link org.gecko.emf.ngsi.protocols.MQTTConfiguration#getSecurity <em>Security</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Security</em>' containment reference.
	 * @see #getSecurity()
	 * @generated
	 */
	void setSecurity(Security value);

} // MQTTConfiguration
